/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.sharedcachemanager.CleanerTask;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CleanerService
extends CompositeService {
    public static final String GLOBAL_CLEANER_PID = ".cleaner_pid";
    private static final Log LOG = LogFactory.getLog(CleanerService.class);
    private Configuration conf;
    private CleanerMetrics metrics;
    private ScheduledExecutorService scheduledExecutor;
    private final SCMStore store;
    private final Lock cleanerTaskLock;

    public CleanerService(SCMStore store) {
        super("CleanerService");
        this.store = store;
        this.cleanerTaskLock = new ReentrantLock();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("Shared cache cleaner").build();
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, tf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        if (!this.writeGlobalCleanerPidFile()) {
            throw new YarnException("The global cleaner pid file already exists! It appears there is another CleanerService running in the cluster");
        }
        this.metrics = CleanerMetrics.getInstance();
        super.serviceStart();
        CleanerTask task = CleanerTask.create((Configuration)this.conf, (SCMStore)this.store, (CleanerMetrics)this.metrics, (Lock)this.cleanerTaskLock);
        long periodInMinutes = CleanerService.getPeriod((Configuration)this.conf);
        this.scheduledExecutor.scheduleAtFixedRate((Runnable)task, CleanerService.getInitialDelay((Configuration)this.conf), periodInMinutes, TimeUnit.MINUTES);
        LOG.info((Object)("Scheduled the shared cache cleaner task to run every " + periodInMinutes + " minutes."));
    }

    protected void serviceStop() throws Exception {
        LOG.info((Object)"Shutting down the background thread.");
        this.scheduledExecutor.shutdownNow();
        try {
            if (this.scheduledExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.info((Object)"The background thread stopped.");
            } else {
                LOG.warn((Object)"Gave up waiting for the cleaner task to shutdown.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"The cleaner service was interrupted while shutting down the task.", (Throwable)e);
        }
        this.removeGlobalCleanerPidFile();
        super.serviceStop();
    }

    protected void runCleanerTask() {
        CleanerTask task = CleanerTask.create((Configuration)this.conf, (SCMStore)this.store, (CleanerMetrics)this.metrics, (Lock)this.cleanerTaskLock);
        this.scheduledExecutor.execute((Runnable)task);
    }

    private boolean writeGlobalCleanerPidFile() throws YarnException {
        String root = this.conf.get("yarn.sharedcache.root-dir", "/sharedcache");
        Path pidPath = new Path(root, ".cleaner_pid");
        try {
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            if (fs.exists(pidPath)) {
                return false;
            }
            FSDataOutputStream os = fs.create(pidPath, false);
            String ID = ManagementFactory.getRuntimeMXBean().getName();
            os.writeUTF(ID);
            os.close();
            fs.deleteOnExit(pidPath);
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        LOG.info((Object)("Created the global cleaner pid file at " + pidPath.toString()));
        return true;
    }

    private void removeGlobalCleanerPidFile() {
        try {
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            String root = this.conf.get("yarn.sharedcache.root-dir", "/sharedcache");
            Path pidPath = new Path(root, ".cleaner_pid");
            fs.delete(pidPath, false);
            LOG.info((Object)("Removed the global cleaner pid file at " + pidPath.toString()));
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to remove the global cleaner pid file! The file may need to be removed manually.", (Throwable)e);
        }
    }

    private static int getInitialDelay(Configuration conf) {
        int initialDelayInMinutes = conf.getInt("yarn.sharedcache.cleaner.initial-delay-mins", 10);
        if (initialDelayInMinutes < 0) {
            throw new HadoopIllegalArgumentException("Negative initial delay value: " + initialDelayInMinutes + ". The initial delay must be greater than zero.");
        }
        return initialDelayInMinutes;
    }

    private static int getPeriod(Configuration conf) {
        int periodInMinutes = conf.getInt("yarn.sharedcache.cleaner.period-mins", 1440);
        if (periodInMinutes <= 0) {
            throw new HadoopIllegalArgumentException("Non-positive period value: " + periodInMinutes + ". The cleaner period must be greater than or equal to zero.");
        }
        return periodInMinutes;
    }
}

