/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(about="Client SCM metrics", context="yarn")
public class ClientSCMMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSCMMetrics.class);
    final MetricsRegistry registry = new MetricsRegistry("clientRequests");
    private static final ClientSCMMetrics INSTANCE = ClientSCMMetrics.create();
    @Metric(value={"Number of cache hits"})
    MutableCounterLong cacheHits;
    @Metric(value={"Number of cache misses"})
    MutableCounterLong cacheMisses;
    @Metric(value={"Number of cache releases"})
    MutableCounterLong cacheReleases;

    private ClientSCMMetrics() {
        LOG.debug("Initialized " + this.registry);
    }

    public static ClientSCMMetrics getInstance() {
        return INSTANCE;
    }

    static ClientSCMMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ClientSCMMetrics metrics = new ClientSCMMetrics();
        ms.register("clientRequests", null, (Object)metrics);
        return metrics;
    }

    public void incCacheHitCount() {
        this.cacheHits.incr();
    }

    public void incCacheMissCount() {
        this.cacheMisses.incr();
    }

    public void incCacheRelease() {
        this.cacheReleases.incr();
    }

    public long getCacheHits() {
        return this.cacheHits.value();
    }

    public long getCacheMisses() {
        return this.cacheMisses.value();
    }

    public long getCacheReleases() {
        return this.cacheReleases.value();
    }
}

