/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.server.sharedcachemanager.RemoteAppChecker;
import org.apache.hadoop.yarn.server.sharedcachemanager.TestRemoteAppChecker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRemoteAppChecker {
    private RemoteAppChecker checker;

    @After
    public void cleanup() {
        if (this.checker != null) {
            this.checker.stop();
        }
    }

    private YarnClient createCheckerWithMockedClient() {
        YarnClient client = (YarnClient)Mockito.spy((Object)new DummyYarnClientImpl(this));
        this.checker = new RemoteAppChecker(client);
        this.checker.init(new Configuration());
        this.checker.start();
        return client;
    }

    @Test
    public void testNonExistentApp() throws Exception {
        YarnClient client = this.createCheckerWithMockedClient();
        ApplicationId id = ApplicationId.newInstance((long)1L, (int)1);
        ((YarnClient)Mockito.doReturn(null).when((Object)client)).getApplicationReport(id);
        Assert.assertFalse((boolean)this.checker.isApplicationActive(id));
        ((YarnClient)Mockito.doThrow((Throwable)new ApplicationNotFoundException("Throw!")).when((Object)client)).getApplicationReport(id);
        Assert.assertFalse((boolean)this.checker.isApplicationActive(id));
    }

    @Test
    public void testRunningApp() throws Exception {
        YarnClient client = this.createCheckerWithMockedClient();
        ApplicationId id = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationReportPBImpl report = new ApplicationReportPBImpl();
        report.setYarnApplicationState(YarnApplicationState.ACCEPTED);
        ((YarnClient)Mockito.doReturn((Object)report).when((Object)client)).getApplicationReport(id);
        Assert.assertTrue((boolean)this.checker.isApplicationActive(id));
    }
}

