/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.server.sharedcachemanager.CleanerTask;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCleanerTask {
    private static final String ROOT = "/sharedcache";
    private static final long SLEEP_TIME = 0L;
    private static final int NESTED_LEVEL = 3;

    @Test
    public void testNonExistentRoot() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        CleanerMetrics metrics = (CleanerMetrics)Mockito.mock(CleanerMetrics.class);
        SCMStore store = (SCMStore)Mockito.mock(SCMStore.class);
        CleanerTask task = this.createSpiedTask(fs, store, metrics, (Lock)new ReentrantLock());
        Mockito.when((Object)fs.exists(task.getRootPath())).thenReturn((Object)false);
        task.run();
        ((CleanerTask)Mockito.verify((Object)task, (VerificationMode)Mockito.never())).process();
    }

    @Test
    public void testProcessFreshResource() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        CleanerMetrics metrics = (CleanerMetrics)Mockito.mock(CleanerMetrics.class);
        SCMStore store = (SCMStore)Mockito.mock(SCMStore.class);
        CleanerTask task = this.createSpiedTask(fs, store, metrics, (Lock)new ReentrantLock());
        Mockito.when((Object)store.isResourceEvictable((String)Matchers.isA(String.class), (FileStatus)Matchers.isA(FileStatus.class))).thenReturn((Object)false);
        FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)status.getPath()).thenReturn((Object)new Path("/sharedcache/a/b/c/abc"));
        task.processSingleResource(status);
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.never())).rename((Path)Matchers.eq((Object)status.getPath()), (Path)Matchers.isA(Path.class));
        ((CleanerMetrics)Mockito.verify((Object)metrics)).reportAFileProcess();
        ((CleanerMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.never())).reportAFileDelete();
    }

    @Test
    public void testProcessEvictableResource() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        CleanerMetrics metrics = (CleanerMetrics)Mockito.mock(CleanerMetrics.class);
        SCMStore store = (SCMStore)Mockito.mock(SCMStore.class);
        CleanerTask task = this.createSpiedTask(fs, store, metrics, (Lock)new ReentrantLock());
        Mockito.when((Object)store.isResourceEvictable((String)Matchers.isA(String.class), (FileStatus)Matchers.isA(FileStatus.class))).thenReturn((Object)true);
        FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)status.getPath()).thenReturn((Object)new Path("/sharedcache/a/b/c/abc"));
        Mockito.when((Object)store.removeResource((String)Matchers.isA(String.class))).thenReturn((Object)true);
        Mockito.when((Object)fs.rename((Path)Matchers.isA(Path.class), (Path)Matchers.isA(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)fs.delete((Path)Matchers.isA(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        task.processSingleResource(status);
        ((FileSystem)Mockito.verify((Object)fs)).rename((Path)Matchers.eq((Object)status.getPath()), (Path)Matchers.isA(Path.class));
        ((CleanerMetrics)Mockito.verify((Object)metrics)).reportAFileDelete();
        ((CleanerMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.never())).reportAFileProcess();
    }

    private CleanerTask createSpiedTask(FileSystem fs, SCMStore store, CleanerMetrics metrics, Lock isCleanerRunning) {
        return (CleanerTask)Mockito.spy((Object)new CleanerTask(ROOT, 0L, 3, fs, store, metrics, isCleanerRunning));
    }

    @Test
    public void testResourceIsInUseHasAnActiveApp() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        CleanerMetrics metrics = (CleanerMetrics)Mockito.mock(CleanerMetrics.class);
        SCMStore store = (SCMStore)Mockito.mock(SCMStore.class);
        FileStatus resource = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)resource.getPath()).thenReturn((Object)new Path("/sharedcache/a/b/c/abc"));
        Mockito.when((Object)store.isResourceEvictable((String)Matchers.isA(String.class), (FileStatus)Matchers.isA(FileStatus.class))).thenReturn((Object)true);
        Mockito.when((Object)store.removeResource((String)Matchers.isA(String.class))).thenReturn((Object)false);
        CleanerTask task = this.createSpiedTask(fs, store, metrics, (Lock)new ReentrantLock());
        task.processSingleResource(resource);
        ((CleanerMetrics)Mockito.verify((Object)metrics)).reportAFileProcess();
        ((CleanerMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.never())).reportAFileDelete();
    }
}

