/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.sharedcachemanager.AppChecker;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RemoteAppChecker
extends AppChecker {
    private static final EnumSet<YarnApplicationState> ACTIVE_STATES = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.ACCEPTED, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.RUNNING);
    private final YarnClient client;

    public RemoteAppChecker() {
        this(YarnClient.createYarnClient());
    }

    RemoteAppChecker(YarnClient client) {
        super("RemoteAppChecker");
        this.client = client;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.addService((Service)this.client);
        super.serviceInit(conf);
    }

    @InterfaceAudience.Private
    public boolean isApplicationActive(ApplicationId id) throws YarnException {
        ApplicationReport report = null;
        try {
            report = this.client.getApplicationReport(id);
        }
        catch (ApplicationNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
        if (report == null) {
            return false;
        }
        return ACTIVE_STATES.contains(report.getYarnApplicationState());
    }

    @InterfaceAudience.Private
    public Collection<ApplicationId> getActiveApplications() throws YarnException {
        try {
            ArrayList<ApplicationId> activeApps = new ArrayList<ApplicationId>();
            List apps = this.client.getApplications(ACTIVE_STATES);
            for (ApplicationReport app : apps) {
                activeApps.add(app.getApplicationId());
            }
            return activeApps;
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }
}

