/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;

public class UserSettings {
    private final String username;
    private final Integer maxRunningApps;

    UserSettings(Builder builder) {
        this.username = builder.username;
        this.maxRunningApps = builder.maxRunningApps;
    }

    public String render() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.addStartTag(pw);
        AllocationFileWriter.addIfPresent(pw, "maxRunningApps", this.maxRunningApps);
        this.addEndTag(pw);
        pw.close();
        return sw.toString();
    }

    private void addStartTag(PrintWriter pw) {
        pw.println("<user name=\"" + this.username + "\">");
    }

    private void addEndTag(PrintWriter pw) {
        pw.println("</user>");
    }

    public static class Builder {
        private final String username;
        private Integer maxRunningApps;

        public Builder(String username) {
            this.username = username;
        }

        public Builder maxRunningApps(int value) {
            this.maxRunningApps = value;
            return this;
        }

        public UserSettings build() {
            return new UserSettings(this);
        }
    }
}

