/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatcher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatchers;
import org.junit.Test;

public class TestMappingRuleMatchers
extends TestCase {
    @Test
    public void testCatchAll() {
        VariableContext variables = new VariableContext();
        MappingRuleMatchers.MatchAllMatcher matcher = new MappingRuleMatchers.MatchAllMatcher();
        TestMappingRuleMatchers.assertTrue((boolean)matcher.match(variables));
    }

    @Test
    public void testVariableMatcher() {
        VariableContext matchingContext = new VariableContext();
        matchingContext.put("%user", "bob");
        matchingContext.put("%primary_group", "developers");
        matchingContext.put("%application", "TurboMR");
        matchingContext.put("%custom", "Matching string");
        matchingContext.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"developers"}));
        VariableContext mismatchingContext = new VariableContext();
        mismatchingContext.put("%user", "dave");
        mismatchingContext.put("%primary_group", "testers");
        mismatchingContext.put("%application", "Tester APP");
        mismatchingContext.put("%custom", "Not matching string");
        mismatchingContext.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"testers"}));
        VariableContext emptyContext = new VariableContext();
        HashMap<String, Object> matchers = new HashMap<String, Object>();
        matchers.put("User matcher", MappingRuleMatchers.createUserMatcher((String)"bob"));
        matchers.put("Group matcher", MappingRuleMatchers.createUserGroupMatcher((String)"developers"));
        matchers.put("Application name matcher", MappingRuleMatchers.createApplicationNameMatcher((String)"TurboMR"));
        matchers.put("Custom matcher", new MappingRuleMatchers.VariableMatcher("%custom", "Matching string"));
        matchers.forEach((matcherName, matcher) -> {
            TestMappingRuleMatchers.assertTrue((String)(matcherName + " with matchingContext should match"), (boolean)matcher.match(matchingContext));
            TestMappingRuleMatchers.assertFalse((String)(matcherName + " with mismatchingContext shouldn't match"), (boolean)matcher.match(mismatchingContext));
            TestMappingRuleMatchers.assertFalse((String)(matcherName + " with emptyContext shouldn't match"), (boolean)matcher.match(emptyContext));
        });
    }

    @Test
    public void testVariableMatcherSubstitutions() {
        VariableContext matchingContext = new VariableContext();
        matchingContext.put("%user", "bob");
        matchingContext.put("%primary_group", "developers");
        matchingContext.put("%application", "TurboMR");
        matchingContext.put("%custom", "bob");
        matchingContext.put("%cus", "b");
        matchingContext.put("%tom", "ob");
        VariableContext mismatchingContext = new VariableContext();
        mismatchingContext.put("%user", "dave");
        mismatchingContext.put("%primary_group", "testers");
        mismatchingContext.put("%application", "Tester APP");
        mismatchingContext.put("%custom", "bob");
        mismatchingContext.put("%cus", "b");
        mismatchingContext.put("%tom", "ob");
        MappingRuleMatchers.VariableMatcher customUser = new MappingRuleMatchers.VariableMatcher("%custom", "%user");
        MappingRuleMatchers.VariableMatcher userCusTom = new MappingRuleMatchers.VariableMatcher("%user", "%cus%tom");
        MappingRuleMatchers.VariableMatcher userCustom = new MappingRuleMatchers.VariableMatcher("%user", "%custom");
        MappingRuleMatchers.VariableMatcher userUser = new MappingRuleMatchers.VariableMatcher("%user", "%user");
        MappingRuleMatchers.VariableMatcher userStatic = new MappingRuleMatchers.VariableMatcher("%user", "bob");
        TestMappingRuleMatchers.assertTrue((String)"%custom should match %user in matching context", (boolean)customUser.match(matchingContext));
        TestMappingRuleMatchers.assertTrue((String)"%user should match %custom in matching context", (boolean)userCustom.match(matchingContext));
        TestMappingRuleMatchers.assertTrue((String)"%user (bob) should match %cus%tom (b + ob) in matching context", (boolean)userCusTom.match(matchingContext));
        TestMappingRuleMatchers.assertTrue((String)"%user should match %user in any context", (boolean)userUser.match(matchingContext));
        TestMappingRuleMatchers.assertTrue((String)"%user (bob) should match bob in in matching context", (boolean)userStatic.match(matchingContext));
        TestMappingRuleMatchers.assertFalse((String)"%custom (bob) should NOT match %user (dave) in mismatching context", (boolean)customUser.match(mismatchingContext));
        TestMappingRuleMatchers.assertFalse((String)"%user (dave) should NOT match %custom (bob) in mismatching context", (boolean)userCustom.match(mismatchingContext));
        TestMappingRuleMatchers.assertFalse((String)"%user (dave) should NOT match %cus%tom (b+ob) in mismatching context", (boolean)userCusTom.match(mismatchingContext));
        TestMappingRuleMatchers.assertTrue((String)"%user should match %user in any context", (boolean)userUser.match(mismatchingContext));
        TestMappingRuleMatchers.assertFalse((String)"%user (dave) should NOT match match bob in in matching context", (boolean)userStatic.match(mismatchingContext));
    }

    @Test
    public void testVariableMatcherWithEmpties() {
        VariableContext emptyContext = new VariableContext();
        VariableContext allNull = new VariableContext();
        allNull.put("%null", null);
        allNull.put("%empty", null);
        VariableContext allEmpty = new VariableContext();
        allEmpty.put("%null", "");
        allEmpty.put("%empty", "");
        VariableContext allMakesSense = new VariableContext();
        allMakesSense.put("%null", null);
        allMakesSense.put("%empty", "");
        VariableContext allFull = new VariableContext();
        allFull.put("%null", "full");
        allFull.put("%empty", "full");
        MappingRuleMatchers.VariableMatcher nullMatcher = new MappingRuleMatchers.VariableMatcher("%null", null);
        MappingRuleMatchers.VariableMatcher emptyMatcher = new MappingRuleMatchers.VariableMatcher("%empty", "");
        TestMappingRuleMatchers.assertTrue((boolean)nullMatcher.match(emptyContext));
        TestMappingRuleMatchers.assertTrue((boolean)emptyMatcher.match(emptyContext));
        TestMappingRuleMatchers.assertTrue((boolean)nullMatcher.match(allEmpty));
        TestMappingRuleMatchers.assertTrue((boolean)emptyMatcher.match(allEmpty));
        TestMappingRuleMatchers.assertTrue((boolean)nullMatcher.match(allNull));
        TestMappingRuleMatchers.assertTrue((boolean)emptyMatcher.match(allNull));
        TestMappingRuleMatchers.assertTrue((boolean)nullMatcher.match(allMakesSense));
        TestMappingRuleMatchers.assertTrue((boolean)emptyMatcher.match(allMakesSense));
        TestMappingRuleMatchers.assertFalse((boolean)nullMatcher.match(allFull));
        TestMappingRuleMatchers.assertFalse((boolean)emptyMatcher.match(allFull));
        MappingRuleMatchers.VariableMatcher nullVarMatcher = new MappingRuleMatchers.VariableMatcher(null, "");
        TestMappingRuleMatchers.assertFalse((boolean)nullVarMatcher.match(emptyContext));
        TestMappingRuleMatchers.assertFalse((boolean)nullVarMatcher.match(allNull));
        TestMappingRuleMatchers.assertFalse((boolean)nullVarMatcher.match(allEmpty));
        TestMappingRuleMatchers.assertFalse((boolean)nullVarMatcher.match(allMakesSense));
        TestMappingRuleMatchers.assertFalse((boolean)nullVarMatcher.match(allFull));
    }

    @Test
    public void testBoolOperatorMatchers() {
        VariableContext developerBob = new VariableContext();
        developerBob.put("%user", "bob");
        developerBob.put("%primary_group", "developers");
        developerBob.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"developers"}));
        VariableContext testerBob = new VariableContext();
        testerBob.put("%user", "bob");
        testerBob.put("%primary_group", "testers");
        testerBob.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"testers"}));
        VariableContext testerDave = new VariableContext();
        testerDave.put("%user", "dave");
        testerDave.put("%primary_group", "testers");
        testerDave.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"testers"}));
        VariableContext accountantDave = new VariableContext();
        accountantDave.put("%user", "dave");
        accountantDave.put("%primary_group", "accountants");
        MappingRuleMatchers.VariableMatcher userBob = new MappingRuleMatchers.VariableMatcher("%user", "bob");
        MappingRuleMatchers.VariableMatcher groupDevelopers = new MappingRuleMatchers.VariableMatcher("%primary_group", "developers");
        MappingRuleMatchers.VariableMatcher groupAccountants = new MappingRuleMatchers.VariableMatcher("%primary_group", "accountants");
        MappingRuleMatchers.AndMatcher developerBobMatcher = new MappingRuleMatchers.AndMatcher(new MappingRuleMatcher[]{userBob, groupDevelopers});
        MappingRuleMatcher testerDaveMatcher = MappingRuleMatchers.createUserGroupMatcher((String)"dave", (String)"testers");
        MappingRuleMatchers.OrMatcher accountantOrBobMatcher = new MappingRuleMatchers.OrMatcher(new MappingRuleMatcher[]{groupAccountants, userBob});
        TestMappingRuleMatchers.assertTrue((boolean)developerBobMatcher.match(developerBob));
        TestMappingRuleMatchers.assertFalse((boolean)developerBobMatcher.match(testerBob));
        TestMappingRuleMatchers.assertFalse((boolean)developerBobMatcher.match(testerDave));
        TestMappingRuleMatchers.assertFalse((boolean)developerBobMatcher.match(accountantDave));
        TestMappingRuleMatchers.assertFalse((boolean)testerDaveMatcher.match(developerBob));
        TestMappingRuleMatchers.assertFalse((boolean)testerDaveMatcher.match(testerBob));
        TestMappingRuleMatchers.assertTrue((boolean)testerDaveMatcher.match(testerDave));
        TestMappingRuleMatchers.assertFalse((boolean)testerDaveMatcher.match(accountantDave));
        TestMappingRuleMatchers.assertTrue((boolean)accountantOrBobMatcher.match(developerBob));
        TestMappingRuleMatchers.assertTrue((boolean)accountantOrBobMatcher.match(testerBob));
        TestMappingRuleMatchers.assertFalse((boolean)accountantOrBobMatcher.match(testerDave));
        TestMappingRuleMatchers.assertTrue((boolean)accountantOrBobMatcher.match(accountantDave));
    }

    @Test
    public void testToStrings() {
        MappingRuleMatchers.VariableMatcher var = new MappingRuleMatchers.VariableMatcher("%a", "b");
        MappingRuleMatcher all = MappingRuleMatchers.createAllMatcher();
        MappingRuleMatchers.AndMatcher and = new MappingRuleMatchers.AndMatcher(new MappingRuleMatcher[]{var, all, var});
        MappingRuleMatchers.OrMatcher or = new MappingRuleMatchers.OrMatcher(new MappingRuleMatcher[]{var, all, var});
        TestMappingRuleMatchers.assertEquals((String)"VariableMatcher{variable='%a', value='b'}", (String)var.toString());
        TestMappingRuleMatchers.assertEquals((String)"MatchAllMatcher", (String)all.toString());
        TestMappingRuleMatchers.assertEquals((String)("AndMatcher{matchers=[" + var.toString() + ", " + all.toString() + ", " + var.toString() + "]}"), (String)and.toString());
        TestMappingRuleMatchers.assertEquals((String)("OrMatcher{matchers=[" + var.toString() + ", " + all.toString() + ", " + var.toString() + "]}"), (String)or.toString());
    }

    @Test
    public void testGroupMatching() {
        VariableContext letterGroups = new VariableContext();
        letterGroups.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"a", "b", "c"}));
        VariableContext numberGroups = new VariableContext();
        numberGroups.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"1", "2", "3"}));
        VariableContext noGroups = new VariableContext();
        MappingRuleMatcher matchA = MappingRuleMatchers.createUserGroupMatcher((String)"a");
        MappingRuleMatcher matchB = MappingRuleMatchers.createUserGroupMatcher((String)"b");
        MappingRuleMatcher matchC = MappingRuleMatchers.createUserGroupMatcher((String)"c");
        MappingRuleMatcher match1 = MappingRuleMatchers.createUserGroupMatcher((String)"1");
        MappingRuleMatcher match2 = MappingRuleMatchers.createUserGroupMatcher((String)"2");
        MappingRuleMatcher match3 = MappingRuleMatchers.createUserGroupMatcher((String)"3");
        MappingRuleMatcher matchNull = MappingRuleMatchers.createUserGroupMatcher(null);
        TestMappingRuleMatchers.assertTrue((boolean)matchA.match(letterGroups));
        TestMappingRuleMatchers.assertTrue((boolean)matchB.match(letterGroups));
        TestMappingRuleMatchers.assertTrue((boolean)matchC.match(letterGroups));
        TestMappingRuleMatchers.assertFalse((boolean)match1.match(letterGroups));
        TestMappingRuleMatchers.assertFalse((boolean)match2.match(letterGroups));
        TestMappingRuleMatchers.assertFalse((boolean)match3.match(letterGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchNull.match(letterGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchA.match(numberGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchB.match(numberGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchC.match(numberGroups));
        TestMappingRuleMatchers.assertTrue((boolean)match1.match(numberGroups));
        TestMappingRuleMatchers.assertTrue((boolean)match2.match(numberGroups));
        TestMappingRuleMatchers.assertTrue((boolean)match3.match(numberGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchNull.match(numberGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchA.match(noGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchB.match(noGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchC.match(noGroups));
        TestMappingRuleMatchers.assertFalse((boolean)match1.match(noGroups));
        TestMappingRuleMatchers.assertFalse((boolean)match2.match(noGroups));
        TestMappingRuleMatchers.assertFalse((boolean)match3.match(noGroups));
        TestMappingRuleMatchers.assertFalse((boolean)matchNull.match(noGroups));
    }
}

