/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework;

import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.mockframework.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ContainerSpecification {
    Priority priority;
    Resource resource = Resource.newInstance((int)0, (int)0);
    Resource pendingResource = Resource.newInstance((int)0, (int)0);
    NodeId nodeId;
    String label;
    int repeat;
    boolean reserved;
    String username;

    private ContainerSpecification(Builder builder) {
        if (builder.resource != null) {
            Resources.addTo((Resource)this.resource, (Resource)builder.resource);
        }
        if (builder.pendingResource != null) {
            Resources.addTo((Resource)this.pendingResource, (Resource)builder.pendingResource);
        }
        this.priority = builder.priority;
        this.nodeId = builder.nodeId;
        this.label = builder.label;
        this.repeat = builder.repeat;
        this.reserved = builder.reserved;
        this.username = builder.username;
    }

    static class Builder {
        private Priority priority;
        private Resource resource;
        private NodeId nodeId;
        private String label;
        private int repeat;
        private boolean reserved;
        private Resource pendingResource;
        private String username = "user";

        Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        Builder withPriority(String value) {
            this.priority = Priority.newInstance((int)Integer.valueOf(value));
            return this;
        }

        Builder withResource(String value) {
            this.resource = ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(value);
            return this;
        }

        Builder withHostname(String value) {
            this.nodeId = NodeId.newInstance((String)value, (int)1);
            return this;
        }

        Builder withLabel(String value) {
            this.label = value;
            return this;
        }

        Builder withRepeat(String repeat) {
            this.repeat = Integer.valueOf(repeat);
            return this;
        }

        Builder withReserved(String value) {
            this.reserved = Boolean.valueOf(value);
            return this;
        }

        Builder withPendingResource(String value) {
            this.pendingResource = ProportionalCapacityPreemptionPolicyMockFramework.parseResourceFromString(value);
            return this;
        }

        Builder withUsername(String value) {
            this.username = value;
            return this;
        }

        public ContainerSpecification build() {
            return new ContainerSpecification(this);
        }
    }
}

