/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResourceManagerMXBean {
    public static final Logger LOG = LoggerFactory.getLogger(TestResourceManagerMXBean.class);

    @Test
    public void testResourceManagerMXBean() throws Exception {
        try (ResourceManager resourceManager = new ResourceManager();){
            YarnConfiguration conf = new YarnConfiguration();
            UserGroupInformation.setConfiguration((Configuration)conf);
            resourceManager.init((Configuration)conf);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=ResourceManager,name=ResourceManager");
            boolean securityEnabled = (Boolean)mbs.getAttribute(mxbeanName, "SecurityEnabled");
            Assert.assertEquals((Object)resourceManager.isSecurityEnabled(), (Object)securityEnabled);
        }
    }
}

