/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.function.Supplier;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClusterMetrics {
    private ClusterMetrics metrics;

    @Test
    public void testAmMetrics() throws Exception {
        assert (this.metrics != null);
        Assert.assertTrue((!this.metrics.aMLaunchDelay.changed() ? 1 : 0) != 0);
        Assert.assertTrue((!this.metrics.aMRegisterDelay.changed() ? 1 : 0) != 0);
        Assert.assertTrue((!this.metrics.getAMContainerAllocationDelay().changed() ? 1 : 0) != 0);
        this.metrics.addAMLaunchDelay(1L);
        this.metrics.addAMRegisterDelay(1L);
        this.metrics.addAMContainerAllocationDelay(1L);
        Assert.assertTrue((boolean)this.metrics.aMLaunchDelay.changed());
        Assert.assertTrue((boolean)this.metrics.aMRegisterDelay.changed());
        Assert.assertTrue((boolean)this.metrics.getAMContainerAllocationDelay().changed());
    }

    @Before
    public void setup() {
        DefaultMetricsSystem.initialize((String)"ResourceManager");
        this.metrics = ClusterMetrics.getMetrics();
    }

    @After
    public void tearDown() {
        ClusterMetrics.destroy();
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms.getSource("ClusterMetrics") != null) {
            DefaultMetricsSystem.shutdown();
        }
    }

    @Test
    public void testClusterMetrics() throws Exception {
        Assert.assertTrue((!this.metrics.containerAssignedPerSecond.changed() ? 1 : 0) != 0);
        this.metrics.incrNumContainerAssigned();
        this.metrics.incrNumContainerAssigned();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return TestClusterMetrics.this.metrics.getContainerAssignedPerSecond() == 2;
            }
        }, (long)500L, (long)5000L);
    }
}

