/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceRequestInfo;
import org.apache.hadoop.yarn.server.webapp.AppAttemptBlock;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class RMAppAttemptBlock
extends AppAttemptBlock {
    private final ResourceManager rm;
    protected Configuration conf;
    private static final String DIAGNOSTICS_SCRIPT_BODY = "var refresh = false;" + "var haveGotAppDiagnostic = false;" + "function getArray(objOrArray) {" + "  if(Array.isArray(objOrArray)){" + "    return objOrArray;" + "  } else {" + "    return [objOrArray];" + "  }" + "}" + "function getTableDataFromObjectArray(objectArray, fields) {" + "  if (objectArray == undefined) {" + "    return [];" + "  }" + "  var data = [];" + "  $.each(objectArray, function(i, object) {" + "    var dataItem = [];" + "    for (var i=0; i<fields.length; i++) {" + "      dataItem.push(object[fields[i]] != undefined ? " + "object[fields[i]] : '');" + "    }" + "    data.push(dataItem);" + "  });" + "  return data;" + "}" + "function sendRequest(requestURL, doneCallBackFunc," + "                      failCallBackFunc) {" + " $.ajax({" + "  type: 'GET'," + "  url: requestURL," + "  contentType: 'text/plain'" + " }).done(doneCallBackFunc).fail(failCallBackFunc);" + "}" + "function parseQueryAppActResponse(responseObj) {" + " var requestDiagnostics = [], dateTime, appDiagnostic;" + " responseObj = responseObj['appActivities'];" + " if(responseObj.hasOwnProperty('allocations')){" + "  var allocations = getArray(responseObj['allocations']);" + "  var allocation = allocations[0];" + "  dateTime = allocation['dateTime'];" + "  if(allocation.hasOwnProperty('diagnostic')){" + "   appDiagnostic = allocation['diagnostic'];" + "  }" + "  if(allocation.hasOwnProperty('children')){" + "   var requestAllocations = " + "     getArray(allocation['children']);" + "   $.each(requestAllocations, function (i, requestAllocation) {" + "    if(requestAllocation.hasOwnProperty('children')){" + "     var allocationAttempts = " + "       getArray(requestAllocation['children']);" + "     var diagnosticSummary = requestAllocation.hasOwnProperty(" + "       'diagnostic')? requestAllocation['diagnostic']+'. ':'';" + "     $.each(allocationAttempts, function(i,allocationAttempt) {" + "      if (i > 0) {" + "       diagnosticSummary += ', ';" + "      }" + "      diagnosticSummary += allocationAttempt['count'] + ' ' +" + "        (allocationAttempt['count']=='1' ? 'node ' : 'nodes ')" + "        + allocationAttempt['allocationState'];" + "      if (allocationAttempt.hasOwnProperty('diagnostic')) {" + "       diagnosticSummary += ' with diagnostic:' + " + "                   allocationAttempt['diagnostic'];" + "      }" + "     });" + "     delete requestAllocation['children'];" + "     requestAllocation['diagnostic']=diagnosticSummary;" + "    }" + "    requestDiagnostics.push(requestAllocation);" + "   });" + "  }" + " }" + " return [requestDiagnostics, dateTime, appDiagnostic];" + "}" + "function handleQueryAppActDone(data){" + "  console.log('App activities:', data);" + "  var results = parseQueryAppActResponse(data);" + "  console.log('parsed results:', results);" + "  var requestDiagnostics = results[0];" + "  var dateTime = results[1];" + "  var appDiagnostic = results[2];" + "  haveGotAppDiagnostic = false;" + "  if (appDiagnostic != undefined) {" + "    haveGotAppDiagnostic = true;" + "    $('#appDiagnostic').html('App diagnostic: '" + "        + appDiagnostic);" + "  }" + "  $('#diagnosticsTableDiv').empty();" + "  if (requestDiagnostics.length > 0) {" + "    haveGotAppDiagnostic = true;" + "    tableData = getTableDataFromObjectArray(requestDiagnostics," + " ['requestPriority', 'allocationRequestId', 'allocationState'," + " 'diagnostic']);" + "    $('#diagnosticsTableDiv').append('<table " + "      id=\"diagnosticsTable\"></table>');" + "    $('#diagnosticsTable').dataTable( {" + "      'aaData': tableData," + "      'aoColumns': [" + "        { 'sTitle': 'Priority' }," + "        { 'sTitle': 'AllocationRequestId' }," + "        { 'sTitle': 'AllocationState' }," + "        { 'sTitle': 'DiagnosticSummary' }" + "      ]," + "      bJQueryUI:true, sPaginationType: 'full_numbers'," + "      iDisplayLength:20, aLengthMenu:[20, 40, 60, 80, 100]" + "    });" + "  }" + "  if (haveGotAppDiagnostic) {" + "    $('#refreshDiagnosticsBtn').attr('disabled',false);" + "    $('#diagnosticsUpdateTime').html('Updated at ' + dateTime);" + "  } else {" + "    $('#diagnosticsUpdateTime').html('');" + "    if (refresh) {" + "      refreshSchedulerDiagnostics();" + "    }" + "  }" + "}" + "function handleRequestFailure(data){" + " alert('Request app activities REST API failed.');" + " console.log(data);" + "}" + "function handleRefreshAppActDone(data){" + " refresh = true;" + " setTimeout(function(){" + "  queryAppDiagnostics();" + " }, 2000);" + "}" + "function refreshAppDiagnostics() {" + " $('#refreshDiagnosticsBtn').attr('disabled',true);" + " sendRequest(refreshAppActivitiesURL,handleRefreshAppActDone," + "             handleRequestFailure);" + "}" + "function queryAppDiagnostics() {" + " sendRequest(getAppActivitiesURL,handleQueryAppActDone," + "             handleRequestFailure);" + "}" + "function parseHierarchicalQueue(node, nodeInfos," + "    parentNodePath, partition) {" + "  var nodePath = parentNodePath + '/' + node['name'];" + "  if (node.hasOwnProperty('name')){" + "    if (node['diagnostic'] == undefined || node['diagnostic']" + "      .indexOf(ignoreActivityContent) == -1){" + "     var nodeInfo = {};" + "     nodeInfo['partition'] = partition;" + "     nodeInfo['path'] = nodePath;" + "     nodeInfo['allocationState'] = node['allocationState'];" + "     nodeInfo['diagnostic'] = " + "      node['diagnostic'] == undefined ? '':node['diagnostic'];" + "     nodeInfos.push(nodeInfo);" + "    }" + "  }" + "  if (node.hasOwnProperty('children')){" + "    var children = getArray(node['children']);" + "    $.each(children, function (i, child) {" + "      parseHierarchicalQueue(child, nodeInfos, nodePath," + "        partition);" + "    });" + "  }" + "}" + "function parseQueueDiagnostics(data) {" + "  var nodeInfos = [], dateTime;" + "  if(data.hasOwnProperty('dateTime')){" + "      dateTime = data['dateTime'];" + "  }" + "  if(data.hasOwnProperty('allocations')){" + "    var allocations = getArray(data['allocations']);" + "    $.each(allocations, function (i, allocation) {" + "      if (allocation.hasOwnProperty('root')) {" + "        var root = allocation['root'];" + "        var partition = allocation['partition'];" + "        parseHierarchicalQueue(root, nodeInfos, '', partition);" + "      }" + "    });" + "  }" + "  return [nodeInfos, dateTime];" + "}" + "function handleRefreshSchedulerActDone(data){" + " console.log('handleRefreshSchedulerActDone', data);" + " setTimeout(function(){" + "  querySchedulerDiagnostics();" + "  $('#refreshDiagnosticsBtn').attr('disabled',false);" + " }, 100);" + "}" + "function handleQuerySchedulerActDone(data){" + "  console.log('Scheduler activities:', data);" + "  data = data['activities'];" + "  var results = parseQueueDiagnostics(data);" + "  var nodeInfos = results[0];" + "  var dateTime = results[1];" + "  $('#diagnosticsTableDiv').empty();" + "  if(dateTime != undefined){" + "   $('#diagnosticsUpdateTime').html('App diagnostics not found!" + " Got useful scheduler activities updated at '+dateTime);" + "    tableData = getTableDataFromObjectArray(nodeInfos, " + " ['partition', 'path', 'allocationState', 'diagnostic']);" + "    $('#diagnosticsTableDiv').append('<table " + "      id=\"diagnosticsTable\"></table>');" + "    $('#diagnosticsTable').dataTable({" + "      'aaData': tableData," + "      'aoColumns': [" + "        { 'sTitle': 'Partition' }," + "        { 'sTitle': 'SchedulingNode' }," + "        { 'sTitle': 'AllocationState' }," + "        { 'sTitle': 'Diagnostic' }" + "      ]," + "      bJQueryUI:true, sPaginationType: 'full_numbers'," + "      iDisplayLength:20, aLengthMenu:[20, 40, 60, 80, 100]" + "    });" + "  } else if(data.hasOwnProperty('diagnostic')){" + "    $('#diagnosticsUpdateTime').html(data['diagnostic']);" + "  }" + "  $('#refreshDiagnosticsBtn').attr('disabled',false);" + "}" + "function refreshSchedulerDiagnostics() {" + " $('#refreshDiagnosticsBtn').attr('disabled',true);" + " sendRequest(schedulerActivitiesURL," + "   handleRefreshSchedulerActDone,handleRequestFailure);" + "}" + "function querySchedulerDiagnostics() {" + " sendRequest(schedulerActivitiesURL," + "   handleQuerySchedulerActDone,handleRequestFailure);" + "}" + "queryAppDiagnostics();";

    @Inject
    RMAppAttemptBlock(View.ViewContext ctx, ResourceManager rm, Configuration conf) {
        super(null, ctx);
        this.rm = rm;
        this.conf = conf;
    }

    private void createResourceRequestsTable(HtmlBlock.Block html) {
        AppInfo app = new AppInfo(this.rm, (RMApp)this.rm.getRMContext().getRMApps().get(this.appAttemptId.getApplicationId()), true, WebAppUtils.getHttpSchemePrefix((Configuration)this.conf));
        List<ResourceRequestInfo> resourceRequests = app.getResourceRequests();
        if (resourceRequests == null || resourceRequests.isEmpty()) {
            return;
        }
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)div.h3("Total Outstanding Resource Requests: " + this.getTotalResource(resourceRequests)).table("#resourceRequests").thead().tr().th(".priority", "Priority").th(".allocationRequestId", "AllocationRequestId").th(".resource", "ResourceName").th(".capacity", "Capability").th(".containers", "NumContainers").th(".relaxlocality", "RelaxLocality").th(".labelexpression", "NodeLabelExpression").th(".executiontype", "ExecutionType").th(".allocationTags", "AllocationTags").th(".placementConstraint", "PlacementConstraint").__()).__()).tbody();
        StringBuilder resourceRequestTableData = new StringBuilder("[\n");
        for (ResourceRequestInfo resourceRequest : resourceRequests) {
            if (resourceRequest.getNumContainers() == 0) continue;
            resourceRequestTableData.append("[\"").append(String.valueOf(resourceRequest.getPriority())).append("\",\"").append(String.valueOf(resourceRequest.getAllocationRequestId())).append("\",\"").append(resourceRequest.getResourceName() == null ? "N/A" : resourceRequest.getResourceName()).append("\",\"").append(StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)String.valueOf(resourceRequest.getCapability())))).append("\",\"").append(String.valueOf(resourceRequest.getNumContainers())).append("\",\"").append(String.valueOf(resourceRequest.getRelaxLocality())).append("\",\"").append(resourceRequest.getNodeLabelExpression() == null ? "N/A" : resourceRequest.getNodeLabelExpression()).append("\",\"").append((Object)(resourceRequest.getExecutionTypeRequest() == null ? "N/A" : resourceRequest.getExecutionTypeRequest().getExecutionType())).append("\",\"").append(resourceRequest.getAllocationTags() == null ? "N/A" : StringUtils.join(resourceRequest.getAllocationTags(), (String)",")).append("\",\"").append(resourceRequest.getPlacementConstraint() == null ? "N/A" : resourceRequest.getPlacementConstraint()).append("\"],\n");
        }
        if (resourceRequestTableData.charAt(resourceRequestTableData.length() - 2) == ',') {
            resourceRequestTableData.delete(resourceRequestTableData.length() - 2, resourceRequestTableData.length() - 1);
        }
        resourceRequestTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var resourceRequestsTableData=" + resourceRequestTableData}).__();
        ((Hamlet.TABLE)tbody.__()).__();
        this.createDiagnosticsTable(html, (Hamlet.DIV<Hamlet>)div);
        div.__();
    }

    private Resource getTotalResource(List<ResourceRequestInfo> requests) {
        Resource totalResource = Resource.newInstance((int)0, (int)0);
        if (requests == null) {
            return totalResource;
        }
        for (ResourceRequestInfo request : requests) {
            if (request.getNumContainers() == 0 || request.getResourceName() != null && !request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)totalResource, (Resource)Resources.multiply((Resource)request.getCapability().getResource(), (double)request.getNumContainers()));
        }
        return totalResource;
    }

    private void createContainerLocalityTable(HtmlBlock.Block html) {
        RMAppAttemptMetrics attemptMetrics = null;
        RMAppAttempt attempt = this.getRMAppAttempt();
        if (attempt != null) {
            attemptMetrics = attempt.getRMAppAttemptMetrics();
        }
        if (attemptMetrics == null) {
            return;
        }
        Hamlet.DIV div = html.div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.h3("Total Allocated Containers: " + attemptMetrics.getTotalAllocatedContainers()).h3("Each table cell represents the number of NodeLocal/RackLocal/OffSwitch containers satisfied by NodeLocal/RackLocal/OffSwitch resource requests.").table("#containerLocality");
        table.tr().th(".ui-state-default", "").th(".ui-state-default", "Node Local Request").th(".ui-state-default", "Rack Local Request").th(".ui-state-default", "Off Switch Request").__();
        String[] containersType = new String[]{"Num Node Local Containers (satisfied by)", "Num Rack Local Containers (satisfied by)", "Num Off Switch Containers (satisfied by)"};
        boolean odd = false;
        for (int i = 0; i < attemptMetrics.getLocalityStatistics().length; ++i) {
            odd = !odd;
            table.tr(odd ? ".odd" : ".even").td(containersType[i]).td(String.valueOf(attemptMetrics.getLocalityStatistics()[i][0])).td(i == 0 ? "" : String.valueOf(attemptMetrics.getLocalityStatistics()[i][1])).td(i <= 1 ? "" : String.valueOf(attemptMetrics.getLocalityStatistics()[i][2])).__();
        }
        table.__();
        div.__();
    }

    private boolean isApplicationInFinalState(YarnApplicationAttemptState state) {
        return state == YarnApplicationAttemptState.FINISHED || state == YarnApplicationAttemptState.FAILED || state == YarnApplicationAttemptState.KILLED;
    }

    protected void createAttemptHeadRoomTable(HtmlBlock.Block html) {
        RMAppAttempt attempt = this.getRMAppAttempt();
        if (attempt != null && !this.isApplicationInFinalState(YarnApplicationAttemptState.valueOf((String)attempt.getAppAttemptState().toString()))) {
            RMAppAttemptMetrics metrics = attempt.getRMAppAttemptMetrics();
            Hamlet.DIV pdiv = html.__(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
            this.info("Application Attempt Overview").clear();
            this.info("Application Attempt Metrics").__("Application Attempt Headroom : ", (Object)(metrics == null ? "N/A" : metrics.getApplicationAttemptHeadroom()));
            pdiv.__();
        }
    }

    private RMAppAttempt getRMAppAttempt() {
        ApplicationId appId = this.appAttemptId.getApplicationId();
        RMAppAttempt attempt = null;
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(appId);
        if (rmApp != null) {
            attempt = rmApp.getAppAttempts().get(this.appAttemptId);
        }
        return attempt;
    }

    protected void generateOverview(ApplicationAttemptReport appAttemptReport, Collection<ContainerReport> containers, AppAttemptInfo appAttempt, String node) {
        RMAppAttempt rmAppAttempt = this.getRMAppAttempt();
        String appBlacklistedNodes = this.getNodeString(rmAppAttempt.getBlacklistedNodes());
        String rmBlackListedNodes = this.getNodeString(rmAppAttempt.getAMBlacklistManager().getBlacklistUpdates().getBlacklistAdditions());
        this.info("Application Attempt Overview").__("Application Attempt State:", (Object)(appAttempt.getAppAttemptState() == null ? "N/A" : appAttempt.getAppAttemptState())).__("Started:", (Object)Times.format((long)appAttempt.getStartedTime())).__("Elapsed:", (Object)org.apache.hadoop.util.StringUtils.formatTime((long)Times.elapsed((long)appAttempt.getStartedTime(), (long)appAttempt.getFinishedTime()))).__("AM Container:", appAttempt.getAmContainerId() == null || containers == null || !this.hasAMContainer(appAttemptReport.getAMContainerId(), containers) ? null : this.root_url(new String[]{"container", appAttempt.getAmContainerId()}), (Object)(appAttempt.getAmContainerId() == null ? "N/A" : String.valueOf(appAttempt.getAmContainerId()))).__("Node:", (Object)node).__("Tracking URL:", appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? null : this.root_url(new String[]{appAttempt.getTrackingUrl()}), (Object)(appAttempt.getTrackingUrl() == null || appAttempt.getTrackingUrl().equals("N/A") ? "Unassigned" : (appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FINISHED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.FAILED || appAttempt.getAppAttemptState() == YarnApplicationAttemptState.KILLED ? "History" : "ApplicationMaster"))).__("Diagnostics Info:", (Object)(appAttempt.getDiagnosticsInfo() == null ? "" : appAttempt.getDiagnosticsInfo())).__("Nodes blacklisted by the application:", (Object)appBlacklistedNodes).__("Nodes blacklisted by the system:", (Object)rmBlackListedNodes);
    }

    private String getNodeString(Collection<String> nodes) {
        String concatinatedString = "-";
        if (null != nodes && !nodes.isEmpty()) {
            concatinatedString = StringUtils.join(nodes, (String)", ");
        }
        return concatinatedString;
    }

    protected void createTablesForAttemptMetrics(HtmlBlock.Block html) {
        this.createContainerLocalityTable(html);
        this.createResourceRequestsTable(html);
    }

    protected List<ContainerReport> getContainers(GetContainersRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getContainers(request).getContainerList();
    }

    protected ApplicationAttemptReport getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        return this.rm.getClientRMService().getApplicationAttemptReport(request).getApplicationAttemptReport();
    }

    private void createDiagnosticsTable(HtmlBlock.Block html, Hamlet.DIV<Hamlet> parentDiv) {
        if (!(this.rm.getResourceScheduler() instanceof CapacityScheduler)) {
            return;
        }
        String appActivitiesURL = "/ws/v1/cluster" + "/scheduler/app-activities/{appid}".replace("{appid}", this.appAttemptId.getApplicationId().toString()) + "?";
        String refreshAppActivitiesURL = appActivitiesURL + "actions=refresh";
        String getAppActivitiesURL = appActivitiesURL + "actions=get&groupBy=diagnostic&summarize=true";
        String refreshAndGetAppActivitiesURL = appActivitiesURL + "actions=refresh&actions=get&groupBy=diagnostic&summarize=true";
        String schedulerActivitiesURL = "/ws/v1/cluster" + "/scheduler/activities" + "?" + "groupBy" + "=diagnostic";
        Hamlet.DIV div = parentDiv.div();
        div.p().__(new Object[]{"Diagnostics in cache "}).__(new Object[]{"(For more details refer to "}).a(refreshAndGetAppActivitiesURL, "App Activities").__(new Object[]{" or "}).a(schedulerActivitiesURL, "Scheduler Activities").__(new Object[]{")"}).__();
        div.button().$id("refreshDiagnosticsBtn").$style("border-style: solid; border-color: #000000; border-width: 1px; cursor: hand; cursor: pointer; border-radius: 4px").$onclick("refreshAppDiagnostics()").b("Refresh").__();
        div.p().$id("diagnosticsUpdateTime").__();
        div.p().$id("appDiagnostic").__();
        div.div("#diagnosticsTableDiv").__();
        div.__();
        StringBuilder script = new StringBuilder();
        script.append("var refreshAppActivitiesURL = '").append(refreshAppActivitiesURL).append("';").append("var getAppActivitiesURL = '").append(getAppActivitiesURL).append("';").append("var schedulerActivitiesURL = '").append(schedulerActivitiesURL).append("';").append("var ignoreActivityContent = '").append("does not need more resource';").append(DIAGNOSTICS_SCRIPT_BODY);
        html.script().$type("text/javascript").__(new Object[]{script.toString()}).__();
    }
}

