/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.SchedulingRequestPBImpl;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.exceptions.SchedulerInvalidResoureRequestException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintsUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PendingAskUpdateResult;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;

public class SingleConstraintAppPlacementAllocator<N extends SchedulerNode>
extends AppPlacementAllocator<N> {
    private static final Log LOG = LogFactory.getLog(SingleConstraintAppPlacementAllocator.class);
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private SchedulingRequest schedulingRequest = null;
    private String targetNodePartition;
    private Set<String> targetAllocationTags;
    private AllocationTagsManager allocationTagsManager;
    private PlacementConstraintManager placementConstraintManager;

    public SingleConstraintAppPlacementAllocator() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public Iterator<N> getPreferredNodeIterator(CandidateNodeSet<N> candidateNodeSet) {
        N singleNode = CandidateNodeSetUtils.getSingleNode(candidateNodeSet);
        if (null != singleNode) {
            return IteratorUtils.singletonIterator(singleNode);
        }
        return IteratorUtils.emptyIterator();
    }

    @Override
    public PendingAskUpdateResult updatePendingAsk(Collection<ResourceRequest> requests, boolean recoverPreemptedRequestForAContainer) {
        if (requests != null && !requests.isEmpty()) {
            throw new SchedulerInvalidResoureRequestException(this.getClass().getName() + " not be able to handle ResourceRequest, there exists a " + "SchedulingRequest with the same scheduler key=" + SchedulerRequestKey.create((ResourceRequest)requests.iterator().next()) + ", please send ResourceRequest with a different allocationId and " + "priority");
        }
        return null;
    }

    private PendingAskUpdateResult internalUpdatePendingAsk(SchedulingRequest newSchedulingRequest, boolean recoverContainer) {
        if (recoverContainer && this.schedulingRequest == null) {
            throw new SchedulerInvalidResoureRequestException("Trying to recover a container request=" + newSchedulingRequest.toString() + ", however" + "there's no existing scheduling request, this should not happen.");
        }
        if (this.schedulingRequest != null) {
            ResourceSizing sizing = newSchedulingRequest.getResourceSizing();
            int existingNumAllocations = this.schedulingRequest.getResourceSizing().getNumAllocations();
            int newNumAllocations = recoverContainer ? existingNumAllocations + 1 : sizing.getNumAllocations();
            sizing.setNumAllocations(existingNumAllocations);
            if (!this.schedulingRequest.equals(newSchedulingRequest)) {
                sizing.setNumAllocations(newNumAllocations);
                throw new SchedulerInvalidResoureRequestException("Invalid updated SchedulingRequest added to scheduler,  we only allows changing numAllocations for the updated SchedulingRequest. Old=" + this.schedulingRequest.toString() + " new=" + newSchedulingRequest.toString() + ", if any fields need to be updated, please cancel the " + "old request (by setting numAllocations to 0) and send a " + "SchedulingRequest with different combination of " + "priority/allocationId");
            }
            if (newNumAllocations == existingNumAllocations) {
                return null;
            }
            sizing.setNumAllocations(newNumAllocations);
            if (newNumAllocations < 0) {
                throw new SchedulerInvalidResoureRequestException("numAllocation in ResourceSizing field must be >= 0, updating schedulingRequest failed.");
            }
            PendingAskUpdateResult updateResult = new PendingAskUpdateResult(new PendingAsk(this.schedulingRequest.getResourceSizing()), new PendingAsk(newSchedulingRequest.getResourceSizing()), this.targetNodePartition, this.targetNodePartition);
            this.schedulingRequest.getResourceSizing().setNumAllocations(newNumAllocations);
            LOG.info((Object)("Update numAllocation from old=" + existingNumAllocations + " to new=" + newNumAllocations));
            return updateResult;
        }
        this.validateAndSetSchedulingRequest(newSchedulingRequest);
        return new PendingAskUpdateResult(null, new PendingAsk(newSchedulingRequest.getResourceSizing()), null, this.targetNodePartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingAskUpdateResult updatePendingAsk(SchedulerRequestKey schedulerRequestKey, SchedulingRequest newSchedulingRequest, boolean recoverPreemptedRequestForAContainer) {
        this.writeLock.lock();
        try {
            PendingAskUpdateResult pendingAskUpdateResult = this.internalUpdatePendingAsk(newSchedulingRequest, recoverPreemptedRequestForAContainer);
            return pendingAskUpdateResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String throwExceptionWithMetaInfo(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppId=").append(this.appSchedulingInfo.getApplicationId()).append(" Key=").append(this.schedulerRequestKey).append(". Exception message:").append(message);
        throw new SchedulerInvalidResoureRequestException(sb.toString());
    }

    private void validateAndSetSchedulingRequest(SchedulingRequest newSchedulingRequest) throws SchedulerInvalidResoureRequestException {
        if (newSchedulingRequest.getResourceSizing() == null || newSchedulingRequest.getResourceSizing().getResources() == null) {
            this.throwExceptionWithMetaInfo("No ResourceSizing found in the scheduling request, please double check");
        }
        if (newSchedulingRequest.getExecutionType() != null && newSchedulingRequest.getExecutionType().getExecutionType() != ExecutionType.GUARANTEED) {
            this.throwExceptionWithMetaInfo("Only GUARANTEED execution type is supported.");
        }
        String nodePartition = null;
        Object targetAllocationTags = null;
        PlacementConstraint constraint = newSchedulingRequest.getPlacementConstraint();
        if (constraint != null) {
            Set targetExpressionSet;
            PlacementConstraint.SingleConstraint singleConstraint;
            PlacementConstraint.AbstractConstraint ac = constraint.getConstraintExpr();
            if (!(ac instanceof PlacementConstraint.SingleConstraint)) {
                this.throwExceptionWithMetaInfo("Only accepts " + PlacementConstraint.SingleConstraint.class.getName() + " as constraint-expression. Rejecting the new added " + "constraint-expression.class=" + ac.getClass().getName());
            }
            if (!(singleConstraint = (PlacementConstraint.SingleConstraint)ac).getScope().equals("node")) {
                this.throwExceptionWithMetaInfo("Only support scope=nodenow. PlacementConstraint=" + singleConstraint);
            }
            if (singleConstraint.getMinCardinality() != 0 || singleConstraint.getMaxCardinality() != 0) {
                this.throwExceptionWithMetaInfo("Only support anti-affinity, which is: minCardinality=0, maxCardinality=1");
            }
            if ((targetExpressionSet = singleConstraint.getTargetExpressions()) == null || targetExpressionSet.isEmpty()) {
                this.throwExceptionWithMetaInfo("TargetExpression should not be null or empty");
            }
            for (PlacementConstraint.TargetExpression targetExpression : targetExpressionSet) {
                if (targetExpression.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE)) {
                    Set values;
                    if (!targetExpression.getTargetKey().equals("yarn_node_partition/")) {
                        this.throwExceptionWithMetaInfo("When TargetType=" + PlacementConstraint.TargetExpression.TargetType.NODE_ATTRIBUTE + " only " + "yarn_node_partition/" + " is accepted as TargetKey.");
                    }
                    if (nodePartition != null) {
                        this.throwExceptionWithMetaInfo("Only one node partition targetExpression is allowed");
                    }
                    if ((values = targetExpression.getTargetValues()) == null || values.isEmpty()) {
                        nodePartition = "";
                        continue;
                    }
                    if (values.size() > 1) {
                        this.throwExceptionWithMetaInfo("Inside one targetExpression, we only support affinity to at most one node partition now");
                    }
                    nodePartition = (String)values.iterator().next();
                    continue;
                }
                if (!targetExpression.getTargetType().equals((Object)PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG)) continue;
                if (targetAllocationTags != null) {
                    this.throwExceptionWithMetaInfo("Only one AllocationTag targetExpression is allowed");
                }
                if (targetExpression.getTargetValues() == null || targetExpression.getTargetValues().isEmpty()) {
                    this.throwExceptionWithMetaInfo("Failed to find allocation tags from TargetExpressions or couldn't find self-app target.");
                }
                targetAllocationTags = new HashSet(targetExpression.getTargetValues());
            }
            if (targetAllocationTags == null) {
                this.throwExceptionWithMetaInfo("Couldn't find target expression with type == ALLOCATION_TAG, it is required to include one and only one target expression with type == ALLOCATION_TAG");
            }
        }
        if (targetAllocationTags == null) {
            targetAllocationTags = ImmutableSet.of();
        }
        if (nodePartition == null) {
            nodePartition = "";
        }
        this.targetNodePartition = nodePartition;
        this.targetAllocationTags = targetAllocationTags;
        this.schedulingRequest = new SchedulingRequestPBImpl(((SchedulingRequestPBImpl)newSchedulingRequest).getProto());
        LOG.info((Object)("Successfully added SchedulingRequest to app=" + this.appSchedulingInfo.getApplicationAttemptId() + " targetAllocationTags=[" + StringUtils.join((CharSequence)",", (Iterable)targetAllocationTags) + "]. nodePartition=" + this.targetNodePartition));
    }

    @Override
    public Map<String, ResourceRequest> getResourceRequests() {
        return Collections.emptyMap();
    }

    @Override
    public PendingAsk getPendingAsk(String resourceName) {
        this.readLock.lock();
        try {
            if (resourceName.equals("*") && this.schedulingRequest != null) {
                PendingAsk pendingAsk = new PendingAsk(this.schedulingRequest.getResourceSizing());
                return pendingAsk;
            }
            PendingAsk pendingAsk = PendingAsk.ZERO;
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getOutstandingAsksCount(String resourceName) {
        this.readLock.lock();
        try {
            if (resourceName.equals("*") && this.schedulingRequest != null) {
                int n = this.schedulingRequest.getResourceSizing().getNumAllocations();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void decreasePendingNumAllocation() {
        ResourceSizing sizing = this.schedulingRequest.getResourceSizing();
        sizing.setNumAllocations(sizing.getNumAllocations() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerRequest allocate(SchedulerRequestKey schedulerKey, NodeType type, SchedulerNode node) {
        this.writeLock.lock();
        try {
            SchedulingRequestPBImpl containerSchedulingRequest = new SchedulingRequestPBImpl(((SchedulingRequestPBImpl)this.schedulingRequest).getProto());
            containerSchedulingRequest.getResourceSizing().setNumAllocations(1);
            this.decreasePendingNumAllocation();
            ContainerRequest containerRequest = new ContainerRequest((SchedulingRequest)containerSchedulingRequest);
            return containerRequest;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean checkCardinalityAndPending(SchedulerNode node) {
        if (this.schedulingRequest.getResourceSizing().getNumAllocations() <= 0) {
            return false;
        }
        try {
            return PlacementConstraintsUtil.canSatisfyConstraints(this.appSchedulingInfo.getApplicationId(), this.schedulingRequest, node, this.placementConstraintManager, this.allocationTagsManager);
        }
        catch (InvalidAllocationTagsQueryException e) {
            LOG.warn((Object)"Failed to query node cardinality:", (Throwable)((Object)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAllocate(NodeType type, SchedulerNode node) {
        try {
            this.readLock.lock();
            boolean bl = this.checkCardinalityAndPending(node);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean canDelayTo(String resourceName) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean precheckNode(SchedulerNode schedulerNode, SchedulingMode schedulingMode) {
        String nodePartitionToLookAt = schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY ? schedulerNode.getPartition() : "";
        this.readLock.lock();
        try {
            boolean bl = this.targetNodePartition.equals(nodePartitionToLookAt) && this.checkCardinalityAndPending(schedulerNode);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getPrimaryRequestedNodePartition() {
        return this.targetNodePartition;
    }

    @Override
    public int getUniqueLocationAsks() {
        return 1;
    }

    @Override
    public void showRequests() {
        try {
            this.readLock.lock();
            if (this.schedulingRequest != null) {
                LOG.info((Object)this.schedulingRequest.toString());
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    SchedulingRequest getSchedulingRequest() {
        return this.schedulingRequest;
    }

    @VisibleForTesting
    String getTargetNodePartition() {
        return this.targetNodePartition;
    }

    @VisibleForTesting
    Set<String> getTargetAllocationTags() {
        return this.targetAllocationTags;
    }

    @Override
    public void initialize(AppSchedulingInfo appSchedulingInfo, SchedulerRequestKey schedulerRequestKey, RMContext rmContext) {
        super.initialize(appSchedulingInfo, schedulerRequestKey, rmContext);
        this.allocationTagsManager = rmContext.getAllocationTagsManager();
        this.placementConstraintManager = rmContext.getPlacementConstraintManager();
    }
}

