/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.StringReader;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.AdHocLogDumper;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServices
extends JerseyTestBase {
    private static MockRM rm;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestRMWebServices() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @BeforeClass
    public static void initClusterMetrics() {
        ClusterMetrics clusterMetrics = ClusterMetrics.getMetrics();
        clusterMetrics.incrDecommisionedNMs();
        clusterMetrics.incrNumActiveNodes();
        clusterMetrics.incrNumLostNMs();
        clusterMetrics.incrNumRebootedNMs();
        clusterMetrics.incrNumUnhealthyNMs();
    }

    @Test
    public void testInfoXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        this.verifyClusterInfoXML(xml);
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("cluster").path("bogus").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("cluster").accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testCluster() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterInfo(json);
    }

    @Test
    public void testClusterSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterInfo(json);
    }

    @Test
    public void testClusterDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterInfo(json);
    }

    @Test
    public void testInfo() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterInfo(json);
    }

    @Test
    public void testInfoSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterInfo(json);
    }

    @Test
    public void testInfoDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterInfo(json);
    }

    public void verifyClusterInfoXML(String xml) throws JSONException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("clusterInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyClusterGeneric(WebServicesTestUtils.getXmlLong((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"haState"), WebServicesTestUtils.getXmlString((Element)element, (String)"haZooKeeperConnectionState"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"resourceManagerVersion"));
        }
    }

    public void verifyClusterInfo(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("clusterInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)12L, (long)info.length());
        this.verifyClusterGeneric(info.getLong("id"), info.getLong("startedOn"), info.getString("state"), info.getString("haState"), info.getString("haZooKeeperConnectionState"), info.getString("hadoopVersionBuiltOn"), info.getString("hadoopBuildVersion"), info.getString("hadoopVersion"), info.getString("resourceManagerVersionBuiltOn"), info.getString("resourceManagerBuildVersion"), info.getString("resourceManagerVersion"));
    }

    public void verifyClusterGeneric(long clusterid, long startedon, String state, String haState, String haZooKeeperConnectionState, String hadoopVersionBuiltOn, String hadoopBuildVersion, String hadoopVersion, String resourceManagerVersionBuiltOn, String resourceManagerBuildVersion, String resourceManagerVersion) {
        Assert.assertEquals((String)"clusterId doesn't match: ", (long)ResourceManager.getClusterTimeStamp(), (long)clusterid);
        Assert.assertEquals((String)"startedOn doesn't match: ", (long)ResourceManager.getClusterTimeStamp(), (long)startedon);
        Assert.assertTrue((String)("stated doesn't match: " + state), (boolean)state.matches(Service.STATE.INITED.toString()));
        Assert.assertTrue((String)("HA state doesn't match: " + haState), (boolean)haState.matches("INITIALIZING"));
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersionBuiltOn", (String)VersionInfo.getDate(), (String)hadoopVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"hadoopBuildVersion", (String)VersionInfo.getBuildVersion(), (String)hadoopBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersion", (String)VersionInfo.getVersion(), (String)hadoopVersion);
        WebServicesTestUtils.checkStringMatch((String)"resourceManagerVersionBuiltOn", (String)YarnVersionInfo.getDate(), (String)resourceManagerVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"resourceManagerBuildVersion", (String)YarnVersionInfo.getBuildVersion(), (String)resourceManagerBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"resourceManagerVersion", (String)YarnVersionInfo.getVersion(), (String)resourceManagerVersion);
    }

    @Test
    public void testClusterMetrics() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("metrics").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterMetricsJSON(json);
    }

    @Test
    public void testClusterMetricsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("metrics/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterMetricsJSON(json);
    }

    @Test
    public void testClusterMetricsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("metrics").get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterMetricsJSON(json);
    }

    @Test
    public void testClusterMetricsXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("metrics").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        this.verifyClusterMetricsXML(xml);
    }

    public void verifyClusterMetricsXML(String xml) throws JSONException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("clusterMetrics");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyClusterMetrics(WebServicesTestUtils.getXmlInt((Element)element, (String)"appsSubmitted"), WebServicesTestUtils.getXmlInt((Element)element, (String)"appsCompleted"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reservedMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"availableMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"allocatedMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"reservedVirtualCores"), WebServicesTestUtils.getXmlInt((Element)element, (String)"availableVirtualCores"), WebServicesTestUtils.getXmlInt((Element)element, (String)"allocatedVirtualCores"), WebServicesTestUtils.getXmlInt((Element)element, (String)"totalVirtualCores"), WebServicesTestUtils.getXmlInt((Element)element, (String)"containersAllocated"), WebServicesTestUtils.getXmlInt((Element)element, (String)"totalMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"totalNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"lostNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"unhealthyNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"decommissionedNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"rebootedNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"activeNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"shutdownNodes"));
        }
    }

    public void verifyClusterMetricsJSON(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject clusterinfo = json.getJSONObject("clusterMetrics");
        Assert.assertEquals((String)"incorrect number of elements", (long)25L, (long)clusterinfo.length());
        this.verifyClusterMetrics(clusterinfo.getInt("appsSubmitted"), clusterinfo.getInt("appsCompleted"), clusterinfo.getInt("reservedMB"), clusterinfo.getInt("availableMB"), clusterinfo.getInt("allocatedMB"), clusterinfo.getInt("reservedVirtualCores"), clusterinfo.getInt("availableVirtualCores"), clusterinfo.getInt("allocatedVirtualCores"), clusterinfo.getInt("totalVirtualCores"), clusterinfo.getInt("containersAllocated"), clusterinfo.getInt("totalMB"), clusterinfo.getInt("totalNodes"), clusterinfo.getInt("lostNodes"), clusterinfo.getInt("unhealthyNodes"), clusterinfo.getInt("decommissionedNodes"), clusterinfo.getInt("rebootedNodes"), clusterinfo.getInt("activeNodes"), clusterinfo.getInt("shutdownNodes"));
    }

    public void verifyClusterMetrics(int submittedApps, int completedApps, int reservedMB, int availableMB, int allocMB, int reservedVirtualCores, int availableVirtualCores, int allocVirtualCores, int totalVirtualCores, int containersAlloc, int totalMB, int totalNodes, int lostNodes, int unhealthyNodes, int decommissionedNodes, int rebootedNodes, int activeNodes, int shutdownNodes) throws JSONException, Exception {
        ResourceScheduler rs = rm.getResourceScheduler();
        QueueMetrics metrics = rs.getRootQueueMetrics();
        ClusterMetrics clusterMetrics = ClusterMetrics.getMetrics();
        long totalMBExpect = metrics.getAvailableMB() + metrics.getAllocatedMB();
        long totalVirtualCoresExpect = metrics.getAvailableVirtualCores() + metrics.getAllocatedVirtualCores();
        Assert.assertEquals((String)"appsSubmitted doesn't match", (long)metrics.getAppsSubmitted(), (long)submittedApps);
        Assert.assertEquals((String)"appsCompleted doesn't match", (long)metrics.getAppsCompleted(), (long)completedApps);
        Assert.assertEquals((String)"reservedMB doesn't match", (long)metrics.getReservedMB(), (long)reservedMB);
        Assert.assertEquals((String)"availableMB doesn't match", (long)metrics.getAvailableMB(), (long)availableMB);
        Assert.assertEquals((String)"allocatedMB doesn't match", (long)metrics.getAllocatedMB(), (long)allocMB);
        Assert.assertEquals((String)"reservedVirtualCores doesn't match", (long)metrics.getReservedVirtualCores(), (long)reservedVirtualCores);
        Assert.assertEquals((String)"availableVirtualCores doesn't match", (long)metrics.getAvailableVirtualCores(), (long)availableVirtualCores);
        Assert.assertEquals((String)"allocatedVirtualCores doesn't match", (long)totalVirtualCoresExpect, (long)allocVirtualCores);
        Assert.assertEquals((String)"containersAllocated doesn't match", (long)0L, (long)containersAlloc);
        Assert.assertEquals((String)"totalMB doesn't match", (long)totalMBExpect, (long)totalMB);
        Assert.assertEquals((String)"totalNodes doesn't match", (long)(clusterMetrics.getNumActiveNMs() + clusterMetrics.getNumLostNMs() + clusterMetrics.getNumDecommisionedNMs() + clusterMetrics.getNumRebootedNMs() + clusterMetrics.getUnhealthyNMs()), (long)totalNodes);
        Assert.assertEquals((String)"lostNodes doesn't match", (long)clusterMetrics.getNumLostNMs(), (long)lostNodes);
        Assert.assertEquals((String)"unhealthyNodes doesn't match", (long)clusterMetrics.getUnhealthyNMs(), (long)unhealthyNodes);
        Assert.assertEquals((String)"decommissionedNodes doesn't match", (long)clusterMetrics.getNumDecommisionedNMs(), (long)decommissionedNodes);
        Assert.assertEquals((String)"rebootedNodes doesn't match", (long)clusterMetrics.getNumRebootedNMs(), (long)rebootedNodes);
        Assert.assertEquals((String)"activeNodes doesn't match", (long)clusterMetrics.getNumActiveNMs(), (long)activeNodes);
        Assert.assertEquals((String)"shutdownNodes doesn't match", (long)clusterMetrics.getNumShutdownNMs(), (long)shutdownNodes);
    }

    @Test
    public void testClusterSchedulerFifo() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterSchedulerFifo(json);
    }

    @Test
    public void testClusterSchedulerFifoSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterSchedulerFifo(json);
    }

    @Test
    public void testClusterSchedulerFifoDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterSchedulerFifo(json);
    }

    @Test
    public void testClusterSchedulerFifoXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        this.verifySchedulerFifoXML(xml);
    }

    public void verifySchedulerFifoXML(String xml) throws JSONException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesSched = dom.getElementsByTagName("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesSched.getLength());
        NodeList nodes = dom.getElementsByTagName("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyClusterSchedulerFifoGeneric(WebServicesTestUtils.getXmlAttrString((Element)element, (String)"xsi:type"), WebServicesTestUtils.getXmlString((Element)element, (String)"qstate"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"capacity"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"usedCapacity"), WebServicesTestUtils.getXmlInt((Element)element, (String)"minQueueMemoryCapacity"), WebServicesTestUtils.getXmlInt((Element)element, (String)"maxQueueMemoryCapacity"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numNodes"), WebServicesTestUtils.getXmlInt((Element)element, (String)"usedNodeCapacity"), WebServicesTestUtils.getXmlInt((Element)element, (String)"availNodeCapacity"), WebServicesTestUtils.getXmlInt((Element)element, (String)"totalNodeCapacity"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numContainers"));
        }
    }

    public void verifyClusterSchedulerFifo(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)info.length());
        info = info.getJSONObject("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)11L, (long)info.length());
        this.verifyClusterSchedulerFifoGeneric(info.getString("type"), info.getString("qstate"), (float)info.getDouble("capacity"), (float)info.getDouble("usedCapacity"), info.getInt("minQueueMemoryCapacity"), info.getInt("maxQueueMemoryCapacity"), info.getInt("numNodes"), info.getInt("usedNodeCapacity"), info.getInt("availNodeCapacity"), info.getInt("totalNodeCapacity"), info.getInt("numContainers"));
    }

    public void verifyClusterSchedulerFifoGeneric(String type, String state, float capacity, float usedCapacity, int minQueueCapacity, int maxQueueCapacity, int numNodes, int usedNodeCapacity, int availNodeCapacity, int totalNodeCapacity, int numContainers) throws JSONException, Exception {
        Assert.assertEquals((String)"type doesn't match", (Object)"fifoScheduler", (Object)type);
        Assert.assertEquals((String)"qstate doesn't match", (Object)QueueState.RUNNING.toString(), (Object)state);
        Assert.assertEquals((String)"capacity doesn't match", (double)1.0, (double)capacity, (double)0.0);
        Assert.assertEquals((String)"usedCapacity doesn't match", (double)0.0, (double)usedCapacity, (double)0.0);
        Assert.assertEquals((String)"minQueueMemoryCapacity doesn't match", (long)1024L, (long)minQueueCapacity);
        Assert.assertEquals((String)"maxQueueMemoryCapacity doesn't match", (long)8192L, (long)maxQueueCapacity);
        Assert.assertEquals((String)"numNodes doesn't match", (long)0L, (long)numNodes);
        Assert.assertEquals((String)"usedNodeCapacity doesn't match", (long)0L, (long)usedNodeCapacity);
        Assert.assertEquals((String)"availNodeCapacity doesn't match", (long)0L, (long)availNodeCapacity);
        Assert.assertEquals((String)"totalNodeCapacity doesn't match", (long)0L, (long)totalNodeCapacity);
        Assert.assertEquals((String)"numContainers doesn't match", (long)0L, (long)numContainers);
    }

    @Test
    public void testAppsRace() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationReport mockReport = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        Mockito.when((Object)mockReport.getApplicationId()).thenReturn((Object)appId);
        GetApplicationsResponse mockAppsResponse = (GetApplicationsResponse)Mockito.mock(GetApplicationsResponse.class);
        Mockito.when((Object)mockAppsResponse.getApplicationList()).thenReturn(Arrays.asList(mockReport));
        ClientRMService mockClientSvc = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockClientSvc.getApplications((GetApplicationsRequest)Matchers.isA(GetApplicationsRequest.class))).thenReturn((Object)mockAppsResponse);
        ResourceManager mockRM = (ResourceManager)Mockito.mock(ResourceManager.class);
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, null, null, null, null);
        Mockito.when((Object)mockRM.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)mockRM.getClientRMService()).thenReturn((Object)mockClientSvc);
        rmContext.setNodeLabelManager((RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class));
        RMWebServices webSvc = new RMWebServices(mockRM, new Configuration(), (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        Set emptySet = Collections.unmodifiableSet(Collections.emptySet());
        HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        AppsInfo appsInfo = webSvc.getApps(mockHsr, null, emptySet, null, null, null, null, null, null, null, null, emptySet, emptySet, null);
        Assert.assertTrue((boolean)appsInfo.getApps().isEmpty());
        appsInfo = webSvc.getApps(mockHsr, null, emptySet, "FAILED", null, null, null, null, null, null, null, emptySet, emptySet, null);
        Assert.assertTrue((boolean)appsInfo.getApps().isEmpty());
    }

    @Test
    public void testDumpingSchedulerLogs() throws Exception {
        ResourceManager mockRM = (ResourceManager)Mockito.mock(ResourceManager.class);
        YarnConfiguration conf = new YarnConfiguration();
        HttpServletRequest mockHsr = this.mockHttpServletRequestByUserName("non-admin");
        ApplicationACLsManager aclsManager = new ApplicationACLsManager((Configuration)conf);
        Mockito.when((Object)mockRM.getApplicationACLsManager()).thenReturn((Object)aclsManager);
        RMWebServices webSvc = new RMWebServices(mockRM, (Configuration)conf, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        webSvc.dumpSchedulerLogs("1", mockHsr);
        this.waitforLogDump(50);
        this.checkSchedulerLogFileAndCleanup();
        conf.setBoolean("yarn.acl.enable", true);
        conf.setStrings("yarn.admin.acl", new String[]{"admin"});
        aclsManager = new ApplicationACLsManager((Configuration)conf);
        Mockito.when((Object)mockRM.getApplicationACLsManager()).thenReturn((Object)aclsManager);
        webSvc = new RMWebServices(mockRM, (Configuration)conf, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        boolean exceptionThrown = false;
        try {
            webSvc.dumpSchedulerLogs("1", mockHsr);
            Assert.fail((String)"Dumping logs should fail");
        }
        catch (ForbiddenException ae) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"ForbiddenException expected", (boolean)exceptionThrown);
        exceptionThrown = false;
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "testuser";
            }
        });
        try {
            webSvc.dumpSchedulerLogs("1", mockHsr);
            Assert.fail((String)"Dumping logs should fail");
        }
        catch (ForbiddenException ae) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"ForbiddenException expected", (boolean)exceptionThrown);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)new Principal(){

            @Override
            public String getName() {
                return "admin";
            }
        });
        webSvc.dumpSchedulerLogs("1", mockHsr);
        this.waitforLogDump(50);
        this.checkSchedulerLogFileAndCleanup();
    }

    private void checkSchedulerLogFileAndCleanup() {
        ResourceScheduler scheduler = rm.getResourceScheduler();
        String targetFile = scheduler instanceof FairScheduler ? "yarn-fair-scheduler-debug.log" : (scheduler instanceof CapacityScheduler ? "yarn-capacity-scheduler-debug.log" : "yarn-scheduler-debug.log");
        File logFile = new File(System.getProperty("yarn.log.dir"), targetFile);
        Assert.assertTrue((String)"scheduler log file doesn't exist", (boolean)logFile.exists());
        FileUtils.deleteQuietly((File)logFile);
    }

    private void waitforLogDump(int tickcount) throws InterruptedException {
        while (tickcount > 0) {
            Thread.sleep(100L);
            if (!AdHocLogDumper.getState()) {
                return;
            }
            --tickcount;
        }
    }

    private HttpServletRequest mockHttpServletRequestByUserName(String username) {
        HttpServletRequest mockHsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockHsr.getRemoteUser()).thenReturn((Object)username);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)username);
        Mockito.when((Object)mockHsr.getUserPrincipal()).thenReturn((Object)principal);
        return mockHsr;
    }

    @Test
    public void testCheckUserAccessToQueue() throws Exception {
        ResourceManager mockRM = (ResourceManager)Mockito.mock(ResourceManager.class);
        YarnConfiguration conf = new YarnConfiguration();
        FifoScheduler mockScheduler = new FifoScheduler(){

            public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
                return acl == QueueACL.ADMINISTER_QUEUE ? callerUGI.getUserName().equals("admin") : ImmutableSet.of((Object)"admin", (Object)"yarn").contains((Object)callerUGI.getUserName());
            }
        };
        Mockito.when((Object)mockRM.getResourceScheduler()).thenReturn((Object)mockScheduler);
        RMWebServices webSvc = new RMWebServices(mockRM, (Configuration)conf, (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        boolean caughtException = false;
        HttpServletRequest mockHsr = this.mockHttpServletRequestByUserName("non-admin");
        try {
            webSvc.checkUserAccessToQueue("queue", "jack", QueueACL.SUBMIT_APPLICATIONS.name(), mockHsr);
        }
        catch (ForbiddenException e) {
            caughtException = true;
        }
        Assert.assertTrue((boolean)caughtException);
        mockHsr = this.mockHttpServletRequestByUserName("admin");
        caughtException = false;
        try {
            webSvc.checkUserAccessToQueue("queue", "jack", "XYZ_ACL", mockHsr);
        }
        catch (BadRequestException e) {
            caughtException = true;
        }
        Assert.assertTrue((boolean)caughtException);
        mockHsr = this.mockHttpServletRequestByUserName("admin");
        Assert.assertFalse((boolean)webSvc.checkUserAccessToQueue("queue", "jack", QueueACL.SUBMIT_APPLICATIONS.name(), mockHsr).isAllowed());
        Assert.assertFalse((boolean)webSvc.checkUserAccessToQueue("queue", "jack", QueueACL.ADMINISTER_QUEUE.name(), mockHsr).isAllowed());
        mockHsr = this.mockHttpServletRequestByUserName("admin");
        Assert.assertTrue((boolean)webSvc.checkUserAccessToQueue("queue", "admin", QueueACL.SUBMIT_APPLICATIONS.name(), mockHsr).isAllowed());
        Assert.assertTrue((boolean)webSvc.checkUserAccessToQueue("queue", "admin", QueueACL.ADMINISTER_QUEUE.name(), mockHsr).isAllowed());
        mockHsr = this.mockHttpServletRequestByUserName("admin");
        Assert.assertTrue((boolean)webSvc.checkUserAccessToQueue("queue", "yarn", QueueACL.SUBMIT_APPLICATIONS.name(), mockHsr).isAllowed());
        Assert.assertFalse((boolean)webSvc.checkUserAccessToQueue("queue", "yarn", QueueACL.ADMINISTER_QUEUE.name(), mockHsr).isAllowed());
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            Configuration conf = new Configuration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rm = new MockRM(conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

