/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

public class AllocationFileQueueProperties {
    private final String queueName;
    private final String minResources;
    private final String maxResources;
    private final String aclAdministerApps;
    private final String aclSubmitApps;
    private final String schedulingPolicy;
    private final Integer maxRunningApps;
    private final Double maxAMShare;
    private final Integer minSharePreemptionTimeout;
    private final Boolean parent;
    private final String maxChildResources;
    private final Integer fairSharePreemptionTimeout;
    private final Double fairSharePreemptionThreshold;

    AllocationFileQueueProperties(Builder builder) {
        this.queueName = builder.queueName;
        this.parent = builder.parent;
        this.minResources = builder.minResources;
        this.maxResources = builder.maxResources;
        this.aclAdministerApps = builder.aclAdministerApps;
        this.aclSubmitApps = builder.aclSubmitApps;
        this.schedulingPolicy = builder.schedulingPolicy;
        this.maxRunningApps = builder.maxRunningApps;
        this.maxAMShare = builder.maxAMShare;
        this.minSharePreemptionTimeout = builder.minSharePreemptionTimeout;
        this.maxChildResources = builder.maxChildResources;
        this.fairSharePreemptionTimeout = builder.fairSharePreemptionTimeout;
        this.fairSharePreemptionThreshold = builder.fairSharePreemptionThreshold;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getMinResources() {
        return this.minResources;
    }

    public String getMaxResources() {
        return this.maxResources;
    }

    public String getAclAdministerApps() {
        return this.aclAdministerApps;
    }

    public String getAclSubmitApps() {
        return this.aclSubmitApps;
    }

    public String getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    public Integer getMaxRunningApps() {
        return this.maxRunningApps;
    }

    public Double getMaxAMShare() {
        return this.maxAMShare;
    }

    public Integer getMinSharePreemptionTimeout() {
        return this.minSharePreemptionTimeout;
    }

    public Boolean getParent() {
        return this.parent;
    }

    public String getMaxChildResources() {
        return this.maxChildResources;
    }

    public Integer getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    public Double getFairSharePreemptionThreshold() {
        return this.fairSharePreemptionThreshold;
    }

    public static final class Builder {
        private String queueName;
        private Boolean parent = false;
        private String minResources;
        private String maxResources;
        private String aclAdministerApps;
        private String aclSubmitApps;
        private String schedulingPolicy;
        private Integer maxRunningApps;
        private Double maxAMShare;
        private Integer minSharePreemptionTimeout;
        private String maxChildResources;
        private Integer fairSharePreemptionTimeout;
        private Double fairSharePreemptionThreshold;

        Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Builder minResources(String minResources) {
            this.minResources = minResources;
            return this;
        }

        public Builder maxResources(String maxResources) {
            this.maxResources = maxResources;
            return this;
        }

        public Builder aclAdministerApps(String aclAdministerApps) {
            this.aclAdministerApps = aclAdministerApps;
            return this;
        }

        public Builder aclSubmitApps(String aclSubmitApps) {
            this.aclSubmitApps = aclSubmitApps;
            return this;
        }

        public Builder schedulingPolicy(String schedulingPolicy) {
            this.schedulingPolicy = schedulingPolicy;
            return this;
        }

        public Builder maxRunningApps(Integer maxRunningApps) {
            this.maxRunningApps = maxRunningApps;
            return this;
        }

        public Builder maxAMShare(Double maxAMShare) {
            this.maxAMShare = maxAMShare;
            return this;
        }

        public Builder minSharePreemptionTimeout(Integer minSharePreemptionTimeout) {
            this.minSharePreemptionTimeout = minSharePreemptionTimeout;
            return this;
        }

        public Builder parent(Boolean parent) {
            this.parent = parent;
            return this;
        }

        public Builder maxChildResources(String maxChildResources) {
            this.maxChildResources = maxChildResources;
            return this;
        }

        public Builder fairSharePreemptionTimeout(Integer fairSharePreemptionTimeout) {
            this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
            return this;
        }

        public Builder fairSharePreemptionThreshold(Double fairSharePreemptionThreshold) {
            this.fairSharePreemptionThreshold = fairSharePreemptionThreshold;
            return this;
        }

        public AllocationFileQueueProperties build() {
            return new AllocationFileQueueProperties(this);
        }
    }
}

