/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.LightWeightResource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestFairSchedulerConfiguration {
    private static final String A_CUSTOM_RESOURCE = "a-custom-resource";

    @Test
    public void testParseResourceConfigValue() throws Exception {
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, 1024 mb").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 mb, 2 vcores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2vcores,1024mb").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb,2vcores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024   mb, 2    vcores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 Mb, 2 vCores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024 mb, 2 vcores  ").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024.3 mb, 2.35 vcores  ").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024. mb, 2. vcores  ").getResource());
        Resource clusterResource = BuilderUtils.newResource((long)2048L, (int)4);
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 50% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% Memory, 50% CpU").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)4), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 100% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)4), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" 100% cpu, 50% memory").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 0% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50 % memory, 50 % cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%memory,50%cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  50  %  memory,  50  %  cpu  ").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50.% memory, 50.% cpu").getResource(clusterResource));
        clusterResource = BuilderUtils.newResource((long)10240L, (int)4);
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1116L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"10.9% memory, 50.6% cpu").getResource(clusterResource));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testNoUnits() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyMemory() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyCPU() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024vcores");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testGibberish() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1o24vc0res");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testNoUnitsPercentage() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"95%, 50% memory");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testInvalidNumPercentage() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"95A% cpu, 50% memory");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testCpuPercentageMemoryAbsolute() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% cpu, 1024 mb");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testMemoryPercentageCpuAbsolute() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 2 vcores");
    }

    @Test
    public void testAllocationIncrementMemoryDefaultUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "256");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource minimum = Resources.createResource((long)0L, (int)0);
        Resource maximum = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)769L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1023L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1024L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1280L, (long)resourceCalculator.normalize(Resources.createResource((long)1025L), minimum, maximum, increment).getMemorySize());
    }

    @Test
    public void testAllocationIncrementMemoryNonDefaultUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "1 Gi");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource minimum = Resources.createResource((long)0L, (int)0);
        Resource maximum = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1023L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)1024L, (long)resourceCalculator.normalize(Resources.createResource((long)1024L), minimum, maximum, increment).getMemorySize());
        Assert.assertEquals((long)2048L, (long)resourceCalculator.normalize(Resources.createResource((long)1025L), minimum, maximum, increment).getMemorySize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAllocationIncrementInvalidUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "1 Xi");
        new FairSchedulerConfiguration(conf).getIncrementAllocation();
    }

    @Test
    public void testAllocationIncrementVCoreNoUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".increment-allocation", "10");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource min = Resources.createResource((long)0L, (int)0);
        Resource max = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)10L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)9), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)10L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)10), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)20L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)11), min, max, increment).getVirtualCores());
    }

    @Test
    public void testAllocationIncrementVCoreWithUnit() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".increment-allocation", "1k");
        FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
        Resource min = Resources.createResource((long)0L, (int)0);
        Resource max = Resources.createResource((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        Resource increment = fsc.getIncrementAllocation();
        DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();
        Assert.assertEquals((long)1000L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)999), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)1000L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)1000), min, max, increment).getVirtualCores());
        Assert.assertEquals((long)2000L, (long)resourceCalculator.normalize(Resources.createResource((long)0L, (int)1001), min, max, increment).getVirtualCores());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocationIncrementCustomResource() throws Exception {
        try {
            this.initResourceTypes();
            Configuration conf = new Configuration();
            conf.set("yarn.resource-types.a-custom-resource.increment-allocation", "10");
            FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
            Resource increment = fsc.getIncrementAllocation();
            DominantResourceCalculator calculator = new DominantResourceCalculator();
            Resource min = Resources.createResource((long)0L, (int)0);
            Resource max = Resource.newInstance((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE, Collections.singletonMap(A_CUSTOM_RESOURCE, Long.MAX_VALUE / UnitsConversionUtil.convert((String)"k", (String)"", (long)1L)));
            Assert.assertEquals((Object)this.customResourceInformation(10000L, ""), (Object)calculator.normalize(this.customResource(9999L, ""), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(10000L, ""), (Object)calculator.normalize(this.customResource(10000L, ""), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(20000L, ""), (Object)calculator.normalize(this.customResource(10001L, ""), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(10L, "k"), (Object)calculator.normalize(this.customResource(9L, "k"), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(10L, "k"), (Object)calculator.normalize(this.customResource(10L, "k"), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
            Assert.assertEquals((Object)this.customResourceInformation(20L, "k"), (Object)calculator.normalize(this.customResource(11L, "k"), min, max, increment).getResourceInformation(A_CUSTOM_RESOURCE));
        }
        finally {
            ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        }
    }

    private Resource customResource(long value, String units) {
        return new LightWeightResource(0L, 0, new ResourceInformation[]{null, null, this.customResourceInformation(value, units)});
    }

    private ResourceInformation customResourceInformation(long value, String units) {
        return ResourceInformation.newInstance((String)A_CUSTOM_RESOURCE, (String)units, (long)value, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Long.MAX_VALUE);
    }

    private void initResourceTypes() {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.configuration.provider-class", CustomResourceTypesConfigurationProvider.class.getName());
        ResourceUtils.resetResourceTypes((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryIncrementConfiguredViaMultipleProperties() {
        TestAppender testAppender = new TestAppender();
        Log4JLogger logger = (Log4JLogger)FairSchedulerConfiguration.LOG;
        logger.getLogger().addAppender((Appender)testAppender);
        try {
            Configuration conf = new Configuration();
            conf.set("yarn.scheduler.increment-allocation-mb", "7");
            conf.set("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".increment-allocation", "13");
            FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
            Resource increment = fsc.getIncrementAllocation();
            Assert.assertEquals((long)13L, (long)increment.getMemorySize());
            Assert.assertTrue((String)"Warning message is not logged when specifying memory increment via multiple properties", (boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && "Configuration yarn.resource-types.memory-mb.increment-allocation=13 is overriding the yarn.scheduler.increment-allocation-mb=7 property".equals(e.getMessage())));
        }
        finally {
            logger.getLogger().removeAppender((Appender)testAppender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCpuIncrementConfiguredViaMultipleProperties() {
        TestAppender testAppender = new TestAppender();
        Log4JLogger logger = (Log4JLogger)FairSchedulerConfiguration.LOG;
        logger.getLogger().addAppender((Appender)testAppender);
        try {
            Configuration conf = new Configuration();
            conf.set("yarn.scheduler.increment-allocation-vcores", "7");
            conf.set("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".increment-allocation", "13");
            FairSchedulerConfiguration fsc = new FairSchedulerConfiguration(conf);
            Resource increment = fsc.getIncrementAllocation();
            Assert.assertEquals((long)13L, (long)increment.getVirtualCores());
            Assert.assertTrue((String)"Warning message is not logged when specifying CPU vCores increment via multiple properties", (boolean)testAppender.getLogEvents().stream().anyMatch(e -> e.getLevel() == Level.WARN && "Configuration yarn.resource-types.vcores.increment-allocation=13 is overriding the yarn.scheduler.increment-allocation-vcores=7 property".equals(e.getMessage())));
        }
        finally {
            logger.getLogger().removeAppender((Appender)testAppender);
        }
    }

    private static class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> logEvents = new CopyOnWriteArrayList<LoggingEvent>();

        private TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent arg0) {
            this.logEvents.add(arg0);
        }

        private List<LoggingEvent> getLogEvents() {
            return this.logEvents;
        }
    }

    private static class CustomResourceTypesConfigurationProvider
    extends LocalConfigurationProvider {
        private CustomResourceTypesConfigurationProvider() {
        }

        public InputStream getConfigurationInputStream(Configuration bootstrapConf, String name) throws YarnException, IOException {
            if ("resource-types.xml".equals(name)) {
                return new ByteArrayInputStream("<configuration>\n <property>\n   <name>yarn.resource-types</name>\n   <value>a-custom-resource</value>\n </property>\n <property>\n   <name>yarn.resource-types.a-custom-resource.units</name>\n   <value>k</value>\n </property>\n</configuration>\n".getBytes());
            }
            return super.getConfigurationInputStream(bootstrapConf, name);
        }
    }
}

