/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplicationsNamespace;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSchedulingRequestContainerAllocation {
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @Test
    public void testIntraAppAntiAffinity() throws Exception {
        int j;
        int i;
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            nms[i2] = rm1.registerNode("192.168.0." + i2 + ":1234", 10240);
            rmNodes[i2] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i2].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)10, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j2 = 0; j2 < 4; ++j2) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j2]));
            }
        }
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)5L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)10, (Resource)Resource.newInstance((int)2048, (int)1)), Priority.newInstance((int)2), 1L, (Set<String>)ImmutableSet.of((Object)"reducer"), "reducer");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)9L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)10, (Resource)Resource.newInstance((int)2048, (int)1)), Priority.newInstance((int)3), 1L, (Set<String>)ImmutableSet.of((Object)"reducer2"), "mapper");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)9L, (long)schedulerApp.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testIntraAppAntiAffinityWithMultipleTags() throws Exception {
        int j;
        int i;
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            nms[i2] = rm1.registerNode("192.168.0." + i2 + ":1234", 10240);
            rmNodes[i2] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i2].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)2, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"tag_1_1", (Object)"tag_1_2"), "tag_1_1", "tag_1_2");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j2 = 0; j2 < 4; ++j2) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j2]));
            }
        }
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)3L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)2), 1L, (Set<String>)ImmutableSet.of((Object)"tag_2_1", (Object)"tag_2_2"), "tag_1_1", "tag_1_2");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)4L, (long)schedulerApp.getLiveContainers().size());
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)3), 1L, (Set<String>)ImmutableSet.of((Object)"tag_3"), "tag_1_1", "tag_1_2", "tag_2_1", "tag_2_2");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        Assert.assertEquals((long)5L, (long)schedulerApp.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testInterAppAntiAffinity() throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            nms[i] = rm1.registerNode("192.168.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        System.out.println("Mappers on HOST0: " + rmNodes[0].getAllocationTagsWithCount().get("mapper"));
        System.out.println("Mappers on HOST1: " + rmNodes[1].getAllocationTagsWithCount().get("mapper"));
        System.out.println("Mappers on HOST2: " + rmNodes[2].getAllocationTagsWithCount().get("mapper"));
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)4L, (long)schedulerApp.getLiveContainers().size());
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nms[0]);
        TargetApplicationsNamespace.All allNs = new TargetApplicationsNamespace.All();
        am2.allocateAppAntiAffinity(ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, allNs.toString(), (Set<String>)ImmutableSet.of((Object)"foo"), "mapper");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)4L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertTrue((boolean)schedulerApp2.getLiveContainers().stream().allMatch(rmContainer -> {
            if (!rmContainer.getContainer().getNodeId().equals((Object)rmNodes[0])) {
                return !rmContainer.getAllocationTags().contains("mapper");
            }
            return true;
        }));
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nms[0]);
        am3.allocateAppAntiAffinity(ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, allNs.toString(), (Set<String>)ImmutableSet.of((Object)"mapper"), "mapper");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[j]));
            }
        }
        FiCaSchedulerApp schedulerApp3 = cs.getApplicationAttempt(am3.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp3.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testSchedulingRequestDisabledByDefault() throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            nms[i] = rm1.registerNode("192.168.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        boolean caughtException = false;
        try {
            am1.allocateIntraAppAntiAffinity(ResourceSizing.newInstance((int)2, (Resource)Resource.newInstance((int)1024, (int)1)), Priority.newInstance((int)1), 1L, (Set<String>)ImmutableSet.of((Object)"tag_1_1", (Object)"tag_1_2"), "tag_1_1", "tag_1_2");
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assert.assertTrue((boolean)caughtException);
        rm1.close();
    }

    @Test
    public void testSchedulingRequestWithNullConstraint() throws Exception {
        Configuration csConf = TestUtils.getConfigurationWithMultipleQueues(new Configuration());
        csConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestSchedulingRequestContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM[] nms = new MockNM[4];
        RMNode[] rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            nms[i] = rm1.registerNode("192.168.0." + i + ":1234", 10240);
            rmNodes[i] = (RMNode)rm1.getRMContext().getRMNodes().get(nms[i].getNodeId());
        }
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "c");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nms[0]);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        PlacementConstraint constraint = PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"t1"})}).build();
        SchedulingRequest sc = SchedulingRequest.newInstance((long)0L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)ImmutableSet.of((Object)"t1"), (ResourceSizing)ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), (PlacementConstraint)constraint);
        AllocateRequest request = AllocateRequest.newBuilder().schedulingRequests((List)ImmutableList.of((Object)sc)).build();
        am1.allocate(request);
        for (int i = 0; i < 4; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[i]));
        }
        FiCaSchedulerApp schedApp = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedApp.getLiveContainers().size());
        sc = SchedulingRequest.newInstance((long)1L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)ImmutableSet.of((Object)"t2"), (ResourceSizing)ResourceSizing.newInstance((int)2, (Resource)Resource.newInstance((int)1024, (int)1)), null);
        AllocateRequest request1 = AllocateRequest.newBuilder().schedulingRequests((List)ImmutableList.of((Object)sc)).build();
        am1.allocate(request1);
        for (int i = 0; i < 4; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNodes[i]));
        }
        Assert.assertEquals((long)4L, (long)schedApp.getLiveContainers().size());
        rm1.close();
    }
}

