/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAppSchedulingInfo {
    @Test
    public void testBacklistChanged() {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)1);
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        ((FSLeafQueue)Mockito.doReturn((Object)"test").when((Object)queue)).getQueueName();
        AppSchedulingInfo appSchedulingInfo = new AppSchedulingInfo(appAttemptId, "test", (Queue)queue, null, 0L, new ResourceUsage(), new HashMap(), null);
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        ArrayList<String> blacklistAdditions = new ArrayList<String>();
        blacklistAdditions.add("node1");
        blacklistAdditions.add("node2");
        appSchedulingInfo.updatePlacesBlacklistedByApp(blacklistAdditions, new ArrayList());
        Assert.assertTrue((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        blacklistAdditions.clear();
        blacklistAdditions.add("node1");
        appSchedulingInfo.updatePlacesBlacklistedByApp(blacklistAdditions, new ArrayList());
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        ArrayList<String> blacklistRemovals = new ArrayList<String>();
        blacklistRemovals.add("node1");
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), blacklistRemovals);
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), blacklistRemovals);
        Assert.assertTrue((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), blacklistRemovals);
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
    }

    @Test
    public void testSchedulerRequestKeyOrdering() {
        TreeSet<SchedulerRequestKey> ts = new TreeSet<SchedulerRequestKey>();
        ts.add(TestUtils.toSchedulerKey(Priority.newInstance((int)1), 1L));
        ts.add(TestUtils.toSchedulerKey(Priority.newInstance((int)1), 2L));
        ts.add(TestUtils.toSchedulerKey(Priority.newInstance((int)0), 4L));
        ts.add(TestUtils.toSchedulerKey(Priority.newInstance((int)0), 3L));
        ts.add(TestUtils.toSchedulerKey(Priority.newInstance((int)2), 5L));
        ts.add(TestUtils.toSchedulerKey(Priority.newInstance((int)2), 6L));
        Iterator iter = ts.iterator();
        SchedulerRequestKey sk = (SchedulerRequestKey)iter.next();
        Assert.assertEquals((long)0L, (long)sk.getPriority().getPriority());
        Assert.assertEquals((long)3L, (long)sk.getAllocationRequestId());
        sk = (SchedulerRequestKey)iter.next();
        Assert.assertEquals((long)0L, (long)sk.getPriority().getPriority());
        Assert.assertEquals((long)4L, (long)sk.getAllocationRequestId());
        sk = (SchedulerRequestKey)iter.next();
        Assert.assertEquals((long)1L, (long)sk.getPriority().getPriority());
        Assert.assertEquals((long)1L, (long)sk.getAllocationRequestId());
        sk = (SchedulerRequestKey)iter.next();
        Assert.assertEquals((long)1L, (long)sk.getPriority().getPriority());
        Assert.assertEquals((long)2L, (long)sk.getAllocationRequestId());
        sk = (SchedulerRequestKey)iter.next();
        Assert.assertEquals((long)2L, (long)sk.getPriority().getPriority());
        Assert.assertEquals((long)5L, (long)sk.getAllocationRequestId());
        sk = (SchedulerRequestKey)iter.next();
        Assert.assertEquals((long)2L, (long)sk.getPriority().getPriority());
        Assert.assertEquals((long)6L, (long)sk.getAllocationRequestId());
    }

    @Test
    public void testSchedulerKeyAccounting() {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)1);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        ((Queue)Mockito.doReturn((Object)Mockito.mock(QueueMetrics.class)).when((Object)queue)).getMetrics();
        AppSchedulingInfo info = new AppSchedulingInfo(appAttemptId, "test", queue, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), 0L, new ResourceUsage(), new HashMap(), null);
        Assert.assertEquals((long)0L, (long)info.getSchedulerKeys().size());
        Priority pri1 = Priority.newInstance((int)1);
        ResourceRequest req1 = ResourceRequest.newInstance((Priority)pri1, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1);
        Priority pri2 = Priority.newInstance((int)2);
        ResourceRequest req2 = ResourceRequest.newInstance((Priority)pri2, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)2);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(req1);
        reqs.add(req2);
        info.updateResourceRequests(reqs, false);
        ArrayList keys = new ArrayList(info.getSchedulerKeys());
        Assert.assertEquals((long)2L, (long)keys.size());
        Assert.assertEquals((Object)SchedulerRequestKey.create((ResourceRequest)req1), keys.get(0));
        Assert.assertEquals((Object)SchedulerRequestKey.create((ResourceRequest)req2), keys.get(1));
        for (SchedulerRequestKey schedulerKey : info.getSchedulerKeys()) {
            info.allocate(NodeType.OFF_SWITCH, null, schedulerKey, null);
        }
        Assert.assertEquals((long)1L, (long)info.getSchedulerKeys().size());
        Assert.assertEquals((Object)SchedulerRequestKey.create((ResourceRequest)req2), info.getSchedulerKeys().iterator().next());
        req2 = ResourceRequest.newInstance((Priority)pri2, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1);
        reqs.clear();
        reqs.add(req2);
        info.updateResourceRequests(reqs, false);
        info.allocate(NodeType.OFF_SWITCH, null, SchedulerRequestKey.create((ResourceRequest)req2), null);
        Assert.assertEquals((long)0L, (long)info.getSchedulerKeys().size());
        req1 = ResourceRequest.newInstance((Priority)pri1, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)5);
        reqs.clear();
        reqs.add(req1);
        info.updateResourceRequests(reqs, false);
        Assert.assertEquals((long)1L, (long)info.getSchedulerKeys().size());
        Assert.assertEquals((Object)SchedulerRequestKey.create((ResourceRequest)req1), info.getSchedulerKeys().iterator().next());
        req1 = ResourceRequest.newInstance((Priority)pri1, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)0);
        reqs.clear();
        reqs.add(req1);
        info.updateResourceRequests(reqs, false);
        Assert.assertEquals((long)0L, (long)info.getSchedulerKeys().size());
    }
}

