/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants.InvariantViolationException;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.invariants.MetricsInvariantChecker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.Test;

public class TestMetricsInvariantChecker {
    public static final Logger LOG = Logger.getLogger(TestMetricsInvariantChecker.class);
    private MetricsSystem metricsSystem;
    private MetricsInvariantChecker ic;
    private Configuration conf;

    @Before
    public void setup() {
        this.metricsSystem = DefaultMetricsSystem.instance();
        JvmMetrics.initSingleton((String)"ResourceManager", null);
        this.ic = new MetricsInvariantChecker();
        this.conf = new Configuration();
        this.conf.set("yarn.resourcemanager.invariant-checker.file", "src/test/resources/invariants.txt");
        this.conf.setBoolean("yarn.resourcemanager.invariant-checker.throw-on-violation", true);
        this.ic.init(this.conf, null, null);
    }

    @Test(timeout=5000L)
    public void testManyRuns() {
        QueueMetrics qm = QueueMetrics.forQueue((MetricsSystem)this.metricsSystem, (String)"root", null, (boolean)false, (Configuration)this.conf);
        qm.setAvailableResourcesToQueue("", Resource.newInstance((int)1, (int)1));
        int numIterations = 1000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < numIterations; ++i) {
            this.ic.editSchedule();
        }
        long end = System.currentTimeMillis();
        System.out.println("Runtime per iteration (avg of " + numIterations + " iterations): " + (end - start) + " tot time");
    }

    @Test
    public void testViolation() {
        QueueMetrics qm = QueueMetrics.forQueue((MetricsSystem)this.metricsSystem, (String)"root", null, (boolean)false, (Configuration)this.conf);
        qm.setAvailableResourcesToQueue("", Resource.newInstance((int)-1, (int)-1));
        try {
            this.ic.editSchedule();
            TestCase.fail();
        }
        catch (InvariantViolationException invariantViolationException) {
            // empty catch block
        }
        this.conf.setBoolean("yarn.resourcemanager.invariant-checker.throw-on-violation", false);
        this.ic.init(this.conf, null, null);
        this.ic.editSchedule();
    }
}

