/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyIntraQueueWithDRF
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", true);
        this.rc = new DominantResourceCalculator();
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.rc);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testSimpleIntraQueuePreemptionWithVCoreResource() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        String labelsConfig = "=100:50,true;";
        String nodesConfig = "n1= res=100:50";
        String queuesConfig = "root(=[100:50 100:50 80:40 120:60 0]);-a(=[10:5 100:50 10:5 50:25 0]);-b(=[40:20 100:50 40:20 60:30 0]);-c(=[20:10 100:50 10:5 10:5 0]);-d(=[30:15 100:50 20:10 0 0])";
        String appsConfig = "a\t(1,1:1,n1,,5,false,25:25);a\t(1,1:1,n1,,5,false,25:25);b\t(4,1:1,n1,,36,false,20:20);b\t(4,1:1,n1,,2,false,10:10);b\t(5,1:1,n1,,1,false,10:10);b\t(6,1:1,n1,,1,false,10:10);c\t(1,1:1,n1,,10,false,10:10);d\t(1,1:1,n1,,20,false,0)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)1))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testIntraQueuePreemptionWithDominantVCoreResource() throws IOException {
        this.conf.set("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "priority_first");
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100:200,true;";
        String nodesConfig = "n1= res=100:200";
        String queuesConfig = "root(=[100:50 100:50 50:40 110:60 0]);-a(=[40:20 100:50 9:9 50:30 0]);-b(=[60:30 100:50 40:30 60:30 0]);";
        String appsConfig = "a\t(1,2:1,n1,,4,false,25:25);a\t(1,1:3,n1,,2,false,25:25);b\t(4,2:1,n1,,10,false,20:20);b\t(4,1:2,n1,,5,false,10:10);b\t(5,1:1,n1,,5,false,30:20);b\t(6,2:1,n1,,5,false,30:20);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }
}

