/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyForReservedContainers
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.select_based_on_reserved_containers", true);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testPreemptionForSimpleReservedContainer() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=50;n2= res=50";
        String queuesConfig = "root(=[100 100 100 9 9]);-a(=[50 100 90 0]);-b(=[50 100 10 9 9])";
        String appsConfig = "a\t(1,1,n1,,45,false)(1,1,n2,,45,false);b\t(1,1,n1,,1,false)(1,9,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n1", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testUseReservedAndFifoSelectorTogether() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=50;n2= res=50";
        String queuesConfig = "root(=[100 100 100 70 10]);-a(=[30 100 45 0]);-b(=[70 100 55 70 50])";
        String appsConfig = "a\t(1,1,n2,,35,false)(1,1,n1,,10,false);b\t(1,1,n2,,5,false)(1,50,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n1", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n2", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testReservedSelectorSkipsAMContainer() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=50;n2= res=50";
        String queuesConfig = "root(=[100 100 100 70 10]);-a(=[30 100 45 0]);-b(=[70 100 55 70 50])";
        String appsConfig = "a\t(1,1,n1,,10,false)(1,1,n2,,35,false);b\t(1,1,n2,,5,false)(1,50,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n1", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n2", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testPreemptionForReservedContainerRespectGuaranteedResource() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=50;n2= res=50";
        String queuesConfig = "root(=[100 100 100 9 9]);-a(=[85 100 90 0]);-b(=[15 100 10 9 9])";
        String appsConfig = "a\t(1,1,n1,,45,false)(1,1,n2,,45,false);b\t(1,1,n1,,1,false)(1,9,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testPreemptionForReservedContainerWhichHasAvailableResource() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=50;n2= res=50";
        String queuesConfig = "root(=[100 100 99 9 9]);-a(=[50 100 90 0]);-b(=[50 100 9 9 9])";
        String appsConfig = "a\t(1,1,n1,,45,false)(1,1,n2,,45,false);b\t(1,9,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n1", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n2", (int)1))));
    }

    @Test
    public void testPreemptionForReservedContainerWhichHasNondivisibleAvailableResource() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=50;n2= res=50";
        String queuesConfig = "root(=[100 100 99 9 9]);-a(=[50 100 90 0]);-b(=[50 100 9 9 9])";
        String appsConfig = "a\t(1,2,n1,,24,false)(1,2,n2,,23,false);b\t(1,9,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n1", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n2", (int)1))));
    }

    @Test
    public void testPreemptionForReservedContainerRespectAvailableResources() throws IOException {
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=25;n2= res=25;n3= res=25;n4= res=25;";
        String queuesConfig = "root(=[100 100 89 9 9]);-a(=[50 100 80 0]);-b(=[50 100 9 9 9])";
        String appsConfig = "a\t(1,2,n1,,10,false)(1,2,n2,,10,false)(1,2,n3,,10,false)(1,2,n4,,10,false);b\t(1,9,n1,,1,true)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n1", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n2", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n3", (int)1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new ProportionalCapacityPreemptionPolicyMockFramework.IsPreemptionRequestForQueueAndNode(this.getAppAttemptId(1), "a", NodeId.newInstance((String)"n4", (int)1))));
    }
}

