/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestSignalContainer {
    private static final Log LOG = LogFactory.getLog(TestSignalContainer.class);

    @Test
    public void testSignalRequestDeliveryToNM() throws Exception {
        int signaledConts;
        List contsToSignal;
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        FairScheduler fs = null;
        if (rm.getResourceScheduler().getClass() == FairScheduler.class) {
            fs = (FairScheduler)rm.getResourceScheduler();
        }
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 2;
        am.allocate("h1", 1000, 2, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        ArrayList conts = new ArrayList(2);
        int waitCount = 0;
        while (conts.size() < 2 && waitCount++ < 200) {
            LOG.info((Object)("Got " + conts.size() + " containers. Waiting to get " + 2));
            Thread.sleep(100L);
            List allocation = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            conts.addAll(allocation);
            if (fs == null) continue;
            nm1.nodeHeartbeat(true);
        }
        Assert.assertEquals((long)2L, (long)conts.size());
        for (Container container : conts) {
            rm.signalToContainer(container.getId(), SignalContainerCommand.OUTPUT_THREAD_DUMP);
        }
        waitCount = 0;
        for (signaledConts = 0; signaledConts < 2 && waitCount++ < 200; signaledConts += contsToSignal.size()) {
            LOG.info((Object)("Waiting to get signalcontainer events.. signaledConts: " + signaledConts));
            NodeHeartbeatResponse resp = nm1.nodeHeartbeat(true);
            contsToSignal = resp.getContainersToSignalList();
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)signaledConts);
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED);
        rm.stop();
    }
}

