/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class RMHATestBase
extends ClientBaseWithFixes {
    private static final int ZK_TIMEOUT_MS = 5000;
    private static HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
    protected Configuration configuration = new YarnConfiguration();
    static MockRM rm1 = null;
    static MockRM rm2 = null;
    Configuration confForRM1;
    Configuration confForRM2;

    @Before
    public void setup() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        this.configuration.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.configuration.set("yarn.resourcemanager.store.class", ZKRMStateStore.class.getName());
        this.configuration.set("hadoop.zk.address", this.hostPort);
        this.configuration.setInt("hadoop.zk.timeout-ms", 5000);
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.configuration.set("yarn.resourcemanager.cluster-id", "test-yarn-cluster");
        int base = 100;
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)"rm1"), "0.0.0.0:" + (base + 20));
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)"rm2"), "0.0.0.0:" + (base + 40));
            base *= 2;
        }
        this.confForRM1 = new Configuration(this.configuration);
        this.confForRM1.set("yarn.resourcemanager.ha.id", "rm1");
        this.confForRM2 = new Configuration(this.configuration);
        this.confForRM2.set("yarn.resourcemanager.ha.id", "rm2");
    }

    @After
    public void teardown() {
        if (rm1 != null) {
            rm1.stop();
        }
        if (rm2 != null) {
            rm2.stop();
        }
    }

    protected MockAM launchAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        nm.nodeHeartbeat(true);
        ((AbstractYarnScheduler)rm.getResourceScheduler()).update();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        rm.waitForState(app.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.RUNNING);
        return am;
    }

    private MockRM initMockRMWithOldConf(final Configuration confForRM1) {
        return new MockRM(confForRM1, null, false, false){

            @Override
            protected AdminService createAdminService() {
                return new AdminService(this){

                    protected void startServer() {
                    }

                    protected void stopServer() {
                    }

                    protected Configuration loadNewConfiguration() throws IOException, YarnException {
                        return confForRM1;
                    }
                };
            }
        };
    }

    protected void startRMs() throws IOException {
        rm1 = this.initMockRMWithOldConf(this.confForRM1);
        rm2 = this.initMockRMWithOldConf(this.confForRM2);
        this.startRMs(rm1, this.confForRM1, rm2, this.confForRM2);
    }

    protected void startRMsWithCustomizedRMAppManager() throws IOException {
        final Configuration conf1 = new Configuration(this.confForRM1);
        rm1 = new MockRM(conf1){

            protected RMAppManager createRMAppManager() {
                return new MyRMAppManager((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.masterService, this.applicationACLsManager, conf1);
            }
        };
        rm2 = new MockRM(this.confForRM2);
        this.startRMs(rm1, conf1, rm2, this.confForRM2);
    }

    protected boolean isFinalState(RMAppState state) {
        return state.equals((Object)RMAppState.FINISHING) || state.equals((Object)RMAppState.FINISHED) || state.equals((Object)RMAppState.FAILED) || state.equals((Object)RMAppState.KILLED);
    }

    protected void explicitFailover() throws IOException {
        RMHATestBase.rm1.adminService.transitionToStandby(requestInfo);
        RMHATestBase.rm2.adminService.transitionToActive(requestInfo);
        Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
        Assert.assertTrue((rm2.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
    }

    protected void startRMs(MockRM rm1, Configuration confForRM1, MockRM rm2, Configuration confForRM2) throws IOException {
        rm1.init(confForRM1);
        rm1.start();
        Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
        rm2.init(confForRM2);
        rm2.start();
        Assert.assertTrue((rm2.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
        rm1.adminService.transitionToActive(requestInfo);
        Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
    }

    private static class MyRMAppManager
    extends RMAppManager {
        private Configuration conf;
        private RMContext rmContext;

        public MyRMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
            super(context, scheduler, masterService, applicationACLsManager, conf);
            this.conf = conf;
            this.rmContext = context;
        }

        protected void submitApplication(ApplicationSubmissionContext submissionContext, long submitTime, String user) throws YarnException {
            RMAppImpl application = new RMAppImpl(submissionContext.getApplicationId(), this.rmContext, this.conf, submissionContext.getApplicationName(), user, submissionContext.getQueue(), submissionContext, (YarnScheduler)this.rmContext.getScheduler(), this.rmContext.getApplicationMasterService(), submitTime, submissionContext.getApplicationType(), submissionContext.getApplicationTags(), null);
            this.rmContext.getRMApps().put(submissionContext.getApplicationId(), application);
        }
    }
}

