/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFairSchedulerConfiguration {
    @Test
    public void testParseResourceConfigValue() throws Exception {
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2 vcores, 1024 mb").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 mb, 2 vcores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"2vcores,1024mb").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb,2vcores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024   mb, 2    vcores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"1024 Mb, 2 vCores").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024 mb, 2 vcores  ").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024.3 mb, 2.35 vcores  ").getResource());
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  1024. mb, 2. vcores  ").getResource());
        Resource clusterResource = BuilderUtils.newResource((long)2048L, (int)4);
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 50% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% Memory, 50% CpU").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)4), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 100% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)4), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)" 100% cpu, 50% memory").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)0), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 0% cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50 % memory, 50 % cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50%memory,50%cpu").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"  50  %  memory,  50  %  cpu  ").getResource(clusterResource));
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1024L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"50.% memory, 50.% cpu").getResource(clusterResource));
        clusterResource = BuilderUtils.newResource((long)10240L, (int)4);
        Assert.assertEquals((Object)BuilderUtils.newResource((long)1116L, (int)2), (Object)FairSchedulerConfiguration.parseResourceConfigValue((String)"10.9% memory, 50.6% cpu").getResource(clusterResource));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testNoUnits() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyMemory() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024mb");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOnlyCPU() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1024vcores");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testGibberish() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"1o24vc0res");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testNoUnitsPercentage() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"95%, 50% memory");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testInvalidNumPercentage() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"95A% cpu, 50% memory");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testCpuPercentageMemoryAbsolute() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% cpu, 1024 mb");
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testMemoryPercentageCpuAbsolute() throws Exception {
        FairSchedulerConfiguration.parseResourceConfigValue((String)"50% memory, 2 vcores");
    }
}

