/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.xml.sax.SAXException;

public class TestFairScheduler
extends FairSchedulerTestBase {
    private final int GB = 1024;
    private static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        this.conf = this.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.scheduler.setRMContext(this.resourceManager.getRMContext());
    }

    @After
    public void tearDown() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
        YarnAuthorizationProvider.destroy();
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            this.scheduler.serviceInit((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            this.scheduler.serviceInit((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    @Test(timeout=2000L)
    public void testLoadConfigurationOnInitialize() throws IOException {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setInt("yarn.scheduler.fair.max.assign", 3);
        this.conf.setBoolean("yarn.scheduler.fair.sizebasedweight", true);
        this.conf.setDouble("yarn.scheduler.fair.locality.threshold.node", 0.5);
        this.conf.setDouble("yarn.scheduler.fair.locality.threshold.rack", 0.7);
        this.conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.conf.setInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 10);
        this.conf.setInt("yarn.scheduler.fair.locality-delay-rack-ms", 5000);
        this.conf.setInt("yarn.scheduler.fair.locality-delay-node-ms", 5000);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        this.conf.setInt("yarn.scheduler.increment-allocation-mb", 128);
        ResourceUtils.resetResourceTypes((Configuration)this.conf);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((Object)true, (Object)this.scheduler.assignMultiple);
        Assert.assertEquals((long)3L, (long)this.scheduler.maxAssign);
        Assert.assertEquals((Object)true, (Object)this.scheduler.sizeBasedWeight);
        Assert.assertEquals((double)0.5, (double)this.scheduler.nodeLocalityThreshold, (double)0.01);
        Assert.assertEquals((double)0.7, (double)this.scheduler.rackLocalityThreshold, (double)0.01);
        Assert.assertTrue((String)"The continuous scheduling should be enabled", (boolean)this.scheduler.continuousSchedulingEnabled);
        Assert.assertEquals((long)10L, (long)this.scheduler.continuousSchedulingSleepMs);
        Assert.assertEquals((long)5000L, (long)this.scheduler.nodeLocalityDelayMs);
        Assert.assertEquals((long)5000L, (long)this.scheduler.rackLocalityDelayMs);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((long)512L, (long)this.scheduler.getMinimumResourceCapability().getMemorySize());
        Assert.assertEquals((long)128L, (long)this.scheduler.getIncrementResourceCapability().getMemorySize());
    }

    @Test
    public void testNonMinZeroResourcesSettings() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 256);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        ResourceUtils.resetResourceTypes((Configuration)conf);
        this.scheduler.init((Configuration)conf);
        this.scheduler.reinitialize((Configuration)conf, null);
        Assert.assertEquals((long)256L, (long)this.scheduler.getMinimumResourceCapability().getMemorySize());
        Assert.assertEquals((long)1L, (long)this.scheduler.getMinimumResourceCapability().getVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getIncrementResourceCapability().getMemorySize());
        Assert.assertEquals((long)2L, (long)this.scheduler.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testMinZeroResourcesSettings() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 0);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        ResourceUtils.resetResourceTypes((Configuration)conf);
        this.scheduler.init((Configuration)conf);
        this.scheduler.reinitialize((Configuration)conf, null);
        Assert.assertEquals((long)0L, (long)this.scheduler.getMinimumResourceCapability().getMemorySize());
        Assert.assertEquals((long)0L, (long)this.scheduler.getMinimumResourceCapability().getVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getIncrementResourceCapability().getMemorySize());
        Assert.assertEquals((long)2L, (long)this.scheduler.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testAggregateCapacityTracking() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getClusterResource().getMemorySize());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)512), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)1536L, (long)this.scheduler.getClusterResource().getMemorySize());
        NodeRemovedSchedulerEvent nodeEvent3 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        Assert.assertEquals((long)512L, (long)this.scheduler.getClusterResource().getMemorySize());
    }

    @Test
    public void testSimpleFairShareCalculation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "queue1", "user1");
        this.createSchedulingRequest(10240, "queue2", "user1");
        this.createSchedulingRequest(10240, "root.default", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            Assert.assertEquals((long)3414L, (long)p.getFairShare().getMemorySize());
            Assert.assertEquals((long)3414L, (long)p.getMetrics().getFairShareMB());
            Assert.assertEquals((long)3414L, (long)p.getSteadyFairShare().getMemorySize());
            Assert.assertEquals((long)3414L, (long)p.getMetrics().getSteadyFairShareMB());
        }
    }

    @Test
    public void testFairShareWithHighMaxResources() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<maxResources>1073741824 mb 1000 vcores</maxResources>");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<maxResources>1073741824 mb 1000 vcores</maxResources>");
        out.println("<weight>.75</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((String)"Queue A did not get its expected fair share", (long)2048L, (long)queue.getFairShare().getMemorySize());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((String)"Queue B did not get its expected fair share", (long)6144L, (long)queue.getFairShare().getMemorySize());
    }

    @Test
    public void testFairShareWithLowMaxResources() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\">");
        out.println("    <maxResources>1024 mb 1 vcores</maxResources>");
        out.println("    <weight>0.75</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\">");
        out.println("    <maxResources>3072 mb 3 vcores</maxResources>");
        out.println("    <weight>0.25</weight>");
        out.println("  </queue>");
        out.println("</allocations>");
        out.close();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, 1, "queueA", "user1", 2);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, 1, "queueB", "user1", 4);
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((String)"Queue A did not get its expected fair share", (long)1024L, (long)queue.getFairShare().getMemorySize());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((String)"Queue B did not get its expected fair share", (long)3072L, (long)queue.getFairShare().getMemorySize());
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"App 1 is not running with the correct number of containers", (long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        Assert.assertEquals((String)"App 2 is not running with the correct number of containers", (long)3L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
    }

    @Test
    public void testChildMaxResources() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\" type=\"parent\">");
        out.println("    <maxChildResources>2048mb,2vcores</maxChildResources>");
        out.println("  </queue>");
        out.println("</allocations>");
        out.close();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, 1, "queueA.queueB", "user1", 8);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, 1, "queueA.queueC", "user1", 8);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        Assert.assertEquals((String)"App 1 is not running with the correct number of containers", (long)2L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        Assert.assertEquals((String)"App 2 is not running with the correct number of containers", (long)2L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\" type=\"parent\">");
        out.println("    <maxChildResources>3072mb,3vcores</maxChildResources>");
        out.println("  </queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        Assert.assertEquals((String)"App 1 is not running with the correct number of containers", (long)3L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        Assert.assertEquals((String)"App 2 is not running with the correct number of containers", (long)3L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("  <queue name=\"queueA\" type=\"parent\">");
        out.println("    <maxChildResources>1024mb,1vcores</maxChildResources>");
        out.println("  </queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        Assert.assertEquals((String)"App 1 is not running with the correct number of containers", (long)3L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        Assert.assertEquals((String)"App 2 is not running with the correct number of containers", (long)3L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
    }

    @Test
    public void testFairShareWithZeroWeight() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)0L, (long)queue.getFairShare().getMemorySize());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)0L, (long)queue.getFairShare().getMemorySize());
    }

    @Test
    public void testComputeMaxAMResource() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueFSZeroWithMax\">");
        out.println("<weight>0</weight>");
        out.println("<maxAMShare>0.5</maxAMShare>");
        out.println("<maxResources>4096 mb 4 vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueFSZeroWithAVL\">");
        out.println("<weight>0.0</weight>");
        out.println("<maxAMShare>0.5</maxAMShare>");
        out.println("</queue>");
        out.println("<queue name=\"queueFSNonZero\">");
        out.println("<weight>1</weight>");
        out.println("<maxAMShare>0.5</maxAMShare>");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        long memCapacity = 20480L;
        int cpuCapacity = 20;
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((long)memCapacity, (int)cpuCapacity), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        Resource amResource = Resource.newInstance((int)1024, (int)1);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        FSLeafQueue queueFSZeroWithMax = this.scheduler.getQueueManager().getLeafQueue("queueFSZeroWithMax", true);
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queueFSZeroWithMax", "user1", amResource);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"QueueFSZeroWithMax's fair share should be zero", (long)0L, (long)queueFSZeroWithMax.getFairShare().getMemorySize());
        Resource expectedAMResource = Resources.multiplyAndRoundUp((Resource)queueFSZeroWithMax.getMaxShare(), (double)queueFSZeroWithMax.getMaxAMShare());
        Assert.assertEquals((String)"QueueFSZeroWithMax's maximum AM resource should be maxShare * maxAMShare", (long)expectedAMResource.getMemorySize(), (long)queueFSZeroWithMax.getMetrics().getMaxAMShareMB());
        Assert.assertEquals((String)"QueueFSZeroWithMax's maximum AM resource should be maxShare * maxAMShare", (long)expectedAMResource.getVirtualCores(), (long)queueFSZeroWithMax.getMetrics().getMaxAMShareVCores());
        Assert.assertEquals((String)"QueueFSZeroWithMax's AM resource usage should be the same to AM resource request", (long)amResource.getMemorySize(), (long)queueFSZeroWithMax.getMetrics().getAMResourceUsageMB());
        amResource = Resources.createResource((int)1024, (int)1);
        FSLeafQueue queueFSZeroWithAVL = this.scheduler.getQueueManager().getLeafQueue("queueFSZeroWithAVL", true);
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queueFSZeroWithAVL", "user1", amResource);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        expectedAMResource = Resources.multiplyAndRoundUp((Resource)Resources.createResource((long)(memCapacity - amResource.getMemorySize()), (int)(cpuCapacity - amResource.getVirtualCores())), (double)queueFSZeroWithAVL.getMaxAMShare());
        Assert.assertEquals((String)"QueueFSZeroWithAVL's fair share should be zero", (long)0L, (long)queueFSZeroWithAVL.getFairShare().getMemorySize());
        Assert.assertEquals((String)"QueueFSZeroWithAVL's maximum AM resource should be  available resource * maxAMShare", (long)expectedAMResource.getMemorySize(), (long)queueFSZeroWithAVL.getMetrics().getMaxAMShareMB());
        Assert.assertEquals((String)"QueueFSZeroWithAVL's maximum AM resource should be  available resource * maxAMShare", (long)expectedAMResource.getVirtualCores(), (long)queueFSZeroWithAVL.getMetrics().getMaxAMShareVCores());
        Assert.assertEquals((String)"QueueFSZeroWithMax's AM resource usage should be the same to AM resource request", (long)amResource.getMemorySize(), (long)queueFSZeroWithAVL.getMetrics().getAMResourceUsageMB());
        amResource = Resources.createResource((int)1024, (int)1);
        FSLeafQueue queueFSNonZero = this.scheduler.getQueueManager().getLeafQueue("queueFSNonZero", true);
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "queueFSNonZero", "user1", amResource);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertNotEquals((String)"QueueFSNonZero's fair share shouldn't be zero", (long)0L, (long)queueFSNonZero.getFairShare().getMemorySize());
        expectedAMResource = Resources.multiplyAndRoundUp((Resource)queueFSNonZero.getFairShare(), (double)queueFSNonZero.getMaxAMShare());
        Assert.assertEquals((String)"QueueFSNonZero's maximum AM resource should be  fair share * maxAMShare", (long)expectedAMResource.getMemorySize(), (long)queueFSNonZero.getMetrics().getMaxAMShareMB());
        Assert.assertEquals((String)"QueueFSNonZero's maximum AM resource should be  fair share * maxAMShare", (long)expectedAMResource.getVirtualCores(), (long)queueFSNonZero.getMetrics().getMaxAMShareVCores());
        Assert.assertEquals((String)"QueueFSNonZero's AM resource usage should be the same to AM resource request", (long)amResource.getMemorySize(), (long)queueFSNonZero.getMetrics().getAMResourceUsageMB());
    }

    @Test
    public void testFairShareWithZeroWeightNoneZeroMinRes() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1 mb 1 vcores</minResources>");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>1 mb 1 vcores</minResources>");
        out.println("<weight>0.0</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)1L, (long)queue.getFairShare().getMemorySize());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)1L, (long)queue.getFairShare().getMemorySize());
    }

    @Test
    public void testFairShareWithNoneZeroWeightNoneZeroMinRes() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024 mb 1 vcores</minResources>");
        out.println("<weight>0.5</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>1024 mb 1 vcores</minResources>");
        out.println("<weight>0.5</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(4096, "queueA", "user1");
        this.createSchedulingRequest(4096, "queueB", "user1");
        this.scheduler.update();
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue("queueA", false);
        Assert.assertEquals((long)4096L, (long)queue.getFairShare().getMemorySize());
        queue = this.scheduler.getQueueManager().getLeafQueue("queueB", false);
        Assert.assertEquals((long)4096L, (long)queue.getFairShare().getMemorySize());
    }

    @Test
    public void testQueueInfo() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.75</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queueA", "user1");
        this.createSchedulingRequest(6144, "queueB", "user1");
        this.scheduler.update();
        QueueInfo queueInfo = this.scheduler.getQueueInfo("queueA", false, false);
        Assert.assertEquals((float)0.25f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        Assert.assertEquals((long)0L, (long)queueInfo.getQueueStatistics().getAllocatedContainers());
        Assert.assertEquals((long)0L, (long)queueInfo.getQueueStatistics().getAllocatedMemoryMB());
        queueInfo = this.scheduler.getQueueInfo("queueB", false, false);
        Assert.assertEquals((float)0.75f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        queueInfo = this.scheduler.getQueueInfo("queueA", false, false);
        Assert.assertEquals((float)0.25f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)0.5f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        Assert.assertEquals((long)1L, (long)queueInfo.getQueueStatistics().getAllocatedContainers());
        Assert.assertEquals((long)1024L, (long)queueInfo.getQueueStatistics().getAllocatedMemoryMB());
        queueInfo = this.scheduler.getQueueInfo("queueB", false, false);
        Assert.assertEquals((float)0.75f, (float)queueInfo.getCapacity(), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        Assert.assertEquals((long)1L, (long)queueInfo.getQueueStatistics().getAllocatedContainers());
        Assert.assertEquals((long)6144L, (long)queueInfo.getQueueStatistics().getAllocatedMemoryMB());
    }

    @Test
    public void testSimpleHierarchicalFairShareCalculation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int capacity = 240;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)capacity), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "parent.queue2", "user1");
        this.createSchedulingRequest(10240, "parent.queue3", "user1");
        this.createSchedulingRequest(10240, "root.default", "user1");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection queues = queueManager.getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        FSLeafQueue queue1 = queueManager.getLeafQueue("default", true);
        FSLeafQueue queue2 = queueManager.getLeafQueue("parent.queue2", true);
        FSLeafQueue queue3 = queueManager.getLeafQueue("parent.queue3", true);
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getFairShare().getMemorySize());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getMetrics().getSteadyFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getFairShare().getMemorySize());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getMetrics().getSteadyFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getFairShare().getMemorySize());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getMetrics().getSteadyFairShareMB());
    }

    @Test
    public void testHierarchicalQueuesSimilarParents() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue leafQueue = queueManager.getLeafQueue("parent.child", true);
        Assert.assertEquals((long)2L, (long)queueManager.getLeafQueues().size());
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((Object)"root.parent.child", (Object)leafQueue.getName());
        FSLeafQueue leafQueue2 = queueManager.getLeafQueue("parent", true);
        Assert.assertNull((Object)leafQueue2);
        Assert.assertEquals((long)2L, (long)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue3 = queueManager.getLeafQueue("parent.child.grandchild", true);
        Assert.assertNull((Object)leafQueue3);
        Assert.assertEquals((long)2L, (long)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue4 = queueManager.getLeafQueue("parent.sister", true);
        Assert.assertNotNull((Object)leafQueue4);
        Assert.assertEquals((Object)"root.parent.sister", (Object)leafQueue4.getName());
        Assert.assertEquals((long)3L, (long)queueManager.getLeafQueues().size());
    }

    @Test
    public void testSchedulerRootQueueMetrics() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.rootMetrics.getReservedMB());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerAllocation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)512, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(512, 2, "queue1", "user1", 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getVirtualCores());
        FSQueueMetrics queue1Metrics = this.scheduler.getQueueManager().getQueue("queue1").getMetrics();
        Assert.assertEquals((long)1024L, (long)queue1Metrics.getAllocatedMB());
        Assert.assertEquals((long)2L, (long)queue1Metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAllocatedMB());
        Assert.assertEquals((long)2L, (long)this.scheduler.getRootQueueMetrics().getAllocatedVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerReservation() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemorySize());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemorySize());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemorySize());
    }

    @Test(timeout=5000L)
    public void testOffSwitchAppReservationThreshold() throws Exception {
        this.conf.setFloat("yarn.scheduler.fair.reservable-nodes", 0.5f);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node3));
        Assert.assertEquals((long)6144L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        ApplicationAttemptId attId = this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
        RMNode node4 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.4");
        NodeAddedSchedulerEvent nodeEvent4 = new NodeAddedSchedulerEvent(node4);
        this.scheduler.handle((SchedulerEvent)nodeEvent4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node4));
        Assert.assertEquals((long)8192L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node3));
        this.scheduler.update();
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
    }

    @Test(timeout=5000L)
    public void testRackLocalAppReservationThreshold() throws Exception {
        this.conf.setFloat("yarn.scheduler.fair.reservable-nodes", 0.5f);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(2, Resources.createResource((int)3072), 1, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(2, Resources.createResource((int)3072), 1, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        RMNode node4 = MockNodes.newNodeInfo(2, Resources.createResource((int)3072), 1, "127.0.0.4");
        NodeAddedSchedulerEvent nodeEvent4 = new NodeAddedSchedulerEvent(node4);
        this.scheduler.handle((SchedulerEvent)nodeEvent4);
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node3));
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node4));
        Assert.assertEquals((long)8192L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        ApplicationAttemptId attemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(attemptId);
        this.scheduler.addApplication(attemptId.getApplicationId(), "queue1", "user1", false);
        this.scheduler.addApplicationAttempt(attemptId, false, false);
        ArrayList<ResourceRequest> asks = new ArrayList<ResourceRequest>();
        asks.add(this.createResourceRequest(2048, node2.getRackName(), 1, 1, false));
        this.scheduler.allocate(attemptId, asks, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        ApplicationAttemptId attId = this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
        RMNode node5 = MockNodes.newNodeInfo(2, Resources.createResource((int)3072), 1, "127.0.0.4");
        NodeAddedSchedulerEvent nodeEvent5 = new NodeAddedSchedulerEvent(node5);
        this.scheduler.handle((SchedulerEvent)nodeEvent5);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node4));
        Assert.assertEquals((long)10240L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node3));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node4));
        this.scheduler.update();
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
    }

    @Test(timeout=5000L)
    public void testReservationThresholdWithAssignMultiple() throws Exception {
        this.conf.setFloat("yarn.scheduler.fair.reservable-nodes", 0.0f);
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setBoolean("yarn.scheduler.fair.dynamic.max.assign", false);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(2, Resources.createResource((int)4096, (int)4), 1, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue1", "user1", 10);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)8192L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getNumReservations(null, true));
    }

    @Test(timeout=500000L)
    public void testContainerReservationAttemptExceedingQueueMax() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<queue name=\"queue1\">");
        out.println("<maxResources>2048mb,5vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxResources>2048mb,10vcores</maxResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)5), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2048L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        this.createSchedulingRequest(1024, "queue2", "user2", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemorySize());
    }

    @Test
    public void testRequestAMResourceInZeroFairShareQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<weight>0.0</weight>");
        out.println("<maxResources>4096mb,10vcores</maxResources>");
        out.println("<maxAMShare>0.5</maxAMShare>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<weight>2.0</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queue3\">");
        out.println("<weight>0.000001</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)20), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        this.createSchedulingRequest(1024, "root.queue2", "user2", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Resource amResource = Resource.newInstance((int)1024, (int)1);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "root.queue1", "user1", amResource);
        this.createSchedulingRequestExistingApplication(3072, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application 1 should not be running", (long)0L, (long)app1.getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "root.queue1", "user1", amResource);
        this.createSchedulingRequestExistingApplication(2048, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application 2 should be running", (long)1L, (long)app2.getLiveContainers().size());
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "root.queue3", "user1", amResource);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId3);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application 3 should be running", (long)1L, (long)app3.getLiveContainers().size());
    }

    @Test(timeout=500000L)
    public void testContainerReservationNotExceedingQueueMax() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<queue name=\"queue1\">");
        out.println("<maxResources>3072mb,10vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxResources>2048mb,10vcores</maxResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)5), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2048L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        this.createSchedulingRequest(1024, "queue2", "user2", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemorySize());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemorySize());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("<queue name=\"queue1\">");
        out.println("<maxResources>2048mb,10vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxResources>2048mb,10vcores</maxResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.createSchedulingRequest(1024, "queue2", "user2", 1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2048L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
    }

    @Test
    public void testReservationThresholdGatesReservations() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.conf.setFloat("yarn.scheduler.reservation-threshold.increment-multiple", 2.0f);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(4096, 4, "queue1", "user1", 1, 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)4096L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getReservedContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 3, 1, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemorySize());
        Assert.assertEquals((long)3L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getVirtualCores());
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)3L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getVirtualCores());
        Assert.assertEquals((long)3L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getVirtualCores());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getVirtualCores());
    }

    @Test
    public void testEmptyQueueName() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
    }

    @Test
    public void testQueueuNameWithPeriods() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId1 = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent1 = new AppAddedSchedulerEvent(appAttemptId1.getApplicationId(), ".A", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent1);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId1));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
        ApplicationAttemptId appAttemptId2 = this.createAppAttemptId(2, 1);
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(appAttemptId2.getApplicationId(), "A.", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId2));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
        ApplicationAttemptId appAttemptId3 = this.createAppAttemptId(3, 1);
        AppAddedSchedulerEvent appAddedEvent3 = new AppAddedSchedulerEvent(appAttemptId3.getApplicationId(), "A.B", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent3);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId3));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
    }

    @Test
    public void testAssignToQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        FSLeafQueue queue1 = this.scheduler.assignToQueue((RMApp)rmApp1, "default", "asterix");
        FSLeafQueue queue2 = this.scheduler.assignToQueue((RMApp)rmApp2, "notdefault", "obelix");
        Assert.assertEquals((Object)rmApp1.getQueue(), (Object)queue1.getName());
        Assert.assertEquals((Object)"root.asterix", (Object)rmApp1.getQueue());
        Assert.assertEquals((Object)rmApp2.getQueue(), (Object)queue2.getName());
        Assert.assertEquals((Object)"root.notdefault", (Object)rmApp2.getQueue());
    }

    @Test
    public void testAssignToBadDefaultQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queuePlacementPolicy>");
        out.println("<rule name=\"specified\" create=\"false\" />");
        out.println("<rule name=\"default\" create=\"false\" />");
        out.println("</queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        try {
            FSLeafQueue fSLeafQueue = this.scheduler.assignToQueue((RMApp)rmApp1, "default", "asterix");
        }
        catch (IllegalStateException ise) {
            Assert.fail((String)"Bad queue placement policy terminal rule should not throw exception ");
        }
    }

    @Test
    public void testAssignToNonLeafQueueReturnsNull() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.getQueueManager().getLeafQueue("root.child1.granchild", true);
        this.scheduler.getQueueManager().getLeafQueue("root.child2", true);
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        Assert.assertNull((Object)this.scheduler.assignToQueue((RMApp)rmApp1, "root.child1", "tintin"));
        Assert.assertNotNull((Object)this.scheduler.assignToQueue((RMApp)rmApp2, "root.child2", "snowy"));
    }

    @Test
    public void testQueuePlacementWithPolicy() throws Exception {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ArrayList<QueuePlacementRule> rules = new ArrayList<QueuePlacementRule>();
        rules.add(new QueuePlacementRule.Specified().initialize(true, null));
        rules.add(new QueuePlacementRule.User().initialize(false, null));
        rules.add(new QueuePlacementRule.PrimaryGroup().initialize(false, null));
        rules.add(new QueuePlacementRule.SecondaryGroupExistingQueue().initialize(false, null));
        rules.add(new QueuePlacementRule.Default().initialize(true, null));
        HashSet queues = Sets.newHashSet((Object[])new String[]{"root.user1", "root.user3group", "root.user4subgroup1", "root.user4subgroup2", "root.user5subgroup2"});
        HashMap configuredQueues = new HashMap();
        configuredQueues.put(FSQueueType.LEAF, queues);
        configuredQueues.put(FSQueueType.PARENT, new HashSet());
        this.scheduler.getAllocationConfiguration().placementPolicy = new QueuePlacementPolicy(rules, configuredQueues, this.conf);
        ApplicationAttemptId appId = this.createSchedulingRequest(1024, "somequeue", "user1");
        Assert.assertEquals((Object)"root.somequeue", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user1");
        Assert.assertEquals((Object)"root.user1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user3");
        Assert.assertEquals((Object)"root.user3group", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user4");
        Assert.assertEquals((Object)"root.user4subgroup1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user5");
        Assert.assertEquals((Object)"root.user5subgroup2", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        rules = new ArrayList();
        rules.add(new QueuePlacementRule.User().initialize(false, null));
        rules.add(new QueuePlacementRule.Specified().initialize(true, null));
        rules.add(new QueuePlacementRule.Default().initialize(true, null));
        this.scheduler.getAllocationConfiguration().placementPolicy = new QueuePlacementPolicy(rules, configuredQueues, this.conf);
        appId = this.createSchedulingRequest(1024, "somequeue", "user1");
        Assert.assertEquals((Object)"root.user1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "somequeue", "otheruser");
        Assert.assertEquals((Object)"root.somequeue", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
    }

    @Test
    public void testFairShareWithMinAlloc() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(2048, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((long)1024L, (long)p.getFairShare().getMemorySize());
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((long)2048L, (long)p.getFairShare().getMemorySize());
        }
    }

    @Test
    public void testNestedUserQueue() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"user1group\" type=\"parent\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queuePlacementPolicy>");
        out.println("<rule name=\"specified\" create=\"false\" />");
        out.println("<rule name=\"nestedUserQueue\">");
        out.println("     <rule name=\"primaryGroup\" create=\"false\" />");
        out.println("</rule>");
        out.println("<rule name=\"default\" />");
        out.println("</queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        FSLeafQueue user1Leaf = this.scheduler.assignToQueue((RMApp)rmApp1, "root.default", "user1");
        Assert.assertEquals((Object)"root.user1group.user1", (Object)user1Leaf.getName());
    }

    @Test
    public void testFairShareAndWeightsInNestedUserQueueRule() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parentq\" type=\"parent\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queuePlacementPolicy>");
        out.println("<rule name=\"nestedUserQueue\">");
        out.println("     <rule name=\"specified\" create=\"false\" />");
        out.println("</rule>");
        out.println("<rule name=\"default\" />");
        out.println("</queuePlacementPolicy>");
        out.println("</allocations>");
        out.close();
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int capacity = 16384;
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)capacity), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "root.parentq", "user1");
        this.createSchedulingRequest(10240, "root.parentq", "user2");
        this.createSchedulingRequest(10240, "root.default", "user3");
        this.scheduler.update();
        this.scheduler.getQueueManager().getRootQueue().setSteadyFairShare(this.scheduler.getClusterResource());
        this.scheduler.getQueueManager().getRootQueue().recomputeSteadyShares();
        Collection leafQueues = this.scheduler.getQueueManager().getLeafQueues();
        for (FSLeafQueue leaf : leafQueues) {
            if (!leaf.getName().equals("root.parentq.user1") && !leaf.getName().equals("root.parentq.user2")) continue;
            Assert.assertEquals((long)(capacity / 4), (long)leaf.getFairShare().getMemorySize());
            Assert.assertEquals((long)(capacity / 4), (long)leaf.getSteadyFairShare().getMemorySize());
            Assert.assertEquals((double)1.0, (double)leaf.getWeight(), (double)0.0);
        }
    }

    @Test
    public void testSteadyFairShareWithReloadAndNodeAddRemove() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemorySize());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)6144), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)6144L, (long)this.scheduler.getClusterResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemorySize());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <weight>2</weight>");
        out.println("  </queue>");
        out.println("  <queue name=\"child3\">");
        out.println("    <weight>2</weight>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1024L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)2048L, (long)queueManager.getLeafQueue("child3", false).getSteadyFairShare().getMemorySize());
        NodeRemovedSchedulerEvent nodeEvent2 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)0L, (long)this.scheduler.getClusterResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child1", false).getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)0L, (long)queueManager.getLeafQueue("child2", false).getSteadyFairShare().getMemorySize());
    }

    @Test
    public void testSteadyFairShareWithQueueCreatedRuntime() throws Exception {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)6144), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)6144L, (long)this.scheduler.getClusterResource().getMemorySize());
        Assert.assertEquals((long)6144L, (long)this.scheduler.getQueueManager().getRootQueue().getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)6144L, (long)this.scheduler.getQueueManager().getLeafQueue("default", false).getSteadyFairShare().getMemorySize());
        ApplicationAttemptId appAttemptId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId1, "default", "user1", null);
        Assert.assertEquals((long)3072L, (long)this.scheduler.getQueueManager().getLeafQueue("default", false).getSteadyFairShare().getMemorySize());
        Assert.assertEquals((long)3072L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", false).getSteadyFairShare().getMemorySize());
    }

    @Test
    public void testQueueDemandCalculation() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int minReqSize = 1024;
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.createMockRMApp(id11);
        this.scheduler.addApplication(id11.getApplicationId(), "root.queue1", "user1", false);
        this.scheduler.addApplicationAttempt(id11, false, false);
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(minReqSize * 2, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        ApplicationAttemptId id21 = this.createAppAttemptId(2, 1);
        this.createMockRMApp(id21);
        this.scheduler.addApplication(id21.getApplicationId(), "root.queue2", "user1", false);
        this.scheduler.addApplicationAttempt(id21, false, false);
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ResourceRequest request2 = this.createResourceRequest(2 * minReqSize, "foo", 1, 1, false);
        ResourceRequest request3 = this.createResourceRequest(2 * minReqSize, "*", 1, 1, false);
        ask2.add(request2);
        ask2.add(request3);
        this.scheduler.allocate(id21, ask2, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        ApplicationAttemptId id22 = this.createAppAttemptId(2, 2);
        this.createMockRMApp(id22);
        this.scheduler.addApplication(id22.getApplicationId(), "root.queue2", "user1", false);
        this.scheduler.addApplicationAttempt(id22, false, false);
        ArrayList<ResourceRequest> ask3 = new ArrayList<ResourceRequest>();
        ResourceRequest request4 = this.createResourceRequest(minReqSize, "bar", 2, 2, true);
        ResourceRequest request5 = this.createResourceRequest(minReqSize, "*", 2, 2, true);
        ask3.add(request4);
        ask3.add(request5);
        this.scheduler.allocate(id22, ask3, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.scheduler.update();
        Assert.assertEquals((long)(2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue1").getDemand().getMemorySize());
        Assert.assertEquals((long)(2 * minReqSize + 2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue2").getDemand().getMemorySize());
    }

    @Test
    public void testHierarchicalQueueAllocationFileParsing() throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<queue name=\"queueC\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        Assert.assertEquals((long)4L, (long)leafQueues.size());
        Assert.assertNotNull((Object)queueManager.getLeafQueue("queueA", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueC", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueD", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("default", false));
        Assert.assertEquals((long)4L, (long)leafQueues.size());
    }

    @Test
    public void testConfigureRootQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <minResources>1024mb,1vcores</minResources>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <minResources>1024mb,4vcores</minResources>");
        out.println("  </queue>");
        out.println("  <fairSharePreemptionTimeout>100</fairSharePreemptionTimeout>");
        out.println("  <minSharePreemptionTimeout>120</minSharePreemptionTimeout>");
        out.println("  <fairSharePreemptionThreshold>.5</fairSharePreemptionThreshold>");
        out.println("</queue>");
        out.println("<defaultFairSharePreemptionTimeout>300</defaultFairSharePreemptionTimeout>");
        out.println("<defaultMinSharePreemptionTimeout>200</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.6</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue root = queueManager.getRootQueue();
        Assert.assertTrue((boolean)(root.getPolicy() instanceof DominantResourceFairnessPolicy));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("child1", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("child2", false));
        Assert.assertEquals((long)100000L, (long)root.getFairSharePreemptionTimeout());
        Assert.assertEquals((long)120000L, (long)root.getMinSharePreemptionTimeout());
        Assert.assertEquals((double)0.5, (double)root.getFairSharePreemptionThreshold(), (double)0.01);
    }

    @Test(timeout=5000L)
    public void testMultipleContainersWaitingForReservation() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue2", "user2", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue3", "user3", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getCurrentReservation().getMemorySize());
    }

    @Test(timeout=5000L)
    public void testUserMaxRunningApps() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 1, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testIncreaseQueueMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>1</maxRunningApps></queue></queue></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>3</maxRunningApps></queue></queue></allocations>";
        this.testIncreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    @Test(timeout=5000L)
    public void testIncreaseUserMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>1</maxRunningApps></user></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>3</maxRunningApps></user></allocations>";
        this.testIncreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    private void testIncreaseQueueSettingOnTheFlyInternal(String allocBefore, String allocAfter) throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocBefore);
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocAfter);
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testDecreaseQueueMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>3</maxRunningApps></queue></queue></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>1</maxRunningApps></queue></queue></allocations>";
        this.testDecreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    @Test(timeout=5000L)
    public void testDecreaseUserMaxRunningAppsOnTheFly() throws Exception {
        String allocBefore = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>3</maxRunningApps></user></allocations>";
        String allocAfter = "<?xml version=\"1.0\"?><allocations><queue name=\"root\"><queue name=\"queue1\"><maxRunningApps>10</maxRunningApps></queue></queue><user name=\"user1\"><maxRunningApps>1</maxRunningApps></user></allocations>";
        this.testDecreaseQueueSettingOnTheFlyInternal(allocBefore, allocAfter);
    }

    private void testDecreaseQueueSettingOnTheFlyInternal(String allocBefore, String allocAfter) throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocBefore);
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println(allocAfter);
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId3).getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
        appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId3, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId4).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testReservationWithMultiplePriorities() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2));
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(this.createSchedulingRequest(1024, 1, "queue", "user", 1));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Basic allocation failed", (long)1L, (long)app1.getLiveContainers().size());
        ApplicationAttemptId attId = this.createSchedulingRequest(2048, 2, "queue1", "user1", 1, 2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Reservation at lower priority failed", (long)1L, (long)app2.getReservedContainers().size());
        this.createSchedulingRequestExistingApplication(2048, 2, 1, attId);
        ContainerId containerId = ((RMContainer)app1.getLiveContainers().iterator().next()).getContainerId();
        this.scheduler.allocate(app1.getApplicationAttemptId(), new ArrayList(), Arrays.asList(containerId), null, null, NULL_UPDATE_REQUESTS);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Collection liveContainers = app2.getLiveContainers();
        Assert.assertEquals((String)"Allocation post completion failed", (long)1L, (long)liveContainers.size());
        Assert.assertEquals((String)"High prio container allocated against low prio reservation", (long)2L, (long)((RMContainer)liveContainers.iterator().next()).getContainer().getPriority().getPriority());
    }

    @Test
    public void testAclSubmitApplication() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps> </aclAdministerApps>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <aclSubmitApps>norealuserhasthisname</aclSubmitApps>");
        out.println("    <aclAdministerApps>norealuserhasthisname</aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname2", 1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        Assert.assertNotNull((String)"The application was not allowed", (Object)app1);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        Assert.assertNull((String)"The application was allowed", (Object)app2);
    }

    @Test(timeout=5000L)
    public void testMultipleNodesSingleRackRequest() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        RMNode node3 = MockNodes.newNodeInfo(2, Resources.createResource((int)1024), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(attemptId);
        this.scheduler.addApplication(attemptId.getApplicationId(), "queue1", "user1", false);
        this.scheduler.addApplicationAttempt(attemptId, false, false);
        ArrayList<ResourceRequest> asks = new ArrayList<ResourceRequest>();
        asks.add(this.createResourceRequest(1024, node1.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node2.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node1.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, "*", 1, 2, true));
        this.scheduler.allocate(attemptId, asks, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent1);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attemptId).getLiveContainers().size());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attemptId).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testFifoWithinQueue() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        queue1.setPolicy((SchedulingPolicy)new FifoPolicy());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testFixedMaxAssign() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setBoolean("yarn.scheduler.fair.dynamic.max.assign", false);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "root.default", "user", 8);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)2L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = -1;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testDynamicMaxAssign() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 1, "root.default", "user", 12);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)5L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = 4;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)7L, (long)app.getLiveContainers().size());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testMaxAssignWithZeroMemoryContainers() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setBoolean("yarn.scheduler.fair.dynamic.max.assign", false);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(0, 1, "root.default", "user", 8);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)2L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = -1;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testAssignContainer() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        String user = "user1";
        String fifoQueue = "fifo";
        String fairParent = "fairParent";
        String fairChild1 = "fairParent.fairChild1";
        String fairChild2 = "fairParent.fairChild2";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "fairParent.fairChild1", "user1", 4);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "fairParent.fairChild2", "user1", 4);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.getQueueManager().getLeafQueue("fifo", true).setPolicy(SchedulingPolicy.parse((String)"fifo"));
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)updateEvent1);
            this.scheduler.handle((SchedulerEvent)updateEvent2);
            if ((i + 1) % 2 != 0) continue;
            String ERR = "Wrong number of assigned containers after " + (i + 1) + " updates";
            if (i < 4) {
                Assert.assertEquals((String)ERR, (long)(i + 1), (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)0L, (long)app4.getLiveContainers().size());
            } else {
                Assert.assertEquals((String)ERR, (long)4L, (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)(i - 3), (long)app4.getLiveContainers().size());
            }
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app2.getLiveContainers().size());
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app3.getLiveContainers().size());
        }
    }

    @Test
    public void testNotAllowSubmitApplication() throws Exception {
        int numTries;
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps> </aclAdministerApps>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <aclSubmitApps>userallow</aclSubmitApps>");
        out.println("    <aclAdministerApps>userallow</aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int appId = this.APP_ID++;
        String user = "usernotallow";
        String queue = "queue1";
        ApplicationId applicationId = MockApps.newAppID((int)appId);
        String name = MockApps.newAppName();
        ApplicationMasterService masterService = new ApplicationMasterService(this.resourceManager.getRMContext(), (YarnScheduler)this.scheduler);
        ApplicationSubmissionContextPBImpl submissionContext = new ApplicationSubmissionContextPBImpl();
        ContainerLaunchContext clc = BuilderUtils.newContainerLaunchContext(null, null, null, null, null, null);
        submissionContext.setApplicationId(applicationId);
        submissionContext.setAMContainerSpec(clc);
        RMAppImpl application = new RMAppImpl(applicationId, this.resourceManager.getRMContext(), this.conf, name, user, queue, (ApplicationSubmissionContext)submissionContext, (YarnScheduler)this.scheduler, masterService, System.currentTimeMillis(), "YARN", null, null);
        this.resourceManager.getRMContext().getRMApps().putIfAbsent(applicationId, application);
        application.handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
        int MAX_TRIES = 20;
        for (numTries = 0; !application.getState().equals((Object)RMAppState.SUBMITTED) && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((String)"The application doesn't reach SUBMITTED.", (Object)RMAppState.SUBMITTED, (Object)application.getState());
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)this.ATTEMPT_ID++);
        this.scheduler.addApplication(attId.getApplicationId(), queue, user, false);
        for (numTries = 0; application.getFinishTime() == 0L && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((Object)FinalApplicationStatus.FAILED, (Object)application.getFinalApplicationStatus());
    }

    @Test
    public void testRemoveNodeUpdatesRootQueueMetrics() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent addEvent = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)addEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        NodeRemovedSchedulerEvent removeEvent = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testStrictLocality() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testCancelStrictLocality() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
        }
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node1.getHostName(), 1, 0, true), this.createResourceRequest(1024, "rack1", 1, 0, true), this.createResourceRequest(1024, "*", 1, 1, true));
        this.scheduler.allocate(attId1, update, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testAMStrictLocalityRack() throws IOException {
        this.testAMStrictLocality(false, false);
    }

    @Test
    public void testAMStrictLocalityNode() throws IOException {
        this.testAMStrictLocality(true, false);
    }

    @Test
    public void testAMStrictLocalityRackInvalid() throws IOException {
        this.testAMStrictLocality(false, true);
    }

    @Test
    public void testAMStrictLocalityNodeInvalid() throws IOException {
        this.testAMStrictLocality(true, true);
    }

    private void testAMStrictLocality(boolean node, boolean invalid) throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(2, Resources.createResource((int)1024), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node2.getHostName(), 1, 1, true);
        if (node && invalid) {
            nodeRequest.setResourceName("invalid");
        }
        ResourceRequest rackRequest = this.createResourceRequest(1024, node2.getRackName(), 1, 1, !node);
        if (!node && invalid) {
            rackRequest.setResourceName("invalid");
        }
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        reqs.add(anyRequest);
        reqs.add(rackRequest);
        if (node) {
            reqs.add(nodeRequest);
        }
        ApplicationAttemptId attId1 = this.createSchedulingRequest("queue1", "user1", reqs);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
        if (invalid) {
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)this.scheduler.getNode(node2.getNodeID()).getNumContainers());
            Assert.assertEquals((long)0L, (long)this.scheduler.getNode(node1.getNodeID()).getNumContainers());
        } else {
            Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)1L, (long)this.scheduler.getNode(node2.getNodeID()).getNumContainers());
            Assert.assertEquals((long)0L, (long)this.scheduler.getNode(node1.getNodeID()).getNumContainers());
        }
    }

    @Test
    public void testReservationsStrictLocality() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)1));
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)1));
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node2.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId);
        this.createSchedulingRequestExistingApplication(rackRequest, attId);
        this.createSchedulingRequestExistingApplication(anyRequest, attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((String)"App assigned a container on the wrong node", (long)0L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((String)"App reserved a container on the wrong node", (long)0L, (long)app.getReservedContainers().size());
    }

    @Test
    public void testNoMoreCpuOnNode() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)1), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 1, "default", "user1", 2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFAssignment() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((long)8192L, (int)5));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(2048, 1, "queue1", "user1", 2);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 2, "queue1", "user1", 2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(appAttId2);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getContext());
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFWithQueues() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((long)8192L, (int)7), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3072, 1, "queue1", "user1", 2);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(2048, 2, "queue1", "user1", 2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(appAttId3);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getContext());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test
    public void testDRFHierarchicalQueues() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, BuilderUtils.newResource((long)12288L, (int)12), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3074, 1, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 3, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(2048, 2, "queue1.subqueue2", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(appAttId3);
        ApplicationAttemptId appAttId4 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        Thread.sleep(3L);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(appAttId4);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getContext());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1.subqueue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)app4.getLiveContainers().size());
    }

    @Test(timeout=30000L)
    public void testHostPortNodeName() throws Exception {
        this.conf.setBoolean("yarn.scheduler.include-port-in-node-name", true);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 1, "127.0.0.1", 1);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024), 2, "127.0.0.1", 2);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getNodeID().getHost() + ":" + node1.getNodeID().getPort(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    private void verifyAppRunnable(ApplicationAttemptId attId, boolean runnable) {
        FSAppAttempt app = this.scheduler.getSchedulerApp(attId);
        FSLeafQueue queue = app.getQueue();
        Assert.assertEquals((Object)runnable, (Object)queue.isRunnableApp(app));
        Assert.assertEquals((Object)(!runnable ? 1 : 0), (Object)queue.isNonRunnableApp(app));
    }

    private void verifyQueueNumRunnable(String queueName, int numRunnableInQueue, int numNonRunnableInQueue) {
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue(queueName, false);
        Assert.assertEquals((long)numRunnableInQueue, (long)queue.getNumRunnableApps());
        Assert.assertEquals((long)numNonRunnableInQueue, (long)queue.getNumNonRunnableApps());
    }

    @Test
    public void testUserAndQueueMaxRunningApps() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxRunningApps>2</maxRunningApps>");
        out.println("</queue>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1");
        this.verifyAppRunnable(attId1, true);
        this.verifyQueueNumRunnable("queue1", 1, 0);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue2", "user1");
        this.verifyAppRunnable(attId2, false);
        this.verifyQueueNumRunnable("queue2", 0, 1);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId3, true);
        this.verifyQueueNumRunnable("queue1", 2, 0);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId4, false);
        this.verifyQueueNumRunnable("queue1", 2, 1);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.verifyAppRunnable(attId2, true);
        this.verifyQueueNumRunnable("queue2", 1, 0);
        this.verifyAppRunnable(attId4, true);
        this.verifyQueueNumRunnable("queue1", 2, 0);
        ApplicationAttemptId attId5 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1", 2, 1);
    }

    @Test
    public void testMultipleCompletedEvent() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxAMShare>0.2</maxAMShare>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)20480, (int)20), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "user1", Resource.newInstance((int)1024, (int)1));
        this.createSchedulingRequestExistingApplication(1024, 1, RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority(), attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        RMContainer container = (RMContainer)app1.getLiveContainersMap().values().iterator().next();
        this.scheduler.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        this.scheduler.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container of a completed application"), RMContainerEventType.FINISHED);
        Assert.assertEquals((Object)Resources.none(), (Object)app1.getResourceUsage());
    }

    @Test
    public void testQueueMaxAMShare() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxAMShare>0.2</maxAMShare>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)20480, (int)20), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        Assert.assertEquals((String)"Queue queue1's fair share should be 0", (long)0L, (long)queue1.getFairShare().getMemorySize());
        this.createSchedulingRequest(1024, "root.default", "user1");
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Resource amResource1 = Resource.newInstance((int)1024, (int)1);
        Resource amResource2 = Resource.newInstance((int)2048, (int)2);
        Resource amResource3 = Resource.newInstance((int)1860, (int)2);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1's AM requests 1024 MB memory", (long)1024L, (long)app1.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application1's AM should be running", (long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application2's AM requests 1024 MB memory", (long)1024L, (long)app2.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application2's AM should be running", (long)1L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId3);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application3's AM resource shouldn't be updated", (long)0L, (long)app3.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application3's AM should not be running", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.createSchedulingRequestExistingApplication(1024, 1, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1 should have two running containers", (long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1's AM should be finished", (long)0L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app1.getResourceUsage());
        Assert.assertEquals((String)"Application3's AM should be running", (long)1L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Application3's AM requests 1024 MB memory", (long)1024L, (long)app3.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId4 = this.createAppAttemptId(4, 1);
        this.createApplicationWithAMResource(attId4, "queue1", "user1", amResource2);
        this.createSchedulingRequestExistingApplication(2048, 2, amPriority, attId4);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application4's AM resource shouldn't be updated", (long)0L, (long)app4.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application4's AM should not be running", (long)0L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app4.getResourceUsage());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId5 = this.createAppAttemptId(5, 1);
        this.createApplicationWithAMResource(attId5, "queue1", "user1", amResource2);
        this.createSchedulingRequestExistingApplication(2048, 2, amPriority, attId5);
        FSAppAttempt app5 = this.scheduler.getSchedulerApp(attId5);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application5's AM resource shouldn't be updated", (long)0L, (long)app5.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application5's AM should not be running", (long)0L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app5.getResourceUsage());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent4 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.KILLED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application5's AM should not be running", (long)0L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app5.getResourceUsage());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId3, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application2's AM should be finished", (long)0L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app2.getResourceUsage());
        Assert.assertEquals((String)"Application3's AM should be finished", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app3.getResourceUsage());
        Assert.assertEquals((String)"Application5's AM should be running", (long)1L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Application5's AM requests 2048 MB memory", (long)2048L, (long)app5.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.createSchedulingRequestExistingApplication(1024, 1, attId5);
        Assert.assertEquals((String)"Application5's AM should have 1 container", (long)1L, (long)app5.getLiveContainers().size());
        RMContainer amContainer5 = (RMContainer)app5.getLiveContainers().toArray()[0];
        ContainerExpiredSchedulerEvent containerExpired = new ContainerExpiredSchedulerEvent(amContainer5.getContainerId());
        this.scheduler.handle((SchedulerEvent)containerExpired);
        Assert.assertEquals((String)"Application5's AM should have 0 container", (long)0L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app5.getResourceUsage());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application5 should have 1 container", (long)1L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId6 = this.createAppAttemptId(6, 1);
        this.createApplicationWithAMResource(attId6, "queue1", "user1", amResource3);
        this.createSchedulingRequestExistingApplication(1860, 2, amPriority, attId6);
        FSAppAttempt app6 = this.scheduler.getSchedulerApp(attId6);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application6's AM should not be running", (long)0L, (long)app6.getLiveContainers().size());
        Assert.assertEquals((String)"Finished application usage should be none", (Object)Resources.none(), (Object)app6.getResourceUsage());
        Assert.assertEquals((String)"Application6's AM resource shouldn't be updated", (long)0L, (long)app6.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent5 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.FINISHED, false);
        AppAttemptRemovedSchedulerEvent appRemovedEvent6 = new AppAttemptRemovedSchedulerEvent(attId6, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent5);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent6);
        this.scheduler.update();
        Assert.assertEquals((String)"Queue1's AM resource usage should be 0", (long)0L, (long)queue1.getAmResourceUsage().getMemorySize());
    }

    @Test
    public void testQueueMaxAMShareDefault() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setInt("yarn.scheduler.maximum-allocation-vcores", 6);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("</queue>");
        out.println("<queue name=\"queue2\">");
        out.println("<maxAMShare>0.4</maxAMShare>");
        out.println("</queue>");
        out.println("<queue name=\"queue3\">");
        out.println("<maxResources>10240 mb 4 vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queue4\">");
        out.println("</queue>");
        out.println("<queue name=\"queue5\">");
        out.println("</queue>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)10), 0, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.update();
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        Assert.assertEquals((String)"Queue queue1's fair share should be 0", (long)0L, (long)queue1.getFairShare().getMemorySize());
        FSLeafQueue queue2 = this.scheduler.getQueueManager().getLeafQueue("queue2", true);
        Assert.assertEquals((String)"Queue queue2's fair share should be 0", (long)0L, (long)queue2.getFairShare().getMemorySize());
        FSLeafQueue queue3 = this.scheduler.getQueueManager().getLeafQueue("queue3", true);
        Assert.assertEquals((String)"Queue queue3's fair share should be 0", (long)0L, (long)queue3.getFairShare().getMemorySize());
        FSLeafQueue queue4 = this.scheduler.getQueueManager().getLeafQueue("queue4", true);
        Assert.assertEquals((String)"Queue queue4's fair share should be 0", (long)0L, (long)queue4.getFairShare().getMemorySize());
        FSLeafQueue queue5 = this.scheduler.getQueueManager().getLeafQueue("queue5", true);
        Assert.assertEquals((String)"Queue queue5's fair share should be 0", (long)0L, (long)queue5.getFairShare().getMemorySize());
        List<String> queues = Arrays.asList("root.queue3", "root.queue4", "root.queue5");
        for (String queue : queues) {
            this.createSchedulingRequest(1024, queue, "user1");
            this.scheduler.update();
            this.scheduler.handle((SchedulerEvent)updateEvent);
        }
        Resource amResource1 = Resource.newInstance((int)1024, (int)1);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "test1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application1's AM requests 1024 MB memory", (long)1024L, (long)app1.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application1's AM should be running", (long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queue2", "test1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application2's AM resource shouldn't be updated", (long)0L, (long)app2.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application2's AM should not be running", (long)0L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Queue2's AM resource usage should be 0 MB memory", (long)0L, (long)queue2.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        this.scheduler.update();
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "queue3", "test1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 6, amPriority, attId3);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application3's AM resource shouldn't be updated", (long)0L, (long)app3.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application3's AM should not be running", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Queue3's AM resource usage should be 0 MB memory", (long)0L, (long)queue3.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId4 = this.createAppAttemptId(4, 1);
        this.createApplicationWithAMResource(attId4, "queue3", "test1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 5, amPriority, attId4);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Application4's AM resource shouldn't be updated", (long)0L, (long)app4.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application4's AM should not be running", (long)0L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Queue3's AM resource usage should be 0 MB memory", (long)0L, (long)queue3.getAmResourceUsage().getMemorySize());
    }

    @Test
    public void testQueueMaxAMShareWithContainerReservation() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setFloat("yarn.scheduler.fair.reservable-nodes", 1.0f);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxAMShare>0.5</maxAMShare>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240, (int)10), 1, "127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)10240, (int)10), 2, "127.0.0.2");
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)5120, (int)5), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeE1 = new NodeAddedSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateE1 = new NodeUpdateSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeE2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateE2 = new NodeUpdateSchedulerEvent(node2);
        NodeAddedSchedulerEvent nodeE3 = new NodeAddedSchedulerEvent(node3);
        NodeUpdateSchedulerEvent updateE3 = new NodeUpdateSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeE1);
        this.scheduler.handle((SchedulerEvent)nodeE2);
        this.scheduler.handle((SchedulerEvent)nodeE3);
        this.scheduler.update();
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        Resource amResource1 = Resource.newInstance((int)1024, (int)1);
        Resource amResource2 = Resource.newInstance((int)1024, (int)1);
        Resource amResource3 = Resource.newInstance((int)10240, (int)1);
        Resource amResource4 = Resource.newInstance((int)5120, (int)1);
        Resource amResource5 = Resource.newInstance((int)1024, (int)1);
        Resource amResource6 = Resource.newInstance((int)10240, (int)1);
        Resource amResource7 = Resource.newInstance((int)1024, (int)1);
        Resource amResource8 = Resource.newInstance((int)1024, (int)1);
        int amPriority = RMAppAttemptImpl.AM_CONTAINER_PRIORITY.getPriority();
        ApplicationAttemptId attId1 = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(attId1, "queue1", "user1", amResource1);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId1);
        FSAppAttempt app1 = this.scheduler.getSchedulerApp(attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application1's AM requests 1024 MB memory", (long)1024L, (long)app1.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application1's AM should be running", (long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "queue1", "user1", amResource2);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId2);
        FSAppAttempt app2 = this.scheduler.getSchedulerApp(attId2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application2's AM requests 1024 MB memory", (long)1024L, (long)app2.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application2's AM should be running", (long)1L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "queue1", "user1", amResource3);
        this.createSchedulingRequestExistingApplication(10240, 1, amPriority, attId3);
        FSAppAttempt app3 = this.scheduler.getSchedulerApp(attId3);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application3's AM resource shouldn't be updated", (long)0L, (long)app3.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application3's AM should not be running", (long)0L, (long)app3.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId4 = this.createAppAttemptId(4, 1);
        this.createApplicationWithAMResource(attId4, "queue1", "user1", amResource4);
        this.createSchedulingRequestExistingApplication(5120, 1, amPriority, attId4);
        FSAppAttempt app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application4's AM resource shouldn't be updated", (long)0L, (long)app4.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application4's AM should not be running", (long)0L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE3);
        Assert.assertEquals((String)"Application4's AM requests 5120 MB memory", (long)5120L, (long)app4.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application4's AM should be running", (long)1L, (long)app4.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 6144 MB memory", (long)6144L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId5 = this.createAppAttemptId(5, 1);
        this.createApplicationWithAMResource(attId5, "queue1", "user1", amResource5);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId5);
        FSAppAttempt app5 = this.scheduler.getSchedulerApp(attId5);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application5's AM requests 1024 MB memory", (long)1024L, (long)app5.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application5's AM should be running", (long)1L, (long)app5.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId3, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId6 = this.createAppAttemptId(6, 1);
        this.createApplicationWithAMResource(attId6, "queue1", "user1", amResource6);
        this.createSchedulingRequestExistingApplication(10240, 1, amPriority, attId6);
        FSAppAttempt app6 = this.scheduler.getSchedulerApp(attId6);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application6's AM resource shouldn't be updated", (long)0L, (long)app6.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application6's AM should not be running", (long)0L, (long)app6.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 7168 MB memory", (long)7168L, (long)queue1.getAmResourceUsage().getMemorySize());
        ApplicationAttemptId attId7 = this.createAppAttemptId(7, 1);
        this.createApplicationWithAMResource(attId7, "queue1", "user1", amResource7);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId7);
        FSAppAttempt app7 = this.scheduler.getSchedulerApp(attId7);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application7's AM requests 1024 MB memory", (long)1024L, (long)app7.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application7's AM should be running", (long)1L, (long)app7.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 8192 MB memory", (long)8192L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent4 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent4);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 3072 MB memory", (long)3072L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent5 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent5);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        this.scheduler.handle((SchedulerEvent)updateE2);
        ApplicationAttemptId attId8 = this.createAppAttemptId(8, 1);
        this.createApplicationWithAMResource(attId8, "queue1", "user1", amResource8);
        this.createSchedulingRequestExistingApplication(1024, 1, amPriority, attId8);
        FSAppAttempt app8 = this.scheduler.getSchedulerApp(attId8);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application8's AM resource shouldn't be updated", (long)0L, (long)app8.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application8's AM should not be running", (long)0L, (long)app8.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application8's AM resource shouldn't be updated", (long)0L, (long)app8.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application8's AM should not be running", (long)0L, (long)app8.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 2048 MB memory", (long)2048L, (long)queue1.getAmResourceUsage().getMemorySize());
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        Assert.assertEquals((String)"Queue1's AM resource usage should be 1024 MB memory", (long)1024L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE2);
        Assert.assertEquals((String)"Application6's AM requests 10240 MB memory", (long)10240L, (long)app6.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application6's AM should be running", (long)1L, (long)app6.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 11264 MB memory", (long)11264L, (long)queue1.getAmResourceUsage().getMemorySize());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateE1);
        Assert.assertEquals((String)"Application8's AM requests 1024 MB memory", (long)1024L, (long)app8.getAMResource().getMemorySize());
        Assert.assertEquals((String)"Application8's AM should be running", (long)1L, (long)app8.getLiveContainers().size());
        Assert.assertEquals((String)"Queue1's AM resource usage should be 12288 MB memory", (long)12288L, (long)queue1.getAmResourceUsage().getMemorySize());
    }

    @Test
    public void testMaxRunningAppsHierarchicalQueues() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("  <maxRunningApps>3</maxRunningApps>");
        out.println("  <queue name=\"sub1\"></queue>");
        out.println("  <queue name=\"sub2\"></queue>");
        out.println("  <queue name=\"sub3\">");
        out.println("    <maxRunningApps>1</maxRunningApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1.sub1", "user1");
        this.verifyAppRunnable(attId1, true);
        this.verifyQueueNumRunnable("queue1.sub1", 1, 0);
        clock.tickSec(10);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1.sub3", "user1");
        this.verifyAppRunnable(attId2, true);
        this.verifyQueueNumRunnable("queue1.sub3", 1, 0);
        clock.tickSec(10);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1.sub2", "user1");
        this.verifyAppRunnable(attId3, true);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 0);
        clock.tickSec(10);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1.sub2", "user1");
        this.verifyAppRunnable(attId4, false);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 1);
        clock.tickSec(10);
        ApplicationAttemptId attId5 = this.createSchedulingRequest(1024, "queue1.sub3", "user1");
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1.sub3", 1, 1);
        clock.tickSec(10);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.verifyAppRunnable(attId4, true);
        this.verifyQueueNumRunnable("queue1.sub2", 2, 0);
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1.sub3", 0, 1);
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.KILLED, true);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        Assert.assertEquals((long)0L, (long)this.scheduler.maxRunningEnforcer.usersNonRunnableApps.get((Object)"user1").size());
        this.verifyQueueNumRunnable("queue1.sub3", 0, 0);
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.FINISHED, true);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 0);
        this.verifyQueueNumRunnable("queue1.sub3", 0, 0);
    }

    @Test
    public void testSchedulingOnRemovedNode() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        Assert.assertTrue((String)"Continuous scheduling should be disabled.", (!this.scheduler.isContinuousSchedulingEnabled() ? 1 : 0) != 0);
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.createMockRMApp(id11);
        this.scheduler.addApplication(id11.getApplicationId(), "root.queue1", "user1", false);
        this.scheduler.addApplicationAttempt(id11, false, false);
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(1024, 8, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null, NULL_UPDATE_REQUESTS);
        String hostName = "127.0.0.1";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, hostName);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        FSSchedulerNode node = (FSSchedulerNode)this.scheduler.getSchedulerNode(node1.getNodeID());
        NodeRemovedSchedulerEvent removeNode1 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeNode1);
        this.scheduler.attemptScheduling(node);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(id11, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
    }

    @Test
    public void testDefaultRuleInitializesProperlyWhenPolicyNotConfigured() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        List rules = this.scheduler.allocConf.placementPolicy.getRules();
        for (QueuePlacementRule rule : rules) {
            if (!(rule instanceof QueuePlacementRule.Default)) continue;
            QueuePlacementRule.Default defaultRule = (QueuePlacementRule.Default)rule;
            Assert.assertNotNull((Object)defaultRule.defaultQueueName);
        }
    }

    @Test
    public void testBlacklistNodes() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int GB = 1024;
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)16), 0, host);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttemptId = this.createSchedulingRequest(1024, "root.default", "user", 1);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null, NULL_UPDATE_REQUESTS);
        Assert.assertTrue((boolean)app.isPlaceBlacklisted(host));
        this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host), NULL_UPDATE_REQUESTS);
        Assert.assertFalse((boolean)this.scheduler.getSchedulerApp(appAttemptId).isPlaceBlacklisted(host));
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node.getHostName(), 1, 0, true));
        this.scheduler.allocate(appAttemptId, update, Collections.emptyList(), Collections.singletonList(host), null, NULL_UPDATE_REQUESTS);
        Assert.assertTrue((boolean)app.isPlaceBlacklisted(host));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)0L, (long)app.getLiveContainers().size());
        this.scheduler.allocate(appAttemptId, update, Collections.emptyList(), null, Collections.singletonList(host), NULL_UPDATE_REQUESTS);
        Assert.assertFalse((boolean)app.isPlaceBlacklisted(host));
        this.createSchedulingRequest(1024, "root.default", "user", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(1024, 1, "queue1.subqueue1", "user1");
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 1, "queue1.subqueue2", "user1");
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 1, "default", "user1");
        List apps = this.scheduler.getAppsInQueue("queue1.subqueue1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId1, apps.get(0));
        apps = this.scheduler.getAppsInQueue("root.queue1.subqueue1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId1, apps.get(0));
        apps = this.scheduler.getAppsInQueue("user1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId3, apps.get(0));
        apps = this.scheduler.getAppsInQueue("root.user1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId3, apps.get(0));
        apps = this.scheduler.getAppsInQueue("queue1");
        Assert.assertEquals((long)2L, (long)apps.size());
        HashSet appAttIds = Sets.newHashSet((Object[])new ApplicationAttemptId[]{(ApplicationAttemptId)apps.get(0), (ApplicationAttemptId)apps.get(1)});
        Assert.assertTrue((boolean)appAttIds.contains(appAttId1));
        Assert.assertTrue((boolean)appAttIds.contains(appAttId2));
    }

    @Test
    public void testAddAndRemoveAppFromFairScheduler() throws Exception {
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.resourceManager.getResourceScheduler();
        TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(scheduler.getSchedulerApplications(), (EventHandler<SchedulerEvent>)scheduler, "default");
    }

    @Test
    public void testResourceUsageByMoveApp() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 2, "parent1.queue1", "user1", 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSParentQueue parent1 = queueMgr.getParentQueue("parent1", true);
        FSParentQueue parent2 = queueMgr.getParentQueue("parent2", true);
        FSLeafQueue queue2 = queueMgr.getLeafQueue("parent2.queue2", true);
        FSLeafQueue queue1 = queueMgr.getLeafQueue("parent1.queue1", true);
        Assert.assertEquals((long)parent2.getResourceUsage().getMemorySize(), (long)0L);
        Assert.assertEquals((long)queue2.getResourceUsage().getMemorySize(), (long)0L);
        Assert.assertEquals((long)parent1.getResourceUsage().getMemorySize(), (long)1024L);
        Assert.assertEquals((long)queue1.getResourceUsage().getMemorySize(), (long)1024L);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "parent2.queue2");
        Assert.assertEquals((long)parent2.getResourceUsage().getMemorySize(), (long)1024L);
        Assert.assertEquals((long)queue2.getResourceUsage().getMemorySize(), (long)1024L);
        Assert.assertEquals((long)parent1.getResourceUsage().getMemorySize(), (long)0L);
        Assert.assertEquals((long)queue1.getResourceUsage().getMemorySize(), (long)0L);
    }

    @Test(expected=YarnException.class)
    public void testMoveWouldViolateMaxAppsConstraints() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue queue2 = queueMgr.getLeafQueue("queue2", true);
        queue2.setMaxRunningApps(0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test(expected=YarnException.class)
    public void testMoveWouldViolateMaxResourcesConstraints() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue queue2 = queueMgr.getLeafQueue("queue2", true);
        queue2.setMaxShare(new ConfigurableResource(Resource.newInstance((int)1024, (int)1)));
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)2), (Object)oldQueue.getResourceUsage());
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test(expected=YarnException.class)
    public void testMoveToNonexistentQueue() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test
    public void testLowestCommonAncestorForNonRootParent() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSLeafQueue aQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        FSLeafQueue bQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Mockito.when((Object)aQueue.getName()).thenReturn((Object)"root.queue1.a");
        Mockito.when((Object)bQueue.getName()).thenReturn((Object)"root.queue1.b");
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", true);
        queue1.addChildQueue((FSQueue)aQueue);
        queue1.addChildQueue((FSQueue)bQueue);
        FSQueue ancestorQueue = this.scheduler.findLowestCommonAncestorQueue((FSQueue)aQueue, (FSQueue)bQueue);
        Assert.assertEquals((Object)ancestorQueue, (Object)queue1);
    }

    @Test
    public void testLowestCommonAncestorRootParent() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSLeafQueue aQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        FSLeafQueue bQueue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        Mockito.when((Object)aQueue.getName()).thenReturn((Object)"root.a");
        Mockito.when((Object)bQueue.getName()).thenReturn((Object)"root.b");
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("root", false);
        queue1.addChildQueue((FSQueue)aQueue);
        queue1.addChildQueue((FSQueue)bQueue);
        FSQueue ancestorQueue = this.scheduler.findLowestCommonAncestorQueue((FSQueue)aQueue, (FSQueue)bQueue);
        Assert.assertEquals((Object)ancestorQueue, (Object)queue1);
    }

    @Test
    public void testLowestCommonAncestorDeeperHierarchy() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSQueue aQueue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        FSQueue bQueue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        FSQueue a1Queue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        FSQueue b1Queue = (FSQueue)Mockito.mock(FSLeafQueue.class);
        Mockito.when((Object)a1Queue.getName()).thenReturn((Object)"root.queue1.a.a1");
        Mockito.when((Object)b1Queue.getName()).thenReturn((Object)"root.queue1.b.b1");
        Mockito.when((Object)aQueue.getChildQueues()).thenReturn(Arrays.asList(a1Queue));
        Mockito.when((Object)bQueue.getChildQueues()).thenReturn(Arrays.asList(b1Queue));
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", true);
        queue1.addChildQueue(aQueue);
        queue1.addChildQueue(bQueue);
        FSQueue ancestorQueue = this.scheduler.findLowestCommonAncestorQueue(a1Queue, b1Queue);
        Assert.assertEquals((Object)ancestorQueue, (Object)queue1);
    }

    @Test
    public void testDoubleRemoval() throws Exception {
        String testUser = "user1";
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), testUser, testUser);
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        FSAppAttempt attempt = this.scheduler.getSchedulerApp(attemptId);
        AppAttemptRemovedSchedulerEvent attemptRemovedEvent = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        List attemptList = this.scheduler.getAppsInQueue(testUser);
        Assert.assertNotNull((String)"Queue missing", (Object)attemptList);
        Assert.assertTrue((String)"Attempt should be in the queue", (boolean)attemptList.contains(attemptId));
        Assert.assertFalse((String)"Attempt is stopped", (boolean)attempt.isStopped());
        this.scheduler.handle((SchedulerEvent)attemptRemovedEvent);
        attemptList = this.scheduler.getAppsInQueue(testUser);
        Assert.assertFalse((String)"Attempt should not be in the queue", (boolean)attemptList.contains(attemptId));
        Assert.assertTrue((String)"Attempt should have been stopped", (boolean)attempt.isStopped());
        this.scheduler.handle((SchedulerEvent)attemptRemovedEvent);
        Assert.assertTrue((String)"Attempt queue has changed", (boolean)attempt.getQueue().getName().endsWith(testUser));
    }

    @Test(expected=YarnException.class)
    public void testMoveAfterRemoval() throws Exception {
        String testUser = "user1";
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), testUser, testUser);
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        FSAppAttempt attempt = this.scheduler.getSchedulerApp(attemptId);
        AppAttemptRemovedSchedulerEvent attemptRemovedEvent = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)attemptRemovedEvent);
        List attemptList = this.scheduler.getAppsInQueue(testUser);
        Assert.assertNotNull((String)"Queue missing", (Object)attemptList);
        Assert.assertFalse((String)"Attempt should not be in the queue", (boolean)attemptList.contains(attemptId));
        Assert.assertTrue((String)"Attempt should have been stopped", (boolean)attempt.isStopped());
        Assert.assertTrue((String)"Attempt queue has changed", (boolean)attempt.getQueue().getName().endsWith(testUser));
        this.scheduler.moveApplication(attemptId.getApplicationId(), "default");
    }

    @Test
    public void testPerfMetricsInited() {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        this.scheduler.fsOpDurations.getMetrics((MetricsCollector)collector, true);
        Assert.assertEquals((String)"Incorrect number of perf metrics", (long)1L, (long)collector.getRecords().size());
    }

    @Test
    public void testQueueNameWithTrailingSpace() throws Exception {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId1 = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent1 = new AppAddedSchedulerEvent(appAttemptId1.getApplicationId(), "A", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent1);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNotNull(this.scheduler.getSchedulerApplications().get(appAttemptId1.getApplicationId()));
        AppAttemptAddedSchedulerEvent attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("A", true).getNumRunnableApps());
        Assert.assertNotNull((Object)this.scheduler.getSchedulerApp(appAttemptId1));
        ApplicationAttemptId appAttemptId2 = this.createAppAttemptId(2, 1);
        AppAddedSchedulerEvent appAddedEvent2 = new AppAddedSchedulerEvent(appAttemptId2.getApplicationId(), "A ", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull(this.scheduler.getSchedulerApplications().get(appAttemptId2.getApplicationId()));
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId2));
        ApplicationAttemptId appAttemptId3 = this.createAppAttemptId(3, 1);
        AppAddedSchedulerEvent appAddedEvent3 = new AppAddedSchedulerEvent(appAttemptId3.getApplicationId(), "B.C", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent3);
        Assert.assertEquals((long)3L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNotNull(this.scheduler.getSchedulerApplications().get(appAttemptId3.getApplicationId()));
        attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId3, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("B.C", true).getNumRunnableApps());
        Assert.assertNotNull((Object)this.scheduler.getSchedulerApp(appAttemptId3));
        ApplicationAttemptId appAttemptId4 = this.createAppAttemptId(4, 1);
        AppAddedSchedulerEvent appAddedEvent4 = new AppAddedSchedulerEvent(appAttemptId4.getApplicationId(), "A\u00a0", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent4);
        Assert.assertEquals((long)3L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull(this.scheduler.getSchedulerApplications().get(appAttemptId4.getApplicationId()));
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId4));
    }

    @Test
    public void testEmptyQueueNameInConfigFile() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        try {
            this.scheduler.init(this.conf);
            Assert.fail((String)"scheduler init should fail because empty queue name.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to initialize FairScheduler"));
        }
    }

    @Test
    public void testUserAsDefaultQueueWithLeadingTrailingSpaceUserName() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "  user1", null);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((Object)"root.user1", (Object)((RMApp)this.resourceManager.getRMContext().getRMApps().get(appAttemptId.getApplicationId())).getQueue());
        ApplicationAttemptId attId2 = this.createAppAttemptId(2, 1);
        this.createApplicationWithAMResource(attId2, "default", "user1  ", null);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((Object)"root.user1", (Object)((RMApp)this.resourceManager.getRMContext().getRMApps().get(attId2.getApplicationId())).getQueue());
        ApplicationAttemptId attId3 = this.createAppAttemptId(3, 1);
        this.createApplicationWithAMResource(attId3, "default", "user1", null);
        Assert.assertEquals((long)3L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((Object)"root.user1", (Object)((RMApp)this.resourceManager.getRMContext().getRMApps().get(attId3.getApplicationId())).getQueue());
    }

    @Test
    public void testResourceUpdateDecommissioningNode() throws Exception {
        RMContext spyContext = (RMContext)Mockito.spy((Object)this.resourceManager.getRMContext());
        Dispatcher mockDispatcher = (Dispatcher)Mockito.mock(AsyncDispatcher.class);
        Mockito.when((Object)mockDispatcher.getEventHandler()).thenReturn((Object)new EventHandler(){

            public void handle(Event event) {
                if (event instanceof RMNodeResourceUpdateEvent) {
                    RMNodeResourceUpdateEvent resourceEvent = (RMNodeResourceUpdateEvent)event;
                    TestFairScheduler.this.resourceManager.getResourceScheduler().getSchedulerNode(resourceEvent.getNodeId()).updateTotalResource(resourceEvent.getResourceOption().getResource());
                }
            }
        });
        ((RMContext)Mockito.doReturn((Object)mockDispatcher).when((Object)spyContext)).getDispatcher();
        ((FairScheduler)this.resourceManager.getResourceScheduler()).setRMContext(spyContext);
        ((AsyncDispatcher)mockDispatcher).start();
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)8192, (int)4));
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm_0.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
        RMNode spyNode = (RMNode)Mockito.spy(this.resourceManager.getRMContext().getRMNodes().get(nm_0.getNodeId()));
        Mockito.when((Object)spyNode.getState()).thenReturn((Object)NodeState.DECOMMISSIONING);
        this.resourceManager.getResourceScheduler().handle((Event)new NodeUpdateSchedulerEvent(spyNode));
        Resource usedResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm_0.getNodeId()).getAllocatedResource();
        Assert.assertEquals((long)usedResource.getMemorySize(), (long)0L);
        Assert.assertEquals((long)usedResource.getVirtualCores(), (long)0L);
        Resource totalResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm_0.getNodeId()).getTotalResource();
        Assert.assertEquals((long)totalResource.getMemorySize(), (long)0L);
        Assert.assertEquals((long)totalResource.getVirtualCores(), (long)0L);
        Resource availableResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm_0.getNodeId()).getUnallocatedResource();
        Assert.assertEquals((long)availableResource.getMemorySize(), (long)0L);
        Assert.assertEquals((long)availableResource.getVirtualCores(), (long)0L);
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, this.resourceManager);
        if (this.resourceManager instanceof MockRM) {
            ((MockRM)this.resourceManager).drainEvents();
        }
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    @Test(timeout=120000L)
    public void testContainerAllocationWithContainerIdLeap() throws Exception {
        this.conf.setFloat("yarn.scheduler.fair.reservable-nodes", 0.5f);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)10), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)10), 1, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId app1 = this.createSchedulingRequest(2048, "queue1", "user1", 2);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        ApplicationAttemptId app2 = this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)4096L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        RMContainer reservedContainer1 = ((FSSchedulerNode)this.scheduler.getSchedulerNode(node1.getNodeID())).getReservedContainer();
        Assert.assertNotEquals((Object)reservedContainer1, null);
        RMContainer reservedContainer2 = ((FSSchedulerNode)this.scheduler.getSchedulerNode(node2.getNodeID())).getReservedContainer();
        Assert.assertEquals((Object)reservedContainer2, null);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node1));
            this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        }
        this.scheduler.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent(app1, RMAppAttemptState.KILLED, false));
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemorySize());
        this.scheduler.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        Assert.assertEquals((long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size(), (long)1L);
        long maxId = 0L;
        for (RMContainer container : this.scheduler.getSchedulerApp(app2).getLiveContainers()) {
            Assert.assertTrue((boolean)container.getContainer().getNodeId().equals((Object)node2.getNodeID()));
            if (container.getContainerId().getContainerId() <= maxId) continue;
            maxId = container.getContainerId().getContainerId();
        }
        long reservedId = reservedContainer1.getContainerId().getContainerId();
        Assert.assertEquals((long)(reservedId + 1L), (long)maxId);
    }

    @Test(timeout=120000L)
    public void testRefreshQueuesWhenRMHA() throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        this.conf.setBoolean("yarn.scheduler.fair.user-as-default-queue", false);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        MockRM rm1 = new MockRM(this.conf, null);
        rm1.init(this.conf);
        rm1.start();
        rm1.getAdminService().transitionToStandby(requestInfo);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"test_queue\">");
        out.println("  <maxRunningApps>3</maxRunningApps>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm2 = new MockRM(this.conf);
        MemoryRMStateStore memStore = (MemoryRMStateStore)rm2.getRMStateStore();
        rm2.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 15120, rm2.getResourceTrackerService());
        nm.registerNode();
        rm2.getAdminService().transitionToActive(requestInfo);
        RMApp app = rm2.submitApp(200, "test_app", "user", null, "test_queue");
        RMAppAttempt attempt0 = app.getCurrentAppAttempt();
        nm.nodeHeartbeat(true);
        MockAM am0 = rm2.sendAMLaunched(attempt0.getAppAttemptId());
        am0.registerAppAttempt();
        Assert.assertEquals((Object)"root.test_queue", (Object)app.getQueue());
        ((RMContextImpl)rm1.getRMContext()).setStateStore((RMStateStore)memStore);
        rm1.getAdminService().transitionToActive(requestInfo);
        rm1.drainEvents();
        Assert.assertEquals((long)1L, (long)rm1.getRMContext().getRMApps().size());
        RMApp recoveredApp = (RMApp)rm1.getRMContext().getRMApps().values().iterator().next();
        Assert.assertEquals((Object)"root.test_queue", (Object)recoveredApp.getQueue());
        rm1.stop();
        rm2.stop();
    }

    @Test
    public void testReservationMetrics() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueMetrics metrics = this.scheduler.getRootQueueMetrics();
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user1", null);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.createSchedulingRequestExistingApplication(1024, 1, 1, appAttemptId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)metrics.getReservedContainers());
        Assert.assertEquals((long)0L, (long)metrics.getReservedMB());
        Assert.assertEquals((long)0L, (long)metrics.getReservedVirtualCores());
        this.createSchedulingRequestExistingApplication(4096, 4, 1, appAttemptId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)metrics.getReservedContainers());
        Assert.assertEquals((long)4096L, (long)metrics.getReservedMB());
        Assert.assertEquals((long)4L, (long)metrics.getReservedVirtualCores());
        AppAttemptRemovedSchedulerEvent attRemoveEvent = new AppAttemptRemovedSchedulerEvent(appAttemptId, RMAppAttemptState.KILLED, false);
        this.scheduler.handle((SchedulerEvent)attRemoveEvent);
        Assert.assertEquals((long)0L, (long)metrics.getReservedContainers());
        Assert.assertEquals((long)0L, (long)metrics.getReservedMB());
        Assert.assertEquals((long)0L, (long)metrics.getReservedVirtualCores());
    }

    @Test
    public void testUpdateDemand() throws IOException {
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Resource maxResource = Resources.createResource((int)8192);
        ConfigurableResource maxResourceConf = new ConfigurableResource(maxResource);
        FSAppAttempt app1 = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        Mockito.when((Object)app1.getDemand()).thenReturn((Object)maxResource);
        Mockito.when((Object)app1.getResourceUsage()).thenReturn((Object)Resources.none());
        FSAppAttempt app2 = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        Mockito.when((Object)app2.getDemand()).thenReturn((Object)maxResource);
        Mockito.when((Object)app2.getResourceUsage()).thenReturn((Object)Resources.none());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue queue1 = queueManager.getParentQueue("queue1", true);
        FSLeafQueue aQueue = new FSLeafQueue("root.queue1.a", this.scheduler, queue1);
        aQueue.setMaxShare(maxResourceConf);
        aQueue.addApp(app1, true);
        FSLeafQueue bQueue = new FSLeafQueue("root.queue1.b", this.scheduler, queue1);
        bQueue.setMaxShare(maxResourceConf);
        bQueue.addApp(app2, true);
        queue1.setMaxShare(maxResourceConf);
        queue1.addChildQueue((FSQueue)aQueue);
        queue1.addChildQueue((FSQueue)bQueue);
        queue1.updateDemand();
        Assert.assertTrue((String)"Demand is greater than max allowed ", (boolean)Resources.equals((Resource)queue1.getDemand(), (Resource)maxResource));
        Assert.assertTrue((String)"Demand of child queue not updated ", (Resources.equals((Resource)aQueue.getDemand(), (Resource)maxResource) && Resources.equals((Resource)bQueue.getDemand(), (Resource)maxResource) ? 1 : 0) != 0);
    }

    @Test
    public void testDumpState() throws IOException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"parent\">");
        out.println("  <queue name=\"child1\">");
        out.println("    <weight>1</weight>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        FSLeafQueue child1 = this.scheduler.getQueueManager().getLeafQueue("parent.child1", false);
        Resource resource = Resource.newInstance((int)4096, (int)4);
        child1.setMaxShare(new ConfigurableResource(resource));
        FSAppAttempt app = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        Mockito.when((Object)app.getDemand()).thenReturn((Object)resource);
        Mockito.when((Object)app.getResourceUsage()).thenReturn((Object)resource);
        child1.addApp(app, true);
        child1.updateDemand();
        String childQueueString = "{Name: root.parent.child1, Weight: 1.0, Policy: fair, FairShare: <memory:0, vCores:0>, SteadyFairShare: <memory:0, vCores:0>, MaxShare: <memory:4096, vCores:4>, MinShare: <memory:0, vCores:0>, ResourceUsage: <memory:4096, vCores:4>, Demand: <memory:4096, vCores:4>, Runnable: 1, NumPendingApps: 0, NonRunnable: 0, MaxAMShare: 0.5, MaxAMResource: <memory:0, vCores:0>, AMResourceUsage: <memory:0, vCores:0>, LastTimeAtMinShare: " + clock.getTime() + "}";
        Assert.assertEquals((String)"Unexpected state dump string", (Object)childQueueString, (Object)child1.dumpState());
        FSParentQueue parent = this.scheduler.getQueueManager().getParentQueue("parent", false);
        parent.setMaxShare(new ConfigurableResource(resource));
        parent.updateDemand();
        String parentQueueString = "{Name: root.parent, Weight: 1.0, Policy: fair, FairShare: <memory:0, vCores:0>, SteadyFairShare: <memory:0, vCores:0>, MaxShare: <memory:4096, vCores:4>, MinShare: <memory:0, vCores:0>, ResourceUsage: <memory:4096, vCores:4>, Demand: <memory:4096, vCores:4>, MaxAMShare: 0.5, Runnable: 0}";
        Assert.assertEquals((String)"Unexpected state dump string", (Object)(parentQueueString + ", " + childQueueString), (Object)parent.dumpState());
    }
}

