/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSchedulerApplicationAttempt {
    private static final NodeId nodeId = NodeId.newInstance((String)"somehost", (int)5);
    private Configuration conf = new Configuration();

    @After
    public void tearDown() {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    @Test
    public void testMove() {
        String user = "user1";
        Queue parentQueue = this.createQueue("parent", null);
        Queue oldQueue = this.createQueue("old", parentQueue);
        Queue newQueue = this.createQueue("new", parentQueue);
        QueueMetrics parentMetrics = parentQueue.getMetrics();
        QueueMetrics oldMetrics = oldQueue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        ApplicationAttemptId appAttId = this.createAppAttemptId(0, 0);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)3L);
        SchedulerApplicationAttempt app = new SchedulerApplicationAttempt(appAttId, "user1", oldQueue, oldQueue.getAbstractUsersManager(), rmContext);
        oldMetrics.submitApp("user1");
        Assert.assertEquals((long)0x30000000001L, (long)app.getNewContainerId());
        Resource requestedResource = Resource.newInstance((int)1536, (int)2);
        Priority requestedPriority = Priority.newInstance((int)2);
        ResourceRequest request = ResourceRequest.newInstance((Priority)requestedPriority, (String)"*", (Resource)requestedResource, (int)3);
        app.updateResourceRequests(Arrays.asList(request));
        RMContainer container1 = this.createRMContainer(appAttId, 1, requestedResource);
        app.liveContainers.put(container1.getContainerId(), container1);
        SchedulerNode node = this.createNode();
        app.appSchedulingInfo.allocate(NodeType.OFF_SWITCH, node, TestUtils.toSchedulerKey(requestedPriority), container1.getContainer());
        Priority prio1 = Priority.newInstance((int)1);
        Resource reservedResource = Resource.newInstance((int)2048, (int)3);
        RMContainer container2 = this.createReservedRMContainer(appAttId, 1, reservedResource, node.getNodeID(), prio1);
        HashMap<NodeId, RMContainer> reservations = new HashMap<NodeId, RMContainer>();
        reservations.put(node.getNodeID(), container2);
        app.reservedContainers.put(TestUtils.toSchedulerKey(prio1), reservations);
        oldMetrics.reserveResource(container2.getNodeLabelExpression(), "user1", reservedResource);
        this.checkQueueMetrics(oldMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
        this.checkQueueMetrics(newMetrics, 0, 0, 0, 0, 0, 0, 0, 0);
        this.checkQueueMetrics(parentMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
        app.move(newQueue);
        this.checkQueueMetrics(oldMetrics, 0, 0, 0, 0, 0, 0, 0, 0);
        this.checkQueueMetrics(newMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
        this.checkQueueMetrics(parentMetrics, 1, 1, 1536, 2, 2048, 3, 3072, 4);
    }

    private void checkQueueMetrics(QueueMetrics metrics, int activeApps, int runningApps, int allocMb, int allocVcores, int reservedMb, int reservedVcores, int pendingMb, int pendingVcores) {
        Assert.assertEquals((long)activeApps, (long)metrics.getActiveApps());
        Assert.assertEquals((long)runningApps, (long)metrics.getAppsRunning());
        Assert.assertEquals((long)allocMb, (long)metrics.getAllocatedMB());
        Assert.assertEquals((long)allocVcores, (long)metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)reservedMb, (long)metrics.getReservedMB());
        Assert.assertEquals((long)reservedVcores, (long)metrics.getReservedVirtualCores());
        Assert.assertEquals((long)pendingMb, (long)metrics.getPendingMB());
        Assert.assertEquals((long)pendingVcores, (long)metrics.getPendingVirtualCores());
    }

    private SchedulerNode createNode() {
        SchedulerNode node = (SchedulerNode)Mockito.mock(SchedulerNode.class);
        Mockito.when((Object)node.getNodeName()).thenReturn((Object)"somehost");
        Mockito.when((Object)node.getRackName()).thenReturn((Object)"somerack");
        Mockito.when((Object)node.getNodeID()).thenReturn((Object)nodeId);
        return node;
    }

    private RMContainer createReservedRMContainer(ApplicationAttemptId appAttId, int id, Resource resource, NodeId nodeId, Priority reservedPriority) {
        RMContainer container = this.createRMContainer(appAttId, id, resource);
        Mockito.when((Object)container.getReservedResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getReservedSchedulerKey()).thenReturn((Object)TestUtils.toSchedulerKey(reservedPriority));
        Mockito.when((Object)container.getReservedNode()).thenReturn((Object)nodeId);
        return container;
    }

    private RMContainer createRMContainer(ApplicationAttemptId appAttId, int id, Resource resource) {
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttId, (long)id);
        RMContainer rmContainer = (RMContainer)Mockito.mock(RMContainerImpl.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        Mockito.when((Object)rmContainer.getContainer()).thenReturn((Object)container);
        Mockito.when((Object)rmContainer.getContainerId()).thenReturn((Object)containerId);
        return rmContainer;
    }

    private Queue createQueue(String name, Queue parent) {
        return this.createQueue(name, parent, 1.0f);
    }

    private Queue createQueue(String name, Queue parent, float capacity) {
        QueueMetrics metrics = QueueMetrics.forQueue((String)name, (Queue)parent, (boolean)false, (Configuration)this.conf);
        QueueInfo queueInfo = QueueInfo.newInstance((String)name, (float)capacity, (float)1.0f, (float)0.0f, null, null, (QueueState)QueueState.RUNNING, null, (String)"", null, (boolean)false, null, (boolean)false);
        ActiveUsersManager activeUsersManager = new ActiveUsersManager(metrics);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)queue.getMetrics()).thenReturn((Object)metrics);
        Mockito.when((Object)queue.getAbstractUsersManager()).thenReturn((Object)activeUsersManager);
        Mockito.when((Object)queue.getQueueInfo(false, false)).thenReturn((Object)queueInfo);
        return queue;
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    @Test
    public void testAppPercentages() throws Exception {
        FifoScheduler scheduler = (FifoScheduler)Mockito.mock(FifoScheduler.class);
        Mockito.when((Object)scheduler.getClusterResource()).thenReturn((Object)Resource.newInstance((int)10240, (int)10));
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        ApplicationAttemptId appAttId = this.createAppAttemptId(0, 0);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)3L);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        String user = "user1";
        Queue queue = this.createQueue("test", null);
        SchedulerApplicationAttempt app = new SchedulerApplicationAttempt(appAttId, "user1", queue, queue.getAbstractUsersManager(), rmContext);
        Resource requestedResource = Resource.newInstance((int)1536, (int)2);
        app.attemptResourceUsage.incUsed(requestedResource);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
        queue = this.createQueue("test2", null, 0.5f);
        app = new SchedulerApplicationAttempt(appAttId, "user1", queue, queue.getAbstractUsersManager(), rmContext);
        app.attemptResourceUsage.incUsed(requestedResource);
        Assert.assertEquals((float)30.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
        app.attemptResourceUsage.incUsed(requestedResource);
        app.attemptResourceUsage.incUsed(requestedResource);
        app.attemptResourceUsage.incUsed(requestedResource);
        Assert.assertEquals((float)120.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)60.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
        queue = this.createQueue("test3", null, 0.0f);
        app = new SchedulerApplicationAttempt(appAttId, "user1", queue, queue.getAbstractUsersManager(), rmContext);
        app.attemptResourceUsage.incUsed(requestedResource);
        Assert.assertEquals((float)0.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
    }

    @Test
    public void testAppPercentagesOnswitch() throws Exception {
        FifoScheduler scheduler = (FifoScheduler)Mockito.mock(FifoScheduler.class);
        Mockito.when((Object)scheduler.getClusterResource()).thenReturn((Object)Resource.newInstance((int)0, (int)0));
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        ApplicationAttemptId appAttId = this.createAppAttemptId(0, 0);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)3L);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        String user = "user1";
        Queue queue = this.createQueue("test", null);
        SchedulerApplicationAttempt app = new SchedulerApplicationAttempt(appAttId, "user1", queue, queue.getAbstractUsersManager(), rmContext);
        Resource requestedResource = Resource.newInstance((int)1536, (int)2);
        app.attemptResourceUsage.incUsed(requestedResource);
        Assert.assertEquals((float)0.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.0f);
    }

    @Test
    public void testSchedulingOpportunityOverflow() throws Exception {
        ApplicationAttemptId attemptId = this.createAppAttemptId(0, 0);
        Queue queue = this.createQueue("test", null);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)3L);
        SchedulerApplicationAttempt app = new SchedulerApplicationAttempt(attemptId, "user", queue, queue.getAbstractUsersManager(), rmContext);
        Priority priority2 = Priority.newInstance((int)1);
        SchedulerRequestKey schedulerKey = TestUtils.toSchedulerKey(priority2);
        Assert.assertEquals((long)0L, (long)app.getSchedulingOpportunities(schedulerKey));
        app.addSchedulingOpportunity(schedulerKey);
        Assert.assertEquals((long)1L, (long)app.getSchedulingOpportunities(schedulerKey));
        app.setSchedulingOpportunities(schedulerKey, 0x7FFFFFFE);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)app.getSchedulingOpportunities(schedulerKey));
        app.addSchedulingOpportunity(schedulerKey);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)app.getSchedulingOpportunities(schedulerKey));
        app.addSchedulingOpportunity(schedulerKey);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)app.getSchedulingOpportunities(schedulerKey));
    }
}

