/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppKillByClientEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestRMAppTransitions {
    static final Log LOG = LogFactory.getLog(TestRMAppTransitions.class);
    private boolean isSecurityEnabled;
    private Configuration conf;
    private RMContext rmContext;
    private static int maxAppAttempts = 2;
    private static int appId = 1;
    private DrainDispatcher rmDispatcher;
    private RMStateStore store;
    private RMApplicationHistoryWriter writer;
    private SystemMetricsPublisher publisher;
    private YarnScheduler scheduler;
    private TestSchedulerEventDispatcher schedulerDispatcher;

    @Parameterized.Parameters
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestRMAppTransitions(boolean isSecurityEnabled) {
        this.isSecurityEnabled = isSecurityEnabled;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        UserGroupInformation.AuthenticationMethod authMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        if (this.isSecurityEnabled) {
            authMethod = UserGroupInformation.AuthenticationMethod.KERBEROS;
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)authMethod, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.rmDispatcher = new DrainDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        AMLivelinessMonitor amLivelinessMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        AMLivelinessMonitor amFinishingMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        this.store = (RMStateStore)Mockito.mock(RMStateStore.class);
        this.writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        DelegationTokenRenewer renewer = (DelegationTokenRenewer)Mockito.mock(DelegationTokenRenewer.class);
        RMContextImpl realRMContext = new RMContextImpl((Dispatcher)this.rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, renewer, new AMRMTokenSecretManager(this.conf, this.rmContext), new RMContainerTokenSecretManager(this.conf), new NMTokenSecretManagerInRM(this.conf), new ClientToAMTokenSecretManagerInRM());
        realRMContext.setStateStore(this.store);
        this.publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        realRMContext.setSystemMetricsPublisher(this.publisher);
        realRMContext.setRMApplicationHistoryWriter(this.writer);
        this.rmContext = (RMContext)Mockito.spy((Object)realRMContext);
        ResourceScheduler resourceScheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        ((ResourceScheduler)Mockito.doReturn(null).when((Object)resourceScheduler)).getAppResourceUsageReport((ApplicationAttemptId)Matchers.any());
        ((RMContext)Mockito.doReturn((Object)resourceScheduler).when((Object)this.rmContext)).getScheduler();
        ((RMContext)Mockito.doReturn((Object)Mockito.mock(RMTimelineCollectorManager.class)).when((Object)this.rmContext)).getRMTimelineCollectorManager();
        this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new TestApplicationAttemptEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new TestApplicationEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)new TestApplicationManagerEventDispatcher());
        this.schedulerDispatcher = new TestSchedulerEventDispatcher();
        this.rmDispatcher.register(SchedulerEventType.class, (EventHandler)this.schedulerDispatcher);
        this.rmDispatcher.init(this.conf);
        this.rmDispatcher.start();
    }

    private ByteBuffer getTokens() throws IOException {
        Credentials ts = new Credentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        ts.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        return securityTokens;
    }

    private ByteBuffer getTokensConf() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        Configuration appConf = new Configuration(false);
        appConf.clear();
        appConf.set("dfs.nameservices", "mycluster1,mycluster2");
        appConf.set("dfs.namenode.rpc-address.mycluster2.nn1", "123.0.0.1");
        appConf.set("dfs.namenode.rpc-address.mycluster3.nn2", "123.0.0.2");
        appConf.write((DataOutput)dob);
        ByteBuffer tokenConf = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        return tokenConf;
    }

    private Map<String, LocalResource> getLocalResources() throws UnsupportedFileSystemException {
        FileContext localFS = FileContext.getLocalFSFileContext();
        File tmpDir = new File("target");
        File scriptFile = new File(tmpDir, "scriptFile.sh");
        URL resourceURL = URL.fromPath((Path)localFS.makeQualified(new Path(scriptFile.getAbsolutePath())));
        LocalResource localRes = (LocalResource)Records.newRecord(LocalResource.class);
        localRes.setResource(resourceURL);
        localRes.setSize(-1L);
        localRes.setVisibility(LocalResourceVisibility.APPLICATION);
        localRes.setType(LocalResourceType.FILE);
        localRes.setTimestamp(scriptFile.lastModified());
        String destinationFile = "dest_file";
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        localResources.put(destinationFile, localRes);
        return localResources;
    }

    private Map<String, String> getEnvironment() {
        HashMap<String, String> userSetEnv = new HashMap<String, String>();
        userSetEnv.put(ApplicationConstants.Environment.CONTAINER_ID.name(), "user_set_container_id");
        userSetEnv.put(ApplicationConstants.Environment.NM_HOST.name(), "user_set_NM_HOST");
        userSetEnv.put(ApplicationConstants.Environment.NM_PORT.name(), "user_set_NM_PORT");
        userSetEnv.put(ApplicationConstants.Environment.NM_HTTP_PORT.name(), "user_set_NM_HTTP_PORT");
        userSetEnv.put(ApplicationConstants.Environment.LOCAL_DIRS.name(), "user_set_LOCAL_DIR");
        userSetEnv.put(ApplicationConstants.Environment.USER.key(), "user_set_" + ApplicationConstants.Environment.USER.key());
        userSetEnv.put(ApplicationConstants.Environment.LOGNAME.name(), "user_set_LOGNAME");
        userSetEnv.put(ApplicationConstants.Environment.PWD.name(), "user_set_PWD");
        userSetEnv.put(ApplicationConstants.Environment.HOME.name(), "user_set_HOME");
        return userSetEnv;
    }

    private ContainerRetryContext getContainerRetryContext() {
        ContainerRetryContext containerRetryContext = ContainerRetryContext.newInstance((ContainerRetryPolicy)ContainerRetryPolicy.RETRY_ON_SPECIFIC_ERROR_CODES, new HashSet<Integer>(Arrays.asList(111)), (int)0, (int)0);
        return containerRetryContext;
    }

    private Map<String, ByteBuffer> getServiceData() {
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        String serviceName = "non_exist_auxService";
        serviceData.put(serviceName, ByteBuffer.wrap(serviceName.getBytes()));
        return serviceData;
    }

    private ContainerLaunchContext prepareContainerLaunchContext() throws IOException {
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        clc.setCommands(Arrays.asList("/bin/sleep 5"));
        if (UserGroupInformation.isSecurityEnabled()) {
            clc.setTokens(this.getTokens());
            clc.setTokensConf(this.getTokensConf());
        }
        clc.setLocalResources(this.getLocalResources());
        clc.setEnvironment(this.getEnvironment());
        clc.setContainerRetryContext(this.getContainerRetryContext());
        clc.setServiceData(this.getServiceData());
        return clc;
    }

    private LogAggregationContext getLogAggregationContext() {
        LogAggregationContext logAggregationContext = LogAggregationContext.newInstance((String)"includePattern", (String)"excludePattern", (String)"rolledLogsIncludePattern", (String)"rolledLogsExcludePattern", (String)"policyClass", (String)"policyParameters");
        return logAggregationContext;
    }

    protected RMApp createNewTestApp(ApplicationSubmissionContext submissionContext) throws IOException {
        ApplicationId applicationId = MockApps.newAppID((int)appId++);
        String user = MockApps.newUserName();
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", maxAppAttempts);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, this.scheduler);
        if (submissionContext == null) {
            submissionContext = new ApplicationSubmissionContextPBImpl();
        }
        submissionContext.setApplicationId(applicationId);
        submissionContext.setPriority(Priority.newInstance((int)0));
        submissionContext.setAMContainerSpec(this.prepareContainerLaunchContext());
        submissionContext.setLogAggregationContext(this.getLogAggregationContext());
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, name, user, queue, submissionContext, this.scheduler, masterService, System.currentTimeMillis(), "YARN", null, new ArrayList());
        TestRMAppTransitions.testAppStartState(applicationId, user, name, queue, (RMApp)application);
        this.rmContext.getRMApps().putIfAbsent(application.getApplicationId(), application);
        return application;
    }

    private static void testAppStartState(ApplicationId applicationId, String user, String name, String queue, RMApp application) {
        Assert.assertTrue((String)"application start time is not greater than 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assert.assertEquals((String)"application user is not correct", (Object)user, (Object)application.getUser());
        Assert.assertEquals((String)"application id is not correct", (Object)applicationId, (Object)application.getApplicationId());
        Assert.assertEquals((String)"application progress is not correct", (float)0.0f, (float)application.getProgress(), (float)0.0f);
        Assert.assertEquals((String)"application queue is not correct", (Object)queue, (Object)application.getQueue());
        Assert.assertEquals((String)"application name is not correct", (Object)name, (Object)application.getName());
        Assert.assertEquals((String)"application finish time is not 0 and should be", (long)0L, (long)application.getFinishTime());
        Assert.assertEquals((String)"application tracking url is not correct", null, (Object)application.getTrackingUrl());
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (long)0L, (long)diag.length());
    }

    private static void assertStartTimeSet(RMApp application) {
        Assert.assertTrue((String)"application start time is not greater than 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    private static void assertAppState(RMAppState state, RMApp application) {
        Assert.assertEquals((String)("application state should have been " + state), (Object)state, (Object)application.getState());
    }

    private static void assertFinalAppStatus(FinalApplicationStatus status, RMApp application) {
        Assert.assertEquals((String)("Final application status should have been " + status), (Object)status, (Object)application.getFinalApplicationStatus());
    }

    private void assertTimesAtFinish(RMApp application) {
        TestRMAppTransitions.assertStartTimeSet(application);
        Assert.assertTrue((String)"application finish time is not greater than 0", (application.getFinishTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application finish time is not >= start time", (application.getFinishTime() >= application.getStartTime() ? 1 : 0) != 0);
    }

    private void assertAppFinalStateSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).updateApplicationState((ApplicationStateData)Matchers.any(ApplicationStateData.class));
    }

    private void assertAppFinalStateNotSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)0))).updateApplicationState((ApplicationStateData)Matchers.any(ApplicationStateData.class));
    }

    private void assertKilled(RMApp application) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.KILLED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (Object)"Application killed by user.", (Object)diag.toString());
    }

    private void assertFailed(RMApp application, String regex) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertTrue((String)"application diagnostics is not correct", (boolean)diag.toString().matches(regex));
    }

    private void sendAppUpdateSavedEvent(RMApp application) {
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_UPDATE_SAVED);
        application.handle((Event)event);
        this.rmDispatcher.await();
    }

    private void sendAttemptUpdateSavedEvent(RMApp application) {
        application.getCurrentAppAttempt().handle((Event)new RMAppAttemptEvent(application.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED));
        this.rmDispatcher.await();
    }

    protected RMApp testCreateAppNewSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.START);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.NEW_SAVING, application);
        ((SystemMetricsPublisher)Mockito.verify((Object)this.publisher, (VerificationMode)Mockito.times((int)0))).appCreated((RMApp)Matchers.eq((Object)application), Matchers.anyLong());
        return application;
    }

    protected RMApp testCreateAppSubmittedNoRecovery(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppNewSaving(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_NEW_SAVED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
        ((SystemMetricsPublisher)Mockito.verify((Object)this.publisher)).appCreated((RMApp)Matchers.eq((Object)application), Matchers.anyLong());
        this.verifyRMAppFieldsForNonFinalTransitions(application);
        return application;
    }

    protected RMApp testCreateAppSubmittedRecovery(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        RMStateStore.RMState state = new RMStateStore.RMState();
        ApplicationStateData appState = ApplicationStateData.newInstance((long)123L, (long)123L, null, (String)"user", null);
        state.getApplicationState().put(application.getApplicationId(), appState);
        RMAppRecoverEvent event = new RMAppRecoverEvent(application.getApplicationId(), state);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.SUBMITTED, application);
        this.verifyRMAppFieldsForNonFinalTransitions(application);
        return application;
    }

    protected RMApp testCreateAppAccepted(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppSubmittedNoRecovery(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
        return application;
    }

    protected RMApp testCreateAppRunning(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppAccepted(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet(application);
        TestRMAppTransitions.assertAppState(RMAppState.RUNNING, application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.UNDEFINED, application);
        return application;
    }

    protected RMApp testCreateAppFinalSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppRunning(submissionContext);
        RMAppEvent finishingEvent = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_UNREGISTERED);
        application.handle((Event)finishingEvent);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.assertAppFinalStateSaved(application);
        return application;
    }

    protected RMApp testCreateAppFinishing(ApplicationSubmissionContext submissionContext) throws IOException {
        assert (submissionContext == null || !submissionContext.getUnmanagedAM());
        RMApp application = this.testCreateAppFinalSaving(submissionContext);
        RMAppEvent appUpdated = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_UPDATE_SAVED);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHING, application);
        this.assertTimesAtFinish(application);
        return application;
    }

    protected RMApp testCreateAppFinished(ApplicationSubmissionContext submissionContext, String diagnostics) throws IOException {
        RMApp application = null;
        application = submissionContext != null && submissionContext.getUnmanagedAM() ? this.testCreateAppRunning(submissionContext) : this.testCreateAppFinishing(submissionContext);
        RMAppEvent finishedEvent = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FINISHED, diagnostics);
        application.handle((Event)finishedEvent);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf(diagnostics) != -1 ? 1 : 0) != 0);
        return application;
    }

    @Test
    public void testUnmanagedApp() throws IOException {
        ApplicationSubmissionContextPBImpl subContext = new ApplicationSubmissionContextPBImpl();
        subContext.setUnmanagedAM(true);
        LOG.info((Object)"--- START: testUnmanagedAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished((ApplicationSubmissionContext)subContext, "some diagnostics");
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
        Mockito.reset((Object[])new RMApplicationHistoryWriter[]{this.writer});
        Mockito.reset((Object[])new SystemMetricsPublisher[]{this.publisher});
        LOG.info((Object)"--- START: testUnmanagedAppFailPath ---");
        application = this.testCreateAppRunning((ApplicationSubmissionContext)subContext);
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        Assert.assertEquals((long)1L, (long)appAttempt.getAppAttemptId().getAttemptId());
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Unmanaged application.*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppSuccessPath() throws IOException {
        LOG.info((Object)"--- START: testAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished(null, "some diagnostics");
        Assert.assertTrue((String)"Finished application missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppRecoverPath() throws IOException {
        LOG.info((Object)"--- START: testAppRecoverPath ---");
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setAMContainerSpec(this.prepareContainerLaunchContext());
        this.testCreateAppSubmittedRecovery(sub);
    }

    @Test(timeout=30000L)
    public void testAppNewKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewKill ---");
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppNewKill", (String[])new String[]{"foo_group"});
        RMApp application = this.createNewTestApp(null);
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateNotSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppNewReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewReject ---");
        RMApp application = this.createNewTestApp(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppNewRejectAddToStore() throws IOException {
        LOG.info((Object)"--- START: testAppNewRejectAddToStore ---");
        RMApp application = this.createNewTestApp(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.verifyRMAppFieldsForFinalTransitions(application);
        this.rmContext.getStateStore().removeApplication(application);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingKill ---");
        RMApp application = this.testCreateAppNewSaving(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppNewSavingKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingReject ---");
        RMApp application = this.testCreateAppNewSaving(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingSaveReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingSaveReject ---");
        RMApp application = this.testCreateAppNewSaving(null);
        String rejectedText = "Test Application Rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_SAVE_FAILED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertFailed(application, rejectedText);
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)0))).updateApplicationState((ApplicationStateData)Matchers.any(ApplicationStateData.class));
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.assertTimesAtFinish(application);
    }

    @Test(timeout=30000L)
    public void testAppSubmittedRejected() throws IOException {
        LOG.info((Object)"--- START: testAppSubmittedRejected ---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        String rejectedText = "app rejected";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppSubmittedKill() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppSubmittedKill---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppSubmittedKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppAcceptedFailed() throws IOException {
        RMAppFailedAttemptEvent event;
        LOG.info((Object)"--- START: testAppAcceptedFailed ---");
        RMApp application = this.testCreateAppAccepted(null);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
            application.handle((Event)event);
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
        }
        String message = "Test fail";
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, message, false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*" + message + ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test
    public void testAppAcceptedKill() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppAcceptedKill ---");
        RMApp application = this.testCreateAppAccepted(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppAcceptedKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.KILLING, application);
        RMAppEvent appAttemptKilled = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
        application.handle((Event)appAttemptKilled);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppAcceptedAttemptKilled() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppAcceptedAttemptKilled ---");
        RMApp application = this.testCreateAppAccepted(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
    }

    @Test
    public void testAppRunningKill() throws IOException {
        LOG.info((Object)"--- START: testAppRunningKill ---");
        RMApp application = this.testCreateAppRunning(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppRunningKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppRunningFailed() throws IOException {
        LOG.info((Object)"--- START: testAppRunningFailed ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        int expectedAttemptId = 1;
        Assert.assertEquals((long)expectedAttemptId, (long)appAttempt.getAppAttemptId().getAttemptId());
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            appAttempt = application.getCurrentAppAttempt();
            Assert.assertEquals((long)(++expectedAttemptId), (long)appAttempt.getAppAttemptId().getAttemptId());
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.ACCEPTED, application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState(RMAppState.RUNNING, application);
        }
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppAtFinishingIgnoreKill() throws IOException {
        LOG.info((Object)"--- START: testAppAtFinishingIgnoreKill ---");
        RMApp application = this.testCreateAppFinishing(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState(RMAppState.FINISHING, application);
    }

    @Test
    public void testAppFinalSavingToFinished() throws IOException {
        LOG.info((Object)"--- START: testAppFinalSavingToFinished ---");
        RMApp application = this.testCreateAppFinalSaving(null);
        String diagMsg = "some diagnostics";
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FINISHED, "some diagnostics");
        application.handle((Event)event);
        TestRMAppTransitions.assertAppState(RMAppState.FINAL_SAVING, application);
        RMAppEvent appUpdated = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_UPDATE_SAVED);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus(FinalApplicationStatus.FAILED, application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test
    public void testAppFinishedFinished() throws IOException {
        LOG.info((Object)"--- START: testAppFinishedFinished ---");
        RMApp application = this.testCreateAppFinished(null, "");
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FINISHED, application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (Object)"", (Object)diag.toString());
        this.verifyApplicationFinished(RMAppState.FINISHED);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppFailedFailed() throws IOException {
        LOG.info((Object)"--- START: testAppFailedFailed ---");
        RMApp application = this.testCreateAppNewSaving(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_REJECTED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.FAILED, application);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppKilledKilled() throws IOException {
        LOG.info((Object)"--- START: testAppKilledKilled ---");
        RMApp application = this.testCreateAppRunning(null);
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"fooTestAppKilledKill", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(application.getApplicationId(), "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FINISHED, "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL, "Application killed by user.");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, application);
        this.verifyRMAppFieldsForFinalTransitions(application);
    }

    @Test(timeout=30000L)
    public void testAppStartAfterKilled() throws IOException {
        LOG.info((Object)"--- START: testAppStartAfterKilled ---");
        ApplicationId applicationId = MockApps.newAppID((int)appId++);
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, null, null, null, (ApplicationSubmissionContext)new ApplicationSubmissionContextPBImpl(), null, null, System.currentTimeMillis(), "YARN", null, null){

            protected void onInvalidStateTransition(RMAppEventType rmAppEventType, RMAppState state) {
                Assert.assertTrue((String)("RMAppImpl: can't handle " + rmAppEventType + " at state " + state), (boolean)false);
            }
        };
        UserGroupInformation fooUser = UserGroupInformation.createUserForTesting((String)"testAppStartAfterKilled", (String[])new String[]{"foo_group"});
        RMAppKillByClientEvent event = new RMAppKillByClientEvent(applicationId, "Application killed by user.", fooUser, Server.getRemoteIp());
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertKilled((RMApp)application);
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.START, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish((RMApp)application);
        TestRMAppTransitions.assertAppState(RMAppState.KILLED, (RMApp)application);
    }

    @Test(timeout=30000L)
    public void testAppsRecoveringStates() throws Exception {
        RMStateStore.RMState state = new RMStateStore.RMState();
        Map applicationState = state.getApplicationState();
        this.createRMStateForApplications(applicationState, RMAppState.FINISHED);
        this.createRMStateForApplications(applicationState, RMAppState.KILLED);
        this.createRMStateForApplications(applicationState, RMAppState.FAILED);
        for (ApplicationStateData appState : applicationState.values()) {
            this.testRecoverApplication(appState, state);
        }
    }

    public void testRecoverApplication(ApplicationStateData appState, RMStateStore.RMState rmState) throws Exception {
        ApplicationSubmissionContext submissionContext = appState.getApplicationSubmissionContext();
        RMAppImpl application = new RMAppImpl(appState.getApplicationSubmissionContext().getApplicationId(), this.rmContext, this.conf, submissionContext.getApplicationName(), null, submissionContext.getQueue(), submissionContext, this.scheduler, null, appState.getSubmitTime(), submissionContext.getApplicationType(), submissionContext.getApplicationTags(), Collections.singletonList(BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)submissionContext.getResource(), (int)1)));
        Assert.assertEquals((Object)RMAppState.NEW, (Object)application.getState());
        RMAppRecoverEvent recoverEvent = new RMAppRecoverEvent(application.getApplicationId(), rmState);
        application.handle((RMAppEvent)recoverEvent);
        Assert.assertTrue((String)"Application is not in recoveredFinalStatus.", (boolean)RMAppImpl.isAppInFinalState((RMApp)application));
        this.rmDispatcher.await();
        RMAppState finalState = appState.getState();
        Assert.assertEquals((String)"Application is not in finalState.", (Object)finalState, (Object)application.getState());
        this.verifyRMAppFieldsForFinalTransitions((RMApp)application);
    }

    public void createRMStateForApplications(Map<ApplicationId, ApplicationStateData> applicationState, RMAppState rmAppState) throws IOException {
        RMApp app = this.createNewTestApp(null);
        ApplicationStateData appState = ApplicationStateData.newInstance((long)app.getSubmitTime(), (long)app.getStartTime(), (String)app.getUser(), (ApplicationSubmissionContext)app.getApplicationSubmissionContext(), (RMAppState)rmAppState, null, (long)app.getFinishTime(), null);
        applicationState.put(app.getApplicationId(), appState);
    }

    @Test
    public void testGetAppReport() throws IOException {
        RMApp app = this.createNewTestApp(null);
        TestRMAppTransitions.assertAppState(RMAppState.NEW, app);
        ApplicationReport report = app.createAndGetApplicationReport(null, true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
        Assert.assertEquals((Object)report.getApplicationResourceUsageReport(), (Object)RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT);
        report = app.createAndGetApplicationReport("clientuser", true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
        Assert.assertTrue((String)"bad proxy url for app", (boolean)report.getTrackingUrl().endsWith("/proxy/" + app.getApplicationId() + "/"));
    }

    private void verifyApplicationFinished(RMAppState state) {
        ArgumentCaptor finalState = ArgumentCaptor.forClass(RMAppState.class);
        ((RMApplicationHistoryWriter)Mockito.verify((Object)this.writer)).applicationFinished((RMApp)Matchers.any(RMApp.class), (RMAppState)finalState.capture());
        Assert.assertEquals((Object)state, (Object)finalState.getValue());
        finalState = ArgumentCaptor.forClass(RMAppState.class);
        ((SystemMetricsPublisher)Mockito.verify((Object)this.publisher)).appFinished((RMApp)Matchers.any(RMApp.class), (RMAppState)finalState.capture(), Matchers.anyLong());
        Assert.assertEquals((Object)state, (Object)finalState.getValue());
    }

    private void verifyAppRemovedSchedulerEvent(RMAppState finalState) {
        Assert.assertEquals((Object)SchedulerEventType.APP_REMOVED, (Object)this.schedulerDispatcher.lastSchedulerEvent.getType());
        if (this.schedulerDispatcher.lastSchedulerEvent instanceof AppRemovedSchedulerEvent) {
            AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)this.schedulerDispatcher.lastSchedulerEvent;
            Assert.assertEquals((Object)finalState, (Object)appRemovedEvent.getFinalState());
        }
    }

    private void verifyRMAppFieldsForNonFinalTransitions(RMApp application) throws IOException {
        Assert.assertEquals(Arrays.asList("/bin/sleep 5"), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getCommands());
        Assert.assertEquals(this.getLocalResources(), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getLocalResources());
        if (UserGroupInformation.isSecurityEnabled()) {
            Assert.assertEquals((Object)this.getTokens(), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getTokens());
            Assert.assertEquals((Object)this.getTokensConf(), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getTokensConf());
        }
        Assert.assertEquals(this.getEnvironment(), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getEnvironment());
        Assert.assertEquals((Object)this.getContainerRetryContext(), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getContainerRetryContext());
        Assert.assertEquals(this.getServiceData(), (Object)application.getApplicationSubmissionContext().getAMContainerSpec().getServiceData());
        Assert.assertEquals((Object)this.getLogAggregationContext(), (Object)application.getApplicationSubmissionContext().getLogAggregationContext());
    }

    private void verifyRMAppFieldsForFinalTransitions(RMApp application) {
        Assert.assertEquals(null, (Object)application.getApplicationSubmissionContext().getAMContainerSpec());
        Assert.assertEquals(null, (Object)application.getApplicationSubmissionContext().getLogAggregationContext());
    }

    private static final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        public SchedulerEvent lastSchedulerEvent;

        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
            this.lastSchedulerEvent = event;
        }
    }

    private static final class TestApplicationManagerEventDispatcher
    implements EventHandler<RMAppManagerEvent> {
        private TestApplicationManagerEventDispatcher() {
        }

        public void handle(RMAppManagerEvent event) {
        }
    }

    private static final class TestApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public TestApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    private static final class TestApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public TestApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            ApplicationId appId = event.getApplicationAttemptId().getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
            if (rmApp != null) {
                try {
                    rmApp.getRMAppAttempt(event.getApplicationAttemptId()).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appId), t);
                }
            }
        }
    }
}

