/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.FairReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestReservationSystem
extends ParameterizedSchedulerTestBase {
    private static final String ALLOC_FILE = new File(FairSchedulerTestBase.TEST_DIR, TestReservationSystem.class.getName() + ".xml").getAbsolutePath();
    private AbstractYarnScheduler scheduler;
    private AbstractReservationSystem reservationSystem;
    private RMContext rmContext;
    private Configuration conf;
    private RMContext mockRMContext;

    public TestReservationSystem(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    @Before
    public void setUp() throws IOException {
        this.scheduler = this.initializeScheduler();
        this.rmContext = this.getRMContext();
        this.reservationSystem = this.configureReservationSystem();
        this.reservationSystem.setRMContext(this.rmContext);
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    @After
    public void tearDown() {
        this.conf = null;
        this.reservationSystem = null;
        this.rmContext = null;
        this.scheduler = null;
        this.clearRMContext();
        QueueMetrics.clearQueueMetrics();
    }

    @Test
    public void testInitialize() throws IOException {
        try {
            this.reservationSystem.reinitialize(this.scheduler.getConfig(), this.rmContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
            ReservationSystemTestUtil.validateReservationQueue(this.reservationSystem, ReservationSystemTestUtil.getReservationQueueName());
        } else {
            ReservationSystemTestUtil.validateReservationQueue(this.reservationSystem, ReservationSystemTestUtil.getFullReservationQueueName());
        }
    }

    @Test
    public void testReinitialize() throws IOException {
        this.conf = this.scheduler.getConfig();
        try {
            this.reservationSystem.reinitialize(this.conf, this.rmContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
            ReservationSystemTestUtil.validateReservationQueue(this.reservationSystem, ReservationSystemTestUtil.getReservationQueueName());
        } else {
            ReservationSystemTestUtil.validateReservationQueue(this.reservationSystem, ReservationSystemTestUtil.getFullReservationQueueName());
        }
        String newQ = "reservation";
        Assert.assertNull((Object)this.reservationSystem.getPlan(newQ));
        this.updateSchedulerConf(this.conf, newQ);
        try {
            this.scheduler.reinitialize(this.conf, this.rmContext);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            this.reservationSystem.reinitialize(this.conf, this.rmContext);
        }
        catch (YarnException e) {
            Assert.fail((String)e.getMessage());
        }
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
            ReservationSystemTestUtil.validateReservationQueue(this.reservationSystem, newQ);
        } else {
            ReservationSystemTestUtil.validateReservationQueue(this.reservationSystem, "root." + newQ);
        }
    }

    public AbstractYarnScheduler initializeScheduler() throws IOException {
        switch (this.getSchedulerType()) {
            case CAPACITY: {
                return this.initializeCapacityScheduler();
            }
            case FAIR: {
                return this.initializeFairScheduler();
            }
        }
        return null;
    }

    public AbstractReservationSystem configureReservationSystem() {
        switch (this.getSchedulerType()) {
            case CAPACITY: {
                return new CapacityReservationSystem();
            }
            case FAIR: {
                return new FairReservationSystem();
            }
        }
        return null;
    }

    public void updateSchedulerConf(Configuration conf, String newQ) throws IOException {
        switch (this.getSchedulerType()) {
            case CAPACITY: {
                ReservationSystemTestUtil.updateQueueConfiguration((CapacitySchedulerConfiguration)conf, newQ);
            }
            case FAIR: {
                ReservationSystemTestUtil.updateFSAllocationFile(ALLOC_FILE);
            }
        }
    }

    public RMContext getRMContext() {
        return this.mockRMContext;
    }

    public void clearRMContext() {
        this.mockRMContext = null;
    }

    private CapacityScheduler initializeCapacityScheduler() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(conf);
        CapacityScheduler cs = (CapacityScheduler)Mockito.spy((Object)new CapacityScheduler());
        cs.setConf((Configuration)conf);
        this.mockRMContext = ReservationSystemTestUtil.createRMContext((Configuration)conf);
        cs.setRMContext(this.mockRMContext);
        try {
            cs.serviceInit((Configuration)conf);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationSystemTestUtil.initializeRMContext(10, (AbstractYarnScheduler)cs, this.mockRMContext);
        return cs;
    }

    private Configuration createFSConfiguration() {
        FairSchedulerTestBase testHelper = new FairSchedulerTestBase();
        Configuration conf = testHelper.createConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        return conf;
    }

    private FairScheduler initializeFairScheduler() throws IOException {
        Configuration conf = this.createFSConfiguration();
        ReservationSystemTestUtil.setupFSAllocationFile(ALLOC_FILE);
        this.mockRMContext = ReservationSystemTestUtil.createRMContext(conf);
        return ReservationSystemTestUtil.setupFairScheduler(this.mockRMContext, conf, 10);
    }
}

