/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyInterQueueWithDRF
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.rc = new DominantResourceCalculator();
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.rc);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testInterQueuePreemptionWithMultipleResource() throws Exception {
        String labelsConfig = "=100:200,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100:200 100:200 100:200 100:200]);-a(=[50:100 100:200 40:80 30:70]);-b(=[50:100 100:200 60:120 40:50])";
        String appsConfig = "a\t(1,2:4,n1,,20,false);b\t(1,2:4,n1,,30,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testInterQueuePreemptionWithNaturalTerminationFactor() throws Exception {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 0.2f);
        String labelsConfig = "=100:50,true;";
        String nodesConfig = "n1= res=100:50";
        String queuesConfig = "root(=[100:50 100:50 50:50 0:0]);-a(=[50:25 100:50 50:50 0:0]);-b(=[50:25 50:25 0:0 2:1]);";
        String appsConfig = "a\t(1,2:1,n1,,50,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)1))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }
}

