/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMHA {
    private Log LOG = LogFactory.getLog(TestRMHA.class);
    private Configuration configuration;
    private MockRM rm = null;
    private MockNM nm = null;
    private RMApp app = null;
    private RMAppAttempt attempt = null;
    private static final String STATE_ERR = "ResourceManager is in wrong HA state";
    private static final String RM1_ADDRESS = "1.1.1.1:1";
    private static final String RM1_NODE_ID = "rm1";
    private static final String RM2_ADDRESS = "0.0.0.0:0";
    private static final String RM2_NODE_ID = "rm2";
    private static final String RM3_ADDRESS = "2.2.2.2:2";
    private static final String RM3_NODE_ID = "rm3";

    @Before
    public void setUp() throws Exception {
        this.configuration = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)this.configuration);
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS);
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM3_NODE_ID), RM3_ADDRESS);
        }
        this.configuration.setBoolean("mockrm.webapp.enabled", true);
        this.configuration.setBoolean("yarn.acl.enable", true);
        ClusterMetrics.destroy();
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    private void checkMonitorHealth() throws IOException {
        try {
            this.rm.adminService.monitorHealth();
        }
        catch (HealthCheckFailedException e) {
            Assert.fail((String)"The RM is in bad health: it is Active, but the active services are not running");
        }
    }

    private void checkStandbyRMFunctionality() throws IOException {
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"Active RM services are started", (boolean)this.rm.areActiveServicesRunning());
        Assert.assertTrue((String)"RM is not ready to become active", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
    }

    private void checkActiveRMFunctionality() throws Exception {
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertTrue((String)"Active RM services aren't started", (boolean)this.rm.areActiveServicesRunning());
        Assert.assertTrue((String)"RM is not ready to become active", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        try {
            this.rm.getNewAppId();
            this.nm = this.rm.registerNode("127.0.0.1:1", 2048);
            this.app = this.rm.submitApp(1024);
            this.attempt = this.app.getCurrentAppAttempt();
            this.rm.waitForState(this.attempt.getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to perform Active RM functions");
            this.LOG.error((Object)"ActiveRM check failed", (Throwable)e);
        }
        this.checkActiveRMWebServices();
    }

    private void checkActiveRMWebServices() throws JSONException {
        Client webServiceClient = Client.create((ClientConfig)new DefaultClientConfig());
        InetSocketAddress rmWebappAddr = NetUtils.getConnectAddress((InetSocketAddress)this.rm.getWebapp().getListenerAddress());
        String webappURL = "http://" + rmWebappAddr.getHostName() + ":" + rmWebappAddr.getPort();
        WebResource webResource = webServiceClient.resource(webappURL);
        String path = this.app.getApplicationId().toString();
        ClientResponse response = (ClientResponse)webResource.path("ws").path("v1").path("cluster").path("apps").path(path).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appJson = json.getJSONObject("app");
        Assert.assertEquals((Object)"ACCEPTED", (Object)appJson.getString("state"));
    }

    @Test(timeout=30000L)
    public void testFailoverAndTransitions() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.INITIALIZING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active before being started", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        this.checkMonitorHealth();
        this.rm.start();
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.verifyClusterMetrics(0, 0, 0, 0, 0L, 0);
        this.rm.adminService.transitionToStandby(requestInfo);
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.verifyClusterMetrics(0, 0, 0, 0, 0L, 0);
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.verifyClusterMetrics(1, 1, 1, 1, 2048L, 1);
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.verifyClusterMetrics(1, 2, 2, 2, 2048L, 2);
        this.rm.adminService.transitionToStandby(requestInfo);
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.verifyClusterMetrics(0, 0, 0, 0, 0L, 0);
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.verifyClusterMetrics(1, 1, 1, 1, 2048L, 1);
        this.rm.stop();
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.STOPPING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active even after it is stopped", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        Assert.assertFalse((String)"Active RM services are started", (boolean)this.rm.areActiveServicesRunning());
        this.checkMonitorHealth();
    }

    @Test
    public void testTransitionsWhenAutomaticFailoverEnabled() throws Exception {
        String ERR_UNFORCED_REQUEST = "User request succeeded even when automatic failover is enabled";
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        this.rm.start();
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        try {
            this.rm.adminService.transitionToStandby(requestInfo);
            Assert.fail((String)"User request succeeded even when automatic failover is enabled");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        try {
            this.rm.adminService.transitionToActive(requestInfo);
            Assert.fail((String)"User request succeeded even when automatic failover is enabled");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        String ERR_FORCED_REQUEST = "Forced request by user should work even if automatic failover is enabled";
        requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED);
        try {
            this.rm.adminService.transitionToStandby(requestInfo);
        }
        catch (AccessControlException e) {
            Assert.fail((String)"Forced request by user should work even if automatic failover is enabled");
        }
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        try {
            this.rm.adminService.transitionToActive(requestInfo);
        }
        catch (AccessControlException e) {
            Assert.fail((String)"Forced request by user should work even if automatic failover is enabled");
        }
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
    }

    @Test
    public void testRMDispatcherForHA() throws IOException {
        String errorMessageForEventHandler = "Expect to get the same number of handlers";
        String errorMessageForService = "Expect to get the same number of services";
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf){

            @Override
            protected Dispatcher createDispatcher() {
                return new MyCountingDispatcher();
            }
        };
        this.rm.init((Configuration)conf);
        int expectedEventHandlerCount = ((MyCountingDispatcher)this.rm.getRMContext().getDispatcher()).getEventHandlerCount();
        int expectedServiceCount = this.rm.getServices().size();
        Assert.assertTrue((expectedEventHandlerCount != 0 ? 1 : 0) != 0);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.INITIALIZING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active before being started", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        this.rm.start();
        this.rm.adminService.transitionToStandby(requestInfo);
        this.rm.adminService.transitionToActive(requestInfo);
        this.rm.adminService.transitionToStandby(requestInfo);
        this.rm.adminService.transitionToActive(requestInfo);
        this.rm.adminService.transitionToStandby(requestInfo);
        MyCountingDispatcher dispatcher = (MyCountingDispatcher)this.rm.getRMContext().getDispatcher();
        Assert.assertTrue((!dispatcher.isStopped() ? 1 : 0) != 0);
        this.rm.adminService.transitionToActive(requestInfo);
        Assert.assertEquals((String)errorMessageForEventHandler, (long)expectedEventHandlerCount, (long)((MyCountingDispatcher)this.rm.getRMContext().getDispatcher()).getEventHandlerCount());
        Assert.assertEquals((String)errorMessageForService, (long)expectedServiceCount, (long)this.rm.getServices().size());
        dispatcher = (MyCountingDispatcher)this.rm.getRMContext().getDispatcher();
        this.rm.adminService.transitionToStandby(requestInfo);
        Assert.assertEquals((String)errorMessageForEventHandler, (long)expectedEventHandlerCount, (long)((MyCountingDispatcher)this.rm.getRMContext().getDispatcher()).getEventHandlerCount());
        Assert.assertEquals((String)errorMessageForService, (long)expectedServiceCount, (long)this.rm.getServices().size());
        Assert.assertTrue((boolean)dispatcher.isStopped());
        this.rm.stop();
    }

    @Test
    public void testHAIDLookup() {
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        Assert.assertEquals((Object)conf.get("yarn.resourcemanager.ha.id"), (Object)RM2_NODE_ID);
        this.configuration.set("yarn.resourcemanager.ha.id", RM1_NODE_ID);
        conf = new YarnConfiguration(this.configuration);
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        Assert.assertEquals((Object)conf.get("yarn.resourcemanager.ha.id"), (Object)RM1_NODE_ID);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm3");
        this.configuration.unset("yarn.resourcemanager.ha.id");
        conf = new YarnConfiguration(this.configuration);
        try {
            this.rm = new MockRM((Configuration)conf);
            this.rm.init((Configuration)conf);
            Assert.fail((String)"Should get an exception here.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Invalid configuration! Can not find valid RM_HA_ID."));
        }
    }

    @Test
    public void testHAWithRMHostName() throws Exception {
        this.innerTestHAWithRMHostName(false);
        this.configuration.clear();
        this.setUp();
        this.innerTestHAWithRMHostName(true);
    }

    @Test(timeout=30000L)
    public void testFailoverWhenTransitionToActiveThrowException() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore(){
            int count = 0;

            public synchronized void startInternal() throws Exception {
                if (this.count++ == 0) {
                    throw new Exception("Session Expired");
                }
            }
        };
        memStore.init((Configuration)conf);
        this.rm = new MockRM((Configuration)conf, (RMStateStore)memStore);
        this.rm.init((Configuration)conf);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.INITIALIZING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active before being started", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        this.checkMonitorHealth();
        this.rm.start();
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        try {
            this.rm.adminService.transitionToActive(requestInfo);
            Assert.fail((String)"Transitioned to Active should throw exception.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)"Error when transitioning to Active mode".contains(e.getMessage()));
        }
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
    }

    @Test
    public void testTransitionedToStandbyShouldNotHang() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore(){

            public void updateApplicationState(ApplicationStateData appState) {
                this.notifyStoreOperationFailed((Exception)new StoreFencedException());
            }
        };
        memStore.init((Configuration)conf);
        this.rm = new MockRM((Configuration)conf, (RMStateStore)memStore){

            void stopActiveServices() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                super.stopActiveServices();
            }
        };
        this.rm.init((Configuration)conf);
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Assert.assertEquals((String)STATE_ERR, (Object)HAServiceProtocol.HAServiceState.INITIALIZING, (Object)this.rm.adminService.getServiceStatus().getState());
        Assert.assertFalse((String)"RM is ready to become active before being started", (boolean)this.rm.adminService.getServiceStatus().isReadyToBecomeActive());
        this.checkMonitorHealth();
        this.rm.start();
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.rm.adminService.transitionToActive(requestInfo);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestRMHA.this.rm.transitionToStandby(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
        this.rm.getRMContext().getStateStore().updateApplicationState(null);
        t.join();
        this.rm.adminService.transitionToStandby(requestInfo);
        this.checkStandbyRMFunctionality();
        this.rm.stop();
    }

    @Test
    public void testFailoverClearsRMContext() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.configuration.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.rm = new MockRM((Configuration)conf);
        this.rm.init((Configuration)conf);
        this.rm.start();
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.rm.adminService.transitionToActive(requestInfo);
        this.checkMonitorHealth();
        this.checkActiveRMFunctionality();
        this.verifyClusterMetrics(1, 1, 1, 1, 2048L, 1);
        Assert.assertEquals((long)1L, (long)this.rm.getRMContext().getRMNodes().size());
        Assert.assertEquals((long)1L, (long)this.rm.getRMContext().getRMApps().size());
        Assert.assertNotNull((String)"Node not registered", (Object)this.nm);
        this.rm.adminService.transitionToStandby(requestInfo);
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        this.nm.registerNode();
        this.verifyClusterMetrics(0, 0, 0, 0, 0L, 0);
        this.rm = new MockRM((Configuration)conf, this.rm.getRMStateStore()){

            @Override
            protected ResourceTrackerService createResourceTrackerService() {
                return new ResourceTrackerService((RMContext)this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.rmContext.getContainerTokenSecretManager(), this.rmContext.getNMTokenSecretManager()){

                    protected void serviceStart() throws Exception {
                        throw new Exception("ResourceTracker service failed");
                    }
                };
            }
        };
        this.rm.init((Configuration)conf);
        this.rm.start();
        this.checkMonitorHealth();
        this.checkStandbyRMFunctionality();
        try {
            this.rm.adminService.transitionToActive(requestInfo);
            Assert.fail((String)"Transitioned to Active should throw exception.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)"Error when transitioning to Active mode".contains(e.getMessage()));
        }
        this.verifyClusterMetrics(0, 0, 0, 0, 0L, 0);
        Assert.assertEquals((long)0L, (long)this.rm.getRMContext().getRMNodes().size());
        Assert.assertEquals((long)0L, (long)this.rm.getRMContext().getRMApps().size());
    }

    @Test(timeout=9000000L)
    public void testTransitionedToActiveRefreshFail() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.rm = new MockRM(this.configuration){

            @Override
            protected AdminService createAdminService() {
                return new AdminService(this){
                    int counter;
                    {
                        this.counter = 0;
                    }

                    protected void setConfig(Configuration conf) {
                        super.setConfig(TestRMHA.this.configuration);
                    }

                    protected void refreshAll() throws ServiceFailedException {
                        if (this.counter == 0) {
                            ++this.counter;
                            throw new ServiceFailedException("Simulate RefreshFail");
                        }
                        super.refreshAll();
                    }
                };
            }

            @Override
            protected Dispatcher createDispatcher() {
                return new FailFastDispatcher();
            }
        };
        this.rm.init(this.configuration);
        this.rm.start();
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        FailFastDispatcher dispatcher = (FailFastDispatcher)this.rm.rmContext.getDispatcher();
        this.rm.adminService.transitionToStandby(requestInfo);
        Assert.assertEquals((String)"Fatal Event should be 0", (long)0L, (long)dispatcher.getEventCount());
        Assert.assertEquals((String)"HA state should be in standBy State", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)this.rm.getRMContext().getHAServiceState());
        try {
            this.rm.adminService.transitionToActive(requestInfo);
            Assert.fail((String)"Transition to Active should have failed for refreshAll()");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Service fail Exception expected", (boolean)(e instanceof ServiceFailedException));
        }
        dispatcher.await();
        Assert.assertEquals((String)"Fatal Event to be received", (long)1L, (long)dispatcher.getEventCount());
        this.rm.adminService.transitionToActive(requestInfo);
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)this.rm.getRMContext().getHAServiceState());
        this.rm.adminService.transitionToStandby(requestInfo);
        Assert.assertEquals((Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)this.rm.getRMContext().getHAServiceState());
    }

    public void innerTestHAWithRMHostName(boolean includeBindHost) {
        YarnConfiguration conf;
        if (includeBindHost) {
            this.configuration.set("yarn.resourcemanager.bind-host", "9.9.9.9");
        }
        this.configuration.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)RM1_NODE_ID), "1.1.1.1");
        this.configuration.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)RM2_NODE_ID), "0.0.0.0");
        this.configuration.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)RM3_NODE_ID), "2.2.2.2");
        try {
            conf = new YarnConfiguration(this.configuration);
            this.rm = new MockRM((Configuration)conf);
            this.rm.init((Configuration)conf);
            for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
                Assert.assertEquals((String)("RPC address not set for " + confKey), (Object)RM1_ADDRESS, (Object)conf.get(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID)));
                Assert.assertEquals((String)("RPC address not set for " + confKey), (Object)RM2_ADDRESS, (Object)conf.get(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID)));
                Assert.assertEquals((String)("RPC address not set for " + confKey), (Object)RM3_ADDRESS, (Object)conf.get(HAUtil.addSuffix((String)confKey, (String)RM3_NODE_ID)));
                if (includeBindHost) {
                    Assert.assertEquals((String)"Web address misconfigured WITH bind-host", (Object)this.rm.webAppAddress.substring(0, 7), (Object)"9.9.9.9");
                    continue;
                }
                Assert.assertEquals((String)"Web address misconfigured WITHOUT bind-host", (Object)this.rm.webAppAddress.substring(0, 7), (Object)"0.0.0.0");
            }
        }
        catch (YarnRuntimeException e) {
            Assert.fail((String)"Should not throw any exceptions.");
        }
        this.configuration.clear();
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        this.configuration.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)RM1_NODE_ID), "1.1.1.1");
        this.configuration.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)RM2_NODE_ID), "0.0.0.0");
        try {
            conf = new YarnConfiguration(this.configuration);
            this.rm = new MockRM((Configuration)conf);
            this.rm.init((Configuration)conf);
            Assert.assertEquals((String)"RPC address not set for yarn.resourcemanager.address", (Object)"1.1.1.1:8032", (Object)conf.get(HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM1_NODE_ID)));
            Assert.assertEquals((String)"RPC address not set for yarn.resourcemanager.address", (Object)"0.0.0.0:8032", (Object)conf.get(HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM2_NODE_ID)));
        }
        catch (YarnRuntimeException e) {
            Assert.fail((String)"Should not throw any exceptions.");
        }
    }

    private void verifyClusterMetrics(int activeNodes, int appsSubmitted, int appsPending, int containersPending, long availableMB, int activeApplications) throws Exception {
        int timeoutSecs = 0;
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        ClusterMetrics clusterMetrics = ClusterMetrics.getMetrics();
        boolean isAllMetricAssertionDone = false;
        String message = null;
        while (timeoutSecs++ < 5) {
            try {
                this.assertMetric("appsSubmitted", appsSubmitted, metrics.getAppsSubmitted());
                this.assertMetric("appsPending", appsPending, metrics.getAppsPending());
                this.assertMetric("containersPending", containersPending, metrics.getPendingContainers());
                this.assertMetric("availableMB", availableMB, metrics.getAvailableMB());
                this.assertMetric("activeApplications", activeApplications, metrics.getActiveApps());
                this.assertMetric("activeNodes", activeNodes, clusterMetrics.getNumActiveNMs());
                isAllMetricAssertionDone = true;
                break;
            }
            catch (AssertionError e) {
                message = ((Throwable)((Object)e)).getMessage();
                System.out.println("Waiting for metrics assertion to complete");
                Thread.sleep(1000L);
            }
        }
        Assert.assertTrue(message, (boolean)isAllMetricAssertionDone);
    }

    private void assertMetric(String metricName, long expected, long actual) {
        Assert.assertEquals((String)("Incorrect value for metric " + metricName), (long)expected, (long)actual);
    }

    class FailFastDispatcher
    extends DrainDispatcher {
        int eventreceived = 0;

        FailFastDispatcher() {
        }

        protected void dispatch(Event event) {
            if (event.getType() == RMFatalEventType.TRANSITION_TO_ACTIVE_FAILED) {
                ++this.eventreceived;
            } else {
                super.dispatch(event);
            }
        }

        public int getEventCount() {
            return this.eventreceived;
        }
    }

    class MyCountingDispatcher
    extends AbstractService
    implements Dispatcher {
        private int eventHandlerCount;
        private volatile boolean stopped;

        public MyCountingDispatcher() {
            super("MyCountingDispatcher");
            this.stopped = false;
            this.eventHandlerCount = 0;
        }

        public EventHandler<Event> getEventHandler() {
            return null;
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
            ++this.eventHandlerCount;
        }

        public int getEventHandlerCount() {
            return this.eventHandlerCount;
        }

        protected void serviceStop() throws Exception {
            this.stopped = true;
            super.serviceStop();
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

