/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContainerResourceUsage {
    private YarnConfiguration conf;

    @Before
    public void setup() throws UnknownHostException {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        this.conf = new YarnConfiguration();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
    }

    @After
    public void tearDown() {
    }

    @Test(timeout=120000L)
    public void testUsageWithOneAttemptAndOneContainer() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm.registerNode();
        RMApp app0 = rm.submitApp(200);
        RMAppMetrics rmAppMetrics = app0.getRMAppMetrics();
        Assert.assertTrue((String)("Before app submittion, memory seconds should have been 0 but was " + rmAppMetrics.getMemorySeconds()), (rmAppMetrics.getMemorySeconds() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Before app submission, vcore seconds should have been 0 but was " + rmAppMetrics.getVcoreSeconds()), (rmAppMetrics.getVcoreSeconds() == 0L ? 1 : 0) != 0);
        RMAppAttempt attempt0 = app0.getCurrentAppAttempt();
        nm.nodeHeartbeat(true);
        MockAM am0 = rm.sendAMLaunched(attempt0.getAppAttemptId());
        am0.registerAppAttempt();
        RMContainer rmContainer = rm.getResourceScheduler().getRMContainer(attempt0.getMasterContainer().getId());
        int sleepInterval = 1000;
        for (int cumulativeSleepTime = 0; rmAppMetrics.getMemorySeconds() <= 0L && cumulativeSleepTime < 5000; cumulativeSleepTime += sleepInterval) {
            Thread.sleep(sleepInterval);
        }
        rmAppMetrics = app0.getRMAppMetrics();
        Assert.assertTrue((String)("While app is running, memory seconds should be >0 but is " + rmAppMetrics.getMemorySeconds()), (rmAppMetrics.getMemorySeconds() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("While app is running, vcore seconds should be >0 but is " + rmAppMetrics.getVcoreSeconds()), (rmAppMetrics.getVcoreSeconds() > 0L ? 1 : 0) != 0);
        MockRM.finishAMAndVerifyAppState(app0, rm, nm, am0);
        AggregateAppResourceUsage ru = this.calculateContainerResourceMetrics(rmContainer);
        rmAppMetrics = app0.getRMAppMetrics();
        Assert.assertEquals((String)"Unexpected MemorySeconds value", (long)ru.getMemorySeconds(), (long)rmAppMetrics.getMemorySeconds());
        Assert.assertEquals((String)"Unexpected VcoreSeconds value", (long)ru.getVcoreSeconds(), (long)rmAppMetrics.getVcoreSeconds());
        rm.stop();
    }

    @Test(timeout=120000L)
    public void testUsageWithMultipleContainersAndRMRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm0 = new MockRM((Configuration)this.conf);
        rm0.start();
        MockMemoryRMStateStore memStore = (MockMemoryRMStateStore)rm0.getRMStateStore();
        MockNM nm = new MockNM("127.0.0.1:1234", 65536, rm0.getResourceTrackerService());
        nm.registerNode();
        RMApp app0 = rm0.submitApp(200);
        rm0.waitForState(app0.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt0 = app0.getCurrentAppAttempt();
        ApplicationAttemptId attemptId0 = attempt0.getAppAttemptId();
        rm0.waitForState(attemptId0, RMAppAttemptState.SCHEDULED);
        nm.nodeHeartbeat(true);
        rm0.waitForState(attemptId0, RMAppAttemptState.ALLOCATED);
        MockAM am0 = rm0.sendAMLaunched(attempt0.getAppAttemptId());
        am0.registerAppAttempt();
        int NUM_CONTAINERS = 2;
        am0.allocate("127.0.0.1", 1000, NUM_CONTAINERS, new ArrayList<ContainerId>());
        nm.nodeHeartbeat(true);
        List conts = am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (conts.size() != NUM_CONTAINERS) {
            nm.nodeHeartbeat(true);
            conts.addAll(am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(500L);
        }
        for (Container c : conts) {
            nm.nodeHeartbeat(attempt0.getAppAttemptId(), c.getId().getContainerId(), ContainerState.RUNNING);
            rm0.waitForState(nm, c.getId(), RMContainerState.RUNNING);
        }
        Collection rmContainers = rm0.scheduler.getSchedulerAppInfo(attempt0.getAppAttemptId()).getLiveContainers();
        int sleepInterval = 1000;
        for (int cumulativeSleepTime = 0; app0.getRMAppMetrics().getMemorySeconds() <= 0L && cumulativeSleepTime < 5000; cumulativeSleepTime += sleepInterval) {
            Thread.sleep(sleepInterval);
        }
        for (Container c : conts) {
            if (c.getId().getContainerId() == 1L) continue;
            nm.nodeHeartbeat(attempt0.getAppAttemptId(), c.getId().getContainerId(), ContainerState.COMPLETE);
            rm0.waitForState(nm, c.getId(), RMContainerState.COMPLETED);
        }
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)attempt0.getAppAttemptId(), (long)1L);
        nm.nodeHeartbeat(attempt0.getAppAttemptId(), cId.getContainerId(), ContainerState.COMPLETE);
        rm0.waitForState(nm, cId, RMContainerState.COMPLETED);
        long memorySeconds = 0L;
        long vcoreSeconds = 0L;
        for (RMContainer c : rmContainers) {
            AggregateAppResourceUsage ru = this.calculateContainerResourceMetrics(c);
            memorySeconds += ru.getMemorySeconds();
            vcoreSeconds += ru.getVcoreSeconds();
        }
        RMAppMetrics metricsBefore = app0.getRMAppMetrics();
        Assert.assertEquals((String)"Unexpected MemorySeconds value", (long)memorySeconds, (long)metricsBefore.getMemorySeconds());
        Assert.assertEquals((String)"Unexpected VcoreSeconds value", (long)vcoreSeconds, (long)metricsBefore.getVcoreSeconds());
        MockRM rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        rm1.start();
        RMApp app0After = (RMApp)rm1.getRMContext().getRMApps().get(app0.getApplicationId());
        RMAppMetrics metricsAfter = app0After.getRMAppMetrics();
        Assert.assertEquals((String)"Vcore seconds were not the same after RM Restart", (long)metricsBefore.getVcoreSeconds(), (long)metricsAfter.getVcoreSeconds());
        Assert.assertEquals((String)"Memory seconds were not the same after RM Restart", (long)metricsBefore.getMemorySeconds(), (long)metricsAfter.getMemorySeconds());
        rm0.stop();
        rm0.close();
        rm1.stop();
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testUsageAfterAMRestartWithMultipleContainers() throws Exception {
        this.amRestartTests(false);
    }

    @Test(timeout=60000L)
    public void testUsageAfterAMRestartKeepContainers() throws Exception {
        this.amRestartTests(true);
    }

    private void amRestartTests(boolean keepRunningContainers) throws Exception {
        Object ru;
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        RMApp app = rm.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, keepRunningContainers);
        MockNM nm = new MockNM("127.0.0.1:1234", 10240, rm.getResourceTrackerService());
        nm.registerNode();
        MockAM am0 = MockRM.launchAndRegisterAM(app, rm, nm);
        int NUM_CONTAINERS = 1;
        am0.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
        nm.nodeHeartbeat(true);
        List containers = am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (containers.size() != NUM_CONTAINERS) {
            nm.nodeHeartbeat(true);
            containers.addAll(am0.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(200L);
        }
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am0.getApplicationAttemptId(), (long)2L);
        nm.nodeHeartbeat(am0.getApplicationAttemptId(), containerId2.getContainerId(), ContainerState.RUNNING);
        rm.waitForState(nm, containerId2, RMContainerState.RUNNING);
        Collection rmContainers = rm.scheduler.getSchedulerAppInfo(am0.getApplicationAttemptId()).getLiveContainers();
        ContainerId amContainerId = app.getCurrentAppAttempt().getMasterContainer().getId();
        nm.nodeHeartbeat(am0.getApplicationAttemptId(), amContainerId.getContainerId(), ContainerState.COMPLETE);
        rm.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm.drainEvents();
        long memorySeconds = 0L;
        long vcoreSeconds = 0L;
        if (keepRunningContainers) {
            for (RMContainer c : rmContainers) {
                if (c.getContainerId().equals((Object)amContainerId)) {
                    ru = this.calculateContainerResourceMetrics(c);
                    memorySeconds += ru.getMemorySeconds();
                    vcoreSeconds += ru.getVcoreSeconds();
                    continue;
                }
                Assert.assertTrue((String)"After first attempt failed, remaining container should still be running. ", (boolean)c.getContainerState().equals((Object)ContainerState.RUNNING));
            }
        } else {
            for (RMContainer c : rmContainers) {
                this.waitforContainerCompletion(rm, nm, amContainerId, c);
                ru = this.calculateContainerResourceMetrics(c);
                memorySeconds += ru.getMemorySeconds();
                vcoreSeconds += ru.getVcoreSeconds();
            }
        }
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt2 = app.getCurrentAppAttempt();
        Assert.assertFalse((boolean)attempt2.getAppAttemptId().equals((Object)am0.getApplicationAttemptId()));
        rm.waitForState(attempt2.getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        nm.nodeHeartbeat(true);
        MockAM am1 = rm.sendAMLaunched(attempt2.getAppAttemptId());
        am1.registerAppAttempt();
        rm.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
        am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
        nm.nodeHeartbeat(true);
        containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (containers.size() != NUM_CONTAINERS) {
            nm.nodeHeartbeat(true);
            containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(200L);
        }
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        rmContainers = rm.scheduler.getSchedulerAppInfo(attempt2.getAppAttemptId()).getLiveContainers();
        amContainerId = app.getCurrentAppAttempt().getMasterContainer().getId();
        nm.nodeHeartbeat(am0.getApplicationAttemptId(), amContainerId.getContainerId(), ContainerState.COMPLETE);
        MockRM.finishAMAndVerifyAppState(app, rm, nm, am1);
        for (RMContainer c : rmContainers) {
            this.waitforContainerCompletion(rm, nm, amContainerId, c);
            AggregateAppResourceUsage ru2 = this.calculateContainerResourceMetrics(c);
            memorySeconds += ru2.getMemorySeconds();
            vcoreSeconds += ru2.getVcoreSeconds();
        }
        RMAppMetrics rmAppMetrics = app.getRMAppMetrics();
        Assert.assertEquals((String)"Unexpected MemorySeconds value", (long)memorySeconds, (long)rmAppMetrics.getMemorySeconds());
        Assert.assertEquals((String)"Unexpected VcoreSeconds value", (long)vcoreSeconds, (long)rmAppMetrics.getVcoreSeconds());
        rm.stop();
    }

    private void waitforContainerCompletion(MockRM rm, MockNM nm, ContainerId amContainerId, RMContainer container) throws Exception {
        ContainerId containerId = container.getContainerId();
        if (null != rm.scheduler.getRMContainer(containerId)) {
            if (containerId.equals((Object)amContainerId)) {
                rm.waitForState(nm, containerId, RMContainerState.COMPLETED);
            } else {
                rm.waitForState(nm, containerId, RMContainerState.KILLED);
            }
        } else {
            rm.drainEvents();
        }
    }

    private AggregateAppResourceUsage calculateContainerResourceMetrics(RMContainer rmContainer) {
        Resource resource = rmContainer.getContainer().getResource();
        long usedMillis = rmContainer.getFinishTime() - rmContainer.getCreationTime();
        long memorySeconds = resource.getMemorySize() * usedMillis / 1000L;
        long vcoreSeconds = (long)resource.getVirtualCores() * usedMillis / 1000L;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(ResourceInformation.MEMORY_MB.getName(), memorySeconds);
        map.put(ResourceInformation.VCORES.getName(), vcoreSeconds);
        return new AggregateAppResourceUsage(map);
    }
}

