/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationMasterService {
    private static final Log LOG = LogFactory.getLog(TestApplicationMasterService.class);
    private final int GB = 1024;
    private static YarnConfiguration conf;
    private static AtomicInteger beforeRegCount;
    private static AtomicInteger afterRegCount;
    private static AtomicInteger beforeAllocCount;
    private static AtomicInteger afterAllocCount;
    private static AtomicInteger beforeFinishCount;
    private static AtomicInteger afterFinishCount;
    private static AtomicInteger initCount;

    @Before
    public void setup() {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
    }

    @Test(timeout=300000L)
    public void testApplicationMasterInterceptor() throws Exception {
        conf.set("yarn.resourcemanager.application-master-service.processors", TestInterceptor1.class.getName() + "," + TestInterceptor2.class.getName());
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        int allocCount = 0;
        am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        ++allocCount;
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
            ++allocCount;
        }
        Container allocatedContainer = (Container)alloc1Response.getAllocatedContainers().get(0);
        ContainerTokenIdentifier tokenId = BuilderUtils.newContainerTokenIdentifier((Token)allocatedContainer.getContainerToken());
        am1.unregisterAppAttempt();
        Assert.assertEquals((long)1L, (long)beforeRegCount.get());
        Assert.assertEquals((long)1L, (long)afterRegCount.get());
        Assert.assertEquals((long)(allocCount * 2), (long)beforeAllocCount.get());
        Assert.assertEquals((long)(allocCount * 2), (long)afterAllocCount.get());
        Assert.assertEquals((long)1L, (long)beforeFinishCount.get());
        Assert.assertEquals((long)1L, (long)afterFinishCount.get());
        rm.stop();
    }

    @Test(timeout=3000000L)
    public void testRMIdentifierOnContainerAllocation() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        Container allocatedContainer = (Container)alloc1Response.getAllocatedContainers().get(0);
        ContainerTokenIdentifier tokenId = BuilderUtils.newContainerTokenIdentifier((Token)allocatedContainer.getContainerToken());
        Assert.assertEquals((long)MockRM.getClusterTimeStamp(), (long)tokenId.getRMIdentifier());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000000L)
    public void testAllocateResponseIdOverflow() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(2048);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            Assert.assertTrue((boolean)am1.setApplicationLastResponseId(Integer.MAX_VALUE));
            am1.schedule();
            Assert.assertEquals((long)0L, (long)am1.getResponseId());
            am1.schedule();
            Assert.assertEquals((long)1L, (long)am1.getResponseId());
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testInvalidContainerReleaseRequest() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
            AllocateResponse alloc1Response = am1.schedule();
            nm1.nodeHeartbeat(true);
            while (alloc1Response.getAllocatedContainers().size() < 1) {
                LOG.info((Object)"Waiting for containers to be created for app 1...");
                Thread.sleep(1000L);
                alloc1Response = am1.schedule();
            }
            Assert.assertTrue((alloc1Response.getAllocatedContainers().size() > 0 ? 1 : 0) != 0);
            RMApp app2 = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
            MockAM am2 = rm.sendAMLaunched(attempt2.getAppAttemptId());
            am2.registerAppAttempt();
            ContainerId cId = ((Container)alloc1Response.getAllocatedContainers().get(0)).getId();
            am2.addContainerToBeReleased(cId);
            try {
                am2.schedule();
                Assert.fail((String)"Exception was expected!!");
            }
            catch (InvalidContainerReleaseException e) {
                StringBuilder sb = new StringBuilder("Cannot release container : ");
                sb.append(cId.toString());
                sb.append(" not belonging to this application attempt : ");
                sb.append(attempt2.getAppAttemptId().toString());
                Assert.assertTrue((boolean)e.getMessage().contains(sb.toString()));
            }
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    @Test(timeout=1200000L)
    public void testProgressFilter() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        allocateRequest.setProgress(Float.POSITIVE_INFINITY);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 1.0f) {
            LOG.info((Object)"Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(Float.NaN);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 0.0f) {
            LOG.info((Object)"Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(9.0f);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 1.0f) {
            LOG.info((Object)"Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(Float.NEGATIVE_INFINITY);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 0.0f) {
            LOG.info((Object)"Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(0.5f);
        am1.allocate((AllocateRequest)allocateRequest);
        while ((double)attempt1.getProgress() != 0.5) {
            LOG.info((Object)"Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
        allocateRequest.setProgress(-1.0f);
        am1.allocate((AllocateRequest)allocateRequest);
        while (attempt1.getProgress() != 0.0f) {
            LOG.info((Object)"Waiting for allocate event to be handled ...");
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1200000L)
    public void testFinishApplicationMasterBeforeRegistering() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(2048);
            MockAM am1 = MockRM.launchAM(app1, rm, nm1);
            FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.FAILED, (String)"", (String)"");
            try {
                am1.unregisterAppAttempt(req, false);
                Assert.fail((String)"ApplicationMasterNotRegisteredException should be thrown");
            }
            catch (ApplicationMasterNotRegisteredException e) {
                Assert.assertNotNull((Object)((Object)e));
                Assert.assertNotNull((Object)e.getMessage());
                Assert.assertTrue((boolean)e.getMessage().contains("Application Master is trying to unregister before registering for:"));
            }
            catch (Exception e) {
                Assert.fail((String)"ApplicationMasterNotRegisteredException should be thrown");
            }
            am1.registerAppAttempt();
            am1.unregisterAppAttempt(req, false);
            rm.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FINISHING);
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    @Test(timeout=3000000L)
    public void testResourceTypes() throws Exception {
        HashMap<YarnConfiguration, EnumSet<YarnServiceProtos.SchedulerResourceTypes>> driver = new HashMap<YarnConfiguration, EnumSet<YarnServiceProtos.SchedulerResourceTypes>>();
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration testCapacityDRConf = new YarnConfiguration((Configuration)csconf);
        testCapacityDRConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        YarnConfiguration testCapacityDefConf = new YarnConfiguration();
        testCapacityDefConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        YarnConfiguration testFairDefConf = new YarnConfiguration();
        testFairDefConf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        driver.put(conf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY));
        driver.put(testCapacityDRConf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.CPU, YarnServiceProtos.SchedulerResourceTypes.MEMORY));
        driver.put(testCapacityDefConf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY));
        driver.put(testFairDefConf, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU));
        for (Map.Entry entry : driver.entrySet()) {
            EnumSet expectedValue = (EnumSet)entry.getValue();
            MockRM rm = new MockRM((Configuration)entry.getKey());
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(2048);
            Thread.sleep(1000L);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            RegisterApplicationMasterResponse resp = am1.registerAppAttempt();
            EnumSet types = resp.getSchedulerResourceTypes();
            LOG.info((Object)("types = " + types.toString()));
            Assert.assertEquals((Object)expectedValue, (Object)types);
            rm.stop();
        }
    }

    @Test(timeout=1200000L)
    public void testAllocateAfterUnregister() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.KILLED, (String)"", (String)"");
        am1.unregisterAppAttempt(req, false);
        am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        rm.drainEvents();
        alloc1Response = am1.schedule();
        Assert.assertEquals((long)0L, (long)alloc1Response.getAllocatedContainers().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testInvalidIncreaseDecreaseRequest() throws Exception {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        try (MockRM rm = new MockRM((Configuration)conf);){
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            RegisterApplicationMasterResponse registerResponse = am1.registerAppAttempt();
            this.sentRMContainerLaunched(rm, ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L));
            am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)2048), null)));
            AllocateResponse response = am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)-1), null)));
            Assert.assertEquals((long)1L, (long)response.getUpdateErrors().size());
            Assert.assertEquals((Object)"RESOURCE_OUTSIDE_ALLOWED_RANGE", (Object)((UpdateContainerError)response.getUpdateErrors().get(0)).getReason());
            response = am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.add((Resource)registerResponse.getMaximumResourceCapability(), (Resource)Resources.createResource((int)1)), null)));
            Assert.assertEquals((long)1L, (long)response.getUpdateErrors().size());
            Assert.assertEquals((Object)"RESOURCE_OUTSIDE_ALLOWED_RANGE", (Object)((UpdateContainerError)response.getUpdateErrors().get(0)).getReason());
            response = am1.sendContainerResizingRequest(Arrays.asList(UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Resource)Resources.createResource((int)2048, (int)4), null), UpdateContainerRequest.newInstance((int)0, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attempt1.getAppAttemptId(), (long)1L), (ContainerUpdateType)ContainerUpdateType.DECREASE_RESOURCE, (Resource)Resources.createResource((int)1024, (int)1), null)));
            Assert.assertEquals((long)1L, (long)response.getUpdateErrors().size());
            Assert.assertEquals((Object)"UPDATE_OUTSTANDING_ERROR", (Object)((UpdateContainerError)response.getUpdateErrors().get(0)).getReason());
        }
    }

    @Test(timeout=300000L)
    public void testPriorityInAllocatedResponse() throws Exception {
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        Priority appPriority1 = Priority.newInstance((int)5);
        RMApp app1 = rm.submitApp(2048, appPriority1);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        AllocateRequestPBImpl allocateRequest = new AllocateRequestPBImpl();
        ArrayList release = new ArrayList();
        ArrayList ask = new ArrayList();
        allocateRequest.setReleaseList(release);
        allocateRequest.setAskList(ask);
        AllocateResponse response1 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority1, (Object)response1.getApplicationPriority());
        Priority appPriority2 = Priority.newInstance((int)8);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)app1.getUser());
        rm.getRMAppManager().updateApplicationPriority(ugi, app1.getApplicationId(), appPriority2);
        AllocateResponse response2 = am1.allocate((AllocateRequest)allocateRequest);
        Assert.assertEquals((Object)appPriority2, (Object)response2.getApplicationPriority());
        rm.stop();
    }

    private void sentRMContainerLaunched(MockRM rm, ContainerId containerId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMContainer rmContainer = cs.getRMContainer(containerId);
        if (rmContainer != null) {
            rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        } else {
            Assert.fail((String)"Cannot find RMContainer");
        }
    }

    static {
        beforeRegCount = new AtomicInteger(0);
        afterRegCount = new AtomicInteger(0);
        beforeAllocCount = new AtomicInteger(0);
        afterAllocCount = new AtomicInteger(0);
        beforeFinishCount = new AtomicInteger(0);
        afterFinishCount = new AtomicInteger(0);
        initCount = new AtomicInteger(0);
    }

    static class TestInterceptor2
    implements ApplicationMasterServiceProcessor {
        private ApplicationMasterServiceProcessor nextProcessor;

        TestInterceptor2() {
        }

        public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor next) {
            initCount.incrementAndGet();
            this.nextProcessor = next;
        }

        public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
            beforeRegCount.incrementAndGet();
            this.nextProcessor.registerApplicationMaster(applicationAttemptId, request, response);
            afterRegCount.incrementAndGet();
        }

        public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
            beforeAllocCount.incrementAndGet();
            this.nextProcessor.allocate(appAttemptId, request, response);
            afterAllocCount.incrementAndGet();
        }

        public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
            beforeFinishCount.incrementAndGet();
            this.nextProcessor.finishApplicationMaster(applicationAttemptId, request, response);
            afterFinishCount.incrementAndGet();
        }
    }

    static class TestInterceptor1
    implements ApplicationMasterServiceProcessor {
        private ApplicationMasterServiceProcessor nextProcessor;

        TestInterceptor1() {
        }

        public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor next) {
            initCount.incrementAndGet();
            this.nextProcessor = next;
        }

        public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
            this.nextProcessor.registerApplicationMaster(applicationAttemptId, request, response);
        }

        public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
            beforeAllocCount.incrementAndGet();
            this.nextProcessor.allocate(appAttemptId, request, response);
            afterAllocCount.incrementAndGet();
        }

        public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
            beforeFinishCount.incrementAndGet();
            afterFinishCount.incrementAndGet();
        }
    }
}

