/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.eclipse.jetty.util.log.Log;

public class MockNM {
    private int responseId;
    private NodeId nodeId;
    private long memory;
    private int vCores;
    private ResourceTrackerService resourceTracker;
    private int httpPort = 2;
    private MasterKey currentContainerTokenMasterKey;
    private MasterKey currentNMTokenMasterKey;
    private String version;
    private Map<ContainerId, ContainerStatus> containerStats = new HashMap<ContainerId, ContainerStatus>();
    private Map<ApplicationId, AppCollectorData> registeringCollectors = new ConcurrentHashMap<ApplicationId, AppCollectorData>();

    public MockNM(String nodeIdStr, int memory, ResourceTrackerService resourceTracker) {
        this(nodeIdStr, memory, Math.max(1, memory * 8 / 8192), resourceTracker);
    }

    public MockNM(String nodeIdStr, int memory, int vcores, ResourceTrackerService resourceTracker) {
        this(nodeIdStr, memory, vcores, resourceTracker, YarnVersionInfo.getVersion());
    }

    public MockNM(String nodeIdStr, int memory, int vcores, ResourceTrackerService resourceTracker, String version) {
        this.memory = memory;
        this.vCores = vcores;
        this.resourceTracker = resourceTracker;
        this.version = version;
        String[] splits = nodeIdStr.split(":");
        this.nodeId = BuilderUtils.newNodeId((String)splits[0], (int)Integer.parseInt(splits[1]));
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setResourceTrackerService(ResourceTrackerService resourceTracker) {
        this.resourceTracker = resourceTracker;
    }

    public void containerStatus(ContainerStatus containerStatus) throws Exception {
        HashMap<ApplicationId, List<ContainerStatus>> conts = new HashMap<ApplicationId, List<ContainerStatus>>();
        conts.put(containerStatus.getContainerId().getApplicationAttemptId().getApplicationId(), Arrays.asList(containerStatus));
        this.nodeHeartbeat(conts, true);
    }

    public void containerIncreaseStatus(Container container) throws Exception {
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)container.getId(), (ContainerState)ContainerState.RUNNING, (String)"Success", (int)0, (Resource)container.getResource());
        List<Container> increasedConts = Collections.singletonList(container);
        this.nodeHeartbeat(Collections.singletonList(containerStatus), increasedConts, true, this.responseId);
    }

    public void addRegisteringCollector(ApplicationId appId, AppCollectorData data) {
        this.registeringCollectors.put(appId, data);
    }

    public Map<ApplicationId, AppCollectorData> getRegisteringCollectors() {
        return this.registeringCollectors;
    }

    public RegisterNodeManagerResponse registerNode() throws Exception {
        return this.registerNode(null, null);
    }

    public RegisterNodeManagerResponse registerNode(List<ApplicationId> runningApplications) throws Exception {
        return this.registerNode(null, runningApplications);
    }

    public RegisterNodeManagerResponse registerNode(List<NMContainerStatus> containerReports, List<ApplicationId> runningApplications) throws Exception {
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        req.setNodeId(this.nodeId);
        req.setHttpPort(this.httpPort);
        Resource resource = BuilderUtils.newResource((long)this.memory, (int)this.vCores);
        req.setResource(resource);
        req.setContainerStatuses(containerReports);
        req.setNMVersion(this.version);
        req.setRunningApplications(runningApplications);
        RegisterNodeManagerResponse registrationResponse = this.resourceTracker.registerNodeManager(req);
        this.currentContainerTokenMasterKey = registrationResponse.getContainerTokenMasterKey();
        this.currentNMTokenMasterKey = registrationResponse.getNMTokenMasterKey();
        Resource newResource = registrationResponse.getResource();
        if (newResource != null) {
            this.memory = (int)newResource.getMemorySize();
            this.vCores = newResource.getVirtualCores();
        }
        this.containerStats.clear();
        if (containerReports != null) {
            for (NMContainerStatus report : containerReports) {
                if (report.getContainerState() == ContainerState.COMPLETE) continue;
                this.containerStats.put(report.getContainerId(), ContainerStatus.newInstance((ContainerId)report.getContainerId(), (ContainerState)report.getContainerState(), (String)report.getDiagnostics(), (int)report.getContainerExitStatus()));
            }
        }
        this.responseId = 0;
        return registrationResponse;
    }

    public NodeHeartbeatResponse nodeHeartbeat(boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(Collections.emptyList(), Collections.emptyList(), isHealthy, this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(ApplicationAttemptId attemptId, long containerId, ContainerState containerState) throws Exception {
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId, (long)containerId), (ContainerState)containerState, (String)"Success", (int)0, (Resource)BuilderUtils.newResource((long)this.memory, (int)this.vCores));
        ArrayList<ContainerStatus> containerStatusList = new ArrayList<ContainerStatus>(1);
        containerStatusList.add(containerStatus);
        Log.getLog().info("ContainerStatus: " + containerStatus, new Object[0]);
        return this.nodeHeartbeat(containerStatusList, Collections.emptyList(), true, this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(Map<ApplicationId, List<ContainerStatus>> conts, boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(conts, isHealthy, this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(Map<ApplicationId, List<ContainerStatus>> conts, boolean isHealthy, int resId) throws Exception {
        ArrayList<ContainerStatus> updatedStats = new ArrayList<ContainerStatus>();
        for (List<ContainerStatus> stats : conts.values()) {
            updatedStats.addAll(stats);
        }
        return this.nodeHeartbeat(updatedStats, Collections.emptyList(), isHealthy, resId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(List<ContainerStatus> updatedStats, boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(updatedStats, Collections.emptyList(), isHealthy, this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(List<ContainerStatus> updatedStats, List<Container> increasedConts, boolean isHealthy, int resId) throws Exception {
        Resource newResource;
        NodeHeartbeatRequest req = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeStatus status = (NodeStatus)Records.newRecord(NodeStatus.class);
        status.setResponseId(resId);
        status.setNodeId(this.nodeId);
        ArrayList<ContainerId> completedContainers = new ArrayList<ContainerId>();
        for (ContainerStatus stat : updatedStats) {
            if (stat.getState() == ContainerState.COMPLETE) {
                completedContainers.add(stat.getContainerId());
            }
            this.containerStats.put(stat.getContainerId(), stat);
        }
        status.setContainersStatuses(new ArrayList<ContainerStatus>(this.containerStats.values()));
        for (ContainerId cid : completedContainers) {
            this.containerStats.remove(cid);
        }
        status.setIncreasedContainers(increasedConts);
        NodeHealthStatus healthStatus = (NodeHealthStatus)Records.newRecord(NodeHealthStatus.class);
        healthStatus.setHealthReport("");
        healthStatus.setIsNodeHealthy(isHealthy);
        healthStatus.setLastHealthReportTime(1L);
        status.setNodeHealthStatus(healthStatus);
        req.setNodeStatus(status);
        req.setLastKnownContainerTokenMasterKey(this.currentContainerTokenMasterKey);
        req.setLastKnownNMTokenMasterKey(this.currentNMTokenMasterKey);
        req.setRegisteringCollectors(this.registeringCollectors);
        NodeHeartbeatResponse heartbeatResponse = this.resourceTracker.nodeHeartbeat(req);
        this.responseId = heartbeatResponse.getResponseId();
        MasterKey masterKeyFromRM = heartbeatResponse.getContainerTokenMasterKey();
        if (masterKeyFromRM != null && masterKeyFromRM.getKeyId() != this.currentContainerTokenMasterKey.getKeyId()) {
            this.currentContainerTokenMasterKey = masterKeyFromRM;
        }
        if ((masterKeyFromRM = heartbeatResponse.getNMTokenMasterKey()) != null && masterKeyFromRM.getKeyId() != this.currentNMTokenMasterKey.getKeyId()) {
            this.currentNMTokenMasterKey = masterKeyFromRM;
        }
        if ((newResource = heartbeatResponse.getResource()) != null) {
            this.memory = newResource.getMemorySize();
            this.vCores = newResource.getVirtualCores();
        }
        return heartbeatResponse;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getvCores() {
        return this.vCores;
    }

    public String getVersion() {
        return this.version;
    }

    public void setResponseId(int id) {
        this.responseId = id;
    }
}

