/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSQueue
implements Queue,
Schedulable {
    private static final Log LOG = LogFactory.getLog((String)FSQueue.class.getName());
    private Resource fairShare = Resources.createResource((int)0, (int)0);
    private Resource steadyFairShare = Resources.createResource((int)0, (int)0);
    private final String name;
    protected final FairScheduler scheduler;
    private final FSQueueMetrics metrics;
    protected final FSParentQueue parent;
    protected final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected SchedulingPolicy policy = SchedulingPolicy.DEFAULT_POLICY;
    private long fairSharePreemptionTimeout = Long.MAX_VALUE;
    private long minSharePreemptionTimeout = Long.MAX_VALUE;
    private float fairSharePreemptionThreshold = 0.5f;

    public FSQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        this.name = name;
        this.scheduler = scheduler;
        this.metrics = FSQueueMetrics.forQueue(this.getName(), parent, true, scheduler.getConf());
        this.metrics.setMinShare(this.getMinShare());
        this.metrics.setMaxShare(this.getMaxShare());
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    public SchedulingPolicy getPolicy() {
        return this.policy;
    }

    public FSParentQueue getParent() {
        return this.parent;
    }

    protected void throwPolicyDoesnotApplyException(SchedulingPolicy policy) throws AllocationConfigurationException {
        throw new AllocationConfigurationException("SchedulingPolicy " + policy + " does not apply to queue " + this.getName());
    }

    public abstract void setPolicy(SchedulingPolicy var1) throws AllocationConfigurationException;

    @Override
    public ResourceWeights getWeights() {
        return this.scheduler.getAllocationConfiguration().getQueueWeight(this.getName());
    }

    @Override
    public Resource getMinShare() {
        return this.scheduler.getAllocationConfiguration().getMinResources(this.getName());
    }

    @Override
    public Resource getMaxShare() {
        return this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public Priority getPriority() {
        Priority p = (Priority)this.recordFactory.newRecordInstance(Priority.class);
        p.setPriority(1);
        return p;
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.getQueueName());
        if (this.scheduler.getClusterResource().getMemorySize() == 0L) {
            queueInfo.setCapacity(0.0f);
        } else {
            queueInfo.setCapacity((float)this.getFairShare().getMemorySize() / (float)this.scheduler.getClusterResource().getMemorySize());
        }
        if (this.getFairShare().getMemorySize() == 0L) {
            queueInfo.setCurrentCapacity(0.0f);
        } else {
            queueInfo.setCurrentCapacity((float)this.getResourceUsage().getMemorySize() / (float)this.getFairShare().getMemorySize());
        }
        ArrayList<QueueInfo> childQueueInfos = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            List<FSQueue> childQueues = this.getChildQueues();
            for (FSQueue child : childQueues) {
                childQueueInfos.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueueInfos);
        queueInfo.setQueueState(QueueState.RUNNING);
        queueInfo.setQueueStatistics(this.getQueueStatistics());
        return queueInfo;
    }

    public QueueStatistics getQueueStatistics() {
        QueueStatistics stats = (QueueStatistics)this.recordFactory.newRecordInstance(QueueStatistics.class);
        stats.setNumAppsSubmitted((long)this.getMetrics().getAppsSubmitted());
        stats.setNumAppsRunning((long)this.getMetrics().getAppsRunning());
        stats.setNumAppsPending((long)this.getMetrics().getAppsPending());
        stats.setNumAppsCompleted((long)this.getMetrics().getAppsCompleted());
        stats.setNumAppsKilled((long)this.getMetrics().getAppsKilled());
        stats.setNumAppsFailed((long)this.getMetrics().getAppsFailed());
        stats.setNumActiveUsers((long)this.getMetrics().getActiveUsers());
        stats.setAvailableMemoryMB(this.getMetrics().getAvailableMB());
        stats.setAllocatedMemoryMB(this.getMetrics().getAllocatedMB());
        stats.setPendingMemoryMB(this.getMetrics().getPendingMB());
        stats.setReservedMemoryMB(this.getMetrics().getReservedMB());
        stats.setAvailableVCores((long)this.getMetrics().getAvailableVirtualCores());
        stats.setAllocatedVCores((long)this.getMetrics().getAllocatedVirtualCores());
        stats.setPendingVCores((long)this.getMetrics().getPendingVirtualCores());
        stats.setReservedVCores((long)this.getMetrics().getReservedVirtualCores());
        return stats;
    }

    @Override
    public FSQueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Resource getFairShare() {
        return this.fairShare;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
        this.metrics.setFairShare(fairShare);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated fairShare for " + this.getName() + " is " + fairShare));
        }
    }

    public Resource getSteadyFairShare() {
        return this.steadyFairShare;
    }

    public void setSteadyFairShare(Resource steadyFairShare) {
        this.steadyFairShare = steadyFairShare;
        this.metrics.setSteadyFairShare(steadyFairShare);
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.scheduler.getAllocationConfiguration().hasAccess(this.name, acl, user);
    }

    public long getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    public void setFairSharePreemptionTimeout(long fairSharePreemptionTimeout) {
        this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
    }

    public long getMinSharePreemptionTimeout() {
        return this.minSharePreemptionTimeout;
    }

    public void setMinSharePreemptionTimeout(long minSharePreemptionTimeout) {
        this.minSharePreemptionTimeout = minSharePreemptionTimeout;
    }

    public float getFairSharePreemptionThreshold() {
        return this.fairSharePreemptionThreshold;
    }

    public void setFairSharePreemptionThreshold(float fairSharePreemptionThreshold) {
        this.fairSharePreemptionThreshold = fairSharePreemptionThreshold;
    }

    public abstract void recomputeShares();

    public void updatePreemptionVariables() {
        this.minSharePreemptionTimeout = this.scheduler.getAllocationConfiguration().getMinSharePreemptionTimeout(this.getName());
        if (this.minSharePreemptionTimeout == -1L && this.parent != null) {
            this.minSharePreemptionTimeout = this.parent.getMinSharePreemptionTimeout();
        }
        this.fairSharePreemptionTimeout = this.scheduler.getAllocationConfiguration().getFairSharePreemptionTimeout(this.getName());
        if (this.fairSharePreemptionTimeout == -1L && this.parent != null) {
            this.fairSharePreemptionTimeout = this.parent.getFairSharePreemptionTimeout();
        }
        this.fairSharePreemptionThreshold = this.scheduler.getAllocationConfiguration().getFairSharePreemptionThreshold(this.getName());
        if (this.fairSharePreemptionThreshold < 0.0f && this.parent != null) {
            this.fairSharePreemptionThreshold = this.parent.getFairSharePreemptionThreshold();
        }
    }

    public abstract List<FSQueue> getChildQueues();

    public abstract void collectSchedulerApplications(Collection<ApplicationAttemptId> var1);

    public abstract int getNumRunnableApps();

    protected boolean assignContainerPreCheck(FSSchedulerNode node) {
        return Resources.fitsIn((Resource)this.getResourceUsage(), (Resource)this.scheduler.getAllocationConfiguration().getMaxResources(this.getName())) && node.getReservedContainer() == null;
    }

    public boolean isActive() {
        return this.getNumRunnableApps() > 0;
    }

    public String toString() {
        return String.format("[%s, demand=%s, running=%s, share=%s, w=%s]", this.getName(), this.getDemand(), this.getResourceUsage(), this.fairShare, this.getWeights());
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return null;
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return null;
    }

    @Override
    public void incPendingResource(String nodeLabel, Resource resourceToInc) {
    }

    @Override
    public void decPendingResource(String nodeLabel, Resource resourceToDec) {
    }

    @Override
    public void incReservedResource(String nodeLabel, Resource resourceToInc) {
    }

    @Override
    public void decReservedResource(String nodeLabel, Resource resourceToDec) {
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return null;
    }

    public boolean fitsInMaxShare(Resource additionalResource) {
        Resource usagePlusAddition = Resources.add((Resource)this.getResourceUsage(), (Resource)additionalResource);
        if (!Resources.fitsIn((Resource)usagePlusAddition, (Resource)this.getMaxShare())) {
            return false;
        }
        FSParentQueue parentQueue = this.getParent();
        if (parentQueue != null) {
            return parentQueue.fitsInMaxShare(additionalResource);
        }
        return true;
    }
}

