/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class StageAllocatorGreedyRLE
implements StageAllocator {
    private final boolean allocateLeft;

    public StageAllocatorGreedyRLE(boolean allocateLeft) {
        this.allocateLeft = allocateLeft;
    }

    @Override
    public Map<ReservationInterval, Resource> computeStageAllocation(Plan plan, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications, ReservationRequest rr, long stageEarliestStart, long stageDeadline, String user, ReservationId oldId) throws PlanningException {
        long step;
        if (stageEarliestStart + rr.getDuration() > stageDeadline) {
            return null;
        }
        HashMap<ReservationInterval, Resource> allocationRequests = new HashMap<ReservationInterval, Resource>();
        Resource totalCapacity = plan.getTotalCapacity();
        Resource sizeOfGang = Resources.multiply((Resource)rr.getCapability(), (double)rr.getConcurrency());
        long dur = rr.getDuration();
        if (dur % (step = plan.getStep()) != 0L) {
            dur += step - dur % step;
        }
        int gangsToPlace = rr.getNumContainers() / rr.getConcurrency();
        RLESparseResourceAllocation netRLERes = plan.getAvailableResourceOverTime(user, oldId, stageEarliestStart, stageDeadline);
        netRLERes = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), totalCapacity, netRLERes, planModifications, RLESparseResourceAllocation.RLEOperator.subtract, stageEarliestStart, stageDeadline);
        while (gangsToPlace > 0 && stageEarliestStart + dur <= stageDeadline) {
            int maxGang = gangsToPlace;
            long minPoint = -1L;
            NavigableMap<Long, Resource> partialMap = netRLERes.getRangeOverlapping(stageEarliestStart, stageDeadline).getCumulative();
            if (!this.allocateLeft) {
                partialMap = partialMap.descendingMap();
            }
            Iterator netIt = partialMap.entrySet().iterator();
            long oldT = stageDeadline;
            while (maxGang > 0 && netIt.hasNext()) {
                Resource curAvailRes;
                long t;
                Map.Entry e = netIt.next();
                if (this.allocateLeft) {
                    t = Math.max((Long)e.getKey(), stageEarliestStart);
                    curAvailRes = (Resource)e.getValue();
                } else {
                    t = oldT;
                    oldT = (Long)e.getKey();
                    curAvailRes = partialMap.higherEntry(t).getValue();
                }
                if (curAvailRes == null) continue;
                if (this.exitCondition(t, stageEarliestStart, stageDeadline, dur)) break;
                int curMaxGang = (int)Math.floor(Resources.divide((ResourceCalculator)plan.getResourceCalculator(), (Resource)totalCapacity, (Resource)curAvailRes, (Resource)sizeOfGang));
                if ((curMaxGang = Math.min(gangsToPlace, curMaxGang)) > maxGang) continue;
                maxGang = curMaxGang;
                minPoint = t;
            }
            gangsToPlace = this.trackProgress(planModifications, rr, stageEarliestStart, stageDeadline, allocationRequests, dur, gangsToPlace, maxGang);
            if (this.allocateLeft) {
                if (partialMap.higherKey(minPoint) == null) {
                    stageEarliestStart += dur;
                    continue;
                }
                stageEarliestStart = Math.min(partialMap.higherKey(minPoint), stageEarliestStart + dur);
                continue;
            }
            if (partialMap.higherKey(minPoint) == null) {
                stageDeadline -= dur;
                continue;
            }
            stageDeadline = Math.max(partialMap.higherKey(minPoint), stageDeadline - dur);
        }
        if (gangsToPlace == 0) {
            return allocationRequests;
        }
        for (Map.Entry tempAllocation : allocationRequests.entrySet()) {
            planModifications.removeInterval((ReservationInterval)tempAllocation.getKey(), (Resource)tempAllocation.getValue());
        }
        return null;
    }

    private int trackProgress(RLESparseResourceAllocation planModifications, ReservationRequest rr, long stageEarliestStart, long stageDeadline, Map<ReservationInterval, Resource> allocationRequests, long dur, int gangsToPlace, int maxGang) {
        if (maxGang > 0) {
            gangsToPlace -= maxGang;
            ReservationInterval reservationInt = this.computeReservationInterval(stageEarliestStart, stageDeadline, dur);
            Resource reservationRes = Resources.multiply((Resource)rr.getCapability(), (double)(rr.getConcurrency() * maxGang));
            planModifications.addInterval(reservationInt, reservationRes);
            allocationRequests.put(reservationInt, reservationRes);
        }
        return gangsToPlace;
    }

    private ReservationInterval computeReservationInterval(long stageEarliestStart, long stageDeadline, long dur) {
        ReservationInterval reservationInt = this.allocateLeft ? new ReservationInterval(stageEarliestStart, stageEarliestStart + dur) : new ReservationInterval(stageDeadline - dur, stageDeadline);
        return reservationInt;
    }

    private boolean exitCondition(long t, long stageEarliestStart, long stageDeadline, long dur) {
        if (this.allocateLeft) {
            return t >= stageEarliestStart + dur;
        }
        return t < stageDeadline - dur;
    }
}

