/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMAppAttemptBlock;
import org.apache.hadoop.yarn.server.webapp.AppsBlock;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class RMAppsBlock
extends AppsBlock {
    private ResourceManager rm;

    @Inject
    RMAppsBlock(ResourceManager rm, ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(appBaseProt, ctx);
        this.rm = rm;
    }

    protected void renderData(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI").th(".blacklisted", "Blacklisted Nodes")._())._()).tbody();
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (ApplicationReport appReport : this.appReports) {
            String trackingURL;
            if (!this.reqAppStates.isEmpty() && !this.reqAppStates.contains(appReport.getYarnApplicationState())) continue;
            AppInfo app = new AppInfo(appReport);
            String blacklistedNodesCount = "N/A";
            Set<String> nodes = RMAppAttemptBlock.getBlacklistedNodes(this.rm, ConverterUtils.toApplicationAttemptId((String)app.getCurrentAppAttemptId()));
            if (nodes != null) {
                blacklistedNodesCount = String.valueOf(nodes.size());
            }
            String percent = String.format("%.1f", Float.valueOf(app.getProgress()));
            appsTableData.append("[\"<a href='").append(this.url(new String[]{"app", app.getAppId()})).append("'>").append(app.getAppId()).append("</a>\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getUser()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getType()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)app.getQueue()))).append("\",\"").append(app.getStartedTime()).append("\",\"").append(app.getFinishedTime()).append("\",\"").append((Object)(app.getAppState() == null ? "N/A" : app.getAppState())).append("\",\"").append(app.getFinalAppStatus()).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a ");
            String string = trackingURL = app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? null : app.getTrackingUrl();
            String trackingUI = app.getTrackingUrl() == null || app.getTrackingUrl().equals("N/A") ? "Unassigned" : (app.getAppState() == YarnApplicationState.FINISHED || app.getAppState() == YarnApplicationState.FAILED || app.getAppState() == YarnApplicationState.KILLED ? "History" : "ApplicationMaster");
            appsTableData.append(trackingURL == null ? "#" : "href='" + trackingURL).append("'>").append(trackingUI).append("</a>\",").append("\"").append(blacklistedNodesCount).append("\"],\n");
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var appsTableData=" + appsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

