/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacitySchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestCapacitySchedulerPlanFollower {
    static final int GB = 1024;
    private Clock mClock = null;
    private CapacityScheduler scheduler = null;
    private RMContext rmContext;
    private RMContext spyRMContext;
    private CapacitySchedulerContext csContext;
    private ReservationAgent mAgent;
    private Plan plan;
    private Resource minAlloc = Resource.newInstance((int)1024, (int)1);
    private Resource maxAlloc = Resource.newInstance((int)8192, (int)8);
    private ResourceCalculator res = new DefaultResourceCalculator();
    private CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        CapacityScheduler spyCs = new CapacityScheduler();
        this.scheduler = (CapacityScheduler)Mockito.spy((Object)spyCs);
        this.rmContext = TestUtils.getMockRMContext();
        this.spyRMContext = (RMContext)Mockito.spy((Object)this.rmContext);
        ConcurrentMap spyApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)Matchers.any())).thenReturn(null);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get((ApplicationId)Matchers.any());
        Mockito.when((Object)this.spyRMContext.getRMApps()).thenReturn((Object)spyApps);
        Mockito.when((Object)this.spyRMContext.getScheduler()).thenReturn((Object)this.scheduler);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(csConf);
        this.scheduler.setConf((Configuration)csConf);
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)csConf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)this.minAlloc);
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)this.maxAlloc);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.scheduler.getClusterResource()).thenReturn((Object)Resources.createResource((int)128000, (int)125));
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)csConf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)this.csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        this.scheduler.setRMContext(this.spyRMContext);
        this.scheduler.init((Configuration)csConf);
        this.scheduler.start();
        this.setupPlanFollower();
    }

    private void setupPlanFollower() throws Exception {
        ReservationSystemTestUtil testUtil = new ReservationSystemTestUtil();
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.mAgent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        String reservationQ = testUtil.getFullReservationQueueName();
        CapacitySchedulerConfiguration csConf = this.scheduler.getConfiguration();
        csConf.setReservationWindow(reservationQ, 20L);
        csConf.setMaximumCapacity(reservationQ, 40.0f);
        csConf.setAverageCapacity(reservationQ, 20.0f);
        this.policy.init(reservationQ, (Configuration)csConf);
    }

    @Test
    public void testWithMoveOnExpiry() throws PlanningException, InterruptedException, AccessControlException {
        this.testPlanFollower(true);
    }

    @Test
    public void testWithKillOnExpiry() throws PlanningException, InterruptedException, AccessControlException {
        this.testPlanFollower(false);
    }

    private void testPlanFollower(boolean isMove) throws PlanningException, InterruptedException, AccessControlException {
        this.plan = new InMemoryPlan(this.scheduler.getRootQueueMetrics(), (SharingPolicy)this.policy, this.mAgent, this.scheduler.getClusterResource(), 1L, this.res, this.scheduler.getMinimumResourceCapability(), this.maxAlloc, "dedicated", null, isMove);
        long ts = System.currentTimeMillis();
        ReservationId r1 = ReservationId.newInstance((long)ts, (long)1L);
        int[] f1 = new int[]{10, 10, 10, 10, 10};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r1, null, "u3", "dedicated", 0L, (long)(0 + f1.length), ReservationSystemTestUtil.generateAllocation(0L, 1L, f1), this.res, this.minAlloc)));
        ReservationId r2 = ReservationId.newInstance((long)ts, (long)2L);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r2, null, "u3", "dedicated", 3L, (long)(3 + f1.length), ReservationSystemTestUtil.generateAllocation(3L, 1L, f1), this.res, this.minAlloc)));
        ReservationId r3 = ReservationId.newInstance((long)ts, (long)3L);
        int[] f2 = new int[]{0, 10, 20, 10, 0};
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(r3, null, "u4", "dedicated", 10L, (long)(10 + f2.length), ReservationSystemTestUtil.generateAllocation(10L, 1L, f2), this.res, this.minAlloc)));
        CapacitySchedulerPlanFollower planFollower = new CapacitySchedulerPlanFollower();
        planFollower.init(this.mClock, (ResourceScheduler)this.scheduler, Collections.singletonList(this.plan));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)0L);
        planFollower.run();
        CSQueue defQ = this.scheduler.getQueue("dedicated-default");
        CSQueue q = this.scheduler.getQueue(r1.toString());
        Assert.assertNotNull((Object)q);
        String user_0 = "test-user";
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId_0 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, q.getQueueName(), user_0);
        this.scheduler.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent appAttemptAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId_0, false);
        this.scheduler.handle((SchedulerEvent)appAttemptAddedEvent);
        Assert.assertEquals((long)0L, (long)defQ.getNumApplications());
        Assert.assertEquals((double)0.1, (double)q.getCapacity(), (double)0.01);
        Assert.assertEquals((double)0.1, (double)q.getMaximumCapacity(), (double)1.0);
        Assert.assertEquals((long)1L, (long)q.getNumApplications());
        CSQueue q2 = this.scheduler.getQueue(r2.toString());
        Assert.assertNull((Object)q2);
        CSQueue q3 = this.scheduler.getQueue(r3.toString());
        Assert.assertNull((Object)q3);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)3L);
        planFollower.run();
        Assert.assertEquals((long)0L, (long)defQ.getNumApplications());
        q = this.scheduler.getQueue(r1.toString());
        Assert.assertNotNull((Object)q);
        Assert.assertEquals((double)0.1, (double)q.getCapacity(), (double)0.01);
        Assert.assertEquals((double)0.1, (double)q.getMaximumCapacity(), (double)1.0);
        Assert.assertEquals((long)1L, (long)q.getNumApplications());
        q2 = this.scheduler.getQueue(r2.toString());
        Assert.assertNotNull((Object)q2);
        Assert.assertEquals((double)0.1, (double)q.getCapacity(), (double)0.01);
        Assert.assertEquals((double)0.1, (double)q.getMaximumCapacity(), (double)1.0);
        q3 = this.scheduler.getQueue(r3.toString());
        Assert.assertNull((Object)q3);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)10L);
        planFollower.run();
        q = this.scheduler.getQueue(r1.toString());
        if (isMove) {
            Assert.assertEquals((long)1L, (long)defQ.getNumApplications());
            Assert.assertNull((Object)q);
        } else {
            Assert.assertEquals((long)0L, (long)defQ.getNumApplications());
            Assert.assertNotNull((Object)q);
            AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = new AppAttemptRemovedSchedulerEvent(appAttemptId_0, RMAppAttemptState.KILLED, false);
            this.scheduler.handle((SchedulerEvent)appAttemptRemovedEvent);
        }
        q2 = this.scheduler.getQueue(r2.toString());
        Assert.assertNull((Object)q2);
        q3 = this.scheduler.getQueue(r3.toString());
        Assert.assertNotNull((Object)q3);
        Assert.assertEquals((double)0.0, (double)q3.getCapacity(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)q3.getMaximumCapacity(), (double)1.0);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)11L);
        planFollower.run();
        if (isMove) {
            Assert.assertEquals((long)1L, (long)defQ.getNumApplications());
        } else {
            Assert.assertEquals((long)0L, (long)defQ.getNumApplications());
        }
        q = this.scheduler.getQueue(r1.toString());
        Assert.assertNull((Object)q);
        q2 = this.scheduler.getQueue(r2.toString());
        Assert.assertNull((Object)q2);
        q3 = this.scheduler.getQueue(r3.toString());
        Assert.assertNotNull((Object)q3);
        Assert.assertEquals((double)0.1, (double)q3.getCapacity(), (double)0.01);
        Assert.assertEquals((double)0.1, (double)q3.getMaximumCapacity(), (double)1.0);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)12L);
        planFollower.run();
        q = this.scheduler.getQueue(r1.toString());
        Assert.assertNull((Object)q);
        q2 = this.scheduler.getQueue(r2.toString());
        Assert.assertNull((Object)q2);
        q3 = this.scheduler.getQueue(r3.toString());
        Assert.assertNotNull((Object)q3);
        Assert.assertEquals((double)0.2, (double)q3.getCapacity(), (double)0.01);
        Assert.assertEquals((double)0.2, (double)q3.getMaximumCapacity(), (double)1.0);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)16L);
        planFollower.run();
        q = this.scheduler.getQueue(r1.toString());
        Assert.assertNull((Object)q);
        q2 = this.scheduler.getQueue(r2.toString());
        Assert.assertNull((Object)q2);
        q3 = this.scheduler.getQueue(r3.toString());
        Assert.assertNull((Object)q3);
        Assert.assertTrue(((double)defQ.getCapacity() > 0.9 ? 1 : 0) != 0);
    }

    public static ApplicationACLsManager mockAppACLsManager() {
        Configuration conf = new Configuration();
        return new ApplicationACLsManager(conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

