/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicy {
    static final long TS = 3141592653L;
    int appAlloc = 0;
    boolean setAMContainer = false;
    float setAMResourcePercent = 0.0f;
    Random rand = null;
    Clock mClock = null;
    Configuration conf = null;
    CapacityScheduler mCS = null;
    EventHandler<ContainerPreemptEvent> mDisp = null;
    ResourceCalculator rc = new DefaultResourceCalculator();
    final ApplicationAttemptId appA = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)0), (int)0);
    final ApplicationAttemptId appB = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)1), (int)0);
    final ApplicationAttemptId appC = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)2), (int)0);
    final ApplicationAttemptId appD = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)3), (int)0);
    final ApplicationAttemptId appE = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)4), (int)0);
    final ArgumentCaptor<ContainerPreemptEvent> evtCaptor = ArgumentCaptor.forClass(ContainerPreemptEvent.class);
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() {
        this.conf = new Configuration(false);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.conf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getCanonicalName());
        this.conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.mCS = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.mCS.getResourceCalculator()).thenReturn((Object)this.rc);
        this.mDisp = (EventHandler)Mockito.mock(EventHandler.class);
        this.rand = new Random();
        long seed = this.rand.nextLong();
        System.out.println(this.name.getMethodName() + " SEED: " + seed);
        this.rand.setSeed(seed);
        this.appAlloc = 0;
    }

    @Test
    public void testIgnore() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testProportionalPreemption() {
        int[][] qData = new int[][]{{100, 10, 40, 20, 30}, {100, 100, 100, 100, 100}, {100, 30, 60, 10, 0}, {45, 20, 5, 20, 0}, {0, 0, 0, 0, 0}, {3, 1, 1, 1, 0}, {-1, 1, 1, 1, 1}, {4, 0, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)16))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testMaxCap() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 45, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testPreemptCycle() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testExpireKill() {
        long killTime = 10000L;
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)0L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)5000L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)10001L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)this.evtCaptor.capture());
        List events = this.evtCaptor.getAllValues();
        for (ContainerPreemptEvent e : events.subList(20, 30)) {
            Assert.assertEquals((Object)this.appC, (Object)e.getAppId());
            Assert.assertEquals((Object)ContainerPreemptEventType.KILL_CONTAINER, (Object)e.getType());
        }
    }

    @Test
    public void testDeadzone() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 39, 43, 21}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity", 0.1f);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testOverCapacityImbalance() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testNaturalTermination() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 0.1f);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testObserveOnly() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 90, 10, 0}, {80, 10, 20, 50}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", true);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testHierarchical() {
        int[][] qData = new int[][]{{200, 100, 50, 50, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {200, 110, 60, 50, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testZeroGuar() {
        int[][] qData = new int[][]{{200, 100, 0, 99, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {170, 80, 60, 20, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testZeroGuarOverCap() {
        int[][] qData = new int[][]{{200, 100, 0, 99, 0, 100, 100}, {200, 200, 200, 200, 200, 200, 200}, {170, 170, 60, 20, 90, 0, 0}, {85, 50, 30, 10, 10, 20, 20}, {0, 0, 0, 0, 0, 0, 0}, {4, 3, 1, 1, 1, 1, 1}, {-1, -1, 1, 1, 1, -1, 1}, {2, 3, 0, 0, 0, 1, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testHierarchicalLarge() {
        int[][] qData = new int[][]{{400, 200, 60, 140, 100, 70, 30, 100, 10, 90}, {400, 400, 400, 400, 400, 400, 400, 400, 400, 400}, {400, 210, 70, 140, 100, 50, 50, 90, 90, 0}, {10, 0, 0, 0, 0, 0, 0, 0, 0, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appE)));
    }

    @Test
    public void testContainerOrdering() {
        ArrayList<RMContainer> containers = new ArrayList<RMContainer>();
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)10), (int)0);
        RMContainer rm1 = this.mockContainer(appAttId, 5, (Resource)Mockito.mock(Resource.class), 3);
        RMContainer rm2 = this.mockContainer(appAttId, 3, (Resource)Mockito.mock(Resource.class), 3);
        RMContainer rm3 = this.mockContainer(appAttId, 2, (Resource)Mockito.mock(Resource.class), 2);
        RMContainer rm4 = this.mockContainer(appAttId, 1, (Resource)Mockito.mock(Resource.class), 2);
        RMContainer rm5 = this.mockContainer(appAttId, 4, (Resource)Mockito.mock(Resource.class), 1);
        containers.add(rm3);
        containers.add(rm2);
        containers.add(rm1);
        containers.add(rm5);
        containers.add(rm4);
        ProportionalCapacityPreemptionPolicy.sortContainers(containers);
        assert (((RMContainer)containers.get(0)).equals(rm1));
        assert (((RMContainer)containers.get(1)).equals(rm2));
        assert (((RMContainer)containers.get(2)).equals(rm3));
        assert (((RMContainer)containers.get(3)).equals(rm4));
        assert (((RMContainer)containers.get(4)).equals(rm5));
    }

    @Test
    public void testPolicyInitializeAfterSchedulerInitialized() {
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        for (Service service : rm.getRMActiveService().getServices()) {
            if (!(service instanceof SchedulingMonitor)) continue;
            ProportionalCapacityPreemptionPolicy policy = (ProportionalCapacityPreemptionPolicy)((SchedulingMonitor)service).getSchedulingEditPolicy();
            Assert.assertNotNull((Object)policy.getResourceCalculator());
            return;
        }
        Assert.fail((String)"Failed to find SchedulingMonitor service, please check what happened");
    }

    @Test
    public void testSkipAMContainer() {
        int[][] qData = new int[][]{{100, 50, 50}, {100, 100, 100}, {100, 100, 0}, {70, 20, 50}, {0, 0, 0}, {5, 4, 1}, {-1, 1, 1}, {2, 0, 0}};
        this.setAMContainer = true;
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)24))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)24))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        this.setAMContainer = false;
    }

    @Test
    public void testPreemptSkippedAMContainers() {
        int[][] qData = new int[][]{{100, 10, 90}, {100, 100, 100}, {100, 100, 0}, {70, 20, 90}, {0, 0, 0}, {5, 4, 1}, {-1, 5, 5}, {2, 0, 0}};
        this.setAMContainer = true;
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        this.setAMContainer = false;
    }

    @Test
    public void testAMResourcePercentForSkippedAMContainers() {
        int[][] qData = new int[][]{{100, 10, 90}, {100, 100, 100}, {100, 100, 0}, {70, 20, 90}, {0, 0, 0}, {5, 4, 1}, {-1, 5, 5}, {2, 0, 0}};
        this.setAMContainer = true;
        this.setAMResourcePercent = 0.5f;
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        this.setAMContainer = false;
    }

    @Test
    public void testPreemptionWithVCoreResource() {
        int[][] qData = new int[][]{{100, 100, 100}, {5, 1, 1}, {2, 0, 0}};
        String[][] resData = new String[][]{{"100:100", "50:50", "50:50"}, {"10:100", "10:100", "0"}, {"70:20", "70:20", "10:100"}, {"0", "0", "0"}, {"-1", "1:10", "1:10"}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData, resData, true);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    ProportionalCapacityPreemptionPolicy buildPolicy(int[][] qData) {
        ProportionalCapacityPreemptionPolicy policy = new ProportionalCapacityPreemptionPolicy(this.conf, this.mDisp, this.mCS, this.mClock);
        Resource clusterResources = Resource.newInstance((int)TestProportionalCapacityPreemptionPolicy.leafAbsCapacities(qData[0], qData[7]), (int)0);
        ParentQueue mRoot = this.buildMockRootQueue(this.rand, qData);
        Mockito.when((Object)this.mCS.getRootQueue()).thenReturn((Object)mRoot);
        Mockito.when((Object)this.mCS.getClusterResource()).thenReturn((Object)clusterResources);
        return policy;
    }

    ProportionalCapacityPreemptionPolicy buildPolicy(int[][] qData, String[][] resData) {
        return this.buildPolicy(qData, resData, false);
    }

    ProportionalCapacityPreemptionPolicy buildPolicy(int[][] qData, String[][] resData, boolean useDominantResourceCalculator) {
        if (useDominantResourceCalculator) {
            Mockito.when((Object)this.mCS.getResourceCalculator()).thenReturn((Object)new DominantResourceCalculator());
        }
        ProportionalCapacityPreemptionPolicy policy = new ProportionalCapacityPreemptionPolicy(this.conf, this.mDisp, this.mCS, this.mClock);
        Resource clusterResources = TestProportionalCapacityPreemptionPolicy.leafAbsCapacities(this.parseResourceDetails(resData[0]), qData[2]);
        Mockito.when((Object)this.mCS.getClusterResource()).thenReturn((Object)clusterResources);
        ParentQueue mRoot = this.buildMockRootQueue(this.rand, resData, qData);
        Mockito.when((Object)this.mCS.getRootQueue()).thenReturn((Object)mRoot);
        return policy;
    }

    ParentQueue buildMockRootQueue(Random r, int[] ... queueData) {
        Resource[] abs = this.generateResourceList(queueData[0]);
        Resource[] used = this.generateResourceList(queueData[2]);
        Resource[] pending = this.generateResourceList(queueData[3]);
        Resource[] reserved = this.generateResourceList(queueData[4]);
        Resource[] gran = this.generateResourceList(queueData[6]);
        int[] maxCap = queueData[1];
        int[] apps = queueData[5];
        int[] queues = queueData[7];
        return this.mockNested(abs, maxCap, used, pending, reserved, apps, gran, queues);
    }

    private ParentQueue buildMockRootQueue(Random rand2, String[][] resData, int[][] queueData) {
        Resource[] abs = this.parseResourceDetails(resData[0]);
        Resource[] used = this.parseResourceDetails(resData[1]);
        Resource[] pending = this.parseResourceDetails(resData[2]);
        Resource[] reserved = this.parseResourceDetails(resData[3]);
        Resource[] gran = this.parseResourceDetails(resData[4]);
        int[] maxCap = queueData[0];
        int[] apps = queueData[1];
        int[] queues = queueData[2];
        return this.mockNested(abs, maxCap, used, pending, reserved, apps, gran, queues);
    }

    Resource[] parseResourceDetails(String[] resData) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (int i = 0; i < resData.length; ++i) {
            String[] resource = resData[i].split(":");
            if (resource.length == 1) {
                resourceList.add(Resource.newInstance((int)Integer.valueOf(resource[0]), (int)0));
                continue;
            }
            resourceList.add(Resource.newInstance((int)Integer.valueOf(resource[0]), (int)Integer.valueOf(resource[1])));
        }
        return resourceList.toArray(new Resource[resourceList.size()]);
    }

    Resource[] generateResourceList(int[] qData) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (int i = 0; i < qData.length; ++i) {
            resourceList.add(Resource.newInstance((int)qData[i], (int)0));
        }
        return resourceList.toArray(new Resource[resourceList.size()]);
    }

    ParentQueue mockNested(Resource[] abs, int[] maxCap, Resource[] used, Resource[] pending, Resource[] reserved, int[] apps, Resource[] gran, int[] queues) {
        ResourceCalculator rc = this.mCS.getResourceCalculator();
        Resource tot = TestProportionalCapacityPreemptionPolicy.leafAbsCapacities(abs, queues);
        LinkedList<ParentQueue> pqs = new LinkedList<ParentQueue>();
        ParentQueue root = this.mockParentQueue(null, queues[0], pqs);
        ResourceUsage resUsage = new ResourceUsage();
        resUsage.setUsed(used[0]);
        Mockito.when((Object)root.getQueueName()).thenReturn((Object)"/");
        Mockito.when((Object)Float.valueOf(root.getAbsoluteUsedCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)used[0], (Resource)tot)));
        Mockito.when((Object)Float.valueOf(root.getAbsoluteCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)abs[0], (Resource)tot)));
        Mockito.when((Object)Float.valueOf(root.getAbsoluteMaximumCapacity())).thenReturn((Object)Float.valueOf((float)maxCap[0] / (float)tot.getMemory()));
        Mockito.when((Object)root.getQueueResourceUsage()).thenReturn((Object)resUsage);
        for (int i = 1; i < queues.length; ++i) {
            ParentQueue q;
            ParentQueue p = (ParentQueue)pqs.removeLast();
            String queueName = "queue" + (char)(65 + i - 1);
            if (queues[i] > 0) {
                q = this.mockParentQueue(p, queues[i], pqs);
                ResourceUsage resUsagePerQueue = new ResourceUsage();
                resUsagePerQueue.setUsed(used[i]);
                Mockito.when((Object)q.getQueueResourceUsage()).thenReturn((Object)resUsagePerQueue);
            } else {
                q = this.mockLeafQueue(p, tot, i, abs, used, pending, reserved, apps, gran);
            }
            Mockito.when((Object)q.getParent()).thenReturn((Object)p);
            Mockito.when((Object)q.getQueueName()).thenReturn((Object)queueName);
            Mockito.when((Object)Float.valueOf(q.getAbsoluteUsedCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)used[i], (Resource)tot)));
            Mockito.when((Object)Float.valueOf(q.getAbsoluteCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)abs[i], (Resource)tot)));
            Mockito.when((Object)Float.valueOf(q.getAbsoluteMaximumCapacity())).thenReturn((Object)Float.valueOf((float)maxCap[i] / (float)tot.getMemory()));
        }
        assert (0 == pqs.size());
        return root;
    }

    ParentQueue mockParentQueue(ParentQueue p, int subqueues, Deque<ParentQueue> pqs) {
        ParentQueue pq = (ParentQueue)Mockito.mock(ParentQueue.class);
        ArrayList cqs = new ArrayList();
        Mockito.when((Object)pq.getChildQueues()).thenReturn(cqs);
        for (int i = 0; i < subqueues; ++i) {
            pqs.add(pq);
        }
        if (p != null) {
            p.getChildQueues().add(pq);
        }
        return pq;
    }

    LeafQueue mockLeafQueue(ParentQueue p, Resource tot, int i, Resource[] abs, Resource[] used, Resource[] pending, Resource[] reserved, int[] apps, Resource[] gran) {
        LeafQueue lq = (LeafQueue)Mockito.mock(LeafQueue.class);
        ResourceCalculator rc = this.mCS.getResourceCalculator();
        Mockito.when((Object)lq.getTotalResourcePending()).thenReturn((Object)pending[i]);
        ResourceUsage ru = new ResourceUsage();
        ru.setPending(pending[i]);
        ru.setUsed(used[i]);
        Mockito.when((Object)lq.getQueueResourceUsage()).thenReturn((Object)ru);
        TreeSet<FiCaSchedulerApp> qApps = new TreeSet<FiCaSchedulerApp>(new Comparator<FiCaSchedulerApp>(){

            @Override
            public int compare(FiCaSchedulerApp a1, FiCaSchedulerApp a2) {
                return a1.getApplicationAttemptId().compareTo(a2.getApplicationAttemptId());
            }
        });
        if (apps[i] != 0) {
            Resource aUsed = Resources.divideAndCeil((ResourceCalculator)rc, (Resource)used[i], (int)apps[i]);
            Resource aPending = Resources.divideAndCeil((ResourceCalculator)rc, (Resource)pending[i], (int)apps[i]);
            Resource aReserve = Resources.divideAndCeil((ResourceCalculator)rc, (Resource)reserved[i], (int)apps[i]);
            for (int a = 0; a < apps[i]; ++a) {
                qApps.add(this.mockApp(i, this.appAlloc, aUsed, aPending, aReserve, gran[i]));
                ++this.appAlloc;
            }
        }
        Mockito.when((Object)lq.getApplications()).thenReturn(qApps);
        if (this.setAMResourcePercent != 0.0f) {
            Mockito.when((Object)Float.valueOf(lq.getMaxAMResourcePerQueuePercent())).thenReturn((Object)Float.valueOf(this.setAMResourcePercent));
        }
        p.getChildQueues().add(lq);
        return lq;
    }

    FiCaSchedulerApp mockApp(int qid, int id, Resource used, Resource pending, Resource reserved, Resource gran) {
        FiCaSchedulerApp app = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ResourceCalculator rc = this.mCS.getResourceCalculator();
        ApplicationId appId = ApplicationId.newInstance((long)3141592653L, (int)id);
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)appAttId);
        int cAlloc = 0;
        Resource unit = gran;
        ArrayList<RMContainer> cReserved = new ArrayList<RMContainer>();
        Resource resIter = Resource.newInstance((int)0, (int)0);
        while (Resources.lessThan((ResourceCalculator)rc, (Resource)this.mCS.getClusterResource(), (Resource)resIter, (Resource)reserved)) {
            cReserved.add(this.mockContainer(appAttId, cAlloc, unit, 1));
            ++cAlloc;
            Resources.addTo((Resource)resIter, (Resource)gran);
        }
        Mockito.when((Object)app.getReservedContainers()).thenReturn(cReserved);
        ArrayList<RMContainer> cLive = new ArrayList<RMContainer>();
        Resource usedIter = Resource.newInstance((int)0, (int)0);
        int i = 0;
        while (Resources.lessThan((ResourceCalculator)rc, (Resource)this.mCS.getClusterResource(), (Resource)usedIter, (Resource)used)) {
            if (this.setAMContainer && i == 0) {
                cLive.add(this.mockContainer(appAttId, cAlloc, unit, 0));
            } else {
                cLive.add(this.mockContainer(appAttId, cAlloc, unit, 1));
            }
            ++cAlloc;
            ++i;
            Resources.addTo((Resource)usedIter, (Resource)gran);
        }
        Mockito.when((Object)app.getLiveContainers()).thenReturn(cLive);
        return app;
    }

    RMContainer mockContainer(ApplicationAttemptId appAttId, int id, Resource r, int priority) {
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)appAttId, (long)id);
        Container c = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)c.getResource()).thenReturn((Object)r);
        Mockito.when((Object)c.getPriority()).thenReturn((Object)Priority.create((int)priority));
        RMContainer mC = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)mC.getContainerId()).thenReturn((Object)cId);
        Mockito.when((Object)mC.getContainer()).thenReturn((Object)c);
        Mockito.when((Object)mC.getApplicationAttemptId()).thenReturn((Object)appAttId);
        if (0 == priority) {
            Mockito.when((Object)mC.isAMContainer()).thenReturn((Object)true);
        }
        return mC;
    }

    static int leafAbsCapacities(int[] abs, int[] subqueues) {
        int ret = 0;
        for (int i = 0; i < abs.length; ++i) {
            if (0 != subqueues[i]) continue;
            ret += abs[i];
        }
        return ret;
    }

    static Resource leafAbsCapacities(Resource[] abs, int[] subqueues) {
        Resource ret = Resource.newInstance((int)0, (int)0);
        for (int i = 0; i < abs.length; ++i) {
            if (0 != subqueues[i]) continue;
            Resources.addTo((Resource)ret, (Resource)abs[i]);
        }
        return ret;
    }

    void printString(CSQueue nq, String indent) {
        if (nq instanceof ParentQueue) {
            System.out.println(indent + nq.getQueueName() + " cur:" + nq.getAbsoluteUsedCapacity() + " guar:" + nq.getAbsoluteCapacity());
            for (CSQueue q : ((ParentQueue)nq).getChildQueues()) {
                this.printString(q, indent + "  ");
            }
        } else {
            System.out.println(indent + nq.getQueueName() + " pen:" + ((LeafQueue)nq).getTotalResourcePending() + " cur:" + nq.getAbsoluteUsedCapacity() + " guar:" + nq.getAbsoluteCapacity());
            for (FiCaSchedulerApp a : ((LeafQueue)nq).getApplications()) {
                System.out.println(indent + "  " + a.getApplicationId());
            }
        }
    }

    static class IsPreemptionRequestFor
    extends ArgumentMatcher<ContainerPreemptEvent> {
        private final ApplicationAttemptId appAttId;
        private final ContainerPreemptEventType type;

        IsPreemptionRequestFor(ApplicationAttemptId appAttId) {
            this(appAttId, ContainerPreemptEventType.PREEMPT_CONTAINER);
        }

        IsPreemptionRequestFor(ApplicationAttemptId appAttId, ContainerPreemptEventType type) {
            this.appAttId = appAttId;
            this.type = type;
        }

        public boolean matches(Object o) {
            return this.appAttId.equals((Object)((ContainerPreemptEvent)o).getAppId()) && this.type.equals((Object)((ContainerPreemptEvent)o).getType());
        }

        public String toString() {
            return this.appAttId.toString();
        }
    }
}

