/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;

public class TestAMRestart {
    @Test(timeout=30000L)
    public void testAMRestartWithExistingContainers() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, true);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("127.0.0.1:2351", 4089, rm1.getResourceTrackerService());
        nm2.registerNode();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        int NUM_CONTAINERS = 3;
        am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        while (containers.size() != NUM_CONTAINERS) {
            nm1.nodeHeartbeat(true);
            containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            Thread.sleep(200L);
        }
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.RUNNING);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm1, containerId3, RMContainerState.RUNNING);
        ContainerId containerId4 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L);
        rm1.waitForState(nm1, containerId4, RMContainerState.ACQUIRED);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        nm1.nodeHeartbeat(true);
        ContainerId containerId5 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)5L);
        rm1.waitForContainerAllocated(nm1, containerId5);
        rm1.waitForState(nm1, containerId5, RMContainerState.ALLOCATED);
        am1.allocate("127.0.0.1", 6000, 1, new ArrayList<ContainerId>());
        ContainerId containerId6 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)6L);
        nm1.nodeHeartbeat(true);
        SchedulerApplicationAttempt schedulerAttempt = ((AbstractYarnScheduler)rm1.getResourceScheduler()).getCurrentAttemptForContainer(containerId6);
        while (schedulerAttempt.getReservedContainers().isEmpty()) {
            System.out.println("Waiting for container " + containerId6 + " to be reserved.");
            nm1.nodeHeartbeat(true);
            Thread.sleep(200L);
        }
        Assert.assertEquals((Object)containerId6, (Object)((RMContainer)schedulerAttempt.getReservedContainers().get(0)).getContainerId());
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am1.waitForState(RMAppAttemptState.FAILED);
        Thread.sleep(3000L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        Assert.assertNull((Object)rm1.getResourceScheduler().getRMContainer(containerId4));
        Assert.assertNull((Object)rm1.getResourceScheduler().getRMContainer(containerId5));
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        ApplicationAttemptId newAttemptId = app1.getCurrentAppAttempt().getAppAttemptId();
        Assert.assertFalse((boolean)newAttemptId.equals((Object)am1.getApplicationAttemptId()));
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        nm1.nodeHeartbeat(true);
        MockAM am2 = rm1.sendAMLaunched(attempt2.getAppAttemptId());
        RegisterApplicationMasterResponse registerResponse = am2.registerAppAttempt();
        Assert.assertEquals((long)2L, (long)registerResponse.getContainersFromPreviousAttempts().size());
        boolean containerId2Exists = false;
        boolean containerId3Exists = false;
        for (Container container : registerResponse.getContainersFromPreviousAttempts()) {
            if (container.getId().equals((Object)containerId2)) {
                containerId2Exists = true;
            }
            if (!container.getId().equals((Object)containerId3)) continue;
            containerId3Exists = true;
        }
        Assert.assertTrue((containerId2Exists && containerId3Exists ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.COMPLETE);
        RMAppAttempt newAttempt = app1.getRMAppAttempt(am2.getApplicationAttemptId());
        this.waitForContainersToFinish(4, newAttempt);
        boolean container3Exists = false;
        boolean container4Exists = false;
        boolean container5Exists = false;
        boolean container6Exists = false;
        for (ContainerStatus status : newAttempt.getJustFinishedContainers()) {
            if (status.getContainerId().equals((Object)containerId3)) {
                container3Exists = true;
            }
            if (status.getContainerId().equals((Object)containerId4)) {
                container4Exists = true;
            }
            if (status.getContainerId().equals((Object)containerId5)) {
                container5Exists = true;
            }
            if (!status.getContainerId().equals((Object)containerId6)) continue;
            container6Exists = true;
        }
        Assert.assertTrue((container3Exists && container4Exists && container5Exists && container6Exists ? 1 : 0) != 0);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        SchedulerApplicationAttempt schedulerNewAttempt = ((AbstractYarnScheduler)rm1.getResourceScheduler()).getCurrentAttemptForContainer(containerId2);
        MockRM.finishAMAndVerifyAppState(app1, rm1, nm1, am2);
        Assert.assertFalse((boolean)schedulerNewAttempt.getLiveContainers().contains(containerId2));
        System.out.println("New attempt's just finished containers: " + newAttempt.getJustFinishedContainers());
        this.waitForContainersToFinish(5, newAttempt);
        rm1.stop();
    }

    private void waitForContainersToFinish(int expectedNum, RMAppAttempt attempt) throws InterruptedException {
        for (int count = 0; attempt.getJustFinishedContainers().size() < expectedNum && count < 500; ++count) {
            Thread.sleep(100L);
        }
    }

    @Test(timeout=30000L)
    public void testNMTokensRebindOnAMRestart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.am.max-attempts", 3);
        MockRM rm1 = new MockRM((Configuration)conf);
        rm1.start();
        RMApp app1 = rm1.submitApp(200, "myname", "myuser", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "MAPREDUCE", false, true);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("127.1.1.1:4321", 8000, rm1.getResourceTrackerService());
        nm2.registerNode();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ArrayList containers = new ArrayList();
        ArrayList expectedNMTokens = new ArrayList();
        while (true) {
            AllocateResponse response = am1.allocate("127.0.0.1", 2000, 2, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            containers.addAll(response.getAllocatedContainers());
            expectedNMTokens.addAll(response.getNMTokens());
            if (containers.size() == 2) break;
            Thread.sleep(200L);
            System.out.println("Waiting for container to be allocated.");
        }
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 3L, ContainerState.RUNNING);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        rm1.waitForState(nm1, containerId3, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am1.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am2 = MockRM.launchAM(app1, rm1, nm1);
        RegisterApplicationMasterResponse registerResponse = am2.registerAppAttempt();
        rm1.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        Assert.assertEquals(expectedNMTokens, (Object)registerResponse.getNMTokensFromPreviousAttempts());
        containers = new ArrayList();
        while (true) {
            AllocateResponse allocateResponse = am2.allocate("127.1.1.1", 4000, 1, new ArrayList<ContainerId>());
            nm2.nodeHeartbeat(true);
            containers.addAll(allocateResponse.getAllocatedContainers());
            expectedNMTokens.addAll(allocateResponse.getNMTokens());
            if (containers.size() == 1) break;
            Thread.sleep(200L);
            System.out.println("Waiting for container to be allocated.");
        }
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
        ContainerId am2ContainerId2 = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, am2ContainerId2, RMContainerState.RUNNING);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am2.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am3 = MockRM.launchAM(app1, rm1, nm1);
        registerResponse = am3.registerAppAttempt();
        rm1.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        List transferredTokens = registerResponse.getNMTokensFromPreviousAttempts();
        Assert.assertEquals((long)2L, (long)transferredTokens.size());
        Assert.assertTrue((boolean)transferredTokens.containsAll(expectedNMTokens));
        rm1.stop();
    }

    @Test(timeout=100000L)
    public void testShouldNotCountFailureToMaxAttemptRetry() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        CapacityScheduler scheduler = (CapacityScheduler)rm1.getResourceScheduler();
        ContainerId amContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer));
        am1.waitForState(RMAppAttemptState.FAILED);
        Assert.assertTrue((!attempt1.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)memStore.getState().getApplicationState().get(app1.getApplicationId());
        MockAM am2 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        Assert.assertTrue((boolean)((RMAppAttemptImpl)attempt2).mayBeLastAttempt());
        ContainerId amContainer2 = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer2));
        am2.waitForState(RMAppAttemptState.FAILED);
        Assert.assertTrue((!attempt2.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am3 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 3, nm1);
        RMAppAttempt attempt3 = app1.getCurrentAppAttempt();
        Assert.assertTrue((boolean)((RMAppAttemptImpl)attempt3).mayBeLastAttempt());
        ContainerStatus containerStatus = (ContainerStatus)Records.newRecord(ContainerStatus.class);
        containerStatus.setContainerId(attempt3.getMasterContainer().getId());
        containerStatus.setDiagnostics("mimic NM disk_failure");
        containerStatus.setState(ContainerState.COMPLETE);
        containerStatus.setExitStatus(-101);
        HashMap<ApplicationId, List<ContainerStatus>> conts = new HashMap<ApplicationId, List<ContainerStatus>>();
        conts.put(app1.getApplicationId(), Collections.singletonList(containerStatus));
        nm1.nodeHeartbeat(conts, true);
        am3.waitForState(RMAppAttemptState.FAILED);
        Assert.assertTrue((!attempt3.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        Assert.assertEquals((long)-101L, (long)appState.getAttempt(am3.getApplicationAttemptId()).getAMContainerExitStatus());
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am4 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 4, nm1);
        RMAppAttempt attempt4 = app1.getCurrentAppAttempt();
        Assert.assertTrue((boolean)((RMAppAttemptImpl)attempt4).mayBeLastAttempt());
        MockNM nm2 = new MockNM("127.0.0.1:2234", 8000, rm1.getResourceTrackerService());
        nm2.registerNode();
        nm1.nodeHeartbeat(false);
        am4.waitForState(RMAppAttemptState.FAILED);
        Assert.assertTrue((!attempt4.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        Assert.assertEquals((long)-100L, (long)appState.getAttempt(am4.getApplicationAttemptId()).getAMContainerExitStatus());
        nm2.nodeHeartbeat(true);
        MockAM am5 = rm1.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 5, nm2);
        RMAppAttempt attempt5 = app1.getCurrentAppAttempt();
        Assert.assertTrue((boolean)((RMAppAttemptImpl)attempt5).mayBeLastAttempt());
        nm2.nodeHeartbeat(am5.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am5.waitForState(RMAppAttemptState.FAILED);
        Assert.assertTrue((boolean)attempt5.shouldCountTowardsMaxAttemptRetry());
        rm1.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((long)5L, (long)app1.getAppAttempts().size());
        rm1.stop();
    }

    @Test(timeout=20000L)
    public void testPreemptedAMRestartOnRMRestart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        CapacityScheduler scheduler = (CapacityScheduler)rm1.getResourceScheduler();
        ContainerId amContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        scheduler.killContainer(scheduler.getRMContainer(amContainer));
        am1.waitForState(RMAppAttemptState.FAILED);
        Assert.assertTrue((!attempt1.shouldCountTowardsMaxAttemptRetry() ? 1 : 0) != 0);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)memStore.getState().getApplicationState().get(app1.getApplicationId());
        Assert.assertEquals((long)1L, (long)appState.getAttemptCount());
        Assert.assertEquals((long)-102L, (long)appState.getAttempt(am1.getApplicationAttemptId()).getAMContainerExitStatus());
        MockRM rm2 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        nm1.registerNode();
        rm2.start();
        MockAM am2 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        MockRM.finishAMAndVerifyAppState(app1, rm2, nm1, am2);
        RMAppAttempt attempt2 = ((RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt();
        Assert.assertTrue((boolean)attempt2.shouldCountTowardsMaxAttemptRetry());
        Assert.assertEquals((long)-1000L, (long)appState.getAttempt(am2.getApplicationAttemptId()).getAMContainerExitStatus());
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=50000L)
    public void testRMRestartOrFailoverNotCountedForAMFailures() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        Assert.assertTrue((boolean)((RMAppAttemptImpl)attempt1).mayBeLastAttempt());
        MockRM rm2 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm2.start();
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)memStore.getState().getApplicationState().get(app1.getApplicationId());
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus status = (NMContainerStatus)Records.newRecord(NMContainerStatus.class);
        status.setContainerExitStatus(-106);
        status.setContainerId(attempt1.getMasterContainer().getId());
        status.setContainerState(ContainerState.COMPLETE);
        status.setDiagnostics("");
        nm1.registerNode(Collections.singletonList(status), null);
        rm2.waitForState(attempt1.getAppAttemptId(), RMAppAttemptState.FAILED);
        Assert.assertEquals((long)-106L, (long)appState.getAttempt(am1.getApplicationAttemptId()).getAMContainerExitStatus());
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am2 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 2, nm1);
        MockRM.finishAMAndVerifyAppState(app1, rm2, nm1, am2);
        RMAppAttempt attempt3 = ((RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId())).getCurrentAppAttempt();
        Assert.assertTrue((boolean)attempt3.shouldCountTowardsMaxAttemptRetry());
        Assert.assertEquals((long)-1000L, (long)appState.getAttempt(am2.getApplicationAttemptId()).getAMContainerExitStatus());
        rm1.stop();
        rm2.stop();
    }

    @Test(timeout=50000L)
    public void testRMAppAttemptFailuresValidityInterval() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app = rm1.submitApp(200, 20000L);
        MockAM am = MockRM.launchAM(app, rm1, nm1);
        nm1.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)2L, (long)app.getAppAttempts().size());
        Assert.assertTrue((boolean)((RMAppAttemptImpl)app.getCurrentAppAttempt()).mayBeLastAttempt());
        MockAM am_2 = MockRM.launchAndRegisterAM(app, rm1, nm1);
        am_2.waitForState(RMAppAttemptState.RUNNING);
        nm1.nodeHeartbeat(am_2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am_2.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app.getApplicationId(), RMAppState.FAILED);
        ControlledClock clock = new ControlledClock((Clock)new SystemClock());
        RMAppImpl app1 = (RMAppImpl)rm1.submitApp(200, 6000L);
        app1.setSystemClock((Clock)clock);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am1.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)2L, (long)app1.getAppAttempts().size());
        RMAppAttempt attempt2 = app1.getCurrentAppAttempt();
        Assert.assertTrue((boolean)((RMAppAttemptImpl)attempt2).mayBeLastAttempt());
        MockAM am2 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        am2.waitForState(RMAppAttemptState.RUNNING);
        clock.setTime(System.currentTimeMillis() + 6000L);
        nm1.nodeHeartbeat(am2.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am2.waitForState(RMAppAttemptState.FAILED);
        rm1.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        Assert.assertEquals((long)3L, (long)app1.getAppAttempts().size());
        RMAppAttempt attempt3 = app1.getCurrentAppAttempt();
        clock.reset();
        MockAM am3 = MockRM.launchAndRegisterAM((RMApp)app1, rm1, nm1);
        am3.waitForState(RMAppAttemptState.RUNNING);
        MockRM rm2 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        NMContainerStatus status = (NMContainerStatus)Records.newRecord(NMContainerStatus.class);
        status.setContainerExitStatus(-106);
        status.setContainerId(attempt3.getMasterContainer().getId());
        status.setContainerState(ContainerState.COMPLETE);
        status.setDiagnostics("");
        nm1.registerNode(Collections.singletonList(status), null);
        rm2.waitForState(attempt3.getAppAttemptId(), RMAppAttemptState.FAILED);
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am4 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 4, nm1);
        clock.setTime(System.currentTimeMillis() + 6000L);
        nm1.nodeHeartbeat(am4.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am4.waitForState(RMAppAttemptState.FAILED);
        rm2.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
        MockAM am5 = rm2.waitForNewAMToLaunchAndRegister(app1.getApplicationId(), 5, nm1);
        clock.reset();
        am5.waitForState(RMAppAttemptState.RUNNING);
        nm1.nodeHeartbeat(am5.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am5.waitForState(RMAppAttemptState.FAILED);
        rm2.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        rm1.stop();
        rm2.stop();
    }
}

