/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ParameterizedSchedulerTestBase {
    protected static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static final String FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
    private SchedulerType schedulerType;
    private YarnConfiguration conf = null;

    public ParameterizedSchedulerTestBase(SchedulerType type) {
        this.schedulerType = type;
    }

    public YarnConfiguration getConf() {
        return this.conf;
    }

    @Parameterized.Parameters
    public static Collection<SchedulerType[]> getParameters() {
        return Arrays.asList(new SchedulerType[][]{{SchedulerType.CAPACITY}, {SchedulerType.FAIR}});
    }

    @Before
    public void configureScheduler() throws IOException {
        this.conf = new YarnConfiguration();
        switch (this.schedulerType) {
            case CAPACITY: {
                this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
                break;
            }
            case FAIR: {
                this.configureFairScheduler(this.conf);
            }
        }
    }

    private void configureFairScheduler(YarnConfiguration conf) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(FS_ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queueMaxAMShareDefault>-1.0</queueMaxAMShareDefault>");
        out.println("</allocations>");
        out.close();
        conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        conf.set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
    }

    public static enum SchedulerType {
        CAPACITY,
        FAIR;

    }
}

