/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCSQueueUtils {
    private static final Log LOG = LogFactory.getLog(TestCSQueueUtils.class);
    static final int GB = 1024;

    @Test
    public void testAbsoluteMaxAvailCapacityInvalidDivisor() throws Exception {
        this.runInvalidDivisorTest(false);
        this.runInvalidDivisorTest(true);
    }

    public void runInvalidDivisorTest(boolean useDominant) throws Exception {
        Resource clusterResource;
        DominantResourceCalculator resourceCalculator;
        if (useDominant) {
            resourceCalculator = new DominantResourceCalculator();
            clusterResource = Resources.createResource((int)10, (int)0);
        } else {
            resourceCalculator = new DefaultResourceCalculator();
            clusterResource = Resources.createResource((int)0, (int)99);
        }
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)resourceCalculator);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)0, (int)0));
        RMContext rmContext = TestUtils.getMockRMContext();
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)rmContext);
        String L1Q1 = "L1Q1";
        csConf.setQueues("root", new String[]{"L1Q1"});
        String L1Q1P = "root.L1Q1";
        csConf.setCapacity("root.L1Q1", 90.0f);
        csConf.setMaximumCapacity("root.L1Q1", 90.0f);
        ParentQueue root = new ParentQueue(csContext, "root", null, null);
        LeafQueue l1q1 = new LeafQueue(csContext, "L1Q1", (CSQueue)root, null);
        LOG.info((Object)("t1 root " + CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)root)));
        LOG.info((Object)("t1 l1q1 " + CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l1q1)));
        Assert.assertEquals((float)0.0f, (float)CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l1q1), (float)1.0E-6f);
    }

    @Test
    public void testAbsoluteMaxAvailCapacityNoUse() throws Exception {
        DefaultResourceCalculator resourceCalculator = new DefaultResourceCalculator();
        Resource clusterResource = Resources.createResource((int)0x190000, (int)3200);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)resourceCalculator);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        RMContext rmContext = TestUtils.getMockRMContext();
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)rmContext);
        String L1Q1 = "L1Q1";
        csConf.setQueues("root", new String[]{"L1Q1"});
        String L1Q1P = "root.L1Q1";
        csConf.setCapacity("root.L1Q1", 90.0f);
        csConf.setMaximumCapacity("root.L1Q1", 90.0f);
        ParentQueue root = new ParentQueue(csContext, "root", null, null);
        LeafQueue l1q1 = new LeafQueue(csContext, "L1Q1", (CSQueue)root, null);
        LOG.info((Object)("t1 root " + CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)root)));
        LOG.info((Object)("t1 l1q1 " + CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l1q1)));
        Assert.assertEquals((float)1.0f, (float)CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)root), (float)1.0E-6f);
        Assert.assertEquals((float)0.9f, (float)CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l1q1), (float)1.0E-6f);
    }

    @Test
    public void testAbsoluteMaxAvailCapacityWithUse() throws Exception {
        DefaultResourceCalculator resourceCalculator = new DefaultResourceCalculator();
        Resource clusterResource = Resources.createResource((int)0x190000, (int)3200);
        YarnConfiguration conf = new YarnConfiguration();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)resourceCalculator);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        RMContext rmContext = TestUtils.getMockRMContext();
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)rmContext);
        String L1Q1 = "L1Q1";
        String L1Q2 = "L1Q2";
        String L2Q1 = "L2Q1";
        String L2Q2 = "L2Q2";
        csConf.setQueues("root", new String[]{"L1Q1", "L1Q2", "L2Q1", "L2Q2"});
        String L1Q1P = "root.L1Q1";
        csConf.setCapacity("root.L1Q1", 80.0f);
        csConf.setMaximumCapacity("root.L1Q1", 80.0f);
        String L1Q2P = "root.L1Q2";
        csConf.setCapacity("root.L1Q2", 20.0f);
        csConf.setMaximumCapacity("root.L1Q2", 100.0f);
        String L2Q1P = "root.L1Q1.L2Q1";
        csConf.setCapacity("root.L1Q1.L2Q1", 50.0f);
        csConf.setMaximumCapacity("root.L1Q1.L2Q1", 50.0f);
        String L2Q2P = "root.L1Q1.L2Q2";
        csConf.setCapacity("root.L1Q1.L2Q2", 50.0f);
        csConf.setMaximumCapacity("root.L1Q1.L2Q2", 50.0f);
        ParentQueue root = new ParentQueue(csContext, "root", null, null);
        LeafQueue l1q1 = new LeafQueue(csContext, "L1Q1", (CSQueue)root, null);
        LeafQueue l1q2 = new LeafQueue(csContext, "L1Q2", (CSQueue)root, null);
        LeafQueue l2q2 = new LeafQueue(csContext, "L2Q2", (CSQueue)l1q1, null);
        LeafQueue l2q1 = new LeafQueue(csContext, "L2Q1", (CSQueue)l1q1, null);
        float result = CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l2q2);
        Assert.assertEquals((float)0.4f, (float)result, (float)1.0E-6f);
        LOG.info((Object)("t2 l2q2 " + result));
        root.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.1f));
        l1q2.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.1f));
        result = CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l2q2);
        Assert.assertEquals((float)0.4f, (float)result, (float)1.0E-6f);
        LOG.info((Object)("t2 l2q2 " + result));
        root.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.3f));
        l1q2.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.3f));
        result = CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l2q2);
        Assert.assertEquals((float)0.3f, (float)result, (float)1.0E-6f);
        LOG.info((Object)("t2 l2q2 " + result));
        root.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.1f));
        l1q1.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.1f));
        result = CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l2q2);
        Assert.assertEquals((float)0.3f, (float)result, (float)1.0E-6f);
        LOG.info((Object)("t2 l2q2 " + result));
        root.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.2f));
        l1q1.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.2f));
        l2q1.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.2f));
        result = CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l2q2);
        Assert.assertEquals((float)0.3f, (float)result, (float)1.0E-6f);
        LOG.info((Object)("t2 l2q2 " + result));
        root.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.2f));
        l1q1.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.2f));
        l2q1.getQueueResourceUsage().incUsed(Resources.multiply((Resource)clusterResource, (double)0.2f));
        result = CSQueueUtils.getAbsoluteMaxAvailCapacity((ResourceCalculator)resourceCalculator, (Resource)clusterResource, (CSQueue)l2q2);
        Assert.assertEquals((float)0.1f, (float)result, (float)1.0E-6f);
        LOG.info((Object)("t2 l2q2 " + result));
    }
}

