/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager.MockAsm;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmController;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRMWebApp {
    static final int GiB = 1024;

    @Test
    public void testControllerIndex() {
        Injector injector = WebAppTests.createMockInjector(TestRMWebApp.class, (Object)this, (Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        RmController c = (RmController)injector.getInstance(RmController.class);
        c.index();
        Assert.assertEquals((Object)"Applications", (Object)c.get("title", "unknown"));
    }

    @Test
    public void testView() {
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)TestRMWebApp.mockRMContext((int)15, (int)1, (int)2, (int)8192), (Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        RmView rmViewInstance = (RmView)injector.getInstance(RmView.class);
        rmViewInstance.set("app.state", YarnApplicationState.RUNNING.toString());
        rmViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        rmViewInstance.set("app.state", StringHelper.cjoin((Object[])new Object[]{YarnApplicationState.ACCEPTED.toString(), YarnApplicationState.RUNNING.toString()}));
        rmViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    public void testNodesPage() {
        RMContext rmContext = TestRMWebApp.mockRMContext((int)3, (int)2, (int)12, (int)8192);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        NodesPage instance = (NodesPage)injector.getInstance(NodesPage.class);
        instance.render();
        WebAppTests.flushOutput((Injector)injector);
        instance.moreParams().put("node.state", NodeState.UNHEALTHY.toString());
        instance.render();
        WebAppTests.flushOutput((Injector)injector);
        instance.moreParams().put("node.state", NodeState.LOST.toString());
        instance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    public static RMContext mockRMContext(int numApps, int racks, int numNodes, int mbsPerNode) {
        List apps = MockAsm.newApplications((int)numApps);
        ConcurrentMap applicationsMaps = Maps.newConcurrentMap();
        for (RMApp app : apps) {
            applicationsMaps.put(app.getApplicationId(), app);
        }
        List nodes = MockNodes.newNodes((int)racks, (int)numNodes, (Resource)MockNodes.newResource((int)mbsPerNode));
        ConcurrentMap nodesMap = Maps.newConcurrentMap();
        for (RMNode node : nodes) {
            nodesMap.put(node.getNodeID(), node);
        }
        List deactivatedNodes = MockNodes.deactivatedNodes((int)racks, (int)numNodes, (Resource)MockNodes.newResource((int)mbsPerNode));
        ConcurrentMap deactivatedNodesMap = Maps.newConcurrentMap();
        for (RMNode node : deactivatedNodes) {
            deactivatedNodesMap.put(node.getHostName(), node);
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static ResourceManager mockRm(int apps, int racks, int nodes, int mbsPerNode) throws IOException {
        RMContext rmContext = TestRMWebApp.mockRMContext((int)apps, (int)racks, (int)nodes, (int)mbsPerNode);
        return TestRMWebApp.mockRm((RMContext)rmContext);
    }

    public static ResourceManager mockRm(RMContext rmContext) throws IOException {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        CapacityScheduler rs = TestRMWebApp.mockCapacityScheduler();
        ApplicationACLsManager aclMgr = TestRMWebApp.mockAppACLsManager();
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)rm.getApplicationACLsManager()).thenReturn((Object)aclMgr);
        return rm;
    }

    public static CapacityScheduler mockCapacityScheduler() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestRMWebApp.setupQueueConfiguration((CapacitySchedulerConfiguration)conf);
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext((RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null));
        cs.init((Configuration)conf);
        return cs;
    }

    public static ApplicationACLsManager mockAppACLsManager() {
        Configuration conf = new Configuration();
        return new ApplicationACLsManager(conf);
    }

    static void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A2 = "root.a";
        conf.setCapacity("root.a", 10.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        String A1 = "root.a.a1";
        String A22 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        String C1 = "root.c.c1";
        String C2 = "root.c.c2";
        String C3 = "root.c.c3";
        String C4 = "root.c.c4";
        conf.setQueues("root.c", new String[]{"c1", "c2", "c3", "c4"});
        conf.setCapacity("root.c.c1", 50.0f);
        conf.setCapacity("root.c.c2", 10.0f);
        conf.setCapacity("root.c.c3", 35.0f);
        conf.setCapacity("root.c.c4", 5.0f);
        String C11 = "root.c.c1.c11";
        String C12 = "root.c.c1.c12";
        String C13 = "root.c.c1.c13";
        conf.setQueues("root.c.c1", new String[]{"c11", "c12", "c13"});
        conf.setCapacity("root.c.c1.c11", 15.0f);
        conf.setCapacity("root.c.c1.c12", 45.0f);
        conf.setCapacity("root.c.c1.c13", 40.0f);
    }

    public static ResourceManager mockFifoRm(int apps, int racks, int nodes, int mbsPerNode) throws Exception {
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        RMContext rmContext = TestRMWebApp.mockRMContext((int)apps, (int)racks, (int)nodes, (int)mbsPerNode);
        FifoScheduler rs = TestRMWebApp.mockFifoScheduler((RMContext)rmContext);
        Mockito.when((Object)rm.getResourceScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        return rm;
    }

    public static FifoScheduler mockFifoScheduler(RMContext rmContext) throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestRMWebApp.setupFifoQueueConfiguration((CapacitySchedulerConfiguration)conf);
        FifoScheduler fs = new FifoScheduler();
        fs.setConf((Configuration)new YarnConfiguration());
        fs.setRMContext(rmContext);
        fs.init((Configuration)conf);
        return fs;
    }

    static void setupFifoQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("default", new String[]{"default"});
        conf.setCapacity("default", 100.0f);
    }

    public static void main(String[] args) throws Exception {
        WebApps.$for((String)"yarn", (Object)new TestRMWebApp()).at(8888).inDevMode().start((WebApp)new RMWebApp(TestRMWebApp.mockRm((int)2500, (int)8, (int)8, (int)8192))).joinThread();
        WebApps.$for((String)"yarn", (Object)new TestRMWebApp()).at(8888).inDevMode().start((WebApp)new RMWebApp(TestRMWebApp.mockFifoRm((int)10, (int)1, (int)4, (int)8192))).joinThread();
    }
}

