/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;

public class RMAuthenticationHandler
extends KerberosAuthenticationHandler {
    public static final String TYPE = "kerberos-dt";
    public static final String HEADER = "Hadoop-YARN-Auth-Delegation-Token";
    static RMDelegationTokenSecretManager secretManager;
    static boolean secretManagerInitialized;

    public String getType() {
        return TYPE;
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String delegationParam = this.getEncodedDelegationTokenFromRequest(request);
        if (delegationParam != null) {
            Token dt = new Token();
            dt.decodeFromUrlString(delegationParam);
            UserGroupInformation ugi = this.verifyToken(dt);
            if (ugi == null) {
                throw new AuthenticationException("Invalid token");
            }
            String shortName = ugi.getShortUserName();
            token = new AuthenticationToken(shortName, ugi.getUserName(), this.getType());
        } else {
            token = super.authenticate(request, response);
            if (token != null) {
                token = new AuthenticationToken(token.getUserName(), token.getName(), super.getType());
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserGroupInformation verifyToken(Token<RMDelegationTokenIdentifier> token) throws IOException {
        if (!secretManagerInitialized) {
            throw new IllegalStateException("Secret manager not initialized");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream dis = new DataInputStream(buf);
        RMDelegationTokenIdentifier id = secretManager.createIdentifier();
        try {
            id.readFields((DataInput)dis);
            secretManager.verifyToken((AbstractDelegationTokenIdentifier)id, token.getPassword());
        }
        catch (Throwable t) {
            UserGroupInformation userGroupInformation = null;
            return userGroupInformation;
        }
        finally {
            dis.close();
        }
        return id.getUser();
    }

    protected String getEncodedDelegationTokenFromRequest(HttpServletRequest req) {
        String header = req.getHeader(HEADER);
        return header;
    }

    public static void setSecretManager(RMDelegationTokenSecretManager manager) {
        secretManager = manager;
        secretManagerInitialized = true;
    }

    static {
        secretManagerInitialized = false;
    }
}

