/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AllocationFileLoaderService
extends AbstractService {
    public static final Log LOG = LogFactory.getLog((String)AllocationFileLoaderService.class.getName());
    public static final long ALLOC_RELOAD_INTERVAL_MS = 10000L;
    public static final long ALLOC_RELOAD_WAIT_MS = 5000L;
    public static final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private final Clock clock;
    private long lastSuccessfulReload;
    private boolean lastReloadAttemptFailed = false;
    private File allocFile;
    private Listener reloadListener;
    @VisibleForTesting
    long reloadIntervalMs = 10000L;
    private Thread reloadThread;
    private volatile boolean running = true;

    public AllocationFileLoaderService() {
        this((Clock)new SystemClock());
    }

    public AllocationFileLoaderService(Clock clock) {
        super(AllocationFileLoaderService.class.getName());
        this.clock = clock;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.allocFile = this.getAllocationFile(conf);
        if (this.allocFile != null) {
            this.reloadThread = new /* Unavailable Anonymous Inner Class!! */;
            this.reloadThread.setName("AllocationFileReloader");
            this.reloadThread.setDaemon(true);
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        if (this.reloadThread != null) {
            this.reloadThread.start();
        }
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.running = false;
        if (this.reloadThread != null) {
            this.reloadThread.interrupt();
            try {
                this.reloadThread.join(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"reloadThread fails to join.");
            }
        }
        super.serviceStop();
    }

    public File getAllocationFile(Configuration conf) {
        String allocFilePath = conf.get("yarn.scheduler.fair.allocation.file", "fair-scheduler.xml");
        File allocFile = new File(allocFilePath);
        if (!allocFile.isAbsolute()) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(allocFilePath);
            if (url == null) {
                LOG.warn((Object)(allocFilePath + " not found on the classpath."));
                allocFile = null;
            } else {
                if (!url.getProtocol().equalsIgnoreCase("file")) {
                    throw new RuntimeException("Allocation file " + url + " found on the classpath is not on the local filesystem.");
                }
                allocFile = new File(url.getPath());
            }
        }
        return allocFile;
    }

    public synchronized void setReloadListener(Listener reloadListener) {
        this.reloadListener = reloadListener;
    }

    public synchronized void reloadAllocations() throws IOException, ParserConfigurationException, SAXException, AllocationConfigurationException {
        if (this.allocFile == null) {
            return;
        }
        LOG.info((Object)("Loading allocation file " + this.allocFile));
        HashMap minQueueResources = new HashMap();
        HashMap maxQueueResources = new HashMap();
        HashMap queueMaxApps = new HashMap();
        HashMap<String, Integer> userMaxApps = new HashMap<String, Integer>();
        HashMap queueMaxAMShares = new HashMap();
        HashMap queueWeights = new HashMap();
        HashMap queuePolicies = new HashMap();
        HashMap minSharePreemptionTimeouts = new HashMap();
        HashMap queueAcls = new HashMap();
        int userMaxAppsDefault = Integer.MAX_VALUE;
        int queueMaxAppsDefault = Integer.MAX_VALUE;
        float queueMaxAMShareDefault = -1.0f;
        long fairSharePreemptionTimeout = Long.MAX_VALUE;
        long defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        SchedulingPolicy defaultSchedPolicy = SchedulingPolicy.DEFAULT_POLICY;
        QueuePlacementPolicy newPlacementPolicy = null;
        HashMap configuredQueues = new HashMap();
        for (FSQueueType queueType : FSQueueType.values()) {
            configuredQueues.put(queueType, new HashSet());
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(this.allocFile);
        Element root = doc.getDocumentElement();
        if (!"allocations".equals(root.getTagName())) {
            throw new AllocationConfigurationException("Bad fair scheduler config file: top-level element not <allocations>");
        }
        NodeList elements = root.getChildNodes();
        ArrayList<Element> queueElements = new ArrayList<Element>();
        Element placementPolicyElement = null;
        for (int i = 0; i < elements.getLength(); ++i) {
            String text;
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("queue".equals(element.getTagName()) || "pool".equals(element.getTagName())) {
                queueElements.add(element);
                continue;
            }
            if ("user".equals(element.getTagName())) {
                String userName = element.getAttribute("name");
                NodeList fields = element.getChildNodes();
                for (int j = 0; j < fields.getLength(); ++j) {
                    Element field;
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element) || !"maxRunningApps".equals((field = (Element)fieldNode).getTagName())) continue;
                    String text2 = ((Text)field.getFirstChild()).getData().trim();
                    int val = Integer.parseInt(text2);
                    userMaxApps.put(userName, val);
                }
                continue;
            }
            if ("userMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                userMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("fairSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                fairSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("defaultMinSharePreemptionTimeout".equals(element.getTagName())) {
                long val;
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultMinSharePreemptionTimeout = val = Long.parseLong(text) * 1000L;
                continue;
            }
            if ("queueMaxAppsDefault".equals(element.getTagName())) {
                int val;
                text = ((Text)element.getFirstChild()).getData().trim();
                queueMaxAppsDefault = val = Integer.parseInt(text);
                continue;
            }
            if ("queueMaxAMShareDefault".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                queueMaxAMShareDefault = val = Math.min(val, 1.0f);
                continue;
            }
            if ("defaultQueueSchedulingPolicy".equals(element.getTagName()) || "defaultQueueSchedulingMode".equals(element.getTagName())) {
                text = ((Text)element.getFirstChild()).getData().trim();
                defaultSchedPolicy = SchedulingPolicy.parse((String)text);
                continue;
            }
            if ("queuePlacementPolicy".equals(element.getTagName())) {
                placementPolicyElement = element;
                continue;
            }
            LOG.warn((Object)("Bad element in allocations file: " + element.getTagName()));
        }
        for (Element element : queueElements) {
            String parent = "root";
            if (element.getAttribute("name").equalsIgnoreCase("root")) {
                if (queueElements.size() > 1) {
                    throw new AllocationConfigurationException("If configuring root queue, no other queues can be placed alongside it.");
                }
                parent = null;
            }
            this.loadQueue(parent, element, minQueueResources, maxQueueResources, queueMaxApps, userMaxApps, queueMaxAMShares, queueWeights, queuePolicies, minSharePreemptionTimeouts, queueAcls, configuredQueues);
        }
        Configuration conf = this.getConfig();
        newPlacementPolicy = placementPolicyElement != null ? QueuePlacementPolicy.fromXml(placementPolicyElement, configuredQueues, (Configuration)conf) : QueuePlacementPolicy.fromConfiguration((Configuration)conf, configuredQueues);
        AllocationConfiguration info = new AllocationConfiguration(minQueueResources, maxQueueResources, queueMaxApps, userMaxApps, queueWeights, queueMaxAMShares, userMaxAppsDefault, queueMaxAppsDefault, queueMaxAMShareDefault, queuePolicies, defaultSchedPolicy, minSharePreemptionTimeouts, queueAcls, fairSharePreemptionTimeout, defaultMinSharePreemptionTimeout, newPlacementPolicy, configuredQueues);
        this.lastSuccessfulReload = this.clock.getTime();
        this.lastReloadAttemptFailed = false;
        this.reloadListener.onReload(info);
    }

    private void loadQueue(String parentName, Element element, Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, Float> queueMaxAMShares, Map<String, ResourceWeights> queueWeights, Map<String, SchedulingPolicy> queuePolicies, Map<String, Long> minSharePreemptionTimeouts, Map<String, Map<QueueACL, AccessControlList>> queueAcls, Map<FSQueueType, Set<String>> configuredQueues) throws AllocationConfigurationException {
        String queueName = element.getAttribute("name");
        if (parentName != null) {
            queueName = parentName + "." + queueName;
        }
        HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
        NodeList fields = element.getChildNodes();
        boolean isLeaf = true;
        for (int j = 0; j < fields.getLength(); ++j) {
            String text;
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if ("minResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue((String)text);
                minQueueResources.put(queueName, val);
                continue;
            }
            if ("maxResources".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                Resource val = FairSchedulerConfiguration.parseResourceConfigValue((String)text);
                maxQueueResources.put(queueName, val);
                continue;
            }
            if ("maxRunningApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                int val = Integer.parseInt(text);
                queueMaxApps.put(queueName, val);
                continue;
            }
            if ("maxAMShare".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                float val = Float.parseFloat(text);
                val = Math.min(val, 1.0f);
                queueMaxAMShares.put(queueName, Float.valueOf(val));
                continue;
            }
            if ("weight".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                double val = Double.parseDouble(text);
                queueWeights.put(queueName, new ResourceWeights((float)val));
                continue;
            }
            if ("minSharePreemptionTimeout".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                long val = Long.parseLong(text) * 1000L;
                minSharePreemptionTimeouts.put(queueName, val);
                continue;
            }
            if ("schedulingPolicy".equals(field.getTagName()) || "schedulingMode".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData().trim();
                SchedulingPolicy policy = SchedulingPolicy.parse((String)text);
                queuePolicies.put(queueName, policy);
                continue;
            }
            if ("aclSubmitApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                acls.put(QueueACL.SUBMIT_APPLICATIONS, new AccessControlList(text));
                continue;
            }
            if ("aclAdministerApps".equals(field.getTagName())) {
                text = ((Text)field.getFirstChild()).getData();
                acls.put(QueueACL.ADMINISTER_QUEUE, new AccessControlList(text));
                continue;
            }
            if (!"queue".endsWith(field.getTagName()) && !"pool".equals(field.getTagName())) continue;
            this.loadQueue(queueName, field, minQueueResources, maxQueueResources, queueMaxApps, userMaxApps, queueMaxAMShares, queueWeights, queuePolicies, minSharePreemptionTimeouts, queueAcls, configuredQueues);
            configuredQueues.get(FSQueueType.PARENT).add(queueName);
            isLeaf = false;
        }
        if (isLeaf) {
            if ("parent".equals(element.getAttribute("type"))) {
                configuredQueues.get(FSQueueType.PARENT).add(queueName);
            } else {
                configuredQueues.get(FSQueueType.LEAF).add(queueName);
            }
        }
        queueAcls.put(queueName, acls);
        if (maxQueueResources.containsKey(queueName) && minQueueResources.containsKey(queueName) && !Resources.fitsIn((Resource)minQueueResources.get(queueName), (Resource)maxQueueResources.get(queueName))) {
            LOG.warn((Object)String.format("Queue %s has max resources %s less than min resources %s", queueName, maxQueueResources.get(queueName), minQueueResources.get(queueName)));
        }
    }

    static /* synthetic */ boolean access$000(AllocationFileLoaderService x0) {
        return x0.running;
    }

    static /* synthetic */ Clock access$100(AllocationFileLoaderService x0) {
        return x0.clock;
    }

    static /* synthetic */ File access$200(AllocationFileLoaderService x0) {
        return x0.allocFile;
    }

    static /* synthetic */ long access$300(AllocationFileLoaderService x0) {
        return x0.lastSuccessfulReload;
    }

    static /* synthetic */ boolean access$400(AllocationFileLoaderService x0) {
        return x0.lastReloadAttemptFailed;
    }

    static /* synthetic */ boolean access$402(AllocationFileLoaderService x0, boolean x1) {
        x0.lastReloadAttemptFailed = x1;
        return x0.lastReloadAttemptFailed;
    }
}

