/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class CapacityScheduler
extends AbstractYarnScheduler<FiCaSchedulerApp, FiCaSchedulerNode>
implements PreemptableResourceScheduler,
CapacitySchedulerContext,
Configurable {
    private static final Log LOG = LogFactory.getLog(CapacityScheduler.class);
    private CSQueue root;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    static final Comparator<CSQueue> queueComparator = new /* Unavailable Anonymous Inner Class!! */;
    static final Comparator<FiCaSchedulerApp> applicationComparator = new /* Unavailable Anonymous Inner Class!! */;
    private CapacitySchedulerConfiguration conf;
    private Configuration yarnConf;
    private Map<String, CSQueue> queues = new ConcurrentHashMap();
    private AtomicInteger numNodeManagers = new AtomicInteger(0);
    private ResourceCalculator calculator;
    private boolean usePortForNodeName;
    private boolean scheduleAsynchronously;
    private AsyncScheduleThread asyncSchedulerThread;
    private long asyncScheduleInterval;
    private static final String ASYNC_SCHEDULER_INTERVAL = "yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms";
    private static final long DEFAULT_ASYNC_SCHEDULER_INTERVAL = 5L;
    private static final Random random = new Random(System.currentTimeMillis());
    @InterfaceAudience.Private
    public static final String ROOT_QUEUE = "yarn.scheduler.capacity.root";
    private static final QueueHook noop = new QueueHook();

    public void setConf(Configuration conf) {
        this.yarnConf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0" + ", max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores <= 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min and max should be greater than 0" + ", max should be no smaller than min.");
        }
    }

    public Configuration getConf() {
        return this.yarnConf;
    }

    public CapacityScheduler() {
        super(CapacityScheduler.class.getName());
    }

    public QueueMetrics getRootQueueMetrics() {
        return this.root.getMetrics();
    }

    public CSQueue getRootQueue() {
        return this.root;
    }

    public CapacitySchedulerConfiguration getConfiguration() {
        return this.conf;
    }

    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public Comparator<FiCaSchedulerApp> getApplicationComparator() {
        return applicationComparator;
    }

    public ResourceCalculator getResourceCalculator() {
        return this.calculator;
    }

    public Comparator<CSQueue> getQueueComparator() {
        return queueComparator;
    }

    public int getNumClusterNodes() {
        return this.numNodeManagers.get();
    }

    public synchronized RMContext getRMContext() {
        return this.rmContext;
    }

    public synchronized void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    private synchronized void initScheduler(Configuration configuration) throws IOException {
        this.conf = this.loadCapacitySchedulerConfiguration(configuration);
        this.validateConf((Configuration)this.conf);
        this.minimumAllocation = this.conf.getMinimumAllocation();
        this.maximumAllocation = this.conf.getMaximumAllocation();
        this.calculator = this.conf.getResourceCalculator();
        this.usePortForNodeName = this.conf.getUsePortForNodeName();
        this.applications = new ConcurrentHashMap();
        this.initializeQueues(this.conf);
        this.scheduleAsynchronously = this.conf.getScheduleAynschronously();
        this.asyncScheduleInterval = this.conf.getLong("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", 5L);
        if (this.scheduleAsynchronously) {
            this.asyncSchedulerThread = new AsyncScheduleThread(this);
        }
        LOG.info((Object)("Initialized CapacityScheduler with calculator=" + this.getResourceCalculator().getClass() + ", " + "minimumAllocation=<" + this.getMinimumResourceCapability() + ">, " + "maximumAllocation=<" + this.getMaximumResourceCapability() + ">, " + "asynchronousScheduling=" + this.scheduleAsynchronously + ", " + "asyncScheduleInterval=" + this.asyncScheduleInterval + "ms"));
    }

    private synchronized void startSchedulerThreads() {
        if (this.scheduleAsynchronously) {
            Preconditions.checkNotNull((Object)this.asyncSchedulerThread, (Object)"asyncSchedulerThread is null");
            this.asyncSchedulerThread.start();
        }
    }

    public void serviceInit(Configuration conf) throws Exception {
        Configuration configuration = new Configuration(conf);
        this.initScheduler(configuration);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        CapacityScheduler capacityScheduler = this;
        synchronized (capacityScheduler) {
            if (this.scheduleAsynchronously && this.asyncSchedulerThread != null) {
                this.asyncSchedulerThread.interrupt();
                this.asyncSchedulerThread.join(1000L);
            }
        }
        super.serviceStop();
    }

    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        Configuration configuration = new Configuration(conf);
        CapacitySchedulerConfiguration oldConf = this.conf;
        this.conf = this.loadCapacitySchedulerConfiguration(configuration);
        this.validateConf((Configuration)this.conf);
        try {
            LOG.info((Object)"Re-initializing queues...");
            this.reinitializeQueues(this.conf);
        }
        catch (Throwable t) {
            this.conf = oldConf;
            throw new IOException("Failed to re-init queues", t);
        }
    }

    long getAsyncScheduleInterval() {
        return this.asyncScheduleInterval;
    }

    static void schedule(CapacityScheduler cs) {
        int current = 0;
        Collection nodes = cs.getAllNodes().values();
        int start = random.nextInt(nodes.size());
        for (FiCaSchedulerNode node : nodes) {
            if (current++ < start) continue;
            cs.allocateContainersToNode(node);
        }
        for (FiCaSchedulerNode node : nodes) {
            cs.allocateContainersToNode(node);
        }
        try {
            Thread.sleep(cs.getAsyncScheduleInterval());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this, (CapacitySchedulerConfiguration)conf, null, (String)"root", (Map)this.queues, (Map)this.queues, (QueueHook)noop);
        LOG.info((Object)("Initialized root queue " + this.root));
    }

    @Lock(value={CapacityScheduler.class})
    private void reinitializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        HashMap newQueues = new HashMap();
        CSQueue newRoot = CapacityScheduler.parseQueue((CapacitySchedulerContext)this, (CapacitySchedulerConfiguration)conf, null, (String)"root", newQueues, (Map)this.queues, (QueueHook)noop);
        this.validateExistingQueues(this.queues, newQueues);
        this.addNewQueues(this.queues, newQueues);
        this.root.reinitialize(newRoot, this.clusterResource);
    }

    @Lock(value={CapacityScheduler.class})
    private void validateExistingQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) throws IOException {
        for (String queue : queues.keySet()) {
            if (newQueues.containsKey(queue)) continue;
            throw new IOException(queue + " cannot be found during refresh!");
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void addNewQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) {
        for (Map.Entry<String, CSQueue> e : newQueues.entrySet()) {
            String queueName = e.getKey();
            CSQueue queue = e.getValue();
            if (queues.containsKey(queueName)) continue;
            queues.put(queueName, queue);
        }
    }

    @Lock(value={CapacityScheduler.class})
    static CSQueue parseQueue(CapacitySchedulerContext csContext, CapacitySchedulerConfiguration conf, CSQueue parent, String queueName, Map<String, CSQueue> queues, Map<String, CSQueue> oldQueues, QueueHook hook) throws IOException {
        LeafQueue queue;
        String[] childQueueNames = conf.getQueues(parent == null ? queueName : parent.getQueuePath() + "." + queueName);
        if (childQueueNames == null || childQueueNames.length == 0) {
            if (null == parent) {
                throw new IllegalStateException("Queue configuration missing child queue names for " + queueName);
            }
            queue = new LeafQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook((CSQueue)queue);
        } else {
            ParentQueue parentQueue = new ParentQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook((CSQueue)parentQueue);
            ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
            for (String childQueueName : childQueueNames) {
                CSQueue childQueue = CapacityScheduler.parseQueue((CapacitySchedulerContext)csContext, (CapacitySchedulerConfiguration)conf, (CSQueue)queue, (String)childQueueName, queues, oldQueues, (QueueHook)hook);
                childQueues.add(childQueue);
            }
            parentQueue.setChildQueues(childQueues);
        }
        if (queue instanceof LeafQueue && queues.containsKey(queueName) && queues.get(queueName) instanceof LeafQueue) {
            throw new IOException("Two leaf queues were named " + queueName + ". Leaf queue names must be distinct");
        }
        queues.put(queueName, (CSQueue)queue);
        LOG.info((Object)("Initialized queue: " + queue));
        return queue;
    }

    synchronized CSQueue getQueue(String queueName) {
        return (CSQueue)this.queues.get(queueName);
    }

    private synchronized void addApplication(ApplicationId applicationId, String queueName, String user) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            String message = "Application " + applicationId + " submitted by user " + user + " to unknown queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, message));
            return;
        }
        if (!(queue instanceof LeafQueue)) {
            String message = "Application " + applicationId + " submitted by user " + user + " to non-leaf queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, message));
            return;
        }
        try {
            queue.submitApplication(applicationId, user, queueName);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application " + applicationId + " to queue " + queueName + " from user " + user), (Throwable)ace);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, ace.toString()));
            return;
        }
        SchedulerApplication application = new SchedulerApplication((Queue)queue, user);
        this.applications.put(applicationId, application);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
    }

    private synchronized void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean shouldNotifyAttemptAdded) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        CSQueue queue = (CSQueue)application.getQueue();
        FiCaSchedulerApp attempt = new FiCaSchedulerApp(applicationAttemptId, application.getUser(), (Queue)queue, queue.getActiveUsersManager(), this.rmContext);
        if (transferStateFromPreviousAttempt) {
            attempt.transferStateFromPreviousAttempt(application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt((SchedulerApplicationAttempt)attempt);
        queue.submitApplicationAttempt(attempt, application.getUser());
        LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user " + application.getUser() + " in queue " + queue.getQueueName()));
        if (shouldNotifyAttemptAdded) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Skipping notifying ATTEMPT_ADDED");
        }
    }

    private synchronized void doneApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        CSQueue queue = (CSQueue)application.getQueue();
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("Cannot finish application from non-leaf queue: " + queue.getQueueName()));
        } else {
            queue.finishApplication(applicationId, application.getUser());
        }
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        LOG.info((Object)("Application Attempt " + applicationAttemptId + " is done." + " finalState=" + rmAppAttemptFinalState));
        FiCaSchedulerApp attempt = this.getApplicationAttempt(applicationAttemptId);
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (application == null || attempt == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : attempt.getLiveContainers()) {
            if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                continue;
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)rmContainer.getContainerId(), (String)"Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : attempt.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)rmContainer.getContainerId(), (String)"Application Complete"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
        String queueName = attempt.getQueue().getQueueName();
        CSQueue queue = (CSQueue)this.queues.get(queueName);
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("Cannot finish application from non-leaf queue: " + queueName));
        } else {
            queue.finishApplicationAttempt(attempt, queue.getQueueName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value={Lock.NoLock.class})
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FiCaSchedulerApp application = this.getApplicationAttempt(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, (ResourceCalculator)this.getResourceCalculator(), (Resource)this.getClusterResource(), (Resource)this.getMinimumResourceCapability(), (Resource)this.maximumAllocation);
        for (ContainerId releasedContainerId : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainerId);
            if (rmContainer == null) {
                RMAuditLogger.logFailure((String)application.getUser(), (String)"AM Released Container", (String)"Unauthorized access or invalid container", (String)"CapacityScheduler", (String)"Trying to release container not owned by app or with invalid id", (ApplicationId)application.getApplicationId(), (ContainerId)releasedContainerId);
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)releasedContainerId, (String)"Container released by application"), RMContainerEventType.RELEASED);
        }
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                LOG.info((Object)("Calling allocate on a stopped application " + applicationAttemptId));
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + applicationAttemptId + " application=" + application));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)"allocate: post-update");
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + applicationAttemptId + " #ask=" + ask.size()));
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            return application.getAllocation(this.getResourceCalculator(), this.clusterResource, this.getMinimumResourceCapability());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lock(value={Lock.NoLock.class})
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        CSQueue queue = null;
        CapacityScheduler capacityScheduler = this;
        synchronized (capacityScheduler) {
            queue = (CSQueue)this.queues.get(queueName);
        }
        if (queue == null) {
            throw new IOException("Unknown queue: " + queueName);
        }
        return queue.getQueueInfo(includeChildQueues, recursive);
    }

    @Lock(value={Lock.NoLock.class})
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.root.getQueueUserAclInfo(user);
    }

    private synchronized void nodeUpdate(RMNode nm) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " clusterResources: " + this.clusterResource));
        }
        FiCaSchedulerNode node = this.getNode(nm.getNodeID());
        SchedulerUtils.updateResourceIfChanged((SchedulerNode)node, (RMNode)nm, (Resource)this.clusterResource, (Log)LOG);
        List containerInfoList = nm.pullContainerUpdates();
        ArrayList newlyLaunchedContainers = new ArrayList();
        ArrayList completedContainers = new ArrayList();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node being looked for scheduling " + nm + " availableResource: " + node.getAvailableResource()));
        }
    }

    private synchronized void allocateContainersToNode(FiCaSchedulerNode node) {
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            FiCaSchedulerApp reservedApplication = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(reservedContainer.getContainerId());
            LOG.info((Object)("Trying to fulfill reservation for application " + reservedApplication.getApplicationId() + " on node: " + node.getNodeID()));
            LeafQueue queue = (LeafQueue)reservedApplication.getQueue();
            CSAssignment assignment = queue.assignContainers(this.clusterResource, node);
            RMContainer excessReservation = assignment.getExcessReservation();
            if (excessReservation != null) {
                Container container = excessReservation.getContainer();
                queue.completedContainer(this.clusterResource, assignment.getApplication(), node, excessReservation, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getId(), (String)"Container reservation no longer required."), RMContainerEventType.RELEASED, null);
            }
        }
        if (node.getReservedContainer() == null) {
            if (Resources.greaterThanOrEqual((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)node.getAvailableResource(), (Resource)this.minimumAllocation)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Trying to schedule on node: " + node.getNodeName() + ", available: " + node.getAvailableResource()));
                }
                this.root.assignContainers(this.clusterResource, node);
            }
        } else {
            LOG.info((Object)("Skipping scheduling since node " + node.getNodeID() + " is reserved by application " + node.getReservedContainer().getContainerId().getApplicationAttemptId()));
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FiCaSchedulerNode node) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " launched container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    public void handle(SchedulerEvent event) {
        switch (3.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$scheduler$event$SchedulerEventType[((SchedulerEventType)event.getType()).ordinal()]) {
            case 1: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                this.recoverContainersOnNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case 2: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case 3: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                RMNode node = nodeUpdatedEvent.getRMNode();
                this.nodeUpdate(node);
                if (this.scheduleAsynchronously) break;
                this.allocateContainersToNode(this.getNode(node.getNodeID()));
                break;
            }
            case 4: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationId(), appAddedEvent.getQueue(), appAddedEvent.getUser());
                break;
            }
            case 5: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case 6: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getShouldNotifyAttemptAdded());
                break;
            }
            case 7: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case 8: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private synchronized void addNode(RMNode nodeManager) {
        this.nodes.put(nodeManager.getNodeID(), new FiCaSchedulerNode(nodeManager, this.usePortForNodeName));
        Resources.addTo((Resource)this.clusterResource, (Resource)nodeManager.getTotalCapability());
        this.root.updateClusterResource(this.clusterResource);
        int numNodes = this.numNodeManagers.incrementAndGet();
        LOG.info((Object)("Added node " + nodeManager.getNodeAddress() + " clusterResource: " + this.clusterResource));
        if (this.scheduleAsynchronously && numNodes == 1) {
            this.asyncSchedulerThread.beginSchedule();
        }
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node = (FiCaSchedulerNode)this.nodes.get(nodeInfo.getNodeID());
        if (node == null) {
            return;
        }
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getRMNode().getTotalCapability());
        this.root.updateClusterResource(this.clusterResource);
        int numNodes = this.numNodeManagers.decrementAndGet();
        if (this.scheduleAsynchronously && numNodes == 0) {
            this.asyncSchedulerThread.suspendSchedule();
        }
        List runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus((ContainerId)reservedContainer.getContainerId(), (String)"Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        LOG.info((Object)("Removed node " + nodeInfo.getNodeAddress() + " clusterResource: " + this.clusterResource));
    }

    @Lock(value={CapacityScheduler.class})
    private synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " unknown application " + appId + " completed with event " + event));
            return;
        }
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        LeafQueue queue = (LeafQueue)application.getQueue();
        queue.completedContainer(this.clusterResource, application, node, rmContainer, containerStatus, event, null);
        LOG.info((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + node + " with event: " + event));
    }

    @Lock(value={Lock.NoLock.class})
    @VisibleForTesting
    public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        return (FiCaSchedulerApp)super.getApplicationAttempt(applicationAttemptId);
    }

    @Lock(value={Lock.NoLock.class})
    FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodes.get(nodeId);
    }

    @Lock(value={Lock.NoLock.class})
    Map<NodeId, FiCaSchedulerNode> getAllNodes() {
        return this.nodes;
    }

    @Lock(value={Lock.NoLock.class})
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    public void dropContainerReservation(RMContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DROP_RESERVATION:" + container.toString()));
        }
        this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus((ContainerId)container.getContainerId(), (String)"Container reservation no longer required."), RMContainerEventType.KILL);
    }

    public void preemptContainer(ApplicationAttemptId aid, RMContainer cont) {
        FiCaSchedulerApp app;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PREEMPT_CONTAINER: application:" + aid.toString() + " container: " + cont.toString()));
        }
        if ((app = this.getApplicationAttempt(aid)) != null) {
            app.addPreemptContainer(cont.getContainerId());
        }
    }

    public void killContainer(RMContainer cont) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("KILL_CONTAINER: container" + cont.toString()));
        }
        this.recoverResourceRequestForContainer(cont);
        this.completedContainer(cont, SchedulerUtils.createPreemptedContainerStatus((ContainerId)cont.getContainerId(), (String)"Container preempted by scheduler"), RMContainerEventType.KILL);
    }

    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        CSQueue queue = (CSQueue)this.queues.get(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    private CapacitySchedulerConfiguration loadCapacitySchedulerConfiguration(Configuration configuration) throws IOException {
        try {
            InputStream CSInputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(configuration, "capacity-scheduler.xml");
            if (CSInputStream != null) {
                configuration.addResource(CSInputStream);
                return new CapacitySchedulerConfiguration(configuration, false);
            }
            return new CapacitySchedulerConfiguration(configuration, true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

