/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.TestRMAppAttemptTransitions;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAllocatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestRMAppAttemptTransitions {
    private static final Log LOG = LogFactory.getLog(TestRMAppAttemptTransitions.class);
    private static final String EMPTY_DIAGNOSTICS = "";
    private static final String RM_WEBAPP_ADDR = WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)new Configuration());
    private boolean isSecurityEnabled;
    private RMContext rmContext;
    private YarnScheduler scheduler;
    private ApplicationMasterService masterService;
    private ApplicationMasterLauncher applicationMasterLauncher;
    private AMLivelinessMonitor amLivelinessMonitor;
    private AMLivelinessMonitor amFinishingMonitor;
    private RMApplicationHistoryWriter writer;
    private RMStateStore store;
    private RMAppImpl application;
    private RMAppAttempt applicationAttempt;
    private Configuration conf = new Configuration();
    private AMRMTokenSecretManager amRMTokenManager = (AMRMTokenSecretManager)Mockito.spy((Object)new AMRMTokenSecretManager(this.conf));
    private ClientToAMTokenSecretManagerInRM clientToAMTokenManager = (ClientToAMTokenSecretManagerInRM)Mockito.spy((Object)new ClientToAMTokenSecretManagerInRM());
    private NMTokenSecretManagerInRM nmTokenManager = (NMTokenSecretManagerInRM)Mockito.spy((Object)new NMTokenSecretManagerInRM(this.conf));
    private boolean transferStateFromPreviousAttempt = false;
    private static int appId = 1;
    private ApplicationSubmissionContext submissionContext = null;
    private boolean unmanagedAM;

    @Parameterized.Parameters
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestRMAppAttemptTransitions(Boolean isSecurityEnabled) {
        this.isSecurityEnabled = isSecurityEnabled;
    }

    @Before
    public void setUp() throws Exception {
        UserGroupInformation.AuthenticationMethod authMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        if (this.isSecurityEnabled) {
            authMethod = UserGroupInformation.AuthenticationMethod.KERBEROS;
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)authMethod, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        InlineDispatcher rmDispatcher = new InlineDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        this.amLivelinessMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        this.amFinishingMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        this.writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        this.rmContext = new RMContextImpl((Dispatcher)rmDispatcher, containerAllocationExpirer, this.amLivelinessMonitor, this.amFinishingMonitor, null, this.amRMTokenManager, new RMContainerTokenSecretManager(this.conf), this.nmTokenManager, this.clientToAMTokenManager, this.writer);
        this.store = (RMStateStore)Mockito.mock(RMStateStore.class);
        ((RMContextImpl)this.rmContext).setStateStore(this.store);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        this.masterService = (ApplicationMasterService)Mockito.mock(ApplicationMasterService.class);
        this.applicationMasterLauncher = (ApplicationMasterLauncher)Mockito.mock(ApplicationMasterLauncher.class);
        rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new TestApplicationAttemptEventDispatcher(this, null));
        rmDispatcher.register(RMAppEventType.class, (EventHandler)new TestApplicationEventDispatcher(this, null));
        rmDispatcher.register(SchedulerEventType.class, (EventHandler)new TestSchedulerEventDispatcher(this, null));
        rmDispatcher.register(AMLauncherEventType.class, (EventHandler)new TestAMLauncherEventDispatcher(this, null));
        rmDispatcher.init(this.conf);
        rmDispatcher.start();
        ApplicationId applicationId = MockApps.newAppID((int)appId++);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)0);
        String user = MockApps.newUserName();
        String queue = MockApps.newQueue();
        this.submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)this.submissionContext.getQueue()).thenReturn((Object)queue);
        Resource resource = BuilderUtils.newResource((int)1536, (int)1);
        ContainerLaunchContext amContainerSpec = BuilderUtils.newContainerLaunchContext(null, null, null, null, null, null);
        Mockito.when((Object)this.submissionContext.getAMContainerSpec()).thenReturn((Object)amContainerSpec);
        Mockito.when((Object)this.submissionContext.getResource()).thenReturn((Object)resource);
        this.unmanagedAM = false;
        this.application = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        this.applicationAttempt = new RMAppAttemptImpl(applicationAttemptId, this.rmContext, this.scheduler, this.masterService, this.submissionContext, new Configuration(), false);
        Mockito.when((Object)this.application.getCurrentAppAttempt()).thenReturn((Object)this.applicationAttempt);
        Mockito.when((Object)this.application.getApplicationId()).thenReturn((Object)applicationId);
        this.testAppAttemptNewState();
    }

    @After
    public void tearDown() throws Exception {
        ((AsyncDispatcher)this.rmContext.getDispatcher()).stop();
    }

    private String getProxyUrl(RMAppAttempt appAttempt) {
        String url = null;
        String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf);
        try {
            URI trackingUri = StringUtils.isEmpty((String)appAttempt.getOriginalTrackingUrl()) ? null : ProxyUriUtils.getUriFromAMUrl((String)scheme, (String)appAttempt.getOriginalTrackingUrl());
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)this.conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)scheme, (String)proxy);
            URI result = ProxyUriUtils.getProxyUri((URI)trackingUri, (URI)proxyUri, (ApplicationId)appAttempt.getAppAttemptId().getApplicationId());
            url = result.toASCIIString();
        }
        catch (URISyntaxException ex) {
            Assert.fail();
        }
        return url;
    }

    private void testAppAttemptNewState() {
        Assert.assertEquals((Object)RMAppAttemptState.NEW, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getDiagnostics().length());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertNull((Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((double)0.0, (double)this.applicationAttempt.getProgress(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        Assert.assertNull((Object)this.applicationAttempt.getFinalApplicationStatus());
        Assert.assertNotNull((Object)this.applicationAttempt.getTrackingUrl());
        Assert.assertFalse((boolean)"N/A".equals(this.applicationAttempt.getTrackingUrl()));
    }

    private void testAppAttemptSubmittedState() {
        Assert.assertEquals((Object)RMAppAttemptState.SUBMITTED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getDiagnostics().length());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertNull((Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((double)0.0, (double)this.applicationAttempt.getProgress(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        Assert.assertNull((Object)this.applicationAttempt.getFinalApplicationStatus());
        if (UserGroupInformation.isSecurityEnabled()) {
            ((ClientToAMTokenSecretManagerInRM)Mockito.verify((Object)this.clientToAMTokenManager)).createMasterKey(this.applicationAttempt.getAppAttemptId());
            Assert.assertNull((Object)this.applicationAttempt.createClientToken("some client"));
        }
        Assert.assertNull((Object)this.applicationAttempt.createClientToken(null));
        Assert.assertNotNull((Object)this.applicationAttempt.getAMRMToken());
        ((ApplicationMasterService)Mockito.verify((Object)this.masterService)).registerAppAttempt(this.applicationAttempt.getAppAttemptId());
        ((YarnScheduler)Mockito.verify((Object)this.scheduler)).handle((Event)Matchers.any(AppAttemptAddedSchedulerEvent.class));
    }

    private void testAppAttemptSubmittedToFailedState(String diagnostics) {
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)diagnostics, (Object)this.applicationAttempt.getDiagnostics());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertNull((Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((double)0.0, (double)this.applicationAttempt.getProgress(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        Assert.assertNull((Object)this.applicationAttempt.getFinalApplicationStatus());
        ((ApplicationMasterService)Mockito.verify((Object)this.masterService)).unregisterAttempt(this.applicationAttempt.getAppAttemptId());
        ((RMAppImpl)Mockito.verify((Object)this.application)).handle((RMAppEvent)Matchers.any(RMAppRejectedEvent.class));
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    private void testAppAttemptKilledState(Container amContainer, String diagnostics) {
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.KILLED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)diagnostics, (Object)this.applicationAttempt.getDiagnostics());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertEquals((Object)amContainer, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((double)0.0, (double)this.applicationAttempt.getProgress(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        Assert.assertNull((Object)this.applicationAttempt.getFinalApplicationStatus());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyAttemptFinalStateSaved();
        Assert.assertFalse((boolean)this.transferStateFromPreviousAttempt);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.KILLED);
    }

    private void testAppAttemptRecoveredState() {
        Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED, (Object)this.applicationAttempt.getAppAttemptState());
    }

    private void testAppAttemptScheduledState() {
        int expectedAllocateCount;
        RMAppAttemptState expectedState;
        if (this.unmanagedAM) {
            expectedState = RMAppAttemptState.LAUNCHED;
            expectedAllocateCount = 0;
        } else {
            expectedState = RMAppAttemptState.SCHEDULED;
            expectedAllocateCount = 1;
        }
        Assert.assertEquals((Object)expectedState, (Object)this.applicationAttempt.getAppAttemptState());
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)expectedAllocateCount))).allocate((ApplicationAttemptId)Matchers.any(ApplicationAttemptId.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class));
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertNull((Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((double)0.0, (double)this.applicationAttempt.getProgress(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        Assert.assertNull((Object)this.applicationAttempt.getFinalApplicationStatus());
    }

    private void testAppAttemptAllocatedState(Container amContainer) {
        Assert.assertEquals((Object)RMAppAttemptState.ALLOCATED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)amContainer, (Object)this.applicationAttempt.getMasterContainer());
        ((ApplicationMasterLauncher)Mockito.verify((Object)this.applicationMasterLauncher)).handle((AMLauncherEvent)Matchers.any(AMLauncherEvent.class));
        ((YarnScheduler)Mockito.verify((Object)this.scheduler, (VerificationMode)Mockito.times((int)2))).allocate((ApplicationAttemptId)Matchers.any(ApplicationAttemptId.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class));
        ((NMTokenSecretManagerInRM)Mockito.verify((Object)this.nmTokenManager)).clearNodeSetForAttempt(this.applicationAttempt.getAppAttemptId());
    }

    private void testAppAttemptFailedState(Container container, String diagnostics) {
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)diagnostics, (Object)this.applicationAttempt.getDiagnostics());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertEquals((Object)container, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((double)0.0, (double)this.applicationAttempt.getProgress(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        ((RMAppImpl)Mockito.verify((Object)this.application, (VerificationMode)Mockito.times((int)1))).handle((RMAppEvent)Matchers.any(RMAppFailedAttemptEvent.class));
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyAttemptFinalStateSaved();
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    private void testAppAttemptLaunchedState(Container container) {
        Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)container, (Object)this.applicationAttempt.getMasterContainer());
        if (UserGroupInformation.isSecurityEnabled()) {
            Assert.assertNotNull((Object)this.applicationAttempt.createClientToken("some client"));
        }
    }

    private void testAppAttemptRunningState(Container container, String host, int rpcPort, String trackingUrl, boolean unmanagedAM) {
        Assert.assertEquals((Object)RMAppAttemptState.RUNNING, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)container, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((Object)host, (Object)this.applicationAttempt.getHost());
        Assert.assertEquals((long)rpcPort, (long)this.applicationAttempt.getRpcPort());
        this.verifyUrl(trackingUrl, this.applicationAttempt.getOriginalTrackingUrl());
        if (unmanagedAM) {
            this.verifyUrl(trackingUrl, this.applicationAttempt.getTrackingUrl());
        } else {
            Assert.assertEquals((Object)this.getProxyUrl(this.applicationAttempt), (Object)this.applicationAttempt.getTrackingUrl());
        }
    }

    private void testAppAttemptFinishingState(Container container, FinalApplicationStatus finalStatus, String trackingUrl, String diagnostics) {
        Assert.assertEquals((Object)RMAppAttemptState.FINISHING, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)diagnostics, (Object)this.applicationAttempt.getDiagnostics());
        this.verifyUrl(trackingUrl, this.applicationAttempt.getOriginalTrackingUrl());
        Assert.assertEquals((Object)this.getProxyUrl(this.applicationAttempt), (Object)this.applicationAttempt.getTrackingUrl());
        Assert.assertEquals((Object)container, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((Object)finalStatus, (Object)this.applicationAttempt.getFinalApplicationStatus());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 0);
        this.verifyAttemptFinalStateSaved();
    }

    private void testAppAttemptFinishedState(Container container, FinalApplicationStatus finalStatus, String trackingUrl, String diagnostics, int finishedContainerCount, boolean unmanagedAM) {
        Assert.assertEquals((Object)RMAppAttemptState.FINISHED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)diagnostics, (Object)this.applicationAttempt.getDiagnostics());
        this.verifyUrl(trackingUrl, this.applicationAttempt.getOriginalTrackingUrl());
        if (unmanagedAM) {
            this.verifyUrl(trackingUrl, this.applicationAttempt.getTrackingUrl());
        } else {
            Assert.assertEquals((Object)this.getProxyUrl(this.applicationAttempt), (Object)this.applicationAttempt.getTrackingUrl());
            this.verifyAttemptFinalStateSaved();
        }
        Assert.assertEquals((long)finishedContainerCount, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertEquals((Object)container, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((Object)finalStatus, (Object)this.applicationAttempt.getFinalApplicationStatus());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        Assert.assertFalse((boolean)this.transferStateFromPreviousAttempt);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FINISHED);
    }

    private void submitApplicationAttempt() {
        ApplicationAttemptId appAttemptId = this.applicationAttempt.getAppAttemptId();
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.START));
        this.testAppAttemptSubmittedState();
    }

    private void scheduleApplicationAttempt() {
        this.submitApplicationAttempt();
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.ATTEMPT_ADDED));
        if (this.unmanagedAM) {
            Assert.assertEquals((Object)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
            this.applicationAttempt.handle((Event)new RMAppAttemptNewSavedEvent(this.applicationAttempt.getAppAttemptId(), null));
        }
        this.testAppAttemptScheduledState();
    }

    private Container allocateApplicationAttempt() {
        this.scheduleApplicationAttempt();
        Container container = (Container)Mockito.mock(Container.class);
        Resource resource = BuilderUtils.newResource((int)2048, (int)1);
        Mockito.when((Object)container.getId()).thenReturn((Object)BuilderUtils.newContainerId((ApplicationAttemptId)this.applicationAttempt.getAppAttemptId(), (int)1));
        Mockito.when((Object)container.getResource()).thenReturn((Object)resource);
        Allocation allocation = (Allocation)Mockito.mock(Allocation.class);
        Mockito.when((Object)allocation.getContainers()).thenReturn(Collections.singletonList(container));
        Mockito.when((Object)this.scheduler.allocate((ApplicationAttemptId)Matchers.any(ApplicationAttemptId.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class), (List)Matchers.any(List.class))).thenReturn((Object)allocation);
        RMContainer rmContainer = (RMContainer)Mockito.mock(RMContainerImpl.class);
        Mockito.when((Object)this.scheduler.getRMContainer(container.getId())).thenReturn((Object)rmContainer);
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerAllocatedEvent(this.applicationAttempt.getAppAttemptId()));
        Assert.assertEquals((Object)RMAppAttemptState.ALLOCATED_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        this.applicationAttempt.handle((Event)new RMAppAttemptNewSavedEvent(this.applicationAttempt.getAppAttemptId(), null));
        this.testAppAttemptAllocatedState(container);
        return container;
    }

    private void launchApplicationAttempt(Container container) {
        if (UserGroupInformation.isSecurityEnabled()) {
            Assert.assertNull((Object)this.applicationAttempt.createClientToken("some client"));
        }
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
        this.testAppAttemptLaunchedState(container);
    }

    private void runApplicationAttempt(Container container, String host, int rpcPort, String trackingUrl, boolean unmanagedAM) {
        this.applicationAttempt.handle((Event)new RMAppAttemptRegistrationEvent(this.applicationAttempt.getAppAttemptId(), host, rpcPort, trackingUrl));
        this.testAppAttemptRunningState(container, host, rpcPort, trackingUrl, unmanagedAM);
    }

    private void unregisterApplicationAttempt(Container container, FinalApplicationStatus finalStatus, String trackingUrl, String diagnostics) {
        this.applicationAttempt.handle((Event)new RMAppAttemptUnregistrationEvent(this.applicationAttempt.getAppAttemptId(), trackingUrl, finalStatus, diagnostics));
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        this.testAppAttemptFinishingState(container, finalStatus, trackingUrl, diagnostics);
    }

    private void testUnmanagedAMSuccess(String url) {
        this.unmanagedAM = true;
        Mockito.when((Object)this.submissionContext.getUnmanagedAM()).thenReturn((Object)true);
        this.scheduleApplicationAttempt();
        this.testAppAttemptLaunchedState(null);
        ((AMLivelinessMonitor)Mockito.verify((Object)this.amLivelinessMonitor, (VerificationMode)Mockito.times((int)1))).register((Object)this.applicationAttempt.getAppAttemptId());
        this.runApplicationAttempt(null, "host", 8042, url, true);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)NodeId.newInstance((String)"host", (int)1234));
        this.application.handle((RMAppEvent)new RMAppRunningOnNodeEvent(this.application.getApplicationId(), container.getNodeId()));
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), (ContainerStatus)Mockito.mock(ContainerStatus.class)));
        String diagnostics = "Successful";
        FinalApplicationStatus finalStatus = FinalApplicationStatus.SUCCEEDED;
        this.applicationAttempt.handle((Event)new RMAppAttemptUnregistrationEvent(this.applicationAttempt.getAppAttemptId(), url, finalStatus, diagnostics));
        this.testAppAttemptFinishedState(null, finalStatus, url, diagnostics, 1, true);
        Assert.assertFalse((boolean)this.transferStateFromPreviousAttempt);
    }

    private void sendAttemptUpdateSavedEvent(RMAppAttempt applicationAttempt) {
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)applicationAttempt.getAppAttemptState());
        applicationAttempt.handle((Event)new RMAppAttemptUpdateSavedEvent(applicationAttempt.getAppAttemptId(), null));
    }

    @Test
    public void testUnmanagedAMUnexpectedRegistration() {
        this.unmanagedAM = true;
        Mockito.when((Object)this.submissionContext.getUnmanagedAM()).thenReturn((Object)true);
        this.submitApplicationAttempt();
        Assert.assertEquals((Object)RMAppAttemptState.SUBMITTED, (Object)this.applicationAttempt.getAppAttemptState());
        this.applicationAttempt.handle((Event)new RMAppAttemptRegistrationEvent(this.applicationAttempt.getAppAttemptId(), "host", 8042, "oldtrackingurl"));
        Assert.assertEquals((Object)YarnApplicationAttemptState.SUBMITTED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.testAppAttemptSubmittedToFailedState("Unmanaged AM must register after AM attempt reaches LAUNCHED state.");
    }

    @Test
    public void testUnmanagedAMContainersCleanup() {
        this.unmanagedAM = true;
        Mockito.when((Object)this.submissionContext.getUnmanagedAM()).thenReturn((Object)true);
        Mockito.when((Object)this.submissionContext.getKeepContainersAcrossApplicationAttempts()).thenReturn((Object)true);
        this.submitApplicationAttempt();
        this.applicationAttempt.handle((Event)new RMAppAttemptRegistrationEvent(this.applicationAttempt.getAppAttemptId(), "host", 8042, "oldtrackingurl"));
        Assert.assertEquals((Object)YarnApplicationAttemptState.SUBMITTED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertFalse((boolean)this.transferStateFromPreviousAttempt);
    }

    @Test
    public void testNewToKilled() {
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        Assert.assertEquals((Object)YarnApplicationAttemptState.NEW, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.testAppAttemptKilledState(null, EMPTY_DIAGNOSTICS);
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
    }

    @Test
    public void testNewToRecovered() {
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.RECOVER));
        this.testAppAttemptRecoveredState();
    }

    @Test
    public void testSubmittedToKilled() {
        this.submitApplicationAttempt();
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        Assert.assertEquals((Object)YarnApplicationAttemptState.SUBMITTED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.testAppAttemptKilledState(null, EMPTY_DIAGNOSTICS);
    }

    @Test
    public void testScheduledToKilled() {
        this.scheduleApplicationAttempt();
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        Assert.assertEquals((Object)YarnApplicationAttemptState.SCHEDULED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.testAppAttemptKilledState(null, EMPTY_DIAGNOSTICS);
    }

    @Test
    public void testAllocatedToKilled() {
        Container amContainer = this.allocateApplicationAttempt();
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        Assert.assertEquals((Object)YarnApplicationAttemptState.ALLOCATED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.testAppAttemptKilledState(amContainer, EMPTY_DIAGNOSTICS);
    }

    @Test
    public void testAllocatedToFailed() {
        Container amContainer = this.allocateApplicationAttempt();
        String diagnostics = "Launch Failed";
        this.applicationAttempt.handle((Event)new RMAppAttemptLaunchFailedEvent(this.applicationAttempt.getAppAttemptId(), diagnostics));
        Assert.assertEquals((Object)YarnApplicationAttemptState.ALLOCATED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.testAppAttemptFailedState(amContainer, diagnostics);
    }

    @Test
    public void testAMCrashAtAllocated() {
        Container amContainer = this.allocateApplicationAttempt();
        String containerDiagMsg = "some error";
        int exitCode = 123;
        ContainerStatus cs = BuilderUtils.newContainerStatus((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)containerDiagMsg, (int)exitCode);
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), cs));
        Assert.assertEquals((Object)YarnApplicationAttemptState.ALLOCATED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    @Test
    public void testRunningToFailed() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        String containerDiagMsg = "some error";
        int exitCode = 123;
        ContainerStatus cs = BuilderUtils.newContainerStatus((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)containerDiagMsg, (int)exitCode);
        ApplicationAttemptId appAttemptId = this.applicationAttempt.getAppAttemptId();
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(appAttemptId, cs));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), BuilderUtils.newContainerStatus((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)EMPTY_DIAGNOSTICS, (int)0)));
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.EXPIRE));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertEquals((Object)amContainer, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        String rmAppPageUrl = StringHelper.pjoin((Object[])new Object[]{RM_WEBAPP_ADDR, "cluster", "app", this.applicationAttempt.getAppAttemptId().getApplicationId()});
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getOriginalTrackingUrl());
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getTrackingUrl());
        this.verifyAMHostAndPortInvalidated();
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    @Test
    public void testRunningToKilled() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), BuilderUtils.newContainerStatus((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)EMPTY_DIAGNOSTICS, (int)0)));
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.EXPIRE));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.KILLED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertEquals((Object)amContainer, (Object)this.applicationAttempt.getMasterContainer());
        Assert.assertEquals((long)0L, (long)this.application.getRanNodes().size());
        String rmAppPageUrl = StringHelper.pjoin((Object[])new Object[]{RM_WEBAPP_ADDR, "cluster", "app", this.applicationAttempt.getAppAttemptId().getApplicationId()});
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getOriginalTrackingUrl());
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getTrackingUrl());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyAMHostAndPortInvalidated();
        this.verifyApplicationAttemptFinished(RMAppAttemptState.KILLED);
    }

    @Test(timeout=10000L)
    public void testLaunchedExpire() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.EXPIRE));
        Assert.assertEquals((Object)YarnApplicationAttemptState.LAUNCHED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertTrue((String)"expire diagnostics missing", (boolean)this.applicationAttempt.getDiagnostics().contains("timed out"));
        String rmAppPageUrl = StringHelper.pjoin((Object[])new Object[]{RM_WEBAPP_ADDR, "cluster", "app", this.applicationAttempt.getAppAttemptId().getApplicationId()});
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getOriginalTrackingUrl());
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getTrackingUrl());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    @Test(timeout=20000L)
    public void testRunningExpire() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.EXPIRE));
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertTrue((String)"expire diagnostics missing", (boolean)this.applicationAttempt.getDiagnostics().contains("timed out"));
        String rmAppPageUrl = StringHelper.pjoin((Object[])new Object[]{RM_WEBAPP_ADDR, "cluster", "app", this.applicationAttempt.getAppAttemptId().getApplicationId()});
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getOriginalTrackingUrl());
        Assert.assertEquals((Object)rmAppPageUrl, (Object)this.applicationAttempt.getTrackingUrl());
        this.verifyTokenCount(this.applicationAttempt.getAppAttemptId(), 1);
        this.verifyAMHostAndPortInvalidated();
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    @Test
    public void testUnregisterToKilledFinishing() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        this.unregisterApplicationAttempt(amContainer, FinalApplicationStatus.KILLED, "newtrackingurl", "Killed by user");
    }

    @Test
    public void testTrackingUrlUnmanagedAM() {
        this.testUnmanagedAMSuccess("oldTrackingUrl");
    }

    @Test
    public void testEmptyTrackingUrlUnmanagedAM() {
        this.testUnmanagedAMSuccess(EMPTY_DIAGNOSTICS);
    }

    @Test
    public void testNullTrackingUrlUnmanagedAM() {
        this.testUnmanagedAMSuccess(null);
    }

    @Test
    public void testManagedAMWithTrackingUrl() {
        this.testTrackingUrlManagedAM("theTrackingUrl");
    }

    @Test
    public void testManagedAMWithEmptyTrackingUrl() {
        this.testTrackingUrlManagedAM(EMPTY_DIAGNOSTICS);
    }

    @Test
    public void testManagedAMWithNullTrackingUrl() {
        this.testTrackingUrlManagedAM(null);
    }

    private void testTrackingUrlManagedAM(String url) {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, url, false);
        this.unregisterApplicationAttempt(amContainer, FinalApplicationStatus.SUCCEEDED, url, "Successful");
    }

    @Test
    public void testUnregisterToSuccessfulFinishing() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        this.unregisterApplicationAttempt(amContainer, FinalApplicationStatus.SUCCEEDED, "mytrackingurl", "Successful");
    }

    @Test
    public void testFinishingKill() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        FinalApplicationStatus finalStatus = FinalApplicationStatus.FAILED;
        String trackingUrl = "newtrackingurl";
        String diagnostics = "Job failed";
        this.unregisterApplicationAttempt(amContainer, finalStatus, trackingUrl, diagnostics);
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        this.testAppAttemptFinishingState(amContainer, finalStatus, trackingUrl, diagnostics);
    }

    @Test
    public void testFinishingExpire() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        FinalApplicationStatus finalStatus = FinalApplicationStatus.SUCCEEDED;
        String trackingUrl = "mytrackingurl";
        String diagnostics = "Successful";
        this.unregisterApplicationAttempt(amContainer, finalStatus, trackingUrl, diagnostics);
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.EXPIRE));
        this.testAppAttemptFinishedState(amContainer, finalStatus, trackingUrl, diagnostics, 0, false);
    }

    @Test
    public void testFinishingToFinishing() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        FinalApplicationStatus finalStatus = FinalApplicationStatus.SUCCEEDED;
        String trackingUrl = "mytrackingurl";
        String diagnostics = "Successful";
        this.unregisterApplicationAttempt(amContainer, finalStatus, trackingUrl, diagnostics);
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), BuilderUtils.newContainerStatus((ContainerId)BuilderUtils.newContainerId((ApplicationAttemptId)this.applicationAttempt.getAppAttemptId(), (int)42), (ContainerState)ContainerState.COMPLETE, (String)EMPTY_DIAGNOSTICS, (int)0)));
        this.testAppAttemptFinishingState(amContainer, finalStatus, trackingUrl, diagnostics);
    }

    @Test
    public void testSuccessfulFinishingToFinished() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        FinalApplicationStatus finalStatus = FinalApplicationStatus.SUCCEEDED;
        String trackingUrl = "mytrackingurl";
        String diagnostics = "Successful";
        this.unregisterApplicationAttempt(amContainer, finalStatus, trackingUrl, diagnostics);
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), BuilderUtils.newContainerStatus((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)EMPTY_DIAGNOSTICS, (int)0)));
        this.testAppAttemptFinishedState(amContainer, finalStatus, trackingUrl, diagnostics, 0, false);
    }

    @Test
    public void testFinalSavingToFinishedWithContainerFinished() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        FinalApplicationStatus finalStatus = FinalApplicationStatus.SUCCEEDED;
        String trackingUrl = "mytrackingurl";
        String diagnostics = "Successful";
        this.applicationAttempt.handle((Event)new RMAppAttemptUnregistrationEvent(this.applicationAttempt.getAppAttemptId(), trackingUrl, finalStatus, diagnostics));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(this.applicationAttempt.getAppAttemptId(), BuilderUtils.newContainerStatus((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)EMPTY_DIAGNOSTICS, (int)0)));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        this.testAppAttemptFinishedState(amContainer, finalStatus, trackingUrl, diagnostics, 0, false);
    }

    @Test
    public void testFinalSavingToFinishedWithExpire() {
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        FinalApplicationStatus finalStatus = FinalApplicationStatus.SUCCEEDED;
        String trackingUrl = "mytrackingurl";
        String diagnostics = "Successssseeeful";
        this.applicationAttempt.handle((Event)new RMAppAttemptUnregistrationEvent(this.applicationAttempt.getAppAttemptId(), trackingUrl, finalStatus, diagnostics));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.EXPIRE));
        Assert.assertEquals((Object)RMAppAttemptState.FINAL_SAVING, (Object)this.applicationAttempt.getAppAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        this.testAppAttemptFinishedState(amContainer, finalStatus, trackingUrl, diagnostics, 0, false);
    }

    @Test
    public void testGetClientToken() throws Exception {
        Assume.assumeTrue((boolean)this.isSecurityEnabled);
        Container amContainer = this.allocateApplicationAttempt();
        Token token = this.applicationAttempt.createClientToken(null);
        Assert.assertNull((Object)token);
        token = this.applicationAttempt.createClientToken("clientuser");
        Assert.assertNull((Object)token);
        this.launchApplicationAttempt(amContainer);
        token = this.applicationAttempt.createClientToken(null);
        Assert.assertNull((Object)token);
        token = this.applicationAttempt.createClientToken("clientuser");
        Assert.assertNotNull((Object)token);
        this.applicationAttempt.handle((Event)new RMAppAttemptEvent(this.applicationAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
        Assert.assertEquals((Object)YarnApplicationAttemptState.LAUNCHED, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        token = this.applicationAttempt.createClientToken(null);
        Assert.assertNull((Object)token);
        token = this.applicationAttempt.createClientToken("clientuser");
        Assert.assertNull((Object)token);
    }

    @Test
    public void testFailedToFailed() {
        Mockito.when((Object)this.submissionContext.getKeepContainersAcrossApplicationAttempts()).thenReturn((Object)true);
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        ContainerStatus cs1 = ContainerStatus.newInstance((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"some error", (int)123);
        ApplicationAttemptId appAttemptId = this.applicationAttempt.getAppAttemptId();
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(appAttemptId, cs1));
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertTrue((boolean)this.transferStateFromPreviousAttempt);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
        Assert.assertEquals((long)0L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        ContainerStatus cs2 = ContainerStatus.newInstance((ContainerId)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)2), (ContainerState)ContainerState.COMPLETE, (String)EMPTY_DIAGNOSTICS, (int)0);
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(appAttemptId, cs2));
        Assert.assertEquals((long)1L, (long)this.applicationAttempt.getJustFinishedContainers().size());
        Assert.assertEquals((Object)cs2.getContainerId(), (Object)((ContainerStatus)this.applicationAttempt.getJustFinishedContainers().get(0)).getContainerId());
    }

    @Test
    public void testContainersCleanupForLastAttempt() {
        this.applicationAttempt = new RMAppAttemptImpl(this.applicationAttempt.getAppAttemptId(), this.rmContext, this.scheduler, this.masterService, this.submissionContext, new Configuration(), true);
        Mockito.when((Object)this.submissionContext.getKeepContainersAcrossApplicationAttempts()).thenReturn((Object)true);
        Mockito.when((Object)this.submissionContext.getMaxAppAttempts()).thenReturn((Object)1);
        Container amContainer = this.allocateApplicationAttempt();
        this.launchApplicationAttempt(amContainer);
        this.runApplicationAttempt(amContainer, "host", 8042, "oldtrackingurl", false);
        ContainerStatus cs1 = ContainerStatus.newInstance((ContainerId)amContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"some error", (int)123);
        ApplicationAttemptId appAttemptId = this.applicationAttempt.getAppAttemptId();
        this.applicationAttempt.handle((Event)new RMAppAttemptContainerFinishedEvent(appAttemptId, cs1));
        Assert.assertEquals((Object)YarnApplicationAttemptState.RUNNING, (Object)this.applicationAttempt.createApplicationAttemptState());
        this.sendAttemptUpdateSavedEvent(this.applicationAttempt);
        Assert.assertEquals((Object)RMAppAttemptState.FAILED, (Object)this.applicationAttempt.getAppAttemptState());
        Assert.assertFalse((boolean)this.transferStateFromPreviousAttempt);
        this.verifyApplicationAttemptFinished(RMAppAttemptState.FAILED);
    }

    private void verifyTokenCount(ApplicationAttemptId appAttemptId, int count) {
        ((AMRMTokenSecretManager)Mockito.verify((Object)this.amRMTokenManager, (VerificationMode)Mockito.times((int)count))).applicationMasterFinished(appAttemptId);
        if (UserGroupInformation.isSecurityEnabled()) {
            ((ClientToAMTokenSecretManagerInRM)Mockito.verify((Object)this.clientToAMTokenManager, (VerificationMode)Mockito.times((int)count))).unRegisterApplication(appAttemptId);
            if (count > 0) {
                Assert.assertNull((Object)this.applicationAttempt.createClientToken("client"));
            }
        }
    }

    private void verifyUrl(String url1, String url2) {
        if (url1 == null || url1.trim().isEmpty()) {
            Assert.assertEquals((Object)"N/A", (Object)url2);
        } else {
            Assert.assertEquals((Object)url1, (Object)url2);
        }
    }

    private void verifyAttemptFinalStateSaved() {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).updateApplicationAttemptState((RMStateStore.ApplicationAttemptState)Matchers.any(RMStateStore.ApplicationAttemptState.class));
    }

    private void verifyAMHostAndPortInvalidated() {
        Assert.assertEquals((Object)"N/A", (Object)this.applicationAttempt.getHost());
        Assert.assertEquals((long)-1L, (long)this.applicationAttempt.getRpcPort());
    }

    private void verifyApplicationAttemptFinished(RMAppAttemptState state) {
        ArgumentCaptor finalState = ArgumentCaptor.forClass(RMAppAttemptState.class);
        ((RMApplicationHistoryWriter)Mockito.verify((Object)this.writer)).applicationAttemptFinished((RMAppAttempt)Matchers.any(RMAppAttempt.class), (RMAppAttemptState)finalState.capture());
        Assert.assertEquals((Object)state, (Object)finalState.getValue());
    }

    static /* synthetic */ RMAppAttempt access$000(TestRMAppAttemptTransitions x0) {
        return x0.applicationAttempt;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ RMAppImpl access$200(TestRMAppAttemptTransitions x0) {
        return x0.application;
    }

    static /* synthetic */ boolean access$302(TestRMAppAttemptTransitions x0, boolean x1) {
        x0.transferStateFromPreviousAttempt = x1;
        return x0.transferStateFromPreviousAttempt;
    }

    static /* synthetic */ YarnScheduler access$400(TestRMAppAttemptTransitions x0) {
        return x0.scheduler;
    }

    static /* synthetic */ ApplicationMasterLauncher access$500(TestRMAppAttemptTransitions x0) {
        return x0.applicationMasterLauncher;
    }
}

