/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppStartAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMAppImpl
implements RMApp,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private final ApplicationId applicationId;
    private final RMContext rmContext;
    private final Configuration conf;
    private final String user;
    private final String name;
    private final ApplicationSubmissionContext submissionContext;
    private final Dispatcher dispatcher;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final StringBuilder diagnostics = new StringBuilder();
    private final int maxAppAttempts;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Map<ApplicationAttemptId, RMAppAttempt> attempts = new LinkedHashMap();
    private final long submitTime;
    private final Set<RMNode> updatedNodes = new HashSet();
    private final String applicationType;
    private final Set<String> applicationTags;
    private long startTime;
    private long finishTime = 0L;
    private long storedFinishTime = 0L;
    private RMAppAttempt currentAttempt;
    private String queue;
    private EventHandler handler;
    private static final AppFinishedTransition FINISHED_TRANSITION = new AppFinishedTransition();
    private Set<NodeId> ranNodes = new ConcurrentSkipListSet();
    private RMAppState stateBeforeKilling;
    private RMAppState stateBeforeFinalSaving;
    private RMAppEvent eventCausingFinalSaving;
    private RMAppState targetedFinalState;
    private RMAppState recoveredFinalState;
    Object transitionTodo;
    private static final StateMachineFactory<RMAppImpl, RMAppState, RMAppEventType, RMAppEvent> stateMachineFactory = new StateMachineFactory((Enum)RMAppState.NEW).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.NEW, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition(null)).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.START, (SingleArcTransition)new RMAppNewlySavingTransition(null)).addTransition((Enum)RMAppState.NEW, EnumSet.of(RMAppState.SUBMITTED, new RMAppState[]{RMAppState.ACCEPTED, RMAppState.FINISHED, RMAppState.FAILED, RMAppState.KILLED, RMAppState.FINAL_SAVING}), (Enum)RMAppEventType.RECOVER, (MultipleArcTransition)new RMAppRecoveredTransition(null)).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new AppKilledTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition(null)).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.APP_NEW_SAVED, (SingleArcTransition)new AddApplicationToSchedulerTransition(null)).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new FinalSavingTransition((Object)new AppRejectedTransition(), RMAppState.FAILED)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition(null)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition(null)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new FinalSavingTransition((Object)new AppRejectedTransition(), RMAppState.FAILED)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_ACCEPTED, (SingleArcTransition)new StartAppAttemptTransition(null)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition(null)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition(null)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.ATTEMPT_REGISTERED).addTransition((Enum)RMAppState.ACCEPTED, EnumSet.of(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.ACCEPTED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)new FinalSavingTransition((Object)FINISHED_TRANSITION, RMAppState.FINISHED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.KILLING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAttemptTransition(null)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_ACCEPTED).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition(null)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition(null)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_UNREGISTERED, (SingleArcTransition)new FinalSavingTransition((Object)new AttemptUnregisteredTransition(null), RMAppState.FINISHING, RMAppState.FINISHED)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.RUNNING, EnumSet.of(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.ACCEPTED)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.KILLING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAttemptTransition(null)).addTransition((Enum)RMAppState.FINAL_SAVING, EnumSet.of(RMAppState.FINISHING, RMAppState.FAILED, RMAppState.KILLED, RMAppState.FINISHED), (Enum)RMAppEventType.APP_UPDATE_SAVED, (MultipleArcTransition)new FinalStateSavedTransition(null)).addTransition((Enum)RMAppState.FINAL_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)new AttemptFinishedAtFinalSavingTransition(null)).addTransition((Enum)RMAppState.FINAL_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.FINAL_SAVING, (Enum)RMAppState.FINAL_SAVING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.KILL, RMAppEventType.APP_NEW_SAVED)).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.KILL)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.KILLING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_KILLED, (SingleArcTransition)new FinalSavingTransition((Object)new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.KILLING, EnumSet.of(RMAppEventType.NODE_UPDATE, new RMAppEventType[]{RMAppEventType.ATTEMPT_REGISTERED, RMAppEventType.ATTEMPT_UNREGISTERED, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.APP_UPDATE_SAVED, RMAppEventType.KILL})).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.ATTEMPT_UNREGISTERED, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.KILL)).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, EnumSet.of(RMAppEventType.KILL, RMAppEventType.NODE_UPDATE)).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition(null)).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, EnumSet.of(RMAppEventType.APP_ACCEPTED, new RMAppEventType[]{RMAppEventType.APP_REJECTED, RMAppEventType.KILL, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.NODE_UPDATE})).installTopology();
    private final StateMachine<RMAppState, RMAppEventType, RMAppEvent> stateMachine;
    private static final int DUMMY_APPLICATION_ATTEMPT_NUMBER = -1;

    public RMAppImpl(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType, Set<String> applicationTags) {
        this.applicationId = applicationId;
        this.name = name;
        this.rmContext = rmContext;
        this.dispatcher = rmContext.getDispatcher();
        this.handler = this.dispatcher.getEventHandler();
        this.conf = config;
        this.user = user;
        this.queue = queue;
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.submitTime = submitTime;
        this.startTime = System.currentTimeMillis();
        this.applicationType = applicationType;
        this.applicationTags = applicationTags;
        int globalMaxAppAttempts = this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        int individualMaxAppAttempts = submissionContext.getMaxAppAttempts();
        if (individualMaxAppAttempts <= 0 || individualMaxAppAttempts > globalMaxAppAttempts) {
            this.maxAppAttempts = globalMaxAppAttempts;
            LOG.warn((Object)("The specific max attempts: " + individualMaxAppAttempts + " for application: " + applicationId.getId() + " is invalid, because it is out of the range [1, " + globalMaxAppAttempts + "]. Use the global max attempts instead."));
        } else {
            this.maxAppAttempts = individualMaxAppAttempts;
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        rmContext.getRMApplicationHistoryWriter().applicationStarted((RMApp)this);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null && this.currentAttempt.getFinalApplicationStatus() != null) {
                FinalApplicationStatus finalApplicationStatus = this.currentAttempt.getFinalApplicationStatus();
                return finalApplicationStatus;
            }
            FinalApplicationStatus finalApplicationStatus = this.createFinalApplicationStatus((RMAppState)this.stateMachine.getCurrentState());
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAppState getState() {
        this.readLock.lock();
        try {
            RMAppState rMAppState = (RMAppState)this.stateMachine.getCurrentState();
            return rMAppState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                float f = this.currentAttempt.getProgress();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = (RMAppAttempt)this.attempts.get(appAttemptId);
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAppAttempt getCurrentAppAttempt() {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.currentAttempt;
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
        this.readLock.lock();
        try {
            Map<ApplicationAttemptId, RMAppAttempt> map = Collections.unmodifiableMap(this.attempts);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private FinalApplicationStatus createFinalApplicationStatus(RMAppState state) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$rmapp$RMAppState[state.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case 8: 
            case 9: 
            case 10: {
                return FinalApplicationStatus.FAILED;
            }
            case 11: {
                return FinalApplicationStatus.KILLED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
        this.writeLock.lock();
        try {
            int updatedNodeCount = this.updatedNodes.size();
            updatedNodes.addAll(this.updatedNodes);
            this.updatedNodes.clear();
            int n = updatedNodeCount;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
        this.readLock.lock();
        try {
            ApplicationAttemptId currentApplicationAttemptId = null;
            org.apache.hadoop.yarn.api.records.Token clientToAMToken = null;
            String trackingUrl = "N/A";
            String host = "N/A";
            String origTrackingUrl = "N/A";
            int rpcPort = -1;
            ApplicationResourceUsageReport appUsageReport = RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT;
            FinalApplicationStatus finishState = this.getFinalApplicationStatus();
            String diags = "N/A";
            float progress = 0.0f;
            org.apache.hadoop.yarn.api.records.Token amrmToken = null;
            if (allowAccess) {
                Token token;
                if (this.currentAttempt != null) {
                    Token attemptClientToAMToken;
                    currentApplicationAttemptId = this.currentAttempt.getAppAttemptId();
                    trackingUrl = this.currentAttempt.getTrackingUrl();
                    origTrackingUrl = this.currentAttempt.getOriginalTrackingUrl();
                    if (UserGroupInformation.isSecurityEnabled() && (attemptClientToAMToken = this.currentAttempt.createClientToken(clientUserName)) != null) {
                        clientToAMToken = BuilderUtils.newClientToAMToken((byte[])attemptClientToAMToken.getIdentifier(), (String)attemptClientToAMToken.getKind().toString(), (byte[])attemptClientToAMToken.getPassword(), (String)attemptClientToAMToken.getService().toString());
                    }
                    host = this.currentAttempt.getHost();
                    rpcPort = this.currentAttempt.getRpcPort();
                    appUsageReport = this.currentAttempt.getApplicationResourceUsageReport();
                    progress = this.currentAttempt.getProgress();
                }
                diags = this.diagnostics.toString();
                if (this.currentAttempt != null && this.currentAttempt.getAppAttemptState() == RMAppAttemptState.LAUNCHED && this.getApplicationSubmissionContext().getUnmanagedAM() && clientUserName != null && this.getUser().equals(clientUserName) && (token = this.currentAttempt.getAMRMToken()) != null) {
                    amrmToken = BuilderUtils.newAMRMToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
                }
            }
            if (currentApplicationAttemptId == null) {
                currentApplicationAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)this.applicationId, (int)-1);
            }
            ApplicationReport applicationReport = BuilderUtils.newApplicationReport((ApplicationId)this.applicationId, (ApplicationAttemptId)currentApplicationAttemptId, (String)this.user, (String)this.queue, (String)this.name, (String)host, (int)rpcPort, clientToAMToken, (YarnApplicationState)this.createApplicationState(), (String)diags, (String)trackingUrl, (long)this.startTime, (long)this.finishTime, (FinalApplicationStatus)finishState, (ApplicationResourceUsageReport)appUsageReport, (String)origTrackingUrl, (float)progress, (String)this.applicationType, amrmToken, (Set)this.applicationTags);
            return applicationReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                String string = this.currentAttempt.getTrackingUrl();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getDiagnostics() {
        this.readLock.lock();
        try {
            StringBuilder stringBuilder = this.diagnostics;
            return stringBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId appID = event.getApplicationId();
            LOG.debug((Object)("Processing event for " + appID + " of type " + event.getType()));
            RMAppState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(appID + " State change from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)state.getApplicationState().get(this.getApplicationId());
        this.recoveredFinalState = appState.getState();
        LOG.info((Object)("Recovering app: " + this.getApplicationId() + " with " + appState.getAttemptCount() + " attempts and final state = " + this.recoveredFinalState));
        this.diagnostics.append(appState.getDiagnostics());
        this.storedFinishTime = appState.getFinishTime();
        this.startTime = appState.getStartTime();
        for (int i = 0; i < appState.getAttemptCount(); ++i) {
            this.createNewAttempt();
            ((RMAppAttemptImpl)this.currentAttempt).recover(state);
        }
    }

    private void createNewAttempt() {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)(this.attempts.size() + 1));
        RMAppAttemptImpl attempt = new RMAppAttemptImpl(appAttemptId, this.rmContext, this.scheduler, this.masterService, this.submissionContext, this.conf, this.maxAppAttempts == this.getNumFailedAppAttempts() + 1);
        this.attempts.put(appAttemptId, attempt);
        this.currentAttempt = attempt;
    }

    private void createAndStartNewAttempt(boolean transferStateFromPreviousAttempt) {
        this.createNewAttempt();
        this.handler.handle((Event)new RMAppStartAttemptEvent(this.currentAttempt.getAppAttemptId(), transferStateFromPreviousAttempt));
    }

    private void processNodeUpdate(RMAppNodeUpdateEvent.RMAppNodeUpdateType type, RMNode node) {
        NodeState nodeState = node.getState();
        this.updatedNodes.add(node);
        LOG.debug((Object)("Received node update event:" + type + " for node:" + node + " with state:" + nodeState));
    }

    private void recoverAppAttempts() {
        for (RMAppAttempt attempt : this.getAppAttempts().values()) {
            attempt.handle((Event)new RMAppAttemptEvent(attempt.getAppAttemptId(), RMAppAttemptEventType.RECOVER));
        }
    }

    private String getAppAttemptFailedDiagnostics(RMAppEvent event) {
        String msg = null;
        RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
        if (this.submissionContext.getUnmanagedAM()) {
            msg = "Unmanaged application " + this.getApplicationId() + " failed due to " + failedEvent.getDiagnostics() + ". Failing the application.";
        } else if (this.getNumFailedAppAttempts() >= this.maxAppAttempts) {
            msg = "Application " + this.getApplicationId() + " failed " + this.maxAppAttempts + " times due to " + failedEvent.getDiagnostics() + ". Failing the application.";
        }
        return msg;
    }

    private void rememberTargetTransitions(RMAppEvent event, Object transitionToDo, RMAppState targetFinalState) {
        this.transitionTodo = transitionToDo;
        this.targetedFinalState = targetFinalState;
        this.eventCausingFinalSaving = event;
    }

    private void rememberTargetTransitionsAndStoreState(RMAppEvent event, Object transitionToDo, RMAppState targetFinalState, RMAppState stateToBeStored) {
        this.rememberTargetTransitions(event, transitionToDo, targetFinalState);
        this.stateBeforeFinalSaving = this.getState();
        this.storedFinishTime = System.currentTimeMillis();
        LOG.info((Object)("Updating application " + this.applicationId + " with final state: " + this.targetedFinalState));
        String diags = null;
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$rmapp$RMAppEventType[((RMAppEventType)event.getType()).ordinal()]) {
            case 1: {
                RMAppRejectedEvent rejectedEvent = (RMAppRejectedEvent)event;
                diags = rejectedEvent.getMessage();
                break;
            }
            case 2: {
                RMAppFinishedAttemptEvent finishedEvent = (RMAppFinishedAttemptEvent)event;
                diags = finishedEvent.getDiagnostics();
                break;
            }
            case 3: {
                RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
                diags = this.getAppAttemptFailedDiagnostics((RMAppEvent)failedEvent);
                break;
            }
            case 4: {
                diags = RMAppImpl.getAppKilledDiagnostics();
                break;
            }
        }
        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(this.submitTime, this.startTime, this.submissionContext, this.user, stateToBeStored, diags, this.storedFinishTime);
        this.rmContext.getStateStore().updateApplicationState(appState);
    }

    private static String getAppKilledDiagnostics() {
        return "Application killed by user.";
    }

    private int getNumFailedAppAttempts() {
        int completedAttempts = 0;
        for (RMAppAttempt attempt : this.attempts.values()) {
            if (!attempt.shouldCountTowardsMaxAttemptRetry()) continue;
            ++completedAttempts;
        }
        return completedAttempts;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public Set<String> getApplicationTags() {
        return this.applicationTags;
    }

    public boolean isAppFinalStateStored() {
        RMAppState state = this.getState();
        return state.equals((Object)RMAppState.FINISHING) || state.equals((Object)RMAppState.FINISHED) || state.equals((Object)RMAppState.FAILED) || state.equals((Object)RMAppState.KILLED);
    }

    public YarnApplicationState createApplicationState() {
        RMAppState rmAppState = this.getState();
        if (rmAppState.equals((Object)RMAppState.FINAL_SAVING)) {
            rmAppState = this.stateBeforeFinalSaving;
        }
        if (rmAppState.equals((Object)RMAppState.KILLING)) {
            rmAppState = this.stateBeforeKilling;
        }
        return RMServerUtils.createApplicationState((RMAppState)rmAppState);
    }

    public static boolean isAppInFinalState(RMApp rmApp) {
        RMAppState appState = ((RMAppImpl)rmApp).getRecoveredFinalState();
        return appState == RMAppState.FAILED || appState == RMAppState.FINISHED || appState == RMAppState.KILLED;
    }

    private RMAppState getRecoveredFinalState() {
        return this.recoveredFinalState;
    }

    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }

    static /* synthetic */ void access$1200(RMAppImpl x0, RMAppNodeUpdateEvent.RMAppNodeUpdateType x1, RMNode x2) {
        x0.processNodeUpdate(x1, x2);
    }

    static /* synthetic */ EventHandler access$1300(RMAppImpl x0) {
        return x0.handler;
    }

    static /* synthetic */ Set access$1400(RMAppImpl x0) {
        return x0.ranNodes;
    }

    static /* synthetic */ String access$1502(RMAppImpl x0, String x1) {
        x0.queue = x1;
        return x0.queue;
    }

    static /* synthetic */ ApplicationId access$1600(RMAppImpl x0) {
        return x0.applicationId;
    }

    static /* synthetic */ YarnScheduler access$1700(RMAppImpl x0) {
        return x0.scheduler;
    }

    static /* synthetic */ RMAppState access$1800(RMAppImpl x0) {
        return x0.recoveredFinalState;
    }

    static /* synthetic */ void access$1900(RMAppImpl x0) {
        x0.recoverAppAttempts();
    }

    static /* synthetic */ RMAppAttempt access$2000(RMAppImpl x0) {
        return x0.currentAttempt;
    }

    static /* synthetic */ int access$2100(RMAppImpl x0) {
        return x0.getNumFailedAppAttempts();
    }

    static /* synthetic */ int access$2200(RMAppImpl x0) {
        return x0.maxAppAttempts;
    }

    static /* synthetic */ Map access$2300(RMAppImpl x0) {
        return x0.attempts;
    }

    static /* synthetic */ Log access$2400() {
        return LOG;
    }

    static /* synthetic */ ApplicationSubmissionContext access$2500(RMAppImpl x0) {
        return x0.submissionContext;
    }

    static /* synthetic */ String access$2600(RMAppImpl x0) {
        return x0.user;
    }

    static /* synthetic */ void access$2700(RMAppImpl x0, boolean x1) {
        x0.createAndStartNewAttempt(x1);
    }

    static /* synthetic */ RMAppEvent access$2800(RMAppImpl x0) {
        return x0.eventCausingFinalSaving;
    }

    static /* synthetic */ RMAppState access$2900(RMAppImpl x0) {
        return x0.targetedFinalState;
    }

    static /* synthetic */ String access$3000(RMAppImpl x0, RMAppEvent x1) {
        return x0.getAppAttemptFailedDiagnostics(x1);
    }

    static /* synthetic */ StringBuilder access$3100(RMAppImpl x0) {
        return x0.diagnostics;
    }

    static /* synthetic */ RMContext access$3200(RMAppImpl x0) {
        return x0.rmContext;
    }

    static /* synthetic */ void access$3300(RMAppImpl x0, RMAppEvent x1, Object x2, RMAppState x3, RMAppState x4) {
        x0.rememberTargetTransitionsAndStoreState(x1, x2, x3, x4);
    }

    static /* synthetic */ long access$3402(RMAppImpl x0, long x1) {
        x0.finishTime = x1;
        return x0.finishTime;
    }

    static /* synthetic */ long access$3500(RMAppImpl x0) {
        return x0.storedFinishTime;
    }

    static /* synthetic */ void access$3600(RMAppImpl x0, RMAppEvent x1, Object x2, RMAppState x3) {
        x0.rememberTargetTransitions(x1, x2, x3);
    }

    static /* synthetic */ AppFinishedTransition access$3700() {
        return FINISHED_TRANSITION;
    }

    static /* synthetic */ String access$3800() {
        return RMAppImpl.getAppKilledDiagnostics();
    }

    static /* synthetic */ RMAppState access$3902(RMAppImpl x0, RMAppState x1) {
        x0.stateBeforeKilling = x1;
        return x0.stateBeforeKilling;
    }

    static /* synthetic */ long access$3400(RMAppImpl x0) {
        return x0.finishTime;
    }
}

