/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;

public class RMContextImpl
implements RMContext {
    private Dispatcher rmDispatcher;
    private final ConcurrentMap<ApplicationId, RMApp> applications;
    private final ConcurrentMap<NodeId, RMNode> nodes;
    private final ConcurrentMap<String, RMNode> inactiveNodes;
    private boolean isHAEnabled;
    private boolean isWorkPreservingRecoveryEnabled;
    private HAServiceProtocol.HAServiceState haServiceState;
    private AMLivelinessMonitor amLivelinessMonitor;
    private AMLivelinessMonitor amFinishingMonitor;
    private RMStateStore stateStore;
    private ContainerAllocationExpirer containerAllocationExpirer;
    private DelegationTokenRenewer delegationTokenRenewer;
    private AMRMTokenSecretManager amRMTokenSecretManager;
    private RMContainerTokenSecretManager containerTokenSecretManager;
    private NMTokenSecretManagerInRM nmTokenSecretManager;
    private ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager;
    private AdminService adminService;
    private ClientRMService clientRMService;
    private RMDelegationTokenSecretManager rmDelegationTokenSecretManager;
    private ResourceScheduler scheduler;
    private NodesListManager nodesListManager;
    private ResourceTrackerService resourceTrackerService;
    private ApplicationMasterService applicationMasterService;
    private RMApplicationHistoryWriter rmApplicationHistoryWriter;
    private ConfigurationProvider configurationProvider;
    private int epoch;

    public RMContextImpl() {
        this.applications = new ConcurrentHashMap();
        this.nodes = new ConcurrentHashMap();
        this.inactiveNodes = new ConcurrentHashMap();
        this.haServiceState = HAServiceProtocol.HAServiceState.INITIALIZING;
        this.stateStore = null;
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager, RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        block2: {
            this();
            this.setDispatcher(rmDispatcher);
            this.setContainerAllocationExpirer(containerAllocationExpirer);
            this.setAMLivelinessMonitor(amLivelinessMonitor);
            this.setAMFinishingMonitor(amFinishingMonitor);
            this.setDelegationTokenRenewer(delegationTokenRenewer);
            this.setAMRMTokenSecretManager(appTokenSecretManager);
            this.setContainerTokenSecretManager(containerTokenSecretManager);
            this.setNMTokenSecretManager(nmTokenSecretManager);
            this.setClientToAMTokenSecretManager(clientToAMTokenSecretManager);
            this.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
            NullRMStateStore nullStore = new NullRMStateStore();
            nullStore.setRMDispatcher(rmDispatcher);
            try {
                nullStore.init((Configuration)new YarnConfiguration());
                this.setStateStore((RMStateStore)nullStore);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        LocalConfigurationProvider provider = new LocalConfigurationProvider();
        this.setConfigurationProvider((ConfigurationProvider)provider);
    }

    public Dispatcher getDispatcher() {
        return this.rmDispatcher;
    }

    public RMStateStore getStateStore() {
        return this.stateStore;
    }

    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.applications;
    }

    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.nodes;
    }

    public ConcurrentMap<String, RMNode> getInactiveRMNodes() {
        return this.inactiveNodes;
    }

    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.containerAllocationExpirer;
    }

    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.amLivelinessMonitor;
    }

    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.amFinishingMonitor;
    }

    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.delegationTokenRenewer;
    }

    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.amRMTokenSecretManager;
    }

    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.containerTokenSecretManager;
    }

    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.nmTokenSecretManager;
    }

    public ResourceScheduler getScheduler() {
        return this.scheduler;
    }

    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.clientToAMTokenSecretManager;
    }

    public AdminService getRMAdminService() {
        return this.adminService;
    }

    @VisibleForTesting
    public void setStateStore(RMStateStore store) {
        this.stateStore = store;
    }

    public ClientRMService getClientRMService() {
        return this.clientRMService;
    }

    public ApplicationMasterService getApplicationMasterService() {
        return this.applicationMasterService;
    }

    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTrackerService;
    }

    void setHAEnabled(boolean isHAEnabled) {
        this.isHAEnabled = isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHAServiceState(HAServiceProtocol.HAServiceState haServiceState) {
        HAServiceProtocol.HAServiceState hAServiceState = haServiceState;
        synchronized (hAServiceState) {
            this.haServiceState = haServiceState;
        }
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    void setRMAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public void setClientRMService(ClientRMService clientRMService) {
        this.clientRMService = clientRMService;
    }

    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.rmDelegationTokenSecretManager;
    }

    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.rmDelegationTokenSecretManager = delegationTokenSecretManager;
    }

    void setContainerAllocationExpirer(ContainerAllocationExpirer containerAllocationExpirer) {
        this.containerAllocationExpirer = containerAllocationExpirer;
    }

    void setAMLivelinessMonitor(AMLivelinessMonitor amLivelinessMonitor) {
        this.amLivelinessMonitor = amLivelinessMonitor;
    }

    void setAMFinishingMonitor(AMLivelinessMonitor amFinishingMonitor) {
        this.amFinishingMonitor = amFinishingMonitor;
    }

    void setContainerTokenSecretManager(RMContainerTokenSecretManager containerTokenSecretManager) {
        this.containerTokenSecretManager = containerTokenSecretManager;
    }

    void setNMTokenSecretManager(NMTokenSecretManagerInRM nmTokenSecretManager) {
        this.nmTokenSecretManager = nmTokenSecretManager;
    }

    void setScheduler(ResourceScheduler scheduler) {
        this.scheduler = scheduler;
    }

    void setDelegationTokenRenewer(DelegationTokenRenewer delegationTokenRenewer) {
        this.delegationTokenRenewer = delegationTokenRenewer;
    }

    void setClientToAMTokenSecretManager(ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.clientToAMTokenSecretManager = clientToAMTokenSecretManager;
    }

    void setAMRMTokenSecretManager(AMRMTokenSecretManager amRMTokenSecretManager) {
        this.amRMTokenSecretManager = amRMTokenSecretManager;
    }

    void setNodesListManager(NodesListManager nodesListManager) {
        this.nodesListManager = nodesListManager;
    }

    void setApplicationMasterService(ApplicationMasterService applicationMasterService) {
        this.applicationMasterService = applicationMasterService;
    }

    void setResourceTrackerService(ResourceTrackerService resourceTrackerService) {
        this.resourceTrackerService = resourceTrackerService;
    }

    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAServiceProtocol.HAServiceState getHAServiceState() {
        HAServiceProtocol.HAServiceState hAServiceState = this.haServiceState;
        synchronized (hAServiceState) {
            return this.haServiceState;
        }
    }

    public void setWorkPreservingRecoveryEnabled(boolean enabled) {
        this.isWorkPreservingRecoveryEnabled = enabled;
    }

    public boolean isWorkPreservingRecoveryEnabled() {
        return this.isWorkPreservingRecoveryEnabled;
    }

    public RMApplicationHistoryWriter getRMApplicationHistoryWriter() {
        return this.rmApplicationHistoryWriter;
    }

    public void setRMApplicationHistoryWriter(RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        this.rmApplicationHistoryWriter = rmApplicationHistoryWriter;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public int getEpoch() {
        return this.epoch;
    }

    void setEpoch(int epoch) {
        this.epoch = epoch;
    }
}

