/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMDelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier>
implements Recoverable {
    private static final Log LOG = LogFactory.getLog(RMDelegationTokenSecretManager.class);
    protected final RMContext rmContext;

    public RMDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, RMContext rmContext) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.rmContext = rmContext;
    }

    public RMDelegationTokenIdentifier createIdentifier() {
        return new RMDelegationTokenIdentifier();
    }

    protected void storeNewMasterKey(DelegationKey newKey) {
        try {
            LOG.info((Object)("storing master key with keyID " + newKey.getKeyId()));
            this.rmContext.getStateStore().storeRMDTMasterKey(newKey);
        }
        catch (Exception e) {
            LOG.error((Object)("Error in storing master key with KeyID: " + newKey.getKeyId()));
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    protected void removeStoredMasterKey(DelegationKey key) {
        try {
            LOG.info((Object)("removing master key with keyID " + key.getKeyId()));
            this.rmContext.getStateStore().removeRMDTMasterKey(key);
        }
        catch (Exception e) {
            LOG.error((Object)("Error in removing master key with KeyID: " + key.getKeyId()));
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    protected void storeNewToken(RMDelegationTokenIdentifier identifier, long renewDate) {
        try {
            LOG.info((Object)("storing RMDelegation token with sequence number: " + identifier.getSequenceNumber()));
            this.rmContext.getStateStore().storeRMDelegationTokenAndSequenceNumber(identifier, renewDate, identifier.getSequenceNumber());
        }
        catch (Exception e) {
            LOG.error((Object)("Error in storing RMDelegationToken with sequence number: " + identifier.getSequenceNumber()));
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    protected void updateStoredToken(RMDelegationTokenIdentifier id, long renewDate) {
        try {
            LOG.info((Object)("updating RMDelegation token with sequence number: " + id.getSequenceNumber()));
            this.rmContext.getStateStore().updateRMDelegationTokenAndSequenceNumber(id, renewDate, id.getSequenceNumber());
        }
        catch (Exception e) {
            LOG.error((Object)("Error in updating persisted RMDelegationToken with sequence number: " + id.getSequenceNumber()));
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    protected void removeStoredToken(RMDelegationTokenIdentifier ident) throws IOException {
        try {
            LOG.info((Object)("removing RMDelegation token with sequence number: " + ident.getSequenceNumber()));
            this.rmContext.getStateStore().removeRMDelegationToken(ident, this.delegationTokenSequenceNumber);
        }
        catch (Exception e) {
            LOG.error((Object)("Error in removing RMDelegationToken with sequence number: " + ident.getSequenceNumber()));
            ExitUtil.terminate((int)1, (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized Set<DelegationKey> getAllMasterKeys() {
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.addAll(this.allKeys.values());
        return keySet;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized Map<RMDelegationTokenIdentifier, Long> getAllTokens() {
        HashMap<RMDelegationTokenIdentifier, Long> allTokens = new HashMap<RMDelegationTokenIdentifier, Long>();
        for (Map.Entry entry : this.currentTokens.entrySet()) {
            allTokens.put((RMDelegationTokenIdentifier)entry.getKey(), ((AbstractDelegationTokenSecretManager.DelegationTokenInformation)entry.getValue()).getRenewDate());
        }
        return allTokens;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getLatestDTSequenceNumber() {
        return this.delegationTokenSequenceNumber;
    }

    @Override
    public void recover(RMStateStore.RMState rmState) throws Exception {
        LOG.info((Object)"recovering RMDelegationTokenSecretManager.");
        for (DelegationKey dtKey : rmState.getRMDTSecretManagerState().getMasterKeyState()) {
            this.addKey(dtKey);
        }
        Map<RMDelegationTokenIdentifier, Long> rmDelegationTokens = rmState.getRMDTSecretManagerState().getTokenState();
        this.delegationTokenSequenceNumber = rmState.getRMDTSecretManagerState().getDTSequenceNumber();
        for (Map.Entry<RMDelegationTokenIdentifier, Long> entry : rmDelegationTokens.entrySet()) {
            this.addPersistedDelegationToken((AbstractDelegationTokenIdentifier)entry.getKey(), entry.getValue());
        }
    }
}

