/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;

public class PriorityUtilizationQueueOrderingPolicy
implements QueueOrderingPolicy {
    private List<CSQueue> queues;
    private boolean respectPriority;
    private static ThreadLocal<String> partitionToLookAt = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };

    public static int compare(double relativeAssigned1, double relativeAssigned2, int priority1, int priority2) {
        if (priority1 == priority2) {
            return Double.compare(relativeAssigned1, relativeAssigned2);
        }
        if (relativeAssigned1 < 1.0 && relativeAssigned2 < 1.0 || relativeAssigned1 >= 1.0 && relativeAssigned2 >= 1.0) {
            return Integer.compare(priority2, priority1);
        }
        return Double.compare(relativeAssigned1, relativeAssigned2);
    }

    public PriorityUtilizationQueueOrderingPolicy(boolean respectPriority) {
        this.respectPriority = respectPriority;
    }

    @Override
    public void setQueues(List<CSQueue> queues) {
        this.queues = queues;
    }

    @Override
    public Iterator<CSQueue> getAssignmentIterator(String partition) {
        partitionToLookAt.set(partition);
        ArrayList<CSQueue> sortedQueue = new ArrayList<CSQueue>(this.queues);
        Collections.sort(sortedQueue, new PriorityQueueComparator());
        return sortedQueue.iterator();
    }

    @Override
    public String getConfigName() {
        if (this.respectPriority) {
            return "priority-utilization";
        }
        return "utilization";
    }

    @VisibleForTesting
    public List<CSQueue> getQueues() {
        return this.queues;
    }

    private class PriorityQueueComparator
    implements Comparator<CSQueue> {
        private PriorityQueueComparator() {
        }

        @Override
        public int compare(CSQueue q1, CSQueue q2) {
            String p = (String)partitionToLookAt.get();
            int rc = this.compareQueueAccessToPartition(q1, q2, p);
            if (0 != rc) {
                return rc;
            }
            float used1 = q1.getQueueCapacities().getUsedCapacity(p);
            float used2 = q2.getQueueCapacities().getUsedCapacity(p);
            int p1 = 0;
            int p2 = 0;
            if (PriorityUtilizationQueueOrderingPolicy.this.respectPriority) {
                p1 = q1.getPriority().getPriority();
                p2 = q2.getPriority().getPriority();
            }
            if (0 == (rc = PriorityUtilizationQueueOrderingPolicy.compare(used1, used2, p1, p2))) {
                float abs1 = q1.getQueueCapacities().getAbsoluteCapacity(p);
                float abs2 = q2.getQueueCapacities().getAbsoluteCapacity(p);
                return Float.compare(abs2, abs1);
            }
            return rc;
        }

        private int compareQueueAccessToPartition(CSQueue q1, CSQueue q2, String partition) {
            boolean q2Accessible;
            if (StringUtils.equals((String)partition, (String)"")) {
                return 0;
            }
            boolean q1Accessible = q1.getAccessibleNodeLabels() != null && q1.getAccessibleNodeLabels().contains(partition) || q1.getAccessibleNodeLabels().contains("*");
            boolean bl = q2Accessible = q2.getAccessibleNodeLabels() != null && q2.getAccessibleNodeLabels().contains(partition) || q2.getAccessibleNodeLabels().contains("*");
            if (q1Accessible && !q2Accessible) {
                return -1;
            }
            if (!q1Accessible && q2Accessible) {
                return 1;
            }
            return 0;
        }
    }
}

