/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.DockerLinuxContainerRuntime;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReapContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerCleanup
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCleanup.class);
    private final Context context;
    private final Configuration conf;
    private final Dispatcher dispatcher;
    private final ContainerExecutor exec;
    private final Container container;
    private final ContainerLaunch launch;
    private final long sleepDelayBeforeSigKill;

    public ContainerCleanup(Context context, Configuration configuration, Dispatcher dispatcher, ContainerExecutor exec, Container container, ContainerLaunch containerLaunch) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.conf = (Configuration)Preconditions.checkNotNull((Object)configuration, (Object)"config");
        this.dispatcher = (Dispatcher)Preconditions.checkNotNull((Object)dispatcher, (Object)"dispatcher");
        this.exec = (ContainerExecutor)Preconditions.checkNotNull((Object)exec, (Object)"exec");
        this.container = (Container)Preconditions.checkNotNull((Object)container, (Object)"container");
        this.launch = (ContainerLaunch)Preconditions.checkNotNull((Object)containerLaunch, (Object)"launch");
        this.sleepDelayBeforeSigKill = this.conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        containerId = this.container.getContainerId();
        containerIdStr = containerId.toString();
        ContainerCleanup.LOG.info("Cleaning up container " + containerIdStr);
        try {
            this.context.getNMStateStore().storeContainerKilled(containerId);
        }
        catch (IOException e) {
            ContainerCleanup.LOG.error("Unable to mark container " + containerId + " killed in store", (Throwable)e);
        }
        v0 = alreadyLaunched = this.launch.markLaunched() == false;
        if (!alreadyLaunched) {
            ContainerCleanup.LOG.info("Container " + containerIdStr + " not launched. No cleanup needed to be done");
            return;
        }
        if (ContainerCleanup.LOG.isDebugEnabled()) {
            ContainerCleanup.LOG.debug("Marking container " + containerIdStr + " as inactive");
        }
        this.exec.deactivateContainer(containerId);
        pidFilePath = this.launch.getPidFilePath();
        if (ContainerCleanup.LOG.isDebugEnabled()) {
            ContainerCleanup.LOG.debug("Getting pid for container {} to kill from pid file {}", (Object)containerIdStr, pidFilePath != null ? pidFilePath : "null");
        }
        try {
            processId = this.launch.getContainerPid();
            user = this.container.getUser();
            if (processId != null) {
                this.signalProcess(processId, user, containerIdStr);
            } else {
                if (!this.launch.isLaunchCompleted()) {
                    ContainerCleanup.LOG.warn("Container clean up before pid file created " + containerIdStr);
                    this.dispatcher.getEventHandler().handle((Event)new ContainerExitEvent(this.container.getContainerId(), ContainerEventType.CONTAINER_KILLED_ON_REQUEST, Shell.WINDOWS != false ? ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() : ContainerExecutor.ExitCode.TERMINATED.getExitCode(), "Container terminated before pid file created."));
                }
                if (DockerLinuxContainerRuntime.isDockerContainerRequested(this.conf, this.container.getLaunchContext().getEnvironment())) {
                    this.reapDockerContainerNoPid(user);
                }
            }
            ** if (pidFilePath == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                message = "Exception when trying to cleanup container " + containerIdStr + ": " + StringUtils.stringifyException((Throwable)e);
                ContainerCleanup.LOG.warn(message);
                this.dispatcher.getEventHandler().handle((Event)new ContainerDiagnosticsUpdateEvent(containerId, message));
                ** if (pidFilePath == null) goto lbl-1000
            }
            catch (Throwable var7_13) {
                if (pidFilePath != null) {
                    try {
                        lfs = FileContext.getLocalFSFileContext();
                        lfs.delete(pidFilePath, false);
                        lfs.delete(pidFilePath.suffix(".exitcode"), false);
                    }
                    catch (IOException ioe) {
                        ContainerCleanup.LOG.warn("{} exception trying to delete pid file {}. Ignoring.", new Object[]{containerId, pidFilePath, ioe});
                    }
                }
                throw var7_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    lfs = FileContext.getLocalFSFileContext();
                    lfs.delete(pidFilePath, false);
                    lfs.delete(pidFilePath.suffix(".exitcode"), false);
                }
                catch (IOException ioe) {
                    ContainerCleanup.LOG.warn("{} exception trying to delete pid file {}. Ignoring.", new Object[]{containerId, pidFilePath, ioe});
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                lfs = FileContext.getLocalFSFileContext();
                lfs.delete(pidFilePath, false);
                lfs.delete(pidFilePath.suffix(".exitcode"), false);
            }
            catch (IOException ioe) {
                ContainerCleanup.LOG.warn("{} exception trying to delete pid file {}. Ignoring.", new Object[]{containerId, pidFilePath, ioe});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        try {
            this.launch.reapContainer();
        }
        catch (IOException ioe) {
            ContainerCleanup.LOG.warn("{} exception trying to reap container. Ignoring.", (Object)containerId, (Object)ioe);
        }
    }

    private void signalProcess(String processId, String user, String containerIdStr) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending signal to pid " + processId + " as user " + user + " for container " + containerIdStr);
        }
        ContainerExecutor.Signal signal = this.sleepDelayBeforeSigKill > 0L ? ContainerExecutor.Signal.TERM : ContainerExecutor.Signal.KILL;
        boolean result = this.sendSignal(user, processId, signal);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent signal " + (Object)((Object)signal) + " to pid " + processId + " as user " + user + " for container " + containerIdStr + ", result=" + (result ? "success" : "failed"));
        }
        if (this.sleepDelayBeforeSigKill > 0L) {
            new ContainerExecutor.DelayedProcessKiller(this.container, user, processId, this.sleepDelayBeforeSigKill, ContainerExecutor.Signal.KILL, this.exec).start();
        }
    }

    private boolean sendSignal(String user, String processId, ContainerExecutor.Signal signal) throws IOException {
        return this.exec.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(user).setPid(processId).setSignal(signal).build());
    }

    private void reapDockerContainerNoPid(String user) throws IOException {
        String containerIdStr = this.container.getContainerTokenIdentifier().getContainerID().toString();
        LOG.info("Unable to obtain pid, but docker container request detected. Attempting to reap container " + containerIdStr);
        boolean result = this.exec.reapContainer(new ContainerReapContext.Builder().setContainer(this.container).setUser(this.container.getUser()).build());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sent signal to docker container " + containerIdStr + " as user " + user + ", result=" + (result ? "success" : "failed"));
        }
    }
}

